/*
 * Decompiled with CFR 0.152.
 */
import java.util.StringTokenizer;

class PisoShiftElm
extends ChipElm {
    short data = 0;
    boolean clockstate = false;
    boolean modestate = false;

    boolean hasReset() {
        return false;
    }

    public PisoShiftElm(int n, int n2) {
        super(n, n2);
    }

    public PisoShiftElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
    }

    String getChipName() {
        return "PISO shift register";
    }

    void setupPins() {
        this.sizeX = 10;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(1, 2, "L");
        this.pins[1] = new ChipElm.Pin(2, 2, "");
        this.pins[1].clock = true;
        this.pins[2] = new ChipElm.Pin(1, 0, "I7");
        this.pins[3] = new ChipElm.Pin(2, 0, "I6");
        this.pins[4] = new ChipElm.Pin(3, 0, "I5");
        this.pins[5] = new ChipElm.Pin(4, 0, "I4");
        this.pins[6] = new ChipElm.Pin(5, 0, "I3");
        this.pins[7] = new ChipElm.Pin(6, 0, "I2");
        this.pins[8] = new ChipElm.Pin(7, 0, "I1");
        this.pins[9] = new ChipElm.Pin(8, 0, "I0");
        this.pins[10] = new ChipElm.Pin(1, 3, "Q");
        this.pins[10].output = true;
    }

    int getPostCount() {
        return 11;
    }

    int getVoltageSourceCount() {
        return 1;
    }

    void execute() {
        if (this.pins[0].value && !this.modestate) {
            this.modestate = true;
            this.data = 0;
            if (this.pins[2].value) {
                this.data = (short)(this.data + 128);
            }
            if (this.pins[3].value) {
                this.data = (short)(this.data + 64);
            }
            if (this.pins[4].value) {
                this.data = (short)(this.data + 32);
            }
            if (this.pins[5].value) {
                this.data = (short)(this.data + 16);
            }
            if (this.pins[6].value) {
                this.data = (short)(this.data + 8);
            }
            if (this.pins[7].value) {
                this.data = (short)(this.data + 4);
            }
            if (this.pins[8].value) {
                this.data = (short)(this.data + 2);
            }
            if (this.pins[9].value) {
                this.data = (short)(this.data + 1);
            }
        } else if (this.pins[1].value && !this.clockstate) {
            this.clockstate = true;
            this.pins[10].value = (this.data & 1) != 0;
            this.data = (byte)(this.data >>> 1);
        }
        if (!this.pins[0].value) {
            this.modestate = false;
        }
        if (!this.pins[1].value) {
            this.clockstate = false;
        }
    }

    int getDumpType() {
        return 186;
    }
}

