/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Checkbox;
import java.util.StringTokenizer;

class TFlipFlopElm
extends ChipElm {
    final int FLAG_RESET = 2;
    final int FLAG_SET = 4;
    private boolean last_val;

    boolean hasReset() {
        return (this.flags & 2) != 0 || this.hasSet();
    }

    boolean hasSet() {
        return (this.flags & 4) != 0;
    }

    public TFlipFlopElm(int n, int n2) {
        super(n, n2);
    }

    public TFlipFlopElm(int n, int n2, int n3, int n4, int n5, StringTokenizer stringTokenizer) {
        super(n, n2, n3, n4, n5, stringTokenizer);
        this.pins[2].value = !this.pins[1].value;
    }

    String getChipName() {
        return "T flip-flop";
    }

    void setupPins() {
        this.sizeX = 2;
        this.sizeY = 3;
        this.pins = new ChipElm.Pin[this.getPostCount()];
        this.pins[0] = new ChipElm.Pin(0, 2, "T");
        this.pins[1] = new ChipElm.Pin(0, 3, "Q");
        this.pins[1].state = true;
        this.pins[1].output = true;
        this.pins[2] = new ChipElm.Pin(this.hasSet() ? 1 : 2, 3, "Q");
        this.pins[2].output = true;
        this.pins[2].lineOver = true;
        this.pins[3] = new ChipElm.Pin(1, 2, "");
        this.pins[3].clock = true;
        if (!this.hasSet()) {
            if (this.hasReset()) {
                this.pins[4] = new ChipElm.Pin(2, 2, "R");
            }
        } else {
            this.pins[5] = new ChipElm.Pin(2, 2, "S");
            this.pins[4] = new ChipElm.Pin(2, 3, "R");
        }
    }

    int getPostCount() {
        return 4 + (this.hasReset() ? 1 : 0) + (this.hasSet() ? 1 : 0);
    }

    int getVoltageSourceCount() {
        return 2;
    }

    void reset() {
        super.reset();
        this.volts[2] = 5.0;
        this.pins[2].value = true;
    }

    void execute() {
        if (this.pins[3].value && !this.lastClock && this.pins[0].value) {
            this.pins[1].value = !this.last_val;
            this.pins[2].value = !this.pins[1].value;
            boolean bl = this.last_val = !this.last_val;
        }
        if (this.hasSet() && this.pins[5].value) {
            this.pins[1].value = true;
            this.pins[2].value = false;
        }
        if (this.hasReset() && this.pins[4].value) {
            this.pins[1].value = false;
            this.pins[2].value = true;
        }
        this.lastClock = this.pins[3].value;
    }

    int getDumpType() {
        return 193;
    }

    public EditInfo getEditInfo(int n) {
        if (n == 2) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Reset Pin", this.hasReset());
            return editInfo;
        }
        if (n == 3) {
            EditInfo editInfo = new EditInfo("", 0.0, -1.0, -1.0);
            editInfo.checkbox = new Checkbox("Set Pin", this.hasSet());
            return editInfo;
        }
        return super.getEditInfo(n);
    }

    public void setEditValue(int n, EditInfo editInfo) {
        if (n == 2) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
            this.setupPins();
            this.allocNodes();
            this.setPoints();
        }
        if (n == 3) {
            this.flags = editInfo.checkbox.getState() ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
            this.setupPins();
            this.allocNodes();
            this.setPoints();
        }
        super.setEditValue(n, editInfo);
    }
}

