/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fatcalc;

import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Locale;
import java.util.Properties;

public final class Config {
    private static final String PROPERTIES_HEADER = "FatCalc configuration file";
    private static final String PROPERTY_LANGUAGE = "language";
    private static final String PROPERTY_IMPERIAL = "imperial";
    private static final String PROPERTY_LOOK_AND_FEEL = "look";
    private static final String PROPERTY_POSITION_X = "position.x";
    private static final String PROPERTY_POSITION_Y = "position.y";
    private static final String PROPERTY_USER_NAME = "user.name";
    private static final String PROPERTY_USER_AGE = "user.age";
    private static final String PROPERTY_USER_WEIGHT = "user.weight";
    private static final String PROPERTY_USER_FEMALE = "user.female";
    private String configName = null;
    private File configFile;
    private Properties properties = new Properties();
    private static Config globalInstance;

    public Config() {
        this.configName = System.getProperty("user.home") + File.separator + ".fatcalc";
        this.setDefaults();
        this.configFile = new File(this.configName);
        globalInstance = this;
    }

    private void setDefaults() {
        this.properties.put(PROPERTY_LANGUAGE, Locale.getDefault().getLanguage());
        this.properties.put(PROPERTY_IMPERIAL, Boolean.toString(false));
        this.properties.put(PROPERTY_LOOK_AND_FEEL, "javax.swing.plaf.metal.MetalLookAndFeel");
        this.properties.put(PROPERTY_POSITION_X, Integer.toString(0));
        this.properties.put(PROPERTY_POSITION_Y, Integer.toString(0));
        this.properties.put(PROPERTY_USER_NAME, "");
        this.properties.put(PROPERTY_USER_AGE, Integer.toString(0));
        this.properties.put(PROPERTY_USER_WEIGHT, Double.toString(0.0));
        this.properties.put(PROPERTY_USER_FEMALE, Boolean.toString(false));
    }

    public String getConfigName() {
        return this.configName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.configFile.exists()) {
            if (this.configFile.isDirectory()) {
                System.err.println("Cant't save config to directory.");
                return;
            }
            if (this.configFile.delete()) {
                try {
                    this.configFile.createNewFile();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            } else {
                System.err.println("Cant't delete old config.");
                return;
            }
        }
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(this.configFile);
            this.properties.store(output, PROPERTIES_HEADER);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {
                    System.err.println(exception.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        FileInputStream input = null;
        if (this.configFile.exists()) {
            try {
                input = new FileInputStream(this.configFile);
                this.properties.load(input);
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {
                        System.err.println(exception.getMessage());
                    }
                }
            }
        }
    }

    public String getLanguage() {
        return this.properties.getProperty(PROPERTY_LANGUAGE);
    }

    public void setLanguage(String value) {
        this.properties.put(PROPERTY_LANGUAGE, value);
    }

    public boolean isImperial() {
        return Boolean.parseBoolean(this.properties.getProperty(PROPERTY_IMPERIAL));
    }

    public void setImperial(boolean value) {
        this.properties.put(PROPERTY_IMPERIAL, Boolean.toString(value));
    }

    public Point getWindowPosition() {
        int y;
        int x;
        try {
            x = Integer.parseInt(this.properties.getProperty(PROPERTY_POSITION_X));
            y = Integer.parseInt(this.properties.getProperty(PROPERTY_POSITION_Y));
        }
        catch (Exception exception) {
            x = 0;
            y = 0;
        }
        return new Point(x, y);
    }

    public void setWindowPosition(Point value) {
        this.properties.put(PROPERTY_POSITION_X, Integer.toString(value.x));
        this.properties.put(PROPERTY_POSITION_Y, Integer.toString(value.y));
    }

    public String getLookAndFeel() {
        return this.properties.getProperty(PROPERTY_LOOK_AND_FEEL);
    }

    public void setLookAndFeel(String value) {
        this.properties.put(PROPERTY_LOOK_AND_FEEL, value);
    }

    public boolean isUserFemale() {
        return Boolean.parseBoolean(this.properties.getProperty(PROPERTY_USER_FEMALE));
    }

    public void setUserFemale(boolean value) {
        this.properties.put(PROPERTY_USER_FEMALE, Boolean.toString(value));
    }

    public String getUserName() {
        return this.properties.getProperty(PROPERTY_USER_NAME);
    }

    public void setUserName(String value) {
        this.properties.put(PROPERTY_USER_NAME, value);
    }

    public String getUserAge() {
        return this.properties.getProperty(PROPERTY_USER_AGE);
    }

    public void setUserAge(String value) {
        this.properties.put(PROPERTY_USER_AGE, value);
    }

    public String getUserWeight() {
        return this.properties.getProperty(PROPERTY_USER_WEIGHT);
    }

    public void setUserWeight(String value) {
        this.properties.put(PROPERTY_USER_WEIGHT, value);
    }

    public static Config getGlobal() {
        return globalInstance;
    }
}

