/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import idiet.Daily;
import idiet.IDietApp;
import idiet.User;
import idiet.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.layout.GroupLayout;

public class DietSetup
extends JDialog {
    double totalCals = 0.0;
    double carbs;
    double carbsp;
    double fat;
    double fatp;
    double protein;
    double proteinp;
    double cals;
    int diettype = -1;
    boolean edit = false;
    User u;
    private JTextField CalField;
    private JTextField cField;
    private JTextField cpField;
    private JCheckBox cpcheck;
    public JComboBox dietListBox;
    private JButton doneBtn;
    private JLabel errorLabel;
    private JTextField fField;
    private JTextField fpField;
    private JCheckBox fpcheck;
    private JLabel goalCalories;
    private JComboBox goalComboBox;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JTextField pField;
    private JTextField ppField;
    private JCheckBox ppcheck;
    private JLabel scaloriesLabel;

    public DietSetup(User u, boolean edit) {
        super((Frame)null, true);
        this.edit = edit;
        this.totalCals = u.totalCals == 0.0 ? u.scals : u.totalCals;
        this.cals = u.scals;
        this.carbs = 0.0;
        this.carbsp = 0.0;
        this.fat = 0.0;
        this.fatp = 0.0;
        this.protein = 0.0;
        this.proteinp = 0.0;
        this.u = u;
        this.initComponents();
        switch (this.goalComboBox.getSelectedIndex()) {
            case 0: {
                this.goalCalories.setText(new Double(u.scals).toString() + " - suggested");
                break;
            }
            case 1: {
                this.goalCalories.setText(new Double((double)((int)u.scals) * 0.9).toString() + " - suggested");
                break;
            }
            case 2: {
                this.goalCalories.setText(new Double((double)((int)u.scals) * 1.1).toString() + " - suggested");
            }
        }
    }

    void getForm() {
        this.proteinp = Double.parseDouble(this.ppField.getText());
        this.protein = Double.parseDouble(this.pField.getText());
        this.fatp = Double.parseDouble(this.fpField.getText());
        this.fat = Double.parseDouble(this.fField.getText());
        this.carbs = Double.parseDouble(this.cField.getText());
        this.carbsp = Double.parseDouble(this.cpField.getText());
        this.totalCals = Double.parseDouble(this.CalField.getText());
        this.diettype = this.dietListBox.getSelectedIndex();
    }

    void setForm() {
        this.ppField.setText(new Double(this.proteinp).toString());
        this.pField.setText(new Double(this.protein).toString());
        this.cpField.setText(new Double(this.carbsp).toString());
        this.cField.setText(new Double(this.carbs).toString());
        this.fpField.setText(new Double(this.fatp).toString());
        this.fField.setText(new Double(this.fat).toString());
        this.CalField.setText(new Double(this.totalCals).toString());
        this.dietListBox.setSelectedIndex(this.diettype);
    }

    public void triggerCalsChanged() {
        this.CalFieldActionPerformed(null);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.dietListBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.CalField = new JTextField();
        this.jLabel3 = new JLabel();
        this.pField = new JTextField();
        this.jLabel4 = new JLabel();
        this.cField = new JTextField();
        this.jLabel5 = new JLabel();
        this.fField = new JTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.ppField = new JTextField();
        this.jLabel9 = new JLabel();
        this.cpField = new JTextField();
        this.jLabel10 = new JLabel();
        this.fpField = new JTextField();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.scaloriesLabel = new JLabel();
        this.goalComboBox = new JComboBox();
        this.jLabel13 = new JLabel();
        this.goalCalories = new JLabel();
        this.ppcheck = new JCheckBox();
        this.cpcheck = new JCheckBox();
        this.fpcheck = new JCheckBox();
        this.doneBtn = new JButton();
        this.errorLabel = new JLabel();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        ResourceMap resourceMap = Application.getInstance(IDietApp.class).getContext().getResourceMap(DietSetup.class);
        this.setTitle(resourceMap.getString("iDiet - Diet Setup.title", new Object[0]));
        this.setCursor(new Cursor(0));
        this.setFocusTraversalPolicyProvider(true);
        this.setName("iDiet - Diet Setup");
        this.setResizable(false);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, resourceMap.getString("jPanel1.border.title", new Object[0]), 0, 0, resourceMap.getFont("jPanel1.border.titleFont")));
        this.jPanel1.setName("jPanel1");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.dietListBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Custom Diet", "Atkins", "Body for Life", "Jenny Craig", "The Pritikin Principle", "The Zone", "USDA"}));
        this.dietListBox.setName("dietListBox");
        this.dietListBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.dietListBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.CalField.setText(new Double(this.totalCals).toString());
        this.CalField.setName("CalField");
        this.CalField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.CalFieldActionPerformed(evt);
            }
        });
        this.CalField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.CalFieldFocusLost(evt);
            }
        });
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.pField.setText(resourceMap.getString("pField.text", new Object[0]));
        this.pField.setName("pField");
        this.pField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.pFieldActionPerformed(evt);
            }
        });
        this.pField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.pFieldFocusLost(evt);
            }
        });
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.cField.setText(resourceMap.getString("cField.text", new Object[0]));
        this.cField.setName("cField");
        this.cField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.cFieldActionPerformed(evt);
            }
        });
        this.cField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.cFieldFocusLost(evt);
            }
        });
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.fField.setText(resourceMap.getString("fField.text", new Object[0]));
        this.fField.setName("fField");
        this.fField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.fFieldActionPerformed(evt);
            }
        });
        this.fField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.fFieldFocusLost(evt);
            }
        });
        this.jLabel6.setText(resourceMap.getString("jLabel6.text", new Object[0]));
        this.jLabel6.setName("jLabel6");
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.ppField.setText(resourceMap.getString("ppField.text", new Object[0]));
        this.ppField.setName("ppField");
        this.ppField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.ppFieldActionPerformed(evt);
            }
        });
        this.ppField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.ppFieldFocusLost(evt);
            }
        });
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.cpField.setText(resourceMap.getString("cpField.text", new Object[0]));
        this.cpField.setName("cpField");
        this.cpField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.cpFieldActionPerformed(evt);
            }
        });
        this.cpField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.cpFieldFocusLost(evt);
            }
        });
        this.jLabel10.setText(resourceMap.getString("jLabel10.text", new Object[0]));
        this.jLabel10.setName("jLabel10");
        this.fpField.setText(resourceMap.getString("fpField.text", new Object[0]));
        this.fpField.setName("fpField");
        this.fpField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.fpFieldActionPerformed(evt);
            }
        });
        this.fpField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                DietSetup.this.fpFieldFocusLost(evt);
            }
        });
        this.jLabel11.setText(resourceMap.getString("jLabel11.text", new Object[0]));
        this.jLabel11.setName("jLabel11");
        this.jLabel12.setText(resourceMap.getString("jLabel12.text", new Object[0]));
        this.jLabel12.setName("jLabel12");
        this.scaloriesLabel.setText(resourceMap.getString("scaloriesLabel.text", new Object[0]));
        this.scaloriesLabel.setName("scaloriesLabel");
        this.goalComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Maintain Weight", "Lose Weight", "Gain Weight"}));
        this.goalComboBox.setName("goalComboBox");
        this.goalComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.goalComboBoxActionPerformed(evt);
            }
        });
        this.jLabel13.setText(resourceMap.getString("jLabel13.text", new Object[0]));
        this.jLabel13.setName("jLabel13");
        this.goalCalories.setText(resourceMap.getString("goalCalories.text", new Object[0]));
        this.goalCalories.setName("goalCalories");
        this.ppcheck.setText(resourceMap.getString("ppcheck.text", new Object[0]));
        this.ppcheck.setName("ppcheck");
        this.ppcheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.ppcheckActionPerformed(evt);
            }
        });
        this.cpcheck.setName("cpcheck");
        this.cpcheck.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.cpcheckActionPerformed(evt);
            }
        });
        this.fpcheck.setName("fpcheck");
        this.fpcheck.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                DietSetup.this.fpcheckStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(199, 199, 199).add(this.scaloriesLabel)).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2, false).add(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(this.jLabel1)).add(1, jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1, false).add(2, this.jLabel2).add(2, this.jLabel4).add(2, this.jLabel3).add(2, this.jLabel5).add(2, this.jLabel12).add(2, this.jLabel13)))).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1, false).add(this.dietListBox, 0, -1, Short.MAX_VALUE).add(this.CalField).add(this.goalCalories, -1, -1, Short.MAX_VALUE).add(jPanel1Layout.createParallelGroup(1).add(2, jPanel1Layout.createSequentialGroup().add(this.pField, -2, 46, -2).addPreferredGap(0).add(this.jLabel6).add(27, 27, 27).add(this.ppField, -2, -1, -2).addPreferredGap(0).add(this.jLabel9).addPreferredGap(0).add(this.ppcheck)).add(2, jPanel1Layout.createSequentialGroup().add(this.cField, -2, 59, -2).addPreferredGap(0).add(this.jLabel7).add(27, 27, 27).add(this.cpField, -2, 53, -2).addPreferredGap(0).add(this.jLabel10).addPreferredGap(0).add(this.cpcheck)).add(2, jPanel1Layout.createSequentialGroup().add(this.fField, -2, 0, -2).addPreferredGap(0).add(this.jLabel8).add(27, 27, 27).add(this.fpField, -2, 68, -2).addPreferredGap(0).add(this.jLabel11).addPreferredGap(0).add(this.fpcheck)).add(2, this.goalComboBox, -2, 223, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.cField, this.cpField, this.fField, this.fpField, this.pField, this.ppField}, 1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.dietListBox, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel2).add(this.CalField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel4).add(this.jLabel7).add(this.jLabel10).add(this.cField, -2, -1, -2).add(this.cpField, -2, -1, -2).add(this.cpcheck)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.jLabel6).add(this.jLabel9).add(this.pField, -2, -1, -2).add(this.ppcheck).add(this.ppField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel5).add(this.fField, -2, -1, -2).add(this.jLabel8).add(this.fpField, -2, -1, -2).add(this.jLabel11).add(this.fpcheck)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel12).add(this.goalComboBox, -2, -1, -2)).add(9, 9, 9).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel13).add(this.goalCalories, -2, 17, -2)).add(20, 20, 20).add(this.scaloriesLabel)));
        this.doneBtn.setText(resourceMap.getString("doneBtn.text", new Object[0]));
        this.doneBtn.setName("doneBtn");
        this.doneBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.doneBtnActionPerformed(evt);
            }
        });
        this.errorLabel.setText(resourceMap.getString("errorLabel.text", new Object[0]));
        this.errorLabel.setName("errorLabel");
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setName("jButton2");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DietSetup.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel1, -1, -1, Short.MAX_VALUE).add(1, layout.createSequentialGroup().add(this.errorLabel, -2, 165, -2).addPreferredGap(0, 43, Short.MAX_VALUE).add(this.jButton2).addPreferredGap(0).add(this.doneBtn))).addContainerGap()));
        layout.linkSize(new Component[]{this.doneBtn, this.jButton2}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).addPreferredGap(0).add(layout.createParallelGroup(1).add(this.errorLabel, -1, 29, Short.MAX_VALUE).add(layout.createParallelGroup(3).add(this.doneBtn).add(this.jButton2))).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 418) / 2, (screenSize.height - 376) / 2, 418, 376);
    }

    private void CalFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.carbs = 40.0;
                this.carbsp = Utils.round(Utils.npercent(this.totalCals, this.carbs * 4.0), 1);
            } else {
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
            }
            this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
            this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            this.updateFields();
        }
    }

    public void updateFields() {
        if (this.diettype > -1) {
            this.dietListBox.setSelectedIndex(this.diettype);
        }
        if (this.diettype != 0) {
            this.cpcheck.setSelected(false);
            this.ppcheck.setSelected(false);
            this.fpcheck.setSelected(false);
            this.pField.setEnabled(true);
            this.cField.setEnabled(true);
            this.fField.setEnabled(true);
            this.cpField.setEnabled(true);
            this.ppField.setEnabled(true);
            this.fpField.setEnabled(true);
        }
        this.cField.setText(new Double(this.carbs).toString());
        this.fField.setText(new Double(this.fat).toString());
        this.pField.setText(new Double(this.protein).toString());
        this.cpField.setText(new Double(this.carbsp).toString());
        this.fpField.setText(new Double(this.fatp).toString());
        this.ppField.setText(new Double(this.proteinp).toString());
        if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
            this.cField.setEnabled(false);
        } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Jenny Craig") == 0 || this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Body for Life") == 0 || this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Zone") == 0 || this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("USDA") == 0) {
            this.cpField.setEnabled(false);
            this.ppField.setEnabled(false);
            this.fpField.setEnabled(false);
        } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Pritikin Principle") == 0) {
            this.fpField.setEnabled(false);
        }
    }

    private void ppFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.cpField.setEnabled(false);
            }
            if (this.carbsp + this.fatp + this.proteinp != 100.0) {
                if (this.cpField.isEnabled() && this.fpField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.carbsp = Utils.round(this.carbsp + diff * 3.0, 1);
                    this.fatp = Utils.round(this.fatp + diff * 1.0, 1);
                } else if (this.cpField.isEnabled()) {
                    this.carbsp = 100.0 - this.proteinp - this.fatp;
                } else if (this.fpField.isEnabled()) {
                    this.fatp = 100.0 - this.proteinp - this.carbsp;
                }
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            }
            this.updateFields();
        }
    }

    private void cpFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.protein = Double.parseDouble(this.pField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbs = Double.parseDouble(this.cField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fat = Double.parseDouble(this.fField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.totalCals = Utils.round(Utils.ppercent(this.carbs * 4.0, this.carbsp), 1);
                this.CalField.setText(new Double(this.totalCals).toString());
            }
            if (this.carbsp + this.fatp + this.proteinp != 100.0) {
                if (this.ppField.isEnabled() && this.fpField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.proteinp = Utils.round(this.proteinp + diff * 3.0, 1);
                    this.fatp = Utils.round(this.fatp + diff * 1.0, 1);
                } else if (this.ppField.isEnabled()) {
                    this.proteinp = 100.0 - this.carbsp - this.fatp;
                } else if (this.fpField.isEnabled()) {
                    this.fatp = 100.0 - this.proteinp - this.carbsp;
                }
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            }
            this.updateFields();
        }
    }

    private void fpFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.cpField.setEnabled(false);
            }
            if (this.carbsp + this.fatp + this.proteinp != 100.0) {
                if (this.cpField.isEnabled() && this.ppField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.carbsp = Utils.round(this.carbsp + diff * 2.0, 1);
                    this.proteinp = Utils.round(this.proteinp + diff * 2.0, 1);
                } else if (this.cpField.isEnabled()) {
                    this.carbsp = 100.0 - this.proteinp - this.fatp;
                } else if (this.ppField.isEnabled()) {
                    this.proteinp = 100.0 - this.fatp - this.carbsp;
                }
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            }
            this.updateFields();
        }
    }

    private void doneBtnActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.carbsp + this.fatp + this.proteinp != 100.0) {
                this.errorLabel.setForeground(new Color(255, 0, 0));
                this.jLabel2.setForeground(new Color(0, 0, 0));
                this.jLabel11.setForeground(new Color(255, 0, 0));
                this.jLabel9.setForeground(new Color(255, 0, 0));
                this.jLabel10.setForeground(new Color(255, 0, 0));
                this.errorLabel.setText("Percent do not add up to 100");
            } else {
                this.jLabel2.setForeground(new Color(0, 0, 0));
                this.jLabel11.setForeground(new Color(0, 0, 0));
                this.jLabel9.setForeground(new Color(0, 0, 0));
                this.jLabel10.setForeground(new Color(0, 0, 0));
                this.errorLabel.setText("");
                this.u.fat = this.fat;
                this.u.fatp = this.fatp;
                this.u.carbs = this.carbs;
                this.u.carbsp = this.carbsp;
                this.u.protein = this.protein;
                this.u.proteinp = this.proteinp;
                this.u.totalCals = this.totalCals;
                this.u.diettype = this.dietListBox.getSelectedIndex();
                this.u.setDiet(new String(new SimpleDateFormat("dd MMMMM yyyy").format(Calendar.getInstance().getTime())));
                if (!this.edit) {
                    File f = new File(System.getProperty("user.home") + "/.iDiet_profiles/" + this.u.getNames());
                    try {
                        FileOutputStream file = new FileOutputStream(f);
                        BufferedOutputStream buffer = new BufferedOutputStream(file);
                        ObjectOutputStream output = new ObjectOutputStream(buffer);
                        output.writeObject(this.u);
                        output.close();
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(null, "Could not save " + f.getName());
                        ex.printStackTrace();
                    }
                    new Daily(this.u).setVisible(true);
                }
                this.dispose();
            }
        } else {
            this.jLabel11.setForeground(new Color(0, 0, 0));
            this.jLabel9.setForeground(new Color(0, 0, 0));
            this.jLabel10.setForeground(new Color(0, 0, 0));
            this.errorLabel.setForeground(new Color(255, 0, 0));
            this.errorLabel.setText("Must enter calories");
        }
    }

    private void pFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.protein = Double.parseDouble(this.pField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbs = Double.parseDouble(this.cField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fat = Double.parseDouble(this.fField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.proteinp = Utils.round(Utils.npercent(this.totalCals, this.protein * 4.0), 1);
                this.fatp = 100.0 - this.carbsp - this.proteinp;
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Pritikin Principle") == 0) {
                this.proteinp = Utils.round(Utils.npercent(this.totalCals, this.protein * 4.0), 1);
                this.carbs = Utils.round((this.totalCals - this.protein * 4.0 - this.fat * 9.0) / 4.0, 1);
                this.carbsp = Utils.round(Utils.npercent(this.totalCals, this.carbs * 4.0), 1);
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Custom Diet") == 0) {
                this.proteinp = Utils.round(Utils.npercent(this.totalCals, this.protein * 4.0), 1);
                if (this.cpField.isEnabled() && this.fpField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.carbsp = Utils.round(this.carbsp + diff * 3.0, 1);
                    this.fatp = Utils.round(this.fatp + diff * 1.0, 1);
                } else if (this.cpField.isEnabled()) {
                    this.carbsp = 100.0 - this.proteinp - this.fatp;
                } else if (this.fpField.isEnabled()) {
                    this.fatp = 100.0 - this.proteinp - this.carbsp;
                }
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            } else {
                this.totalCals = Utils.round(Utils.ppercent(this.protein * 4.0, this.proteinp), 1);
                this.CalField.setText(new Double(this.totalCals).toString());
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
            }
            this.updateFields();
        }
    }

    private void cFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.protein = Double.parseDouble(this.pField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbs = Double.parseDouble(this.cField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fat = Double.parseDouble(this.fField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Pritikin Principle") == 0) {
                this.carbsp = Utils.round(Utils.npercent(this.totalCals, this.carbs * 4.0), 1);
                this.protein = Utils.round((this.totalCals - this.carbs * 4.0 - this.fat * 9.0) / 4.0, 1);
                this.proteinp = Utils.round(Utils.npercent(this.totalCals, this.protein * 4.0), 1);
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Custom Diet") == 0) {
                this.carbsp = Utils.round(Utils.npercent(this.totalCals, this.carbs * 4.0), 1);
                if (this.ppField.isEnabled() && this.fpField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.proteinp = Utils.round(this.proteinp + diff * 3.0, 1);
                    this.fatp = Utils.round(this.fatp + diff * 1.0, 1);
                } else if (this.ppField.isEnabled()) {
                    this.proteinp = 100.0 - this.carbsp - this.fatp;
                } else if (this.fpField.isEnabled()) {
                    this.fatp = 100.0 - this.proteinp - this.carbsp;
                }
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
            } else {
                this.totalCals = Utils.round(Utils.ppercent(this.carbs * 4.0, this.carbsp), 1);
                this.CalField.setText(new Double(this.totalCals).toString());
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
            }
            this.updateFields();
        }
    }

    private void fFieldActionPerformed(ActionEvent evt) {
        try {
            this.totalCals = Double.parseDouble(this.CalField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.proteinp = Double.parseDouble(this.ppField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbsp = Double.parseDouble(this.cpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fatp = Double.parseDouble(this.fpField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.protein = Double.parseDouble(this.pField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.carbs = Double.parseDouble(this.cField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.fat = Double.parseDouble(this.fField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.totalCals != 0.0) {
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.fatp = Utils.round(Utils.npercent(this.totalCals, this.fat * 4.0), 1);
                this.proteinp = 100.0 - this.carbsp - this.fatp;
                this.protein = Utils.round(Utils.percent(this.totalCals, this.protein) / 4.0, 1);
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Custom Diet") == 0) {
                this.fatp = Utils.round(Utils.npercent(this.totalCals, this.fat * 9.0), 1);
                if (this.cpField.isEnabled() && this.ppField.isEnabled()) {
                    double diff = (100.0 - this.proteinp - this.carbsp - this.fatp) / 4.0;
                    this.carbsp = Utils.round(this.carbsp + diff * 2.0, 1);
                    this.proteinp = Utils.round(this.proteinp + diff * 2.0, 1);
                } else if (this.cpField.isEnabled()) {
                    this.carbsp = 100.0 - this.proteinp - this.fatp;
                } else if (this.ppField.isEnabled()) {
                    this.proteinp = 100.0 - this.fatp - this.carbsp;
                }
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
            } else {
                this.totalCals = Utils.round(Utils.ppercent(this.fat * 9.0, this.fatp), 1);
                this.CalField.setText(new Double(this.totalCals).toString());
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
            }
            this.updateFields();
        }
    }

    private void dietListBoxActionPerformed(ActionEvent evt) {
        if (this.dietListBox.isFocusOwner()) {
            this.pField.setEnabled(true);
            this.cField.setEnabled(true);
            this.fField.setEnabled(true);
            this.cpField.setEnabled(true);
            this.ppField.setEnabled(true);
            this.fpField.setEnabled(true);
            this.cpcheck.setSelected(false);
            this.ppcheck.setSelected(false);
            this.fpcheck.setSelected(false);
            if (this.dietListBox.getSelectedIndex() != 0) {
                this.cpcheck.setEnabled(false);
                this.ppcheck.setEnabled(false);
                this.fpcheck.setEnabled(false);
            } else {
                this.cpcheck.setEnabled(true);
                this.ppcheck.setEnabled(true);
                this.fpcheck.setEnabled(true);
            }
            this.diettype = this.dietListBox.getSelectedIndex();
            if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Atkins") == 0) {
                this.carbs = 40.0;
                this.carbsp = Utils.round(Utils.npercent(this.totalCals, this.carbs * 4.0), 1);
                this.updateFields();
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Body for Life") == 0) {
                this.carbsp = 50.0;
                this.proteinp = 40.0;
                this.fatp = 10.0;
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.updateFields();
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("Jenny Craig") == 0 || this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("USDA") == 0) {
                this.proteinp = 22.5;
                this.carbsp = 55.0;
                this.fatp = 22.5;
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.updateFields();
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Pritikin Principle") == 0) {
                this.fatp = 10.0;
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.updateFields();
            } else if (this.dietListBox.getSelectedItem().toString().compareToIgnoreCase("The Zone") == 0) {
                this.fatp = 30.0;
                this.proteinp = 30.0;
                this.carbsp = 40.0;
                this.protein = Utils.round(Utils.percent(this.totalCals, this.proteinp) / 4.0, 1);
                this.carbs = Utils.round(Utils.percent(this.totalCals, this.carbsp) / 4.0, 1);
                this.fat = Utils.round(Utils.percent(this.totalCals, this.fatp) / 9.0, 1);
                this.updateFields();
            }
        }
    }

    private void goalComboBoxActionPerformed(ActionEvent evt) {
        switch (this.goalComboBox.getSelectedIndex()) {
            case 0: {
                this.goalCalories.setText(new Double(Utils.round(this.u.scals, 1)).toString() + " - suggested");
                break;
            }
            case 1: {
                this.goalCalories.setText(new Double(Utils.round(this.u.scals * 0.9, 1)).toString() + " - suggested");
                break;
            }
            case 2: {
                this.goalCalories.setText(new Double(Utils.round(this.u.scals * 1.1, 1)).toString() + " - suggested");
            }
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        if (!this.edit) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    private void ppcheckActionPerformed(ActionEvent evt) {
        if (this.ppcheck.isSelected()) {
            this.ppField.setEnabled(false);
        } else {
            this.ppField.setEnabled(true);
        }
    }

    private void cpcheckActionPerformed(ActionEvent evt) {
        if (this.cpcheck.isSelected()) {
            this.cpField.setEnabled(false);
        } else {
            this.cpField.setEnabled(true);
        }
    }

    private void fpcheckStateChanged(ChangeEvent evt) {
        if (this.fpcheck.isSelected()) {
            this.fpField.setEnabled(false);
        } else {
            this.fpField.setEnabled(true);
        }
    }

    private void cpFieldFocusLost(FocusEvent evt) {
        this.cpFieldActionPerformed(null);
    }

    private void ppFieldFocusLost(FocusEvent evt) {
        this.ppFieldActionPerformed(null);
    }

    private void fpFieldFocusLost(FocusEvent evt) {
        this.fpFieldActionPerformed(null);
    }

    private void cFieldFocusLost(FocusEvent evt) {
        this.cFieldActionPerformed(null);
    }

    private void pFieldFocusLost(FocusEvent evt) {
        this.pFieldActionPerformed(null);
    }

    private void fFieldFocusLost(FocusEvent evt) {
        this.fFieldActionPerformed(null);
    }

    private void CalFieldFocusLost(FocusEvent evt) {
        this.CalFieldActionPerformed(null);
    }
}

