/*
 * Decompiled with CFR 0.152.
 */
package idiet;

import idiet.FoodNode;
import idiet.Utils;
import java.io.Serializable;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TTNode
implements Serializable {
    private static final long serialVersionUID = 761439068L;
    String description;
    TTNode nodeP;
    boolean parent;
    boolean extended = false;
    ArrayList<Object> children = new ArrayList();
    double carbs = 0.0;
    double fats = 0.0;
    double proteins = 0.0;
    double calories = 0.0;
    double portion = 0.0;
    int type = 1;
    FoodNode fn;

    public TTNode(String name, boolean parenta) {
        this.description = name;
        this.parent = parenta;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getPortion() {
        return this.portion;
    }

    public void setPortion(double portion) {
        this.portion = portion;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public TTNode clone() {
        if (this.isParent()) {
            TTNode parentNode = new TTNode(this.description, true);
            for (int i = 0; i < this.numbChildren(); ++i) {
                parentNode.addChild(((TTNode)this.children.get(i)).clone());
            }
            return parentNode;
        }
        return new TTNode(this.description, this.calories, this.carbs, this.proteins, this.fats, this.portion, this.type, this.fn);
    }

    public TTNode(String name, double calories, double carbohydrates, double proteins, double fats) {
        this.parent = false;
        this.description = name;
        this.calories = calories;
        this.carbs = carbohydrates;
        this.proteins = proteins;
        this.fats = fats;
    }

    public TTNode(String name, double calories, double carbohydrates, double proteins, double fats, double portion, int type, FoodNode fn) {
        this.parent = false;
        this.portion = portion;
        this.type = type;
        this.fn = fn;
        this.description = name;
        this.calories = calories;
        this.carbs = carbohydrates;
        this.proteins = proteins;
        this.fats = fats;
    }

    public void addParent(TTNode p) {
        this.nodeP = p;
    }

    public boolean isParent() {
        return this.parent;
    }

    boolean isExtended() {
        return this.extended;
    }

    public TTNode getChildAt(int index) {
        if (this.parent && index < this.children.size()) {
            return (TTNode)this.children.get(index);
        }
        return null;
    }

    public ArrayList<Object> getChildren() {
        return this.children;
    }

    public int numbChildren() {
        if (this.parent) {
            return this.children.size();
        }
        return 0;
    }

    public boolean removeChild(TTNode m) {
        this.children.remove(this.children.indexOf(m));
        this.total();
        return true;
    }

    public void extend(boolean extend) {
        this.extended = extend;
    }

    public String toString() {
        return this.description;
    }

    public double getProteins() {
        return this.proteins;
    }

    public double getFats() {
        return this.fats;
    }

    public double getCarbs() {
        return this.carbs;
    }

    public double getCalories() {
        return this.calories;
    }

    public TTNode getParent() {
        if (this.isParent()) {
            return null;
        }
        return this.nodeP;
    }

    public boolean addChild(TTNode n) {
        if (this.isParent()) {
            this.children.add(n);
            n.addParent(this);
            this.total();
            return true;
        }
        return false;
    }

    public void total() {
        if (this.isParent()) {
            this.carbs = 0.0;
            this.fats = 0.0;
            this.proteins = 0.0;
            this.calories = 0.0;
            int c = this.numbChildren();
            for (int i = 0; i < c; ++i) {
                TTNode ch = this.getChildAt(i);
                this.carbs += ch.getCarbs();
                this.fats += ch.getFats();
                this.proteins += ch.getProteins();
                this.calories += ch.getCalories();
            }
            this.carbs = Utils.round(this.carbs, 3);
            this.fats = Utils.round(this.fats, 3);
            this.proteins = Utils.round(this.proteins, 3);
            this.calories = Utils.round(this.calories, 3);
        }
    }
}

