/*
 * Decompiled with CFR 0.152.
 */
package jtides;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jtides.JTides;
import jtides.MyJButton;
import jtides.SiteSet;
import jtides.TidesDoc;

public final class TidesFindNearest
extends JDialog {
    JTides main;
    ImageIcon tideIcon;
    ImageIcon currentIcon;
    ImageIcon tideCurrentIcon;
    TreeMap proximityTree;
    String[] fullList = null;
    boolean searching = false;
    private JButton CloseButton;
    private JTextField LatField;
    private JTextField LongField;
    private JTable OutputList;
    private JButton SearchButton;
    private JComboBox SearchType;
    private JButton UseDisplayButton;
    private JPanel content;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;

    public TidesFindNearest(Frame frame, boolean bl) {
        super(frame, bl);
        this.main = (JTides)frame;
        this.proximityTree = new TreeMap();
        this.tideIcon = new ImageIcon(this.main.getClass().getResource("icons/TideIcon.png"));
        this.currentIcon = new ImageIcon(this.main.getClass().getResource("icons/CurrentIcon.png"));
        this.tideCurrentIcon = new ImageIcon(this.main.getClass().getResource("icons/TideCurrentIcon.png"));
        this.initComponents();
        this.main.tideComp.tweakFont(this.OutputList);
        this.main.tideComp.tweakFont(this.LatField);
        this.main.tideComp.tweakFont(this.LongField);
        this.getDisplayPos();
        this.pack();
        this.SearchType.setRenderer(new MyDropDownListCellRenderer());
        this.setTitle("JTides 5.3" + " Find Nearest Sites");
        this.setupSearchTypes();
        this.setSize(600, 400);
        this.setVisible(true);
    }

    private void setupSearchTypes() {
        String[] stringArray = new String[]{"Tide & Current", "Tide only", "Current only"};
        ImageIcon[] imageIconArray = new ImageIcon[]{this.tideCurrentIcon, this.tideIcon, this.currentIcon};
        for (int i = 0; i < stringArray.length; ++i) {
            JLabel jLabel = new JLabel(stringArray[i], imageIconArray[i], 2);
            this.SearchType.addItem(jLabel);
        }
    }

    private void performSearch() {
        double d = this.getEntry(this.LatField);
        double d2 = this.getEntry(this.LongField);
        if (d < 1000.0 && d2 < 1000.0) {
            this.execSearch(d, d2);
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(null, "Please use an entry format like \"dd.dd [mm.mm] [n/s/e/w]\"", "Numeric Entry Error", 0);
        }
    }

    private void execSearch(final double d, final double d2) {
        if (!this.searching) {
            this.searching = true;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TidesFindNearest.this.execSearchThread(d, d2);
                    TidesFindNearest.this.searching = false;
                }
            };
            thread.start();
        }
    }

    private void execSearchThread(double d, double d2) {
        try {
            Object[][] objectArray;
            int n;
            Object[] objectArray2;
            Object object;
            int n2 = this.SearchType.getSelectedIndex();
            Complex complex = new Complex(d, d2);
            this.proximityTree.clear();
            int n3 = this.main.tideComp.siteIndex.size();
            int n4 = 0;
            this.jProgressBar1.setMinimum(0);
            this.jProgressBar1.setMaximum(n3);
            Iterator iterator = this.main.tideComp.siteIndex.iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                objectArray2 = this.main.tideComp.parseDelimLine((String)object, "\t");
                n = 1;
                bl = ((String)objectArray2.elementAt(0)).equals("T");
                if (n2 != 0) {
                    objectArray = (String)objectArray2.elementAt(0);
                    int n5 = n = n2 == 1 && bl || n2 == 2 && !bl ? 1 : 0;
                }
                if (n == 0) continue;
                objectArray = this.comp_pr_String((String)objectArray2.elementAt(5), (String)objectArray2.elementAt(4), complex);
                while (this.proximityTree.containsKey(new Double(objectArray.rad))) {
                    objectArray.rad += 1.0E-10;
                }
                this.proximityTree.put(new Double(objectArray.rad), object);
                this.jProgressBar1.setValue(++n4);
            }
            object = this.proximityTree.keySet();
            iterator = object.iterator();
            n3 = this.main.configValues.nearestSitesListSize;
            this.fullList = new String[n3];
            objectArray2 = new String[]{"Type", "Site Name", "Distance nm", "Bearing true"};
            n = objectArray2.length;
            objectArray = new String[n3][n];
            int[] nArray = new int[n];
            Graphics graphics = this.OutputList.getGraphics();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            for (n4 = 0; n4 < n3 && iterator.hasNext(); ++n4) {
                String string;
                this.fullList[n4] = string = (String)this.proximityTree.get(iterator.next());
                Vector vector = this.main.tideComp.parseDelimLine(string, "\t");
                String[] stringArray = vector.toArray(new String[0]);
                bl = stringArray[0].equals("T");
                Complex complex2 = this.comp_pr_String(stringArray[5], stringArray[4], complex);
                objectArray[n4][0] = bl ? "*" : " ";
                objectArray[n4][1] = stringArray[3];
                objectArray[n4][2] = this.main.tideComp.padChar(this.main.tideComp.formatDouble(complex2.rad, 1, false), 5, " ");
                objectArray[n4][3] = this.main.tideComp.padChar(this.main.tideComp.formatDouble(complex2.lat * 57.29577951308232, 1, false), 5, " ") + "\u00b0";
                for (int i = 1; i < n; ++i) {
                    int n6 = fontMetrics.stringWidth((String)objectArray[n4][i]);
                    if (n6 <= nArray[i]) continue;
                    nArray[i] = n6;
                }
            }
            for (int i = 0; i < n; ++i) {
                int n7 = fontMetrics.stringWidth(objectArray2[i]);
                if (n7 <= nArray[i]) continue;
                nArray[i] = n7;
            }
            graphics.dispose();
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.OutputList.setModel(defaultTableModel);
            this.OutputList.setSelectionMode(0);
            this.OutputList.getColumnModel().getColumn(0).setCellRenderer(new MyTableCellRenderer());
            TableColumn tableColumn = null;
            for (int i = 0; i < 4; ++i) {
                tableColumn = this.OutputList.getColumnModel().getColumn(i);
                tableColumn.setPreferredWidth(nArray[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jProgressBar1.setValue(0);
    }

    Complex comp_pr(Complex complex, Complex complex2) {
        Complex complex3 = new Complex();
        double d = complex.lng - complex2.lng;
        double d2 = Math.cos(d);
        double d3 = Math.sin(complex2.lat);
        double d4 = Math.cos(complex2.lat);
        complex3.rad = Math.acos(d3 * Math.sin(complex.lat) + d4 * Math.cos(complex.lat) * d2);
        complex3.rad *= 3437.746770784939;
        complex3.lat = Math.atan2(Math.sin(d), d4 * Math.tan(complex.lat) - d3 * d2);
        if (complex3.lat < 0.0) {
            complex3.lat = Math.PI * 2 + complex3.lat;
        }
        return complex3;
    }

    Complex comp_pr_String(String string, String string2, Complex complex) {
        Complex complex2 = null;
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            complex2 = new Complex(d *= 0.01745329251994329, d2 *= 0.01745329251994329);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.comp_pr(complex2, complex);
    }

    double getEntry(JTextField jTextField) {
        double d;
        block8: {
            d = 1000.0;
            double d2 = 0.0;
            double d3 = 0.0;
            String string = "";
            try {
                String string2 = jTextField.getText();
                string2 = this.main.tideComp.srchRplc(0, string2, ",", ".");
                Vector vector = this.main.tideComp.parseLine(string2);
                String[] stringArray = vector.toArray(new String[0]);
                if (stringArray.length > 0) {
                    d2 = Double.parseDouble(stringArray[0]);
                    if (stringArray.length > 1) {
                        if (Character.isDigit(stringArray[1].charAt(0))) {
                            d3 = Double.parseDouble(stringArray[1]);
                        } else {
                            string = stringArray[1];
                        }
                        if (stringArray.length > 2) {
                            string = stringArray[2];
                        }
                    }
                    d = (d2 + d3 / 60.0) * 0.01745329251994329;
                    if (string.length() > 0 && ((string = string.toLowerCase().substring(0, 1)).equals("w") || string.equals("s"))) {
                        d = -d;
                    }
                    break block8;
                }
                throw new Exception();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    private void putEntry(JTextField jTextField, double d, String string, String string2) {
        String string3 = d >= 0.0 ? string : string2;
        d = Math.abs(d);
        int n = (int)d;
        d -= (double)n;
        String string4 = n + " " + this.main.tideComp.formatDouble(d *= 60.0, 2, false) + " " + string3;
        jTextField.setText(string4);
    }

    public void getDisplayPos() {
        TidesDoc tidesDoc = this.main.tabbedPaneManager.getSelectedDoc();
        if (tidesDoc != null) {
            SiteSet siteSet = tidesDoc.siteSet;
            this.putEntry(this.LatField, siteSet.lat, "n", "s");
            this.putEntry(this.LongField, siteSet.lng, "e", "w");
            this.repaint();
        } else {
            this.putEntry(this.LatField, 0.0, "n", "s");
            this.putEntry(this.LongField, 0.0, "e", "w");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.SearchButton = new MyJButton();
        this.CloseButton = new MyJButton();
        this.content = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.LatField = new JTextField();
        this.LongField = new JTextField();
        this.SearchType = new JComboBox();
        this.UseDisplayButton = new MyJButton();
        this.jScrollPane1 = new JScrollPane();
        this.OutputList = new JTable();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TidesFindNearest.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new BorderLayout());
        this.jProgressBar1.setToolTipText("Progress of the search");
        this.jProgressBar1.setStringPainted(true);
        this.jPanel1.add((Component)this.jProgressBar1, "Center");
        this.SearchButton.setText("Search");
        this.SearchButton.setToolTipText("Refresh the list");
        this.SearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidesFindNearest.this.SearchButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.SearchButton, "West");
        this.CloseButton.setText("Close");
        this.CloseButton.setToolTipText("Close this dialog");
        this.CloseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidesFindNearest.this.CloseButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add((Component)this.CloseButton, "East");
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.content.setToolTipText("Enter location data");
        this.content.setMinimumSize(new Dimension(490, 55));
        this.content.setPreferredSize(new Dimension(490, 55));
        this.content.setLayout(new GridBagLayout());
        this.jLabel1.setText("Lat.");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("Lng.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.jLabel2, gridBagConstraints);
        this.LatField.setToolTipText("Use dd.dd [mm.mm] n/s/e/w format");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.LatField, gridBagConstraints);
        this.LongField.setToolTipText("Use dd.dd [mm.mm] n/s/e/w format");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.LongField, gridBagConstraints);
        this.SearchType.setToolTipText("Choose which entries to list");
        this.SearchType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TidesFindNearest.this.SearchTypeItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.SearchType, gridBagConstraints);
        this.UseDisplayButton.setText("Use display pos.");
        this.UseDisplayButton.setToolTipText("Use the position of the diplayed site");
        this.UseDisplayButton.setMaximumSize(new Dimension(Short.MAX_VALUE, 11));
        this.UseDisplayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TidesFindNearest.this.UseDisplayButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.content.add((Component)this.UseDisplayButton, gridBagConstraints);
        this.getContentPane().add((Component)this.content, "North");
        this.OutputList.setToolTipText("Click a site to display it");
        this.OutputList.setAutoResizeMode(0);
        this.OutputList.setRowHeight(22);
        this.OutputList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TidesFindNearest.this.OutputListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.OutputList);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
    }

    private void OutputListMouseClicked(MouseEvent mouseEvent) {
        this.openSelection();
    }

    private void SearchTypeItemStateChanged(ItemEvent itemEvent) {
        this.performSearch();
    }

    private void openSelection() {
        int n = this.OutputList.getSelectedRow();
        if (n != -1 && this.fullList != null && this.fullList.length > n) {
            this.main.openFile(this.fullList[n], true);
        }
    }

    private void UseDisplayButtonActionPerformed(ActionEvent actionEvent) {
        this.getDisplayPos();
    }

    private void SearchButtonActionPerformed(ActionEvent actionEvent) {
        this.performSearch();
    }

    private void CloseButtonActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.quit();
    }

    private void quit() {
        this.main.tabbedPaneManager.refocus();
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new TidesFindNearest((Frame)new JFrame(), true).setVisible(true);
    }

    final class Complex {
        double lat = 0.0;
        double lng = 0.0;
        double rad = 0.0;

        Complex(double d, double d2) {
            this.lat = d;
            this.lng = d2;
        }

        Complex(Complex complex) {
            this.lat = complex.lat;
            this.lng = complex.lng;
            this.rad = complex.rad;
        }

        Complex() {
        }
    }

    final class MyDropDownListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyDropDownListCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setText(jLabel.getText());
            this.setIcon(jLabel.getIcon());
            return this;
        }
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = object.toString();
            if (n2 == 0) {
                boolean bl3 = string.substring(0, 1).equals("*");
                this.setText("");
                this.setIcon(bl3 ? TidesFindNearest.this.tideIcon : TidesFindNearest.this.currentIcon);
            } else {
                this.setText(string);
            }
            this.setEnabled(jTable.isEnabled());
            this.setFont(jTable.getFont());
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }
}

