/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffScrollButton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class KunststoffScrollBarUI
extends MetalScrollBarUI {
    private Color col1 = new Color(255, 255, 255, 64);
    private Color col2 = new Color(255, 255, 255, 0);
    private Color col3 = new Color(0, 0, 0, 0);
    private Color col4 = new Color(0, 0, 0, 64);

    public static ComponentUI createUI(JComponent c) {
        return new KunststoffScrollBarUI();
    }

    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new KunststoffScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new KunststoffScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        Rectangle rec2;
        Rectangle rec1;
        Point grad2End;
        Point grad2Start;
        Point grad1End;
        Point grad1Start;
        super.paintThumb(g, c, thumbBounds);
        Graphics2D g2D = (Graphics2D)g;
        if (this.scrollbar.getOrientation() == 0) {
            grad1Start = new Point(thumbBounds.x, thumbBounds.y + 1);
            grad2Start = grad1End = new Point(thumbBounds.x, thumbBounds.y + thumbBounds.height / 2);
            grad2End = new Point(thumbBounds.x, thumbBounds.y + thumbBounds.height);
            rec1 = new Rectangle(grad1Start, new Dimension(thumbBounds.width, thumbBounds.height / 2));
            rec2 = new Rectangle(grad2Start, new Dimension(thumbBounds.width, thumbBounds.height / 2 + 1));
        } else {
            grad1Start = new Point(thumbBounds.x + 1, thumbBounds.y);
            grad2Start = grad1End = new Point(thumbBounds.x + thumbBounds.width / 2, thumbBounds.y);
            grad2End = new Point(thumbBounds.x + thumbBounds.width, thumbBounds.y);
            rec1 = new Rectangle(grad1Start, new Dimension(thumbBounds.width / 2, thumbBounds.height));
            rec2 = new Rectangle(grad2Start, new Dimension(thumbBounds.width / 2 + 1, thumbBounds.height));
        }
        GradientPaint gradient1 = new GradientPaint(grad1Start, this.col1, grad1End, this.col2);
        GradientPaint gradient2 = new GradientPaint(grad2Start, this.col3, grad2End, this.col4);
        g2D.setPaint(gradient1);
        g2D.fill(rec1);
        g2D.setPaint(gradient2);
        g2D.fill(rec2);
    }
}

