package com.incors.plaf.kunststoff;

/*
 * This code was developed by INCORS GmbH (www.incors.com).
 * It is published under the terms of the Lesser GNU Public License.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.plaf.*;
import javax.swing.plaf.basic.*;

public class KunststoffTextFieldUI extends BasicTextFieldUI{
  private Color col1 = new Color(0, 0, 0, 48);
  private Color col2 = new Color(0, 0, 0, 0);
  JComponent myComponent;

  KunststoffTextFieldUI(JComponent c) {
    super();
    myComponent = c;
  }

  public static ComponentUI createUI(JComponent c) {
    return new KunststoffTextFieldUI(c);
  }

  protected void paintBackground(Graphics g) {
    super.paintBackground(g);
    Rectangle editorRect = getVisibleEditorRect();
    Graphics2D g2D = (Graphics2D) g;
    // paint one gradient in the upper half of the text field
    GradientPaint gradient = new GradientPaint(0.0f, 0.0f, col1, 0.0f, (float) myComponent.getHeight()*2/3, col2);
    g2D.setPaint(gradient);
    g2D.fill(editorRect);
  }
}