/*
 * 01/09/2002 - 20:43:57
 *
 * DefaultFrameAssembler.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package info.jdictionary;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.BorderLayout;
import javax.swing.BoxLayout;
import info.jdictionary.JDictionary;
import info.jdictionary.modules.*;
import info.jdictionary.ImageBank;
import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import info.jdictionary.gui.JDictionaryTheme;

public class DefaultFrameAssembler {

    private JFrame frame;
    private final JDictionary jDictionary;

    private DefaultFooter footer;
    private DefaultHeader header;
    private DefaultLabelledPane labelledPane;
    private DefaultOutput output;
    private DefaultToolBar toolBar;
    private DefaultTreeView treeView;
    private DefaultMenuBar menuBar;
    private int activateCounter = 0;

    JPanel upperPanel = new JPanel();
    public JScrollPane outputScrollPane = new JScrollPane(); //fix it
    JScrollPane pluginTreeViewScrollPane = new JScrollPane();
    JSplitPane outputSplitPane = new JSplitPane();
    JSplitPane pluginSplitPane = new JSplitPane();

    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BoxLayout boxLayout1;

    public DefaultFrameAssembler(final JDictionary jDictionary, JFrame frame) {
        this.jDictionary = jDictionary;
        this.frame = frame;
        boxLayout1 = new BoxLayout(frame.getContentPane(), BoxLayout.Y_AXIS);
        footer = new DefaultFooter(this);
        header = new DefaultHeader(this);
        labelledPane = new DefaultLabelledPane(this);
        output = new DefaultOutput(this);
        toolBar = new DefaultToolBar(this);
        treeView = new DefaultTreeView(this);
        menuBar = new DefaultMenuBar(this);

        frame.addComponentListener(new ComponentAdapter() {
                                 public void componentResized(ComponentEvent e) {
                                     frameResized(e);
                                 }
                             }
                            );

        frame.addWindowListener(new WindowAdapter() {
                              public void windowClosing(WindowEvent e) {
                                  jDictionary.closeJDictionary();
                              }
                              public void windowActivated(WindowEvent e) {
                                  if(activateCounter > 0)
                                      jDictionary.getPluginManager().scanPlugins();
                                  activateCounter++;
                              }
                          }
                         );

        assemble();
        frame.pack();
        restoreSavedScreenState();
        frame.show();
    }


    private void assemble() {
        frame.setTitle(JDictionary.getString("JDictionaryName") + " " + JDictionary.getString("JDictionaryVersion"));
        frame.setIconImage(IconBank.world.getImage());
        frame.getContentPane().setLayout(boxLayout1);
        frame.getContentPane().add(header);
        frame.getContentPane().add(outputSplitPane, null);
        frame.getContentPane().add(footer);

        outputSplitPane.setMaximumSize(new Dimension(2048, 2048));
        outputSplitPane.setContinuousLayout(true);
        outputSplitPane.setOneTouchExpandable(true);
        outputSplitPane.add(outputScrollPane, JSplitPane.RIGHT);
        outputSplitPane.add(pluginSplitPane, JSplitPane.LEFT);

        pluginSplitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        pluginSplitPane.setContinuousLayout(true);
        pluginSplitPane.setOneTouchExpandable(true);
        pluginSplitPane.add(upperPanel, JSplitPane.TOP);
        pluginSplitPane.add(labelledPane, JSplitPane.BOTTOM);

        outputScrollPane.getViewport().add(output, null);

        pluginTreeViewScrollPane.getViewport().add(treeView, null);

        frame.setJMenuBar(menuBar);
        upperPanel.setLayout(borderLayout1);
        upperPanel.add(pluginTreeViewScrollPane, BorderLayout.CENTER);

        upperPanel.add(toolBar, BorderLayout.NORTH);

        setLookAndFeel(null);
    }


    public boolean setLookAndFeel(String lf) {
        KunststoffLookAndFeel kunststoffLF = new KunststoffLookAndFeel();
        kunststoffLF.setCurrentTheme(new JDictionaryTheme());
        try {
            UIManager.setLookAndFeel(kunststoffLF);
        }
        catch(javax.swing.UnsupportedLookAndFeelException e) {return false;}
        SwingUtilities.updateComponentTreeUI(frame);

        return true;
    }


    public DefaultOutput getOutput() {
        return output;
    }


    public DefaultTreeView getTreeView() {
        return treeView;
    }


    void restoreSavedScreenState() {
        frame.setSize(new Dimension(jDictionary.getPrefs().width, jDictionary.getPrefs().height));
        outputSplitPane.setDividerLocation(jDictionary.getPrefs().dividerLocation);
    }


    public void setPluginSplitPaneDivider() {
        pluginSplitPane.setDividerLocation(pluginSplitPane.getMaximumDividerLocation());
    }


    public void savePrefs() {
        jDictionary.getPrefs().width = (int)frame.getSize().getWidth();
        jDictionary.getPrefs().height = (int)frame.getSize().getHeight();
        jDictionary.getPrefs().dividerLocation = outputSplitPane.getDividerLocation();
    }


    public JDictionary getJDictionary() {
        return jDictionary;
    }


    void frameResized(ComponentEvent e) {
        setPluginSplitPaneDivider();
        Dimension dim = frame.getSize();
        if (dim.getWidth() < 620 || dim.getHeight() < 385) {
            if (dim.getWidth() < 620)
                dim.width = 620;
            if (dim.getHeight() < 385)
                dim.height = 385;
            frame.setSize(dim);
        }
    }
}