/*
 * 01/09/2002 - 20:43:57
 *
 * UpgradeAgent.java -
 * Copyright (C) 2002 Csaba Kertsz
 * kcsaba@jdictionary.info
 * www.jdictionary.info
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


package info.jdictionary.gui;

import info.jdictionary.JDictionary;
import info.jdictionary.ImageBank;
import info.jdictionary.IconBank;
import info.jdictionary.FileDownloader;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JProgressBar;
import javax.swing.ImageIcon;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import java.util.zip.ZipFile;
import java.util.zip.ZipEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Enumeration;

public class UpgradeAgent extends JPanel {

    JDictionary jDictionary;
    DownloadThread downloadThread;
    boolean downloading = false;
    boolean success = false;
    boolean downloadError = false;
    JLabel header = new JLabel(ImageBank.getImageByName("UpgradeHeader.png"));
    JLabel text;
    JLabel waitText = new JLabel(JDictionary.getString("InfoAboutNewVersion"), IconBank.info, 0);
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    JPanel actionPanel = new JPanel();
    JScrollPane scrollPane = new JScrollPane();
    JProgressBar progressBar = new JProgressBar();
    JButton button = new JButton();
    BoxLayout boxLayout1 = new BoxLayout(this, BoxLayout.Y_AXIS);
    BoxLayout boxLayout2 = new BoxLayout(actionPanel, BoxLayout.Y_AXIS);
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();


    public UpgradeAgent(JDictionary jDictionary) {
        super();
        this.jDictionary = jDictionary;
        try {
            jbInit();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    private void jbInit() throws Exception {
        setMinimumSize(new Dimension(400, 300));
        setPreferredSize(new Dimension(400, 300));
        setLayout(boxLayout1);
        setBackground(Color.white);
        jPanel1.setLayout(borderLayout1);
        jPanel1.setBackground(Color.white);
        jPanel1.add(waitText, BorderLayout.CENTER);
        scrollPane.setAlignmentX((float) 0.0);
        scrollPane.getViewport().add(jPanel1);
        actionPanel.setLayout(boxLayout2);
        actionPanel.setBackground(Color.white);
        jPanel2.setLayout(borderLayout2);
        jPanel2.setMinimumSize(new Dimension(0, 55));
        jPanel2.setPreferredSize(new Dimension(0, 55));
        jPanel2.setMaximumSize(new Dimension(5000, 55));
        jPanel2.setAlignmentX((float)0.0);
        jPanel2.add(actionPanel);
        progressBar.setStringPainted(true);
        button.setAlignmentX((float)0.5);
        button.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    button_actionPerformed(e);
                }
            });

        add(header, null);
        add(scrollPane, null);
        add(jPanel2, null);
        downloadInfo();
    }


    void upgradeActionPanel() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                if(downloading) {
                    actionPanel.removeAll();
                    button.setText(JDictionary.getString("StopDownload"));
                    button.setIcon(IconBank.stop);
                    actionPanel.add(button);
                    actionPanel.add(progressBar);
                    actionPanel.validate();
                    actionPanel.repaint();
                    return;
                }
                if(!success) {
                    actionPanel.removeAll();
                    return;
                }
                if(!permissionToUpgrade()) {
                    actionPanel.removeAll();
                    actionPanel.setLayout(new BorderLayout());
                    JLabel error = new JLabel(JDictionary.getString("NoPermission"), IconBank.caution, 0);
                    actionPanel.add(error);
                    actionPanel.validate();
                    actionPanel.repaint();
                    return;
                }
                actionPanel.removeAll();
                button.setText(JDictionary.getString("DownloadAndUpgrade"));
                button.setIcon(IconBank.laptopIn);
                button.setEnabled(true);
                actionPanel.add(button);
                if(downloadError) {
                    JLabel errorLabel = new JLabel(JDictionary.getString("DownloadTip4") + " " + JDictionary.getString("WebSite"), IconBank.caution, 0);
                    errorLabel.setAlignmentX((float)0.5);
                    actionPanel.add(errorLabel);
                }
                progressBar.setValue(progressBar.getMinimum());
                progressBar.setString(JDictionary.getString("SearchingForDownloadServer"));
                actionPanel.validate();
                actionPanel.repaint();
            }
        });
    }


    void downloadInfo() {
        new Thread() {
            public void run() {
                URL textURL = null;
                float latestJDictionaryVersion = jDictionary.getNewJDictionaryVersionChecker().getLatestVersion();
                if(latestJDictionaryVersion <= 0) {
                    success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(jDictionary);
                    //networkErrorCenteredPanel.addLine(new JLabel(JDictionary.getString("DownloadTip4"), IconBank.bulb, 0));
                    //networkErrorCenteredPanel.addLine(new JLabel("           " + JDictionary.getString("WebSite")));
                    showComponent(networkErrorCenteredPanel);
                    upgradeActionPanel();
                    return;
                }

                if(jDictionary.getJDictionaryVersion() >= latestJDictionaryVersion) {
                    text = new JLabel(JDictionary.getString("UsingLatestJDictionary"), IconBank.bulb, 0);
                    showComponent(text);
                    upgradeActionPanel();
                    return;
                }

                textURL = getTextURL();
                //textURL = null; //for testing
                if(textURL == null) {
                    success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(jDictionary);
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel(JDictionary.getString("DownloadTip4"), IconBank.bulb, 0));
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel("           " + JDictionary.getString("WebSite")));
                    showComponent(networkErrorCenteredPanel);
                    upgradeActionPanel();
                    return;
                }
                try {
                text = new JLabel(new ImageIcon(textURL));
                }
                catch(java.lang.Exception e) {
                    success = false;
                    NetworkErrorCenteredPanel networkErrorCenteredPanel = new NetworkErrorCenteredPanel(jDictionary);
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel(JDictionary.getString("DownloadTip4"), IconBank.info, 0));
                    networkErrorCenteredPanel.getNetworkErrorPanel().addLine(new JLabel("           " + JDictionary.getString("WebSite")));
                    showComponent(networkErrorCenteredPanel);
                    upgradeActionPanel();
                    return;
                }
                success = true;
                showComponent(text);
                upgradeActionPanel();
            }
        }.start();
    add(jPanel2, null);
    }


    void showComponent(final JComponent component) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                jPanel1.removeAll();
                jPanel1.add(component, BorderLayout.CENTER);
                jPanel1.validate();
                scrollPane.validate();
                jPanel1.repaint();
            }
        });
    }


    boolean permissionToUpgrade() {
        File f = new File(jDictionary.getBaseDir() + jDictionary.getFileSeparator() + "jdictionary.jar");
        if(f.canWrite())
            return true;
        return false;
    }


    void button_actionPerformed(ActionEvent e) {
        if(!downloading) {
            downloading = true;
            downloadError = false;
            upgradeActionPanel();
            startDownload();
        }
        else {
            downloading = false;
            downloadThread.terminate();
            downloadThread = null;
            upgradeActionPanel();
        }
    }


    void startDownload() {
        downloadThread = new DownloadThread();
        downloadThread.start();
    }


    public boolean isSuccess() {
        return success;
    }


    private URL getTextURL() {
        URL textURL = null;
        try {
            textURL = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("InfoAboutNewVersionFile")+ "_" + JDictionary.getLanguage());
            if(textURL.openConnection().getContentLength() > 5000)
                return textURL;

            textURL = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("InfoAboutNewVersionFile"));
            if(textURL.openConnection().getContentLength() > 5000)
                return textURL;

            textURL = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoAboutNewVersionFile")+ "_" + JDictionary.getLanguage());
            if(textURL.openConnection().getContentLength() > 5000)
                return textURL;

            textURL = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("InfoAboutNewVersionFile"));
            if(textURL.openConnection().getContentLength() > 5000)
                return textURL;
        }
        catch(java.net.MalformedURLException e) {}
        catch(java.io.IOException e) {}
        return null;
    }


    class DownloadThread extends Thread {
        FileDownloader downloader;
        boolean terminated = false;

        public void run() {
            byte[] b = null;
            downloader = new FileDownloader();
            b = downloader.download(getUpgradeURL(), progressBar);
            if(b == null) {
                downloading = false;
                if(!terminated)
                    downloadError = true;
                upgradeActionPanel();
                return;
            }
            button.setEnabled(false);
            extractUpgrade(b);

            jDictionary.getPluginManager().removeAllPlugins();
            try {
                Runtime.getRuntime().exec(System.getProperty("java.home") + JDictionary.getFileSeparator()+ "bin" + JDictionary.getFileSeparator() + "java Upgrader", null, new File(jDictionary.getBaseDir()));
            }
            catch(java.io.IOException e) {}
            System.exit(0);
        }


        public void terminate() {
            terminated = true;
            downloader.terminate();
        }


        void extractUpgrade(byte[] b) {
            try {
                File f = new File("upgrade");
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(b);
                fos.close();
                ZipFile zf = new ZipFile("upgrade");
                ZipEntry ze= null;
                InputStream is = null;
                Enumeration entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ze = (ZipEntry)entries.nextElement();
                    f = new File(jDictionary.getBaseDir() + jDictionary.getFileSeparator() + ze.getName());
                    if (f.exists())
                        f.delete();
                    fos = new FileOutputStream(f);
                    is = zf.getInputStream(ze);
                    int c = 0;
                    while((c = is.read()) != -1)
                        fos.write(c);
                }
                fos.close();
                is.close();
                zf.close();
                f = new File("upgrade");
                f.delete();
            }
            catch(java.io.IOException e) {}
        }


        URL getUpgradeURL() {
            URL url = null;
            try {
                url = new URL(JDictionary.getString("SourceforgeDownloadServerURL") + "/" + JDictionary.getString("UpgradeFile"));
                if(url.openConnection().getContentLength() > 20000)
                    return url;
                url = new URL(JDictionary.getString("InfoServerURL") + "/" + JDictionary.getString("UpgradeFile"));
            }
            catch(java.lang.Exception e) {return null;}
            return url;
        }
    }
}