/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.awt;

import com.eteks.parser.CompiledFunction;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class Curve2DDisplay
extends Canvas {
    private double[] values;
    private double minimumX;
    private double maximumX;
    private double minimumY = 0.0;
    private double maximumY = 0.0;
    private CompiledFunction function = null;
    private static final boolean regular = true;

    public Dimension preferredSize() {
        return new Dimension(300, 200);
    }

    public void computeCurve(CompiledFunction compiledFunction, double d, double d2) {
        this.function = compiledFunction;
        this.minimumX = d;
        this.maximumX = d2;
        this.values = new double[this.size().width];
        double[] dArray = new double[1];
        double d3 = (d2 - d) / (double)this.values.length;
        int n = 0;
        while (n < this.values.length) {
            dArray[0] = (double)n * d3 + d;
            this.values[n] = compiledFunction.computeFunction(dArray);
            ++n;
        }
        this.repaint();
    }

    public void reshape(int n, int n2, int n3, int n4) {
        this.values = null;
        super.reshape(n, n2, n3, n4);
        if (this.function != null) {
            this.computeCurve(this.function, this.minimumX, this.maximumX);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        if (this.values != null) {
            Dimension dimension = this.size();
            int n = dimension.height / 2 - (int)(this.values[0] / (this.maximumX - this.minimumX) * (double)dimension.width);
            int n2 = 1;
            while (n2 < this.values.length) {
                int n3 = dimension.height / 2 - (int)(this.values[n2] / (this.maximumX - this.minimumX) * (double)dimension.width);
                if (this.values[n2 - 1] == this.values[n2 - 1] && this.values[n2] == this.values[n2]) {
                    graphics.drawLine(n2 - 1, n, n2, n3);
                }
                n = n3;
                ++n2;
            }
            graphics.setColor(this.getBackground());
            graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, false);
        }
    }
}

