/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.d3d;

import com.eteks.tools.d3d.CoordinatesArray;
import com.eteks.tools.d3d.Matrix3D;

public class Point3D
extends CoordinatesArray {
    public static final int HOMOGENEOUS_COORD = 3;

    public Point3D() {
        this.coord = new float[4];
        this.coord[3] = 1.0f;
    }

    public Point3D(float f, float f2, float f3) {
        this();
        this.coord[0] = f;
        this.coord[1] = f2;
        this.coord[2] = f3;
    }

    public Object clone() {
        return new Point3D(this.coord[0], this.coord[1], this.coord[2]);
    }

    public String toString() {
        String string = "Point3D :";
        int n = 0;
        while (n < 4) {
            string = String.valueOf(string) + " " + this.coord[n];
            ++n;
        }
        return string;
    }

    public Point3D multiplyMatrixByPoint(Matrix3D matrix3D) {
        int n;
        Point3D point3D = new Point3D();
        point3D.coord[3] = 0.0f;
        int n2 = 0;
        while (n2 <= 3) {
            n = 0;
            while (n <= 3) {
                int n3 = n2;
                point3D.coord[n3] = point3D.coord[n3] + matrix3D.getValue(n2, n) * this.coord[n];
                ++n;
            }
            ++n2;
        }
        if (point3D.coord[3] != 1.0f && point3D.coord[3] != 0.0f) {
            n = 0;
            while (n <= 2) {
                int n4 = n++;
                point3D.coord[n4] = point3D.coord[n4] / point3D.coord[3];
            }
        }
        point3D.coord[3] = 1.0f;
        return point3D;
    }
}

