/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.tools.d3d;

import com.eteks.tools.d3d.Point3D;
import com.eteks.tools.d3d.Point3D2D;
import com.eteks.tools.d3d.Vector3D;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;

public class Polygon3D {
    protected Point3D2D[] points;
    private int currentPoint = 0;
    private Color color;
    private Color litColor;

    public Polygon3D(int n, Color color) {
        this.points = new Point3D2D[n];
        this.color = this.litColor = color;
    }

    public void addPoint(Point3D2D point3D2D) {
        if (this.currentPoint < this.points.length) {
            this.points[this.currentPoint++] = point3D2D;
        }
    }

    public void computeLitColor(Vector3D vector3D, float f, float f2, float f3, float f4) {
        if (this.currentPoint >= 3) {
            Vector3D vector3D2 = new Vector3D(this.points[1], this.points[0]).getCrossProduct(new Vector3D(this.points[1], this.points[2]));
            float f5 = vector3D2.getDotProduct(vector3D) / (vector3D2.getLength() * vector3D.getLength());
            float f6 = f2 * f * Math.abs(f5) + f4 * f3;
            if (f6 > 1.0f) {
                f6 = 1.0f;
            }
            this.litColor = new Color((int)((float)this.color.getRed() * f6), (int)((float)this.color.getGreen() * f6), (int)((float)this.color.getBlue() * f6));
        }
    }

    public void paint(Graphics graphics) {
        Point3D point3D;
        Vector3D vector3D;
        if (this.currentPoint >= 3 && (vector3D = new Vector3D(point3D = new Point3D(this.points[1].getScreenXCoordinate(), this.points[1].getScreenYCoordinate(), this.points[1].getScreenZCoordinate()), new Point3D(this.points[0].getScreenXCoordinate(), this.points[0].getScreenYCoordinate(), this.points[0].getScreenZCoordinate())).getCrossProduct(new Vector3D(point3D, new Point3D(this.points[2].getScreenXCoordinate(), this.points[2].getScreenYCoordinate(), this.points[2].getScreenZCoordinate())))).getZ() > 0.0f) {
            Polygon polygon = new Polygon();
            int n = 0;
            while (n < this.points.length) {
                polygon.addPoint(Math.round(this.points[n].getScreenXCoordinate()), Math.round(this.points[n].getScreenYCoordinate()));
                ++n;
            }
            graphics.setColor(this.litColor);
            graphics.fillPolygon(polygon);
        }
    }
}

