/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.Function;
import com.eteks.parser.Syntax;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class AbstractSyntax
implements Syntax {
    private Hashtable constantKeys = new Hashtable();
    private Hashtable unaryOperatorKeys = new Hashtable();
    private Hashtable binaryOperatorKeys = new Hashtable();
    private Hashtable conditionPartKeys = new Hashtable();
    private Hashtable commonFunctionKeys = new Hashtable();
    private Hashtable functions = new Hashtable();
    private Hashtable operatorsPriority = new Hashtable();
    private String whiteSpaceCharacters;
    private char openingBracket;
    private char closingBracket;
    private char parameterSeparator;
    private String assignmentOperator;
    private String delimiters;
    private boolean caseSensitive;
    private boolean shortSyntax;

    public AbstractSyntax() {
        this(false);
    }

    public AbstractSyntax(boolean bl) {
        this.caseSensitive = bl;
    }

    public Object getConstantKey(String string) {
        return this.constantKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public void setConstantKey(String string, Object object) {
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.constantKeys.put(string, object);
    }

    public Object getUnaryOperatorKey(String string) {
        return this.unaryOperatorKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public void setUnaryOperatorKey(String string, Object object) {
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.unaryOperatorKeys.put(string, object);
        this.delimiters = null;
    }

    public Object getBinaryOperatorKey(String string) {
        return this.binaryOperatorKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public void setBinaryOperatorKey(String string, Object object) {
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.binaryOperatorKeys.put(string, object);
        this.delimiters = null;
    }

    public Object getConditionPartKey(String string) {
        return this.conditionPartKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public int getConditionPartCount() {
        return this.conditionPartKeys.contains(Syntax.CONDITION_IF) ? 3 : 2;
    }

    public void setConditionPartKey(String string, Object object) {
        if (!(Syntax.CONDITION_IF.equals(object) || Syntax.CONDITION_THEN.equals(object) || Syntax.CONDITION_ELSE.equals(object))) {
            throw new IllegalArgumentException("Not a valid condition part key");
        }
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.conditionPartKeys.put(string, object);
        this.delimiters = null;
    }

    public Object getCommonFunctionKey(String string) {
        return this.commonFunctionKeys.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public void setCommonFunctionKey(String string, Object object) {
        if (!this.isCaseSensitive()) {
            string = string.toUpperCase();
        }
        this.commonFunctionKeys.put(string, object);
    }

    public Function getFunction(String string) {
        return (Function)this.functions.get(this.isCaseSensitive() ? string : string.toUpperCase());
    }

    public void addFunction(Function function) {
        String string = this.isCaseSensitive() ? function.getName() : function.getName().toUpperCase();
        this.functions.put(string, function);
    }

    public void removeFunction(Function function) {
        String string = this.isCaseSensitive() ? function.getName() : function.getName().toUpperCase();
        this.functions.remove(string);
    }

    public int getBinaryOperatorPriority(Object object) {
        Integer n = (Integer)this.operatorsPriority.get(object);
        if (n != null) {
            return n;
        }
        return 0;
    }

    public void setBinaryOperatorPriority(Object object, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("priority can't be negative");
        }
        this.operatorsPriority.put(object, new Integer(n));
    }

    public String getWhiteSpaceCharacters() {
        return this.whiteSpaceCharacters;
    }

    public void setWhiteSpaceCharacters(String string) {
        this.whiteSpaceCharacters = string;
        this.delimiters = null;
    }

    public char getOpeningBracket() {
        return this.openingBracket;
    }

    public void setOpeningBracket(char c) {
        this.openingBracket = c;
        this.delimiters = null;
    }

    public char getClosingBracket() {
        return this.closingBracket;
    }

    public void setClosingBracket(char c) {
        this.closingBracket = c;
        this.delimiters = null;
    }

    public char getParameterSeparator() {
        return this.parameterSeparator;
    }

    public void setParameterSeparator(char c) {
        this.parameterSeparator = c;
        this.delimiters = null;
    }

    public String getDelimiters() {
        if (this.delimiters == null) {
            this.initDelimiters();
        }
        return this.delimiters;
    }

    private void initDelimiters() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getWhiteSpaceCharacters() != null) {
            stringBuffer.append(this.getWhiteSpaceCharacters());
        }
        if (this.getOpeningBracket() != '\u0000') {
            stringBuffer.append(String.valueOf(this.getOpeningBracket()));
        }
        if (this.getClosingBracket() != '\u0000') {
            stringBuffer.append(String.valueOf(this.getClosingBracket()));
        }
        if (this.getParameterSeparator() != '\u0000') {
            stringBuffer.append(String.valueOf(this.getParameterSeparator()));
        }
        this.addInvalidChars(stringBuffer, this.unaryOperatorKeys.keys());
        this.addInvalidChars(stringBuffer, this.binaryOperatorKeys.keys());
        this.addInvalidChars(stringBuffer, this.conditionPartKeys.keys());
        this.delimiters = stringBuffer.toString();
    }

    private void addInvalidChars(StringBuffer stringBuffer, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.isValidIdentifier(string)) continue;
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (!this.isValidIdentifier(String.valueOf(c)) && stringBuffer.toString().indexOf(c) == -1) {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
    }

    public String getAssignmentOperator() {
        return this.assignmentOperator;
    }

    public void setAssignmentOperator(String string) {
        this.assignmentOperator = string;
    }

    public final boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isShortSyntax() {
        return this.shortSyntax;
    }

    public void setShortSyntax(boolean bl) {
        this.shortSyntax = bl;
    }

    protected Number getLiteralNumber(String string, StringBuffer stringBuffer) {
        char c;
        int n = string.length();
        if (n == 0) {
            return null;
        }
        int n2 = 0;
        char c2 = string.charAt(0);
        if (c2 >= '0' && c2 <= '9') {
            stringBuffer.append(c2);
        } else if (n > 1 && c2 == '.' && (c = string.charAt(1)) >= '0' && c <= '9') {
            stringBuffer.append(c2);
            ++n2;
        } else if (n > 1 && (c2 == '+' || c2 == '-') && ((c = string.charAt(1)) >= '0' && c <= '9' || n > 2 && c == '.' && (c = string.charAt(1)) >= '0' && c <= '9')) {
            stringBuffer.append(c2);
        } else {
            return null;
        }
        int n3 = 1;
        while (n3 < n && ((c2 = string.charAt(n3)) >= '0' && c2 <= '9' || c2 == '.' && n2++ == 0)) {
            stringBuffer.append(c2);
            ++n3;
        }
        char c3 = '\u0000';
        if (n2 <= 1 && n3 + 1 < n) {
            char c4 = string.charAt(n3);
            c3 = c4;
            if ((c4 == 'E' || c3 == 'e') && ((c2 = string.charAt(n3 + 1)) >= '0' && c2 <= '9' || n3 + 2 < n && (c2 == '+' || c2 == '-') && (c2 = string.charAt(n3 + 2)) >= '0' && c2 <= '9')) {
                stringBuffer.append(c3);
                stringBuffer.append(string.charAt(n3 + 1));
                n3 += 2;
                while (n3 < n && (c2 = string.charAt(n3)) >= '0' && c2 <= '9') {
                    stringBuffer.append(c2);
                    ++n3;
                }
            }
        }
        if (n2 > 0 || c3 == 'E' || c3 == 'e') {
            return new Double(stringBuffer.toString());
        }
        return new Long(stringBuffer.toString());
    }

    public abstract Object getLiteral(String var1, StringBuffer var2);

    public abstract boolean isValidIdentifier(String var1);
}

