/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.parser;

import com.eteks.parser.AbstractSyntax;
import com.eteks.parser.Function;
import com.eteks.parser.Interpreter;
import com.eteks.parser.MathMLInterpreter;
import com.eteks.parser.Syntax;
import com.eteks.parser.WrapperInterpreter;

public class JavaSyntax
extends AbstractSyntax {
    private boolean extendedSyntax;

    public JavaSyntax() {
        this(false);
    }

    public JavaSyntax(boolean bl) {
        super(true);
        this.extendedSyntax = bl;
        this.setConstantKey("Math.PI", Syntax.CONSTANT_PI);
        this.setConstantKey("Math.E", Syntax.CONSTANT_E);
        if (bl) {
            this.setConstantKey("true", Syntax.CONSTANT_TRUE);
            this.setConstantKey("false", Syntax.CONSTANT_FALSE);
        }
        this.setUnaryOperatorKey("+", Syntax.OPERATOR_POSITIVE);
        this.setUnaryOperatorKey("-", Syntax.OPERATOR_OPPOSITE);
        this.setUnaryOperatorKey("!", Syntax.OPERATOR_LOGICAL_NOT);
        this.setUnaryOperatorKey("~", Syntax.OPERATOR_BITWISE_NOT);
        this.setBinaryOperatorKey("+", Syntax.OPERATOR_ADD);
        this.setBinaryOperatorKey("-", Syntax.OPERATOR_SUBSTRACT);
        this.setBinaryOperatorKey("*", Syntax.OPERATOR_MULTIPLY);
        this.setBinaryOperatorKey("/", Syntax.OPERATOR_DIVIDE);
        this.setBinaryOperatorKey("%", Syntax.OPERATOR_REMAINDER);
        this.setBinaryOperatorKey("==", Syntax.OPERATOR_EQUAL);
        this.setBinaryOperatorKey("!=", Syntax.OPERATOR_DIFFERENT);
        this.setBinaryOperatorKey(">=", Syntax.OPERATOR_GREATER_OR_EQUAL);
        this.setBinaryOperatorKey("<=", Syntax.OPERATOR_LESS_OR_EQUAL);
        this.setBinaryOperatorKey(">", Syntax.OPERATOR_GREATER);
        this.setBinaryOperatorKey("<", Syntax.OPERATOR_LESS);
        this.setBinaryOperatorKey("||", Syntax.OPERATOR_LOGICAL_OR);
        this.setBinaryOperatorKey("&&", Syntax.OPERATOR_LOGICAL_AND);
        this.setBinaryOperatorKey("|", Syntax.OPERATOR_BITWISE_OR);
        this.setBinaryOperatorKey("^", Syntax.OPERATOR_BITWISE_XOR);
        this.setBinaryOperatorKey("&", Syntax.OPERATOR_BITWISE_AND);
        this.setBinaryOperatorKey("<<", Syntax.OPERATOR_SHIFT_LEFT);
        this.setBinaryOperatorKey(">>", Syntax.OPERATOR_SHIFT_RIGHT);
        this.setBinaryOperatorKey(">>>", Syntax.OPERATOR_SHIFT_RIGHT_0);
        this.setConditionPartKey("?", Syntax.CONDITION_THEN);
        this.setConditionPartKey(":", Syntax.CONDITION_ELSE);
        this.setCommonFunctionKey("Math.log", Syntax.FUNCTION_LN);
        this.setCommonFunctionKey("Math.exp", Syntax.FUNCTION_EXP);
        this.setCommonFunctionKey("Math.sqrt", Syntax.FUNCTION_SQRT);
        this.setCommonFunctionKey("Math.cos", Syntax.FUNCTION_COS);
        this.setCommonFunctionKey("Math.sin", Syntax.FUNCTION_SIN);
        this.setCommonFunctionKey("Math.tan", Syntax.FUNCTION_TAN);
        this.setCommonFunctionKey("Math.acos", Syntax.FUNCTION_ACOS);
        this.setCommonFunctionKey("Math.asin", Syntax.FUNCTION_ASIN);
        this.setCommonFunctionKey("Math.atan", Syntax.FUNCTION_ATAN);
        this.setCommonFunctionKey("Math.floor", Syntax.FUNCTION_FLOOR);
        this.setCommonFunctionKey("Math.ceil", Syntax.FUNCTION_CEIL);
        this.setCommonFunctionKey("Math.round", Syntax.FUNCTION_ROUND);
        this.setCommonFunctionKey("Math.rint", Syntax.FUNCTION_ROUND);
        this.setCommonFunctionKey("Math.abs", Syntax.FUNCTION_ABS);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_LOGICAL_OR, 1);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_LOGICAL_AND, 2);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_BITWISE_OR, 3);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_BITWISE_XOR, 4);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_BITWISE_AND, 5);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_EQUAL, 6);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_DIFFERENT, 6);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_GREATER_OR_EQUAL, 7);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_LESS_OR_EQUAL, 7);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_GREATER, 7);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_LESS, 7);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_SHIFT_LEFT, 8);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_SHIFT_RIGHT, 8);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_SHIFT_RIGHT_0, 8);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_ADD, 9);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_SUBSTRACT, 9);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_REMAINDER, 10);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_DIVIDE, 10);
        this.setBinaryOperatorPriority(Syntax.OPERATOR_MULTIPLY, 10);
        this.setAssignmentOperator("=");
        this.setWhiteSpaceCharacters(" \t\n\r");
        this.setOpeningBracket('(');
        this.setClosingBracket(')');
        this.setParameterSeparator(',');
        this.addFunction(new FunctionAtan2());
        this.addFunction(new FunctionRemain());
        this.addFunction(new FunctionMax());
        this.addFunction(new FunctionMin());
        this.addFunction(new FunctionPow());
        this.addFunction(new FunctionRandom());
    }

    public Object getLiteral(String string, StringBuffer stringBuffer) {
        Number number = this.getLiteralNumber(string, stringBuffer);
        if (number != null) {
            return number;
        }
        if (this.extendedSyntax) {
            return this.getLiteralString(string, stringBuffer);
        }
        return null;
    }

    protected Number getLiteralNumber(String string, StringBuffer stringBuffer) {
        Number number;
        char c;
        if (string.length() > 3 && string.startsWith("0x") && ((c = string.charAt(2)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
            stringBuffer.append(c);
            int n = 3;
            while (n < string.length() && ((c = string.charAt(n)) >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                stringBuffer.append(c);
                ++n;
            }
            number = new Long(Long.parseLong(stringBuffer.toString().substring(2), 16));
        } else if (string.length() > 2 && string.charAt(0) == '0' && (c = string.charAt(1)) >= '0' && c <= '7') {
            int n = 2;
            while (n < string.length() && (c = string.charAt(n)) >= '0' && c <= '7') {
                ++n;
            }
            if (c == '.' || c == 'e' || c == 'E') {
                number = super.getLiteralNumber(string, stringBuffer);
            } else {
                if (c == '8' || c == '9') {
                    return null;
                }
                stringBuffer.append(string.substring(0, n));
                number = new Long(Long.parseLong(stringBuffer.toString().substring(1), 8));
            }
        } else {
            number = super.getLiteralNumber(string, stringBuffer);
        }
        if (number != null && string.length() > stringBuffer.length()) {
            c = string.charAt(stringBuffer.length());
            if (c == 'd' || c == 'D' || c == 'f' || c == 'F') {
                stringBuffer.append(c);
                if (!(number instanceof Double)) {
                    number = new Double(number.doubleValue());
                }
            } else if ((c == 'l' || c == 'L') && number instanceof Long) {
                stringBuffer.append(c);
            }
        }
        return number;
    }

    protected Object getLiteralString(String string, StringBuffer stringBuffer) {
        if (string.length() >= 2) {
            if (string.charAt(0) == '\'') {
                StringBuffer stringBuffer2;
                int n;
                if (string.length() > 2 && (n = this.getCharacter(string, 1, stringBuffer2 = new StringBuffer())) != -1 && string.length() >= 2 + stringBuffer2.length() && string.charAt(stringBuffer2.length() + 1) == '\'') {
                    stringBuffer.append('\'');
                    stringBuffer.append(stringBuffer2.toString());
                    stringBuffer.append('\'');
                    return new Character((char)n);
                }
            } else if (string.charAt(0) == '\"') {
                StringBuffer stringBuffer3 = new StringBuffer();
                StringBuffer stringBuffer4 = new StringBuffer();
                int n = 1;
                while (n < string.length() && string.charAt(n) != '\"') {
                    int n2 = this.getCharacter(string, n, stringBuffer4);
                    if (n2 == -1) {
                        return null;
                    }
                    stringBuffer3.append((char)n2);
                    n += stringBuffer4.length();
                    stringBuffer4.setLength(0);
                }
                if (n < string.length() && string.charAt(n) == '\"') {
                    stringBuffer.append(string.substring(0, n + 1));
                    return stringBuffer3.toString();
                }
            }
        }
        return null;
    }

    protected int getCharacter(String string, int n, StringBuffer stringBuffer) {
        char c = string.charAt(n);
        if (c != '\\') {
            stringBuffer.append(c);
            return c;
        }
        if (n + 1 < string.length()) {
            switch (string.charAt(n + 1)) {
                case 'b': {
                    stringBuffer.append("\\b");
                    return 8;
                }
                case 't': {
                    stringBuffer.append("\\t");
                    return 9;
                }
                case 'n': {
                    stringBuffer.append("\\n");
                    return 10;
                }
                case 'f': {
                    stringBuffer.append("\\f");
                    return 12;
                }
                case 'r': {
                    stringBuffer.append("\\r");
                    return 13;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    return 34;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    return 39;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    return 92;
                }
            }
            c = string.charAt(n + 1);
            if (c >= '0' && c <= '7') {
                int n2 = 2;
                while (n2 < 4 && n + n2 < string.length() && (c = string.charAt(n + n2)) >= '0' && c <= '7') {
                    ++n2;
                }
                if (n2 < 4 || string.charAt(n + 1) <= '3') {
                    stringBuffer.append(string.substring(n, n + n2));
                    return Integer.parseInt(string.substring(n + 1, n + n2), 8);
                }
            } else if (n + 5 < string.length() && string.charAt(n + 1) == 'u') {
                int n3 = 2;
                while (n3 < 6) {
                    c = string.charAt(n + n3);
                    if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                        return -1;
                    }
                    ++n3;
                }
                stringBuffer.append(string.substring(n, n + 6));
                return Integer.parseInt(string.substring(n + 2, n + 6), 16);
            }
        }
        return -1;
    }

    public boolean isValidIdentifier(String string) {
        return this.isJavaIdentifier(string);
    }

    public boolean isJavaIdentifier(String string) {
        if (!Character.isJavaLetter(string.charAt(0))) {
            return false;
        }
        int n = 1;
        while (n < string.length()) {
            if (!Character.isJavaLetterOrDigit(string.charAt(n)) && string.charAt(n) != '.') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static class FunctionAtan2
    implements Function {
        public String getName() {
            return "Math.atan2";
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Number && objectArray[1] instanceof Number) {
                return new Double(Math.atan2(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue()));
            }
            throw new IllegalArgumentException("Can compute only numbers");
        }

        FunctionAtan2() {
        }
    }

    private static class FunctionRemain
    implements Function {
        public String getName() {
            return "Math.IEEEremainder";
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (objectArray[0] instanceof Number && objectArray[1] instanceof Number) {
                return new Double(Math.IEEEremainder(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue()));
            }
            throw new IllegalArgumentException("Can compute only numbers");
        }

        FunctionRemain() {
        }
    }

    private static class FunctionMax
    implements Function {
        public String getName() {
            return "Math.max";
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (interpreter instanceof MathMLInterpreter) {
                return "<apply>\n<max/>\n" + objectArray[0] + objectArray[1] + "</apply>\n";
            }
            if (objectArray[0] instanceof Number && objectArray[1] instanceof Number) {
                if (interpreter instanceof WrapperInterpreter && (objectArray[0] instanceof Integer || objectArray[0] instanceof Long) && (objectArray[1] instanceof Integer || objectArray[1] instanceof Long)) {
                    return new Long(Math.max(((Number)objectArray[0]).longValue(), ((Number)objectArray[1]).longValue()));
                }
                return new Double(Math.max(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue()));
            }
            throw new IllegalArgumentException("Can compute only numbers");
        }

        FunctionMax() {
        }
    }

    private static class FunctionMin
    implements Function {
        public String getName() {
            return "Math.min";
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            if (interpreter instanceof MathMLInterpreter) {
                return "<apply>\n<min/>\n" + objectArray[0] + objectArray[1] + "</apply>\n";
            }
            if (objectArray[0] instanceof Number && objectArray[1] instanceof Number) {
                if (interpreter instanceof WrapperInterpreter && (objectArray[0] instanceof Integer || objectArray[0] instanceof Long) && (objectArray[1] instanceof Integer || objectArray[1] instanceof Long)) {
                    return new Long(Math.min(((Number)objectArray[0]).longValue(), ((Number)objectArray[1]).longValue()));
                }
                return new Double(Math.min(((Number)objectArray[0]).doubleValue(), ((Number)objectArray[1]).doubleValue()));
            }
            throw new IllegalArgumentException("Can compute only numbers");
        }

        FunctionMin() {
        }
    }

    private static class FunctionPow
    implements Function {
        public String getName() {
            return "Math.pow";
        }

        public boolean isValidParameterCount(int n) {
            return n == 2;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return interpreter.getBinaryOperatorValue(Syntax.OPERATOR_POWER, objectArray[0], objectArray[1]);
        }

        FunctionPow() {
        }
    }

    private static class FunctionRandom
    implements Function {
        public String getName() {
            return "Math.random";
        }

        public boolean isValidParameterCount(int n) {
            return n == 0;
        }

        public Object computeFunction(Interpreter interpreter, Object[] objectArray) {
            return new Double(Math.random());
        }

        FunctionRandom() {
        }
    }
}

