/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import net.dnsalias.pcb.csveditor.gui.CsvEditor;
import net.dnsalias.pcb.utilities.HelperClass;

public class DefaultTableSizeDialog
extends JDialog
implements ItemListener,
PropertyChangeListener {
    public static final long serialVersionUID = 19650221L;
    private int option;
    private int colsFormer = 3;
    private int rowsFormer = 3;
    private int colsSelected;
    private int rowsSelected = 1;
    private boolean useColumnNames;
    private boolean useColumnNamesFormer = false;
    private JFrame owner;
    private JOptionPane dialogPane;
    private JLabel lblCols;
    private JLabel lblRows;
    private JLabel lblUseColumnNames;
    private JSpinner colsSpinner;
    private JSpinner rowsSpinner;
    private JCheckBox useColumnNamesCheckbox;
    private SpinnerNumberModel colsModel;
    private SpinnerNumberModel rowsModel;
    private ResourceBundle resourceBundle;
    private static final String resourceSrc = "resources/DefaultTableSizeDialogResources";

    public DefaultTableSizeDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    public DefaultTableSizeDialog(CsvEditor owner, boolean modal, int colsFormer, int rowsFormer, boolean useColumnNamesFormer) {
        this(owner, owner.getAppname(), modal, colsFormer, rowsFormer, useColumnNamesFormer);
    }

    public DefaultTableSizeDialog(CsvEditor owner, String title, boolean modal, int colsFormer, int rowsFormer, boolean useColumnNamesFormer) {
        super(owner, title, modal);
        this.owner = owner;
        this.colsFormer = colsFormer;
        this.rowsFormer = rowsFormer;
        this.useColumnNamesFormer = useColumnNamesFormer;
        this.resourceBundle = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        Object[] options = new Object[]{UIManager.getString("OptionPane.okButtonText")};
        this.dialogPane = new JOptionPane(this.resourceBundle.getString("msg"), 3, -1, null, options, options[0]);
        this.dialogPane.addPropertyChangeListener(this);
        this.lblCols = new JLabel(this.resourceBundle.getString("Columns"));
        Integer colValue = new Integer(this.colsFormer);
        Integer colMin = new Integer(1);
        Integer colMax = new Integer(Short.MAX_VALUE);
        Integer colStep = new Integer(1);
        this.colsModel = new SpinnerNumberModel(colValue, colMin, colMax, colStep);
        this.colsSpinner = new JSpinner(this.colsModel);
        this.lblRows = new JLabel(this.resourceBundle.getString("Rows"));
        Integer rowValue = new Integer(this.rowsFormer);
        Integer rowMin = new Integer(1);
        Integer rowMax = new Integer(Short.MAX_VALUE);
        Integer rowStep = new Integer(1);
        this.rowsModel = new SpinnerNumberModel(rowValue, rowMin, rowMax, rowStep);
        this.rowsSpinner = new JSpinner(this.rowsModel);
        this.lblUseColumnNames = new JLabel(this.resourceBundle.getString("useColumnNames"));
        this.useColumnNamesCheckbox = new JCheckBox();
        this.useColumnNamesCheckbox.addItemListener(this);
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        panel.setLayout(l);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        panel.add((Component)this.lblCols, c);
        c.gridy = 1;
        panel.add((Component)this.colsSpinner, c);
        c.gridx = 1;
        c.gridy = 0;
        c.insets = new Insets(0, 40, 0, 0);
        panel.add((Component)this.lblRows, c);
        c.gridy = 1;
        panel.add((Component)this.rowsSpinner, c);
        c.gridx = 0;
        c.gridy = 2;
        c.insets = new Insets(20, 0, 0, 0);
        panel.add((Component)this.lblUseColumnNames, c);
        c.gridx = 1;
        panel.add((Component)this.useColumnNamesCheckbox, c);
        panel.setBorder(BorderFactory.createEmptyBorder(20, 0, 0, 0));
        this.dialogPane.add((Component)panel, 1);
        this.setContentPane(this.dialogPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        this.dialogPane.selectInitialValue();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.useColumnNamesCheckbox) {
            this.useColumnNames = e.getStateChange() == 1;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.dialogPane && prop.equals("value")) {
            Object selectedOption = this.dialogPane.getValue();
            if (selectedOption != null) {
                this.option = 0;
            }
            if (this.option == 0) {
                this.colsSelected = this.colsModel.getNumber().intValue();
                this.rowsSelected = this.rowsModel.getNumber().intValue();
                this.setVisible(false);
            } else {
                this.colsSelected = this.colsFormer;
                this.rowsSelected = this.rowsFormer;
                this.setVisible(false);
            }
        }
    }

    public int getOption() {
        return this.option;
    }

    public int getSelectedRows() {
        return this.rowsSelected;
    }

    public int getSelectedColumns() {
        return this.colsSelected;
    }

    public boolean getUseColumnNames() {
        return this.useColumnNames;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultTableSizeDialog dialog = new DefaultTableSizeDialog(new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

