/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.csveditor.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import net.dnsalias.pcb.csveditor.gui.Enums;
import net.dnsalias.pcb.utilities.HelperClass;

public class FontDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    public static final long serialVersionUID = 19650221L;
    private int option;
    private JFrame owner;
    private JLabel fsl;
    private JLabel esl;
    private JLabel ssl;
    private JLabel stylel;
    private JTextField etf;
    private JOptionPane dialogPane;
    private JComboBox ecb;
    private JComboBox ehcb;
    private JComboBox fcb;
    private JComboBox scb;
    private JComboBox stylecb;
    private Box box1;
    private Box box2;
    private Box box3;
    private Box box4;
    private Box box5;
    private Box box6;
    private Box box7;
    private String[] availableCharsetsCanonical = new String[0];
    private String[] availableCharsetsHuman = new String[0];
    private String selectedEncoding;
    private String[] availableFonts = new String[0];
    private String[] availableSizes = new String[]{"6", "8", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36", "48", "72"};
    private String[] availableStyles = new String[]{Enums.FontStyle.PLAIN.toString(), Enums.FontStyle.BOLD.toString(), Enums.FontStyle.ITALIC.toString(), Enums.FontStyle.BOLD_ITALIC.toString()};
    private Font selectedFont;
    private int selectedStyle = 0;
    private SortedMap<String, Charset> charsetsCanonical = null;
    private SortedMap<String, String> charsetsHuman = null;
    private final String ENC_TABLE = "libs/encodings.txt";
    private ResourceBundle FontDialogResources;
    private static final String resourceSrc = "resources/FontDialogResources";

    public FontDialog(JFrame owner, boolean modal, Font currentFont, String canonicalEncoding) {
        this(owner, owner.getTitle(), modal, currentFont, canonicalEncoding);
    }

    public FontDialog(JFrame owner, String title, boolean modal, Font currentFont, String canonicalEncoding) {
        super(owner, title, modal);
        this.owner = owner;
        this.selectedFont = currentFont;
        try {
            this.selectedStyle = currentFont.getStyle();
        }
        catch (NumberFormatException e) {
            this.selectedStyle = 0;
        }
        this.charsetsCanonical = Charset.availableCharsets();
        this.charsetsHuman = this.human(this.charsetsCanonical);
        TreeSet<String> canonNames = new TreeSet<String>(new StringComparator());
        canonNames.addAll(this.charsetsHuman.keySet());
        this.availableCharsetsCanonical = canonNames.toArray(new String[0]);
        this.selectedEncoding = canonicalEncoding;
        TreeSet<String> humanNames = new TreeSet<String>(new StringComparator());
        humanNames.addAll(this.charsetsHuman.values());
        this.availableCharsetsHuman = humanNames.toArray(new String[0]);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.availableFonts = ge.getAvailableFontFamilyNames();
        this.FontDialogResources = HelperClass.getResourceBundleFromJar(resourceSrc, "UTF-8");
        this.createAndShowGUI();
    }

    private void createAndShowGUI() {
        this.dialogPane = new JOptionPane(this.FontDialogResources.getString("Select_font_and_encoding"), -1, 2);
        this.dialogPane.addPropertyChangeListener(this);
        this.fsl = new JLabel(this.FontDialogResources.getString("Font"), 2);
        this.fsl.setAlignmentX(0.0f);
        this.fcb = new JComboBox<String>(this.availableFonts);
        this.fcb.setMaximumSize(this.fcb.getMinimumSize());
        this.fcb.setAlignmentX(0.0f);
        this.fcb.setSelectedItem(this.selectedFont.getFamily());
        this.fcb.addActionListener(this);
        this.box1 = new Box(1);
        this.box1.add(this.fsl);
        this.box1.add(this.fcb);
        this.stylel = new JLabel(this.FontDialogResources.getString("Style"), 2);
        this.stylel.setAlignmentX(0.0f);
        this.stylecb = new JComboBox<String>(this.availableStyles);
        this.stylecb.setMaximumSize(this.stylecb.getMinimumSize());
        this.stylecb.setAlignmentX(0.0f);
        if (this.selectedStyle == 1) {
            this.stylecb.setSelectedItem(Enums.FontStyle.BOLD.toString());
        } else if (this.selectedStyle == 2) {
            this.stylecb.setSelectedItem(Enums.FontStyle.ITALIC.toString());
        } else if (this.selectedStyle == 3) {
            this.stylecb.setSelectedItem(Enums.FontStyle.BOLD_ITALIC.toString());
        } else {
            this.stylecb.setSelectedItem(Enums.FontStyle.PLAIN.toString());
        }
        this.stylecb.addActionListener(this);
        this.box7 = new Box(1);
        this.box7.add(this.stylel);
        this.box7.add(this.stylecb);
        this.ssl = new JLabel(this.FontDialogResources.getString("Size"), 2);
        this.ssl.setAlignmentX(0.0f);
        this.scb = new JComboBox<String>(this.availableSizes);
        this.scb.setMaximumSize(this.scb.getMinimumSize());
        this.scb.setAlignmentX(0.0f);
        this.scb.setEditable(true);
        try {
            this.scb.setSelectedItem(Integer.toString(this.selectedFont.getSize()));
        }
        catch (NumberFormatException e) {
            this.scb.setSelectedItem("10");
        }
        this.scb.addActionListener(this);
        this.box2 = new Box(1);
        this.box2.add(this.ssl);
        this.box2.add(this.scb);
        this.esl = new JLabel(this.FontDialogResources.getString("Script"), 2);
        this.esl.setAlignmentX(0.0f);
        this.ecb = new JComboBox<String>(this.availableCharsetsCanonical);
        this.ecb.setMaximumSize(this.ecb.getMinimumSize());
        this.ecb.setAlignmentX(0.0f);
        this.ecb.setSelectedItem(this.selectedEncoding);
        this.ecb.addActionListener(this);
        this.ehcb = new JComboBox<String>(this.availableCharsetsHuman);
        this.ehcb.setMaximumSize(this.ehcb.getMinimumSize());
        this.ehcb.setAlignmentX(0.0f);
        this.ehcb.setSelectedItem(this.charsetsHuman.get(this.selectedEncoding));
        this.ehcb.addActionListener(this);
        this.etf = new JTextField();
        this.etf.setEditable(false);
        this.etf.setAlignmentX(0.0f);
        this.etf.setText(String.format("%s", this.charsetsHuman.get(this.selectedEncoding)));
        this.box3 = new Box(1);
        this.box3.add(this.esl);
        this.box3.add(this.etf);
        this.box3.add(this.ecb);
        this.box4 = new Box(0);
        this.box4.add(this.box3);
        this.box4.add(Box.createHorizontalGlue());
        this.box5 = new Box(0);
        this.box5.add(this.box1);
        this.box5.add(Box.createHorizontalStrut(10));
        this.box5.add(this.box7);
        this.box5.add(Box.createHorizontalStrut(10));
        this.box5.add(this.box2);
        this.box5.add(Box.createHorizontalGlue());
        this.box6 = new Box(1);
        this.box6.add(Box.createVerticalStrut(20));
        this.box6.add(this.box5);
        this.box6.add(Box.createVerticalStrut(20));
        this.box6.add(this.box4);
        this.dialogPane.add((Component)this.box6, 1);
        this.setContentPane(this.dialogPane);
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
        this.dialogPane.selectInitialValue();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ecb && this.ecb.getSelectedItem() != null) {
            this.selectedEncoding = (String)this.ecb.getSelectedItem();
            this.etf.setText(String.format("%s", this.charsetsHuman.get(this.selectedEncoding)));
        }
        if (e.getSource() != this.ehcb || this.ehcb.getSelectedItem() != null) {
            // empty if block
        }
        if (e.getSource() == this.fcb && this.fcb.getSelectedItem() != null) {
            this.selectedFont = new Font((String)this.fcb.getSelectedItem(), this.selectedStyle, new Integer((String)this.scb.getSelectedItem()));
        }
        if (e.getSource() == this.scb && this.scb.getSelectedItem() != null) {
            this.selectedFont = new Font((String)this.fcb.getSelectedItem(), this.selectedStyle, new Integer((String)this.scb.getSelectedItem()));
        }
        if (e.getSource() == this.stylecb && this.stylecb.getSelectedItem() != null) {
            String selection = (String)this.stylecb.getSelectedItem();
            this.selectedStyle = selection.equals(Enums.FontStyle.BOLD.toString()) ? 1 : (selection.equals(Enums.FontStyle.ITALIC.toString()) ? 2 : (selection.equals(Enums.FontStyle.BOLD_ITALIC.toString()) ? 3 : 0));
            this.selectedFont = new Font((String)this.fcb.getSelectedItem(), this.selectedStyle, new Integer((String)this.scb.getSelectedItem()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (this.isVisible() && e.getSource() == this.dialogPane && prop.equals("value")) {
            this.option = (Integer)this.dialogPane.getValue();
            this.setVisible(false);
        }
    }

    public int getOption() {
        return this.option;
    }

    public String getSelectedEncoding() {
        return this.selectedEncoding;
    }

    public String getSelectedEncodingByHumanName() {
        String canonical = null;
        if (this.charsetsHuman.containsValue(this.selectedEncoding)) {
            for (String key : this.charsetsHuman.keySet().toArray(new String[0])) {
                if (!((String)this.charsetsHuman.get(key)).equals(this.selectedEncoding)) continue;
                canonical = key;
                break;
            }
        }
        return canonical;
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public SortedMap<String, String> human(SortedMap<String, Charset> sourceMap) {
        TreeMap<String, String> map = new TreeMap<String, String>(new StringComparator());
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("libs/encodings.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    reader.close();
                    break;
                }
                String[] key_value = line.split("\\t");
                String key = key_value[0];
                String value = key_value[1];
                if (!sourceMap.containsKey(key)) continue;
                map.put(key, value);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return map;
    }

    private static class StringComparator
    implements Comparator<String> {
        private StringComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

