/*
 * Decompiled with CFR 0.152.
 */
package net.dnsalias.pcb.utilities;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HelperClass {
    private HelperClass() {
    }

    public static ResourceBundle getResourceBundleFromJar(String resourceBase, String encoding) {
        ResourceBundle bundle = null;
        HelperClass hc = new HelperClass();
        bundle = hc._getResourceBundleFromJar(resourceBase, encoding, Locale.getDefault());
        return bundle;
    }

    public static ResourceBundle getResourceBundleFromJar(String resourceBase, String encoding, Locale locale) {
        ResourceBundle bundle = null;
        HelperClass hc = new HelperClass();
        bundle = hc._getResourceBundleFromJar(resourceBase, encoding, locale);
        return bundle;
    }

    private ResourceBundle _getResourceBundleFromJar(String resourceBase, String encoding, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        String resourceName = null;
        InputStream is = null;
        PropertyResourceBundle bundle = null;
        resourceName = resourceBase + "_" + language + "_" + country + "_" + variant + ".properties";
        is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            resourceName = resourceBase + "_" + language + "_" + country + ".properties";
            is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
            if (is == null) {
                resourceName = resourceBase + "_" + language + ".properties";
                is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                if (is == null) {
                    resourceName = resourceBase + ".properties";
                    is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
                    if (is != null) {
                        // empty if block
                    }
                }
            }
        }
        try {
            PropertyResourceBundle resourceBundle;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, encoding));
            bundle = resourceBundle = new PropertyResourceBundle(reader);
        }
        catch (NullPointerException npe) {
            System.err.println(resourceBase + ".properties not found");
        }
        catch (UnsupportedEncodingException uee) {
            uee.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return bundle;
    }

    public static JMenuItem getMenuItemByActionCommand(JMenuBar menuBar, String actionCommand) {
        JMenuItem item = null;
        HelperClass hc = new HelperClass();
        item = hc._getMenuItemByActionCommand(menuBar, actionCommand);
        return item;
    }

    private JMenuItem _getMenuItemByActionCommand(JMenuBar menuBar, String actionCommand) {
        MenuElement[] menus;
        for (MenuElement menu : menus = menuBar.getSubElements()) {
            Component[] menuItems;
            if (!(menu instanceof JMenu)) continue;
            for (Component menuItem : menuItems = ((JMenu)menu).getMenuComponents()) {
                if (!(menuItem instanceof JMenuItem) || !((JMenuItem)menuItem).getActionCommand().equals(actionCommand)) continue;
                return (JMenuItem)menuItem;
            }
        }
        return null;
    }

    public static JMenuItem getMenuItemByActionCommand(JPopupMenu popupMenu, String actionCommand) {
        JMenuItem item = null;
        HelperClass hc = new HelperClass();
        item = hc._getMenuItemByActionCommand(popupMenu, actionCommand);
        return item;
    }

    private JMenuItem _getMenuItemByActionCommand(JPopupMenu popupMenu, String actionCommand) {
        Component[] menuItems;
        for (Component menuItem : menuItems = popupMenu.getComponents()) {
            if (!(menuItem instanceof JMenuItem) || !((JMenuItem)menuItem).getActionCommand().equals(actionCommand)) continue;
            return (JMenuItem)menuItem;
        }
        return null;
    }

    public static void fitColumnWidth(JTable table) {
        HelperClass.fitColumnWidth(table, 0);
    }

    public static void fitColumnWidth(JTable table, int minWidth) {
        TableModel model = table.getModel();
        int columnCount = model.getColumnCount();
        int rowCount = model.getRowCount();
        JTableHeader tableHeader = table.getTableHeader();
        TableCellRenderer headerRenderer = tableHeader.getDefaultRenderer();
        if (rowCount > 0) {
            for (int col = 0; col < columnCount; ++col) {
                int headerWidth = 0;
                int cellWidth = minWidth;
                int newCellWidth = 0;
                TableColumn column = table.getColumnModel().getColumn(col);
                Component comp = headerRenderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
                headerWidth = comp.getPreferredSize().width + 5;
                for (int row = 0; row < rowCount; ++row) {
                    comp = table.getDefaultRenderer(model.getColumnClass(col)).getTableCellRendererComponent(table, model.getValueAt(row, col), false, false, row, col);
                    newCellWidth = comp.getPreferredSize().width + 5;
                    cellWidth = Math.max(newCellWidth, cellWidth);
                }
                column.setPreferredWidth(Math.max(headerWidth, cellWidth));
            }
        }
    }

    public static void fitRowHeight(JTable table) {
        HelperClass _helperClass = new HelperClass();
        _helperClass.packRows(table, 0);
    }

    public static void fitRowHeight(JTable table, int margin) {
        HelperClass _helperClass = new HelperClass();
        _helperClass.packRows(table, margin);
    }

    public void packRows(JTable table, int margin) {
        this.packRows(table, 0, table.getRowCount(), margin);
    }

    public void packRows(JTable table, int start, int end, int margin) {
        int rowHeight = 0;
        int newRowHeight = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            newRowHeight = this.getPreferredRowHeight(table, row, margin);
            rowHeight = Math.max(newRowHeight, rowHeight);
        }
        table.setRowHeight(rowHeight);
    }

    public int getPreferredRowHeight(JTable table, int rowIndex, int margin) {
        int height = table.getRowHeight();
        for (int c = 0; c < table.getColumnCount(); ++c) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, c);
            Component comp = table.prepareRenderer(renderer, rowIndex, c);
            int h = comp.getPreferredSize().height + 2 * margin;
            height = Math.max(height, h);
        }
        return height;
    }
}

