/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.ConnectDatagram;
import com.sun.rpc.ConnectSocket;
import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.CredNone;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.RpcException;
import com.sun.rpc.RpcHandler;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;

public class Rpc {
    public Connection conn;
    int prog;
    int vers;
    Cred cred;
    RpcHandler rhandler = new RpcHandler();
    private static int xid = (int)System.currentTimeMillis() & 0xFFFFFFF;
    private static final int PMAP_PROG = 100000;
    private static final int PMAP_PORT = 111;
    private static final int PMAP_VERS = 2;
    private static final int PMAP_GETPORT = 3;
    private static final int PMAP_MAXSZ = 128;
    private static final int MAX_TIMEOUT = 30000;
    private static final int MAX_REPLY = 8448;
    static final int CALL = 0;
    static final int REPLY = 1;
    static final int MSG_ACCEPTED = 0;
    static final int MSG_DENIED = 1;
    static final int SUCCESS = 0;
    static final int PROG_UNAVAIL = 1;
    static final int PROG_MISMATCH = 2;
    static final int PROC_UNAVAIL = 3;
    static final int GARBAGE_ARGS = 4;
    static final int SYSTEM_ERR = 5;
    static final int RPC_MISMATCH = 0;
    static final int AUTH_ERROR = 1;

    public Rpc(Connection connection, int n, int n2) {
        this.conn = connection;
        this.prog = n;
        this.vers = n2;
        this.cred = new CredNone();
    }

    public Rpc(String string, int n, int n2, int n3, String string2, int n4) throws IOException {
        this.conn = this.getConnection(string, n, n2, n3, string2, n4);
        this.prog = n2;
        this.vers = n3;
        this.cred = new CredNone();
    }

    private Connection getConnection(String string, int n, int n2, int n3, String string2, int n4) throws IOException {
        Object object;
        if (n == 0) {
            object = new Rpc(string, 111, 100000, 2, "udp", 128);
            Xdr xdr = new Xdr(128);
            ((Rpc)object).rpc_header(xdr, 3);
            xdr.xdr_int(n2);
            xdr.xdr_int(n3);
            xdr.xdr_int(string2.equals("tcp") ? 6 : 17);
            xdr.xdr_int(0);
            Xdr xdr2 = ((Rpc)object).rpc_call(xdr, 5000, 3);
            n = xdr2.xdr_int();
            if (n == 0) {
                throw new MsgAcceptedException(1);
            }
        }
        object = Connection.connections;
        synchronized (object) {
            this.conn = Connection.getCache(string, n, string2);
            if (this.conn == null) {
                this.conn = string2.equals("tcp") ? new ConnectSocket(string, n, n4) : new ConnectDatagram(string, n, n4);
                Connection.putCache(this.conn);
            }
        }
        return this.conn;
    }

    public void setCred(Cred cred) {
        this.cred = cred;
    }

    public Cred getCred() {
        return this.cred;
    }

    public void setRpcHandler(RpcHandler rpcHandler) {
        this.rhandler = rpcHandler == null ? new RpcHandler() : rpcHandler;
    }

    public void rpc_header(Xdr xdr, int n) {
        xdr.xid = Rpc.next_xid();
        xdr.xdr_offset(this.conn instanceof ConnectSocket ? 4 : 0);
        xdr.xdr_int(xdr.xid);
        xdr.xdr_int(0);
        xdr.xdr_int(2);
        xdr.xdr_int(this.prog);
        xdr.xdr_int(this.vers);
        xdr.xdr_int(n);
        this.cred.putCred(xdr);
    }

    static synchronized int next_xid() {
        return xid++;
    }

    public Xdr rpc_call(Xdr xdr, int n) throws IOException {
        Xdr xdr2 = this.conn.send(xdr, n);
        if (xdr2.xdr_int() != 1) {
            throw new RpcException("Unknown RPC header");
        }
        int n2 = xdr2.xdr_int();
        switch (n2) {
            case 0: {
                xdr2.xdr_skip(4);
                byte[] byArray = xdr2.xdr_bytes();
                int n3 = xdr2.xdr_int();
                switch (n3) {
                    case 1: 
                    case 2: 
                    case 3: {
                        throw new MsgAcceptedException(n3, xdr2.xdr_int(), xdr2.xdr_int());
                    }
                    default: {
                        throw new MsgAcceptedException(n3);
                    }
                    case 0: {
                        return xdr2;
                    }
                }
            }
            case 1: {
                int n4 = xdr2.xdr_int();
                switch (n4) {
                    case 0: {
                        throw new MsgRejectedException(n4, xdr2.xdr_int(), xdr2.xdr_int());
                    }
                    case 1: {
                        int n5 = xdr2.xdr_int();
                        throw new MsgRejectedException(n4, n5);
                    }
                }
                throw new MsgRejectedException(n4);
            }
            default: {
                return xdr2;
            }
        }
    }

    public Xdr rpc_call(Xdr xdr, int n, int n2) throws IOException {
        boolean bl = false;
        Xdr xdr2 = null;
        long l = System.currentTimeMillis();
        if (n2 == 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (this.conn instanceof ConnectSocket) {
            n = 30000;
        }
        int n3 = 0;
        while (n3 < n2) {
            try {
                xdr2 = this.rpc_call(xdr, n);
                break;
            }
            catch (RpcException rpcException) {
                throw rpcException;
            }
            catch (IOException iOException) {
                if (this.rhandler.timeout(this.conn.server, n3, (int)(System.currentTimeMillis() - l))) {
                    throw new InterruptedIOException();
                }
                bl = true;
                if ((n *= 2) > 30000) {
                    n = 30000;
                }
                ++n3;
            }
        }
        if (xdr2 == null) {
            throw new InterruptedIOException();
        }
        if (bl && xdr2 != null) {
            this.rhandler.ok(this.conn.server);
        }
        return xdr2;
    }

    public InetAddress getPeer() {
        return this.conn.getPeer();
    }
}

