/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applet;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import sunw.hotjava.applet.AppletIllegalArgumentException;
import sunw.hotjava.applet.BasicAppletManager;

class AppletObjectInputStream
extends ObjectInputStream {
    private ClassLoader loader;

    public AppletObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(inputStream);
        if (classLoader == null) {
            throw new AppletIllegalArgumentException("appletillegalargumentexception.objectinputstream");
        }
        this.loader = classLoader;
    }

    private Class primitiveType(char c) {
        switch (c) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        String string = objectStreamClass.getName();
        if (string.startsWith("[")) {
            Class<?> clazz;
            Object object;
            int n = 1;
            while (string.charAt(n) == '[') {
                ++n;
            }
            if (string.charAt(n) == 'L') {
                object = string.substring(n + 1, string.length() - 1);
                BasicAppletManager.checkNewAppletPackageAccess((String)object);
                clazz = this.loader.loadClass((String)object);
            } else {
                if (string.length() != n + 1) {
                    throw new ClassNotFoundException(string);
                }
                clazz = this.primitiveType(string.charAt(n));
            }
            object = new int[n];
            int n2 = 0;
            while (n2 < n) {
                object[n2] = false;
                ++n2;
            }
            return Array.newInstance(clazz, (int[])object).getClass();
        }
        BasicAppletManager.checkNewAppletPackageAccess(string);
        return this.loader.loadClass(string);
    }
}

