/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Hashtable;
import java.util.Properties;
import sunw.hotjava.applets.PrefApplet;
import sunw.hotjava.applets.PrefAppletManager;

public class AdvancedPreferenceApplet
extends PrefApplet
implements KeyListener,
FocusListener {
    private static final String name = "advancedPreferenceApplet";
    private static final String propname = "advanced.preference";
    static String securityMode = PrefApplet.properties.getProperty("hotjava.securitymode");
    private Label titleLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.title", "Advanced"));
    private Label securityLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.security.title", "Security"));
    private Label securityModeLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.security.subtitle", "Security Mode"));
    private CheckboxGroup securityModeCheckboxGroup = new CheckboxGroup();
    private Checkbox basicMode = new Checkbox(PrefApplet.properties.getProperty("advanced.preference.security.choice1", "Basic"));
    private Checkbox adminMode = new Checkbox(PrefApplet.properties.getProperty("advanced.preference.security.choice2", "Administrative"));
    private Label warningLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.warn.title", "Show A Warning Before:"));
    private Checkbox enterWarning = new Checkbox(PrefApplet.properties.getProperty("advanced.preference.warn.choice1", "Entering a Secure Web Site"));
    private Checkbox leaveWarning = new Checkbox(PrefApplet.properties.getProperty("advanced.preference.warn.choice2", "Leaving a Secure Web Site"));
    private Label historyLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.history.title", "Visiting Pages History"));
    private Label expirationDaysLabel1 = new Label(PrefApplet.properties.getProperty("advanced.preference.history.day1", "Visited Links Expire After"));
    private Label expirationDaysLabel2 = new Label(PrefApplet.properties.getProperty("advanced.preferencehistory.day2", "Days"));
    private TextField expirationDays = new TextField("", 3);
    private Button clearHistoryButton = new Button(PrefApplet.properties.getProperty("advanced.preference.history.clear", "Clear History"));
    private Label cacheManagementLabel = new Label(PrefApplet.properties.getProperty("advanced.preference.cache.title", "Cache Management"));
    private Button clearImageCacheButton = new Button(PrefApplet.properties.getProperty("advanced.preference.cache.clear", "Clear Image Cache"));

    public void init() {
        Insets insets = new Insets(0, 5, 0, 0);
        Insets insets2 = new Insets(10, 5, 0, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        this.add((Component)this.titleLabel, gridBagConstraints);
        this.add((Component)this.securityLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.add((Component)this.securityModeLabel, gridBagConstraints);
        this.add((Component)this.securityModeLabel, gridBagConstraints);
        this.basicMode.addKeyListener(this);
        this.basicMode.addFocusListener(this);
        this.basicMode.setCheckboxGroup(this.securityModeCheckboxGroup);
        this.adminMode.addKeyListener(this);
        this.adminMode.addFocusListener(this);
        this.adminMode.setCheckboxGroup(this.securityModeCheckboxGroup);
        this.add((Component)this.basicMode, gridBagConstraints);
        this.add((Component)this.adminMode, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        this.add((Component)this.warningLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.enterWarning.addKeyListener(this);
        this.enterWarning.addFocusListener(this);
        this.add((Component)this.enterWarning, gridBagConstraints);
        this.leaveWarning.addKeyListener(this);
        this.leaveWarning.addFocusListener(this);
        this.add((Component)this.leaveWarning, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        this.add((Component)this.historyLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        Panel panel = new Panel();
        panel.add(this.expirationDaysLabel1);
        this.expirationDays.addKeyListener(this);
        panel.add(this.expirationDays);
        panel.add(this.expirationDaysLabel2);
        panel.add(this.clearHistoryButton);
        this.add((Component)panel, gridBagConstraints);
        gridBagConstraints.insets = insets2;
        this.add((Component)this.cacheManagementLabel, gridBagConstraints);
        gridBagConstraints.insets = insets;
        this.add((Component)this.clearImageCacheButton, gridBagConstraints);
    }

    public void updateFields() {
        Properties properties = PrefAppletManager.getProperties(name);
        if (properties.getProperty("hotjava.securitymode").equalsIgnoreCase("Basic")) {
            this.securityModeCheckboxGroup.setSelectedCheckbox(this.basicMode);
        } else {
            this.securityModeCheckboxGroup.setSelectedCheckbox(this.adminMode);
        }
        if (properties.getProperty("security.preference.tosecuresite.warn").equals("true")) {
            this.enterWarning.setState(true);
        } else {
            this.enterWarning.setState(false);
        }
        if (properties.getProperty("security.preference.fromsecuresite.warn").equals("true")) {
            this.leaveWarning.setState(true);
        } else {
            this.leaveWarning.setState(false);
        }
        ((TextComponent)this.expirationDays).setText(PrefApplet.properties.getProperty("urlpool.expires", "168"));
    }

    public String getName() {
        return name;
    }

    public String[] getPropertyNames() {
        String[] stringArray = new String[]{"hotjava.securitymode", "security.preference.tosecuresite.warn", "security.preference.fromsecuresite.warn", "urlpool.expires"};
        return stringArray;
    }

    public void apply() {
        this.updateProperties();
        String[] stringArray = this.getPropertyNames();
        Properties properties = PrefAppletManager.getProperties(name);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            String string2 = properties.getProperty(string);
            if (string2 == null || string2.length() == 0) {
                PrefApplet.properties.remove(string);
            } else {
                PrefApplet.properties.put(string, string2);
            }
            ++n;
        }
        PrefApplet.properties.save();
    }

    public void reset() {
        String[] stringArray = this.getPropertyNames();
        Properties properties = PrefAppletManager.getProperties(name);
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            ((Hashtable)properties).put(string, PrefApplet.properties.getProperty(string, ""));
            ++n;
        }
        PrefAppletManager.updateApplet(name);
    }

    private void updateProperties() {
        String[] stringArray = new String[]{this.securityModeCheckboxGroup.getSelectedCheckbox() == this.basicMode ? "Basic" : "Administrator", new Boolean(this.enterWarning.getState()).toString(), new Boolean(this.leaveWarning.getState()).toString(), this.expirationDays.getText()};
        String[] stringArray2 = this.getPropertyNames();
        boolean bl = false;
        Properties properties = PrefAppletManager.getProperties(name);
        int n = 0;
        while (n < stringArray.length) {
            String string = properties.getProperty(stringArray2[n]);
            if (!stringArray[n].equals(string)) {
                ((Hashtable)properties).put(stringArray2[n], stringArray[n]);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            PrefAppletManager.updateApplet(name);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.updateProperties();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\r') {
            this.updateProperties();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.expirationDays) {
            switch (keyEvent.getKeyCode()) {
                default: {
                    char c = keyEvent.getKeyChar();
                    if (keyEvent.isActionKey() || c >= '0' && c <= '9') break;
                    Toolkit.getDefaultToolkit().beep();
                    keyEvent.consume();
                }
                case 8: 
                case 9: 
                case 10: 
                case 16: 
                case 127: 
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

