/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.KeyListener;
import java.util.Vector;
import sunw.hotjava.applet.PrefsPanel;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.Clock;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UserCheckbox;
import sunw.hotjava.ui.UserLabel;

class ClockPanel
extends Panel
implements PrefsPanel,
Runnable {
    private static String propname = "general.clock.";
    private HJBProperties props;
    private GridBagConstraints c;
    private UserCheckbox showTimeCB;
    private UserCheckbox showDateCB;
    private List timefmts;
    private List datefmts;
    private Vector cboxVector = new Vector(2, 2);
    private UserLabel sample;
    private boolean running = true;
    private KeyListener keylistener;

    public ClockPanel(KeyListener keyListener, String string, Font font, Font font2, Font font3) {
        this.props = HJBProperties.getHJBProperties("hjbrowser");
        this.keylistener = keyListener;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.c.insets = new Insets(10, 10, 0, 0);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.anchor = 17;
        MultiLineLabel multiLineLabel = new MultiLineLabel(string);
        multiLineLabel.setFont(font3);
        multiLineLabel.setMarginWidth(0);
        multiLineLabel.setMarginHeight(0);
        this.add((Component)multiLineLabel, this.c);
        this.c.gridy = 1;
        this.c.gridx = 1;
        this.c.insets = new Insets(0, 10, 0, 0);
        this.showTimeCB = this.addCheckbox("showtime", keyListener);
        this.c.gridy = 2;
        this.c.fill = 1;
        this.c.weightx = 4.0;
        this.c.weighty = 4.0;
        this.timefmts = new List(8);
        this.add((Component)this.timefmts, this.c);
        int n = this.props.getInteger("time.fmt.count", 0);
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.props.getProperty("time.fmt.label." + (n2 + 1));
            if (string2 != null) {
                this.timefmts.add(string2);
            }
            ++n2;
        }
        this.c.fill = 0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.showDateCB = this.addCheckbox("showdate", keyListener);
        this.c.gridy = 2;
        this.c.fill = 1;
        this.c.weightx = 4.0;
        this.c.weighty = 4.0;
        this.datefmts = new List(8);
        this.add((Component)this.datefmts, this.c);
        n = this.props.getInteger("date.fmt.count", 0);
        int n3 = 0;
        while (n3 < n) {
            String string3 = this.props.getProperty("date.fmt.label." + (n3 + 1));
            if (string3 != null) {
                this.datefmts.add(string3);
            }
            ++n3;
        }
        this.c.fill = 0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.insets = new Insets(20, 10, 0, 0);
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.sample = this.addLabel("sample");
        this.init();
    }

    private UserLabel addLabel(String string) {
        UserLabel userLabel = new UserLabel(String.valueOf(propname) + string);
        this.add((Component)userLabel, this.c);
        return userLabel;
    }

    private UserCheckbox addCheckbox(String string, CheckboxGroup checkboxGroup, KeyListener keyListener) {
        UserCheckbox userCheckbox = new UserCheckbox(String.valueOf(propname) + string, checkboxGroup, this.props);
        this.add((Component)userCheckbox, this.c);
        userCheckbox.addKeyListener(keyListener);
        this.cboxVector.addElement(userCheckbox);
        return userCheckbox;
    }

    private UserCheckbox addCheckbox(String string, KeyListener keyListener) {
        UserCheckbox userCheckbox = new UserCheckbox(String.valueOf(propname) + string, this.props);
        this.add((Component)userCheckbox, this.c);
        userCheckbox.addKeyListener(keyListener);
        this.cboxVector.addElement(userCheckbox);
        return userCheckbox;
    }

    private void removeCheckboxes() {
        int n = this.cboxVector.size();
        int n2 = 0;
        while (n2 < n) {
            ((Component)this.cboxVector.elementAt(n2)).removeKeyListener(this.keylistener);
            ++n2;
        }
    }

    private void init() {
        this.props.getProperty("hotjava.clock", "on").equals("on");
        boolean bl = this.props.getProperty("hotjava.time", "on").equals("on");
        boolean bl2 = this.props.getProperty("hotjava.date", "off").equals("on");
        String string = this.props.getProperty("hotjava.time.format", "h:mm a");
        String string2 = this.props.getProperty("hotjava.date.format", "mm/dd/yy");
        int n = this.props.getInteger("time.fmt.count", 0);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string3 = this.props.getProperty("time.fmt." + (n3 + 1));
            if (string.equals(string3)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        this.timefmts.select(n2);
        n2 = 0;
        n = this.props.getInteger("date.fmt.count", 0);
        int n4 = 0;
        while (n4 < n) {
            String string4 = this.props.getProperty("date.fmt." + (n4 + 1));
            if (string2.equals(string4)) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        this.datefmts.select(n2);
        this.showTimeCB.setState(bl);
        this.showDateCB.setState(bl2);
        this.running = true;
        new Thread(this).start();
    }

    private String getFormat() {
        String string = "";
        String string2 = "";
        if (this.showTimeCB.getState()) {
            string = this.props.getProperty("time.fmt." + (this.timefmts.getSelectedIndex() + 1), "");
        }
        if (this.showDateCB.getState()) {
            string2 = this.props.getProperty("date.fmt." + (this.datefmts.getSelectedIndex() + 1), "");
        }
        String string3 = string2.length() != 0 && string.length() != 0 ? String.valueOf(string2) + " " + string : String.valueOf(string2) + string;
        return string3;
    }

    public boolean updateCB(String string, Checkbox checkbox, String string2) {
        String string3;
        String string4 = this.props.getProperty(string, string2);
        String string5 = string3 = checkbox.getState() ? "on" : "off";
        if (!string4.equals(string3)) {
            this.props.put(string, string3);
            return true;
        }
        return false;
    }

    public int apply() {
        String string;
        boolean bl = false;
        String string2 = this.props.getProperty("time.fmt." + (this.timefmts.getSelectedIndex() + 1), "");
        String string3 = this.props.getProperty("date.fmt." + (this.datefmts.getSelectedIndex() + 1), "");
        String string4 = this.props.getProperty("hotjava.clock", "on");
        String string5 = string = this.showTimeCB.getState() || this.showDateCB.getState() ? "on" : "off";
        if (!string4.equals(string)) {
            this.props.put("hotjava.clock", string);
            bl = true;
        }
        bl |= this.updateCB("hotjava.time", this.showTimeCB, "on");
        bl |= this.updateCB("hotjava.date", this.showDateCB, "off");
        String string6 = this.props.getProperty("hotjava.clock.format");
        string = this.getFormat();
        if (!string.equals(string6)) {
            bl |= true;
            this.props.put("hotjava.clock.format", string);
        }
        if (!string2.equals(string6 = this.props.getProperty("hotjava.time.format"))) {
            this.props.put("hotjava.time.format", string2);
        }
        if (!string3.equals(string6 = this.props.getProperty("hotjava.date.format"))) {
            this.props.put("hotjava.date.format", string3);
        }
        if (bl) {
            return 2;
        }
        return 1;
    }

    public void stop() {
        this.running = false;
        this.removeCheckboxes();
        this.cboxVector = null;
    }

    public void run() {
        String string = null;
        while (this.running) {
            String string2 = this.getFormat();
            String string3 = Clock.formatTime(string2);
            if (!string3.equals(string)) {
                this.sample.setText(string3);
                string = string3;
            }
            try {
                Thread.sleep(250L);
            }
            catch (Exception exception) {}
        }
    }
}

