/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import sun.awt.VariableGridLayout;
import sun.io.ByteToCharConverter;
import sun.misc.BASE64Encoder;
import sun.misc.CharacterEncoder;
import sun.net.smtp.SmtpClient;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.applets.HotJavaApplet;
import sunw.hotjava.bean.CurrentDocument;
import sunw.hotjava.misc.Base64HeaderEncoder;
import sunw.hotjava.misc.CharacterEncoding;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.QPEncoder;
import sunw.hotjava.misc.QPHeaderEncoder;
import sunw.hotjava.misc.VerbatimHeaderEncoder;
import sunw.hotjava.ui.ConfirmDialog;
import sunw.hotjava.ui.EnterKeyListener;
import sunw.hotjava.ui.KeyPressInterest;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextArea;
import sunw.hotjava.ui.UserTextField;

public class MailDocumentApplet
extends HotJavaApplet
implements ActionListener,
KeyPressInterest {
    static final String propName = "maildoc";
    static String mimePreamble = null;
    static String mimeEpilogue = null;
    static String boundaryPrefix = null;
    String userMailAddress;
    String toParam;
    String subjectParam;
    TextField fromAddressField;
    TextField toAddressField;
    TextField subjectField;
    TextArea compositionArea;
    UIHJButton sendButton;
    UIHJButton cancelButton;
    UIHJButton insertURLButton;
    EnterKeyListener ekl;
    Checkbox insertDocToggle;
    String url;
    boolean didInsert;
    HJBProperties props = HJBProperties.getHJBProperties("hjbrowser");
    CurrentDocument doc;

    public void init() {
        this.doc = HJWindowManager.getHJWindowManager().getPrevDocument();
        this.ekl = new EnterKeyListener(this);
        if (mimePreamble == null) {
            mimePreamble = this.props.getProperty("maildoc.mime.preamble");
            mimeEpilogue = this.props.getProperty("maildoc.mime.epilogue");
            boundaryPrefix = this.props.getProperty("maildoc.mime.boundary.prefix");
        }
        this.toParam = this.getParameter("to", "");
        this.subjectParam = this.getParameter("subject");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        VariableGridLayout variableGridLayout = new VariableGridLayout(1, 2);
        variableGridLayout.setColFraction(0, 0.15);
        variableGridLayout.setColFraction(1, 0.85);
        panel.setLayout((LayoutManager)variableGridLayout);
        this.add("North", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(0, 1));
        panel.add(panel2);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(0, 1));
        panel.add(panel3);
        this.header(panel2, "tolabel");
        this.toAddressField = new UserTextField("maildoc.headfield");
        panel3.add(this.toAddressField);
        this.toAddressField.addActionListener(this);
        this.header(panel2, "fromlabel");
        this.fromAddressField = new UserTextField("maildoc.headfield");
        panel3.add(this.fromAddressField);
        this.fromAddressField.addActionListener(this);
        this.header(panel2, "subjectlabel");
        this.subjectField = new UserTextField("maildoc.headfield");
        panel3.add(this.subjectField);
        this.subjectField.addActionListener(this);
        this.header(panel2, "composearea.title");
        panel3.add(new Label(""));
        this.compositionArea = new UserTextArea("maildoc.composearea", this.props);
        this.add("Center", this.compositionArea);
        GridBagLayout gridBagLayout = new GridBagLayout();
        Panel panel4 = new Panel();
        panel4.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add("South", panel4);
        panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.insertURLButton = new UIHJButton("maildoc.inserturl", this.props);
        panel.add(this.insertURLButton);
        this.insertURLButton.addActionListener(this);
        this.insertDocToggle = new Checkbox(this.props.getProperty("maildoc.attach.text"));
        panel.add(this.insertDocToggle);
        this.insertDocToggle.addKeyListener(this.ekl);
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        panel4.add(panel);
        panel = new Panel();
        panel.setLayout(new FlowLayout(2, 5, 0));
        UIHJButtonGroup uIHJButtonGroup = new UIHJButtonGroup(this.props);
        this.sendButton = new UIHJButton("maildoc.send", this.props);
        panel.add(this.sendButton);
        this.cancelButton = new UIHJButton("maildoc.cancel", this.props);
        panel.add(this.cancelButton);
        uIHJButtonGroup.addButtonToGroup(this.sendButton);
        uIHJButtonGroup.addButtonToGroup(this.cancelButton);
        this.sendButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        panel4.add(panel);
        this.fetchDocState();
        this.resetFields();
    }

    void resetFields() {
        this.didInsert = false;
        this.resetPreferences();
        ((TextComponent)this.toAddressField).setText(this.toParam);
        this.loadSubject();
        this.compositionArea.setText(this.getParameter("body", ""));
        this.insertDocToggle.setState(false);
    }

    void resetPreferences() {
        this.userMailAddress = this.getParameter("from", this.getMailAddress());
        ((TextComponent)this.fromAddressField).setText(this.userMailAddress);
    }

    public void start() {
        this.fetchDocState();
        this.resetPreferences();
        this.loadSubject();
        this.prepare();
    }

    private void fetchDocState() {
        URL uRL = this.doc.documentURL;
        if (uRL != null) {
            this.url = uRL.toExternalForm();
        }
    }

    private void loadSubject() {
        if (this.subjectParam == null) {
            if (this.url != null) {
                ((TextComponent)this.subjectField).setText(this.doc.documentTitle);
                return;
            }
            ((TextComponent)this.subjectField).setText("");
            return;
        }
        ((TextComponent)this.subjectField).setText(this.subjectParam);
    }

    void header(Container container, String string) {
        container.add(new UserLabel("maildoc." + string));
    }

    void prepare() {
        this.sendButton.setEnabled(true);
        this.insertURLButton.setEnabled(this.canInsertURL());
    }

    boolean canInsert() {
        return this.doc != null && !this.didInsert;
    }

    boolean canInsertURL() {
        return this.url != null;
    }

    private Frame getFrame() {
        return HJWindowManager.getHJWindowManager().getLastFocusHolder();
    }

    public void processEnterEvent(KeyEvent keyEvent) {
        this.actionPerformed(new ActionEvent(this.sendButton, 0, ""));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.sendButton || object instanceof UserTextField) {
            this.sendMail();
            return;
        }
        if (object == this.insertURLButton) {
            this.insertURL();
            this.prepare();
            return;
        }
        if (object == this.cancelButton) {
            HJWindowManager.getHJWindowManager().closeFrame(HJWindowManager.getHJWindowManager().getLastFocusHolder());
            return;
        }
    }

    void insertURL() {
        this.compositionArea.insert(this.url, this.compositionArea.getSelectionStart());
    }

    public void sendMail() {
        String string = this.toAddressField.getText().trim();
        if (string.length() == 0) {
            ((Component)new ConfirmDialog("maildoc.error", this.getFrame(), 1)).setVisible(true);
            return;
        }
        String string2 = this.fromAddressField.getText().trim();
        if (string2.length() == 0) {
            ((Component)new ConfirmDialog("maildoc.error1", this.getFrame(), 1)).setVisible(true);
            return;
        }
        String string3 = this.subjectField.getText().trim();
        String string4 = CharacterEncoding.getNetworkName(this.getCharSet());
        if (string4 == null) {
            string4 = this.getCharSet();
        }
        String string5 = this.props.getProperty("maildoc.headers.transfer.encoding", "quoted-printable");
        char c = string5.charAt(0);
        string5 = this.props.getProperty("maildoc.body.transfer.encoding", "quoted-printable");
        char c2 = string5.charAt(0);
        try {
            SmtpClient smtpClient = new SmtpClient();
            smtpClient.from(string2);
            smtpClient.to(string);
            PrintStream printStream = smtpClient.startMessage();
            if (string2.length() > 0) {
                printStream.println("From: " + string2);
            }
            printStream.println("To: " + string);
            if (string3.length() > 0) {
                String string6 = this.getCharSet();
                this.encodeHeader("Subject", string3, string6, c, printStream);
            }
            if (this.url != null) {
                printStream.println("X-URL: " + this.url);
            }
            printStream.println("Mime-version: 1.0");
            if (this.insertDocToggle.getState()) {
                this.insertMultipartHTMLMessage(printStream, string4, c2);
            } else {
                this.insertSimpleMessage(printStream, string4, c2);
            }
            smtpClient.closeServer();
            HJWindowManager.getHJWindowManager().closeFrame(HJWindowManager.getHJWindowManager().getLastFocusHolder());
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.showStatus(this.props.getPropertyReplace("mailto.error.message", iOException.toString()));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.showStatus(this.props.getPropertyReplace("mailto.error.message", exception.toString()));
            return;
        }
    }

    private String getBoundaryString(Date date) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.US);
        String string = dateFormat.format(date);
        string = string.replace(' ', '_');
        string = string.replace(':', '_');
        return String.valueOf(boundaryPrefix) + string;
    }

    private void insertDoc(PrintStream printStream, String string, char c) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        char[] cArray = new char[4096];
        int n = -1;
        while ((n = this.doc.documentSource.read(cArray, 0, 4096)) != -1) {
            printWriter.write(cArray, 0, n);
        }
        printWriter.flush();
        printWriter.close();
        printStream.println("Content-type: text/html; charset=" + string + "; name=\"" + this.doc.documentURL.getFile() + "\"");
        this.transferEncodeContent(stringWriter.toString(), printStream, c);
    }

    private void insertSimpleMessage(PrintStream printStream, String string, char c) throws IOException {
        printStream.println("Content-type: text/plain; charset=" + string);
        this.transferEncodeContent(this.compositionArea.getText(), printStream, c);
    }

    private void insertMultipartHTMLMessage(PrintStream printStream, String string, char c) throws IOException {
        String string2 = this.getBoundaryString(new Date());
        printStream.println("Content-type: multipart/mixed; boundary=" + string2);
        string2 = "--" + string2;
        printStream.println();
        printStream.println(mimePreamble);
        printStream.println();
        printStream.println(string2);
        this.insertSimpleMessage(printStream, string, c);
        printStream.println();
        printStream.println(string2);
        this.insertDoc(printStream, string, c);
        printStream.println(String.valueOf(string2) + "--");
        printStream.println();
        printStream.println(mimeEpilogue);
        printStream.println();
    }

    private void transferEncodeContent(String string, PrintStream printStream, char c) throws IOException {
        Object object;
        String string2 = null;
        if (!string.endsWith("\n")) {
            string = String.valueOf(string) + "\n";
        }
        switch (c) {
            case 'Q': 
            case 'q': {
                string2 = "quoted-printable";
                object = new QPEncoder(false, false);
                break;
            }
            case 'B': 
            case 'b': {
                string2 = "base64";
                object = new BASE64Encoder();
                break;
            }
            case 'N': 
            case 'n': {
                printStream.println();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(printStream);
                outputStreamWriter.write(string, 0, string.length());
                outputStreamWriter.flush();
                return;
            }
            default: {
                string2 = "base64";
                object = new BASE64Encoder();
            }
        }
        if (string2 != null) {
            printStream.println("Content-transfer-encoding: " + string2);
        }
        printStream.println();
        byte[] byArray = string.getBytes(this.getCharSet());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        object.encodeBuffer((InputStream)byteArrayInputStream, (OutputStream)printStream);
        printStream.flush();
    }

    private void encodeHeader(String string, String string2, String string3, char c, PrintStream printStream) throws IOException {
        CharacterEncoder characterEncoder;
        String string4 = CharacterEncoding.getNetworkName(string3);
        if (string4 == null) {
            string4 = this.getCharSet();
        }
        switch (c) {
            case 'Q': 
            case 'q': {
                characterEncoder = new QPHeaderEncoder(string, string4);
                break;
            }
            case 'B': 
            case 'b': {
                characterEncoder = new Base64HeaderEncoder(string, string4);
                break;
            }
            case 'N': 
            case 'n': {
                characterEncoder = new VerbatimHeaderEncoder(string);
                break;
            }
            default: {
                characterEncoder = new VerbatimHeaderEncoder(string);
            }
        }
        characterEncoder.encodeBuffer(string2.getBytes(string3), (OutputStream)printStream);
    }

    private String getCharSet() {
        String string = this.props.getProperty("maildoc.charset");
        if (string == null) {
            string = this.props.getProperty("hotjava.charset", "8859_1");
        }
        if (string.equals("JISAutoDetect")) {
            string = "EUCJIS";
        }
        try {
            ByteToCharConverter.getConverter((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println("Charset " + string + " is not supported. Use 8859_1");
            string = "8859_1";
        }
        return string;
    }
}

