/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.applets;

import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.Font;
import java.awt.List;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;
import sunw.hotjava.applets.HotJavaApplet;
import sunw.hotjava.ui.RaisedPanel;
import sunw.hotjava.ui.UserLabel;
import sunw.hotjava.ui.UserTextButton;

public class ThreadListApplet
extends HotJavaApplet
implements Runnable {
    static final String propName = "threadlist";
    Thread myThread;
    boolean dieNow;
    Panel topPanel;
    List threadList;
    Vector displayedThreads;
    Object selectedObject;
    ThreadGroup rootThreadGroup;
    ThreadGroup mainThreadGroup;
    Vector allThreads;
    Vector allThreadGroups;
    Vector oldThreads;
    Vector oldThreadGroups;
    Vector allExpandedGroups;
    UserTextButton killButton;
    UserTextButton raiseButton;
    UserTextButton lowerButton;
    static final int defaultMsecSleep = 2000;
    static final int colsName = 50;
    static final int colsPrio = 4;
    static final int indentPerLevel = 2;
    static final String threadGroupClosedMark = "> ";
    static final String threadGroupOpenMark = "+ ";

    public void init() {
        this.setLayout(new BorderLayout());
        Font font = HotJavaApplet.properties.getFont("threadlist.listfont");
        this.topPanel = new RaisedPanel();
        this.add("North", this.topPanel);
        this.topPanel.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        this.topPanel.add("North", panel);
        panel.add("South", new UserLabel("threadlist.legend"));
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        this.add("Center", panel2);
        this.threadList = new List(8, false);
        panel2.add(this.threadList);
        this.threadList.setFont(font);
        Panel panel3 = new Panel();
        this.add("South", panel3);
        this.killButton = new UserTextButton("threadlist.kill", HotJavaApplet.properties);
        panel3.add(this.killButton);
        this.killButton.disable();
        this.raiseButton = new UserTextButton("threadlist.raise", HotJavaApplet.properties);
        panel3.add(this.raiseButton);
        this.raiseButton.disable();
        this.lowerButton = new UserTextButton("threadlist.lower", HotJavaApplet.properties);
        panel3.add(this.lowerButton);
        this.lowerButton.disable();
    }

    public void start() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.die();
            try {
                this.myThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void stop() {
        if (this.myThread != null && this.myThread.isAlive()) {
            this.die();
        }
        this.myThread = null;
    }

    Vector getAllThreadGroups() {
        int n = this.rootThreadGroup.activeGroupCount();
        ThreadGroup[] threadGroupArray = new ThreadGroup[n];
        n = this.rootThreadGroup.enumerate(threadGroupArray);
        Vector<ThreadGroup> vector = new Vector<ThreadGroup>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(threadGroupArray[n2]);
            ++n2;
        }
        return vector;
    }

    Vector getAllThreads() {
        int n = this.rootThreadGroup.activeCount();
        Thread[] threadArray = new Thread[n];
        n = this.rootThreadGroup.enumerate(threadArray);
        Vector<Thread> vector = new Vector<Thread>(n);
        int n2 = 0;
        while (n2 < n) {
            vector.addElement(threadArray[n2]);
            ++n2;
        }
        return vector;
    }

    ThreadGroup getRootThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    ThreadGroup getMainThreadGroup() {
        ThreadGroup[] threadGroupArray = new ThreadGroup[this.rootThreadGroup.activeGroupCount()];
        int n = this.rootThreadGroup.enumerate(threadGroupArray, false);
        int n2 = 0;
        while (n2 < n) {
            if ("main".equals(threadGroupArray[n2].getName())) {
                return threadGroupArray[n2];
            }
            ++n2;
        }
        return null;
    }

    boolean isChildOf(Thread thread, ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = thread.getThreadGroup();
        if (threadGroup2 == threadGroup) {
            return true;
        }
        return this.isChildOf(threadGroup2, threadGroup);
    }

    boolean isChildOf(ThreadGroup threadGroup, ThreadGroup threadGroup2) {
        ThreadGroup threadGroup3 = threadGroup.getParent();
        while (threadGroup3 != null) {
            if (threadGroup3 == threadGroup2) {
                return true;
            }
            threadGroup3 = threadGroup3.getParent();
        }
        return threadGroup2 == null;
    }

    final boolean isAppletThreadGroup(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return false;
        }
        if (threadGroup.getClass().toString().equals("class sunw.hotjava.applets.AppletThreadGroup")) {
            return true;
        }
        return this.isAppletThreadGroup(threadGroup.getParent());
    }

    final boolean isAppletThread(Thread thread) {
        return thread != null && this.isAppletThreadGroup(thread.getThreadGroup());
    }

    void die() {
        this.dieNow = true;
    }

    void sleep(Thread thread) {
        int n = HotJavaApplet.properties.getInteger("threadlist.sleep", 2000);
        try {
            Thread.sleep(n);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void run() {
        Thread thread = Thread.currentThread();
        thread.setName("ThreadListApplet thread");
        this.rootThreadGroup = this.getRootThreadGroup();
        this.mainThreadGroup = this.getMainThreadGroup();
        this.allExpandedGroups = new Vector(3);
        this.allExpandedGroups.addElement(this.mainThreadGroup);
        this.dieNow = false;
        while (!this.dieNow) {
            this.allThreads = this.getAllThreads();
            this.allThreadGroups = this.getAllThreadGroups();
            if (!this.noChanges(this.allThreads, this.oldThreads) || !this.noChanges(this.allThreadGroups, this.oldThreadGroups)) {
                this.removeDeadGroups(this.allExpandedGroups, this.allThreadGroups);
                this.clear();
                this.populateList(this.threadList, this.rootThreadGroup, this.selectedObject, 0, 0);
                this.oldThreads = this.allThreads;
                this.oldThreadGroups = this.allThreadGroups;
                this.prepare();
            }
            this.sleep(thread);
        }
    }

    void clear() {
        this.threadList.clear();
        this.displayedThreads = new Vector(10);
    }

    void removeDeadGroups(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector2.contains(e)) continue;
            vector.removeElement(e);
        }
    }

    boolean noChanges(Vector vector, Vector vector2) {
        if (vector != null && vector2 != null && vector.size() == vector2.size()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (vector2.contains(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void updateEntry(Object object) {
        String string;
        int n = this.displayedThreads.indexOf(object);
        if (object instanceof Thread) {
            string = this.threadInfo((Thread)object, this.calculateDepth((Thread)object));
        } else if (object instanceof ThreadGroup) {
            string = this.threadGroupInfo((ThreadGroup)object, this.calculateDepth((ThreadGroup)object) - 1);
        } else {
            return;
        }
        this.threadList.replaceItem(string, n);
    }

    final String spaces(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        return string;
    }

    String pad(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return this.pad(String.valueOf(string) + "                    ", n);
    }

    String threadInfo(Thread thread, int n) {
        String string = "";
        if (this.isAppletThread(thread)) {
            string = String.valueOf(string) + HotJavaApplet.properties.getProperty("threadlist.applet");
        }
        if (thread.isDaemon()) {
            string = String.valueOf(string) + HotJavaApplet.properties.getProperty("threadlist.daemon");
        }
        return String.valueOf(this.pad(String.valueOf(this.spaces(n * 2)) + thread.getName(), 50)) + "  " + this.pad(String.valueOf(thread.getPriority()), 4) + string;
    }

    String threadGroupInfo(ThreadGroup threadGroup, int n) {
        String string = this.allExpandedGroups.contains(threadGroup) ? threadGroupOpenMark : threadGroupClosedMark;
        String string2 = "";
        if (this.isAppletThreadGroup(threadGroup)) {
            string2 = String.valueOf(string2) + HotJavaApplet.properties.getProperty("threadlist.applet");
        }
        if (threadGroup.isDaemon()) {
            string2 = String.valueOf(string2) + HotJavaApplet.properties.getProperty("threadlist.daemon");
        }
        string2 = String.valueOf(string2) + HotJavaApplet.properties.getProperty("threadlist.group");
        return String.valueOf(this.pad(String.valueOf(this.spaces(n * 2)) + string + threadGroup.getName(), 50)) + "  " + this.pad(String.valueOf(threadGroup.getMaxPriority()), 4) + string2;
    }

    int populateList(List list, ThreadGroup threadGroup, Object object, int n, int n2) {
        Thread[] threadArray;
        int n3 = n;
        int n4 = threadGroup.activeGroupCount();
        ThreadGroup[] threadGroupArray = new ThreadGroup[n4];
        n4 = threadGroup.enumerate(threadGroupArray, false);
        int n5 = 0;
        while (n5 < n4) {
            threadArray = threadGroupArray[n5];
            list.addItem(this.threadGroupInfo((ThreadGroup)threadArray, n2), n3);
            this.displayedThreads.insertElementAt(threadArray, n3);
            n3 = this.allExpandedGroups.contains(threadArray) ? this.populateList(list, (ThreadGroup)threadArray, object, n3 + 1, n2 + 1) : ++n3;
            ++n5;
        }
        n4 = threadGroup.activeCount();
        threadArray = new Thread[n4];
        n4 = threadGroup.enumerate(threadArray, false);
        n5 = 0;
        while (n5 < n4) {
            Thread thread = threadArray[n5];
            list.addItem(this.threadInfo(thread, n2), n3);
            this.displayedThreads.insertElementAt(thread, n3);
            ++n3;
            ++n5;
        }
        return n3;
    }

    synchronized void prepare() {
        if (this.selectedObject != null) {
            int n = this.displayedThreads.indexOf(this.selectedObject);
            if (n > -1) {
                this.threadList.select(n);
            } else {
                this.selectedObject = null;
            }
        }
        if (this.selectedObject instanceof Thread) {
            Thread thread = (Thread)this.selectedObject;
            boolean bl = this.isAppletThread(thread);
            this.killButton.enable(bl);
            int n = thread.getPriority();
            this.raiseButton.enable(bl && n < thread.getThreadGroup().getMaxPriority());
            this.lowerButton.enable(bl && n > 1);
            return;
        }
        if (this.selectedObject instanceof ThreadGroup) {
            ThreadGroup threadGroup = (ThreadGroup)this.selectedObject;
            this.killButton.enable(this.isAppletThreadGroup(threadGroup));
            this.raiseButton.disable();
            this.lowerButton.disable();
            return;
        }
        this.killButton.disable();
        this.raiseButton.disable();
        this.lowerButton.disable();
    }

    public synchronized boolean action(Event event, Object object) {
        if (event.target == this.threadList) {
            int n = this.threadList.getSelectedIndex();
            Object e = this.displayedThreads.elementAt(n);
            if (e instanceof ThreadGroup) {
                if (this.allExpandedGroups.contains(e)) {
                    this.shrinkGroup((ThreadGroup)e, n);
                } else {
                    this.expandGroup((ThreadGroup)e, n);
                }
                this.updateEntry(e);
            }
            this.prepare();
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.endsWith("raise")) {
                Thread thread = (Thread)this.selectedObject;
                thread.setPriority(thread.getPriority() + 1);
                this.updateEntry(this.selectedObject);
                this.prepare();
                return true;
            }
            if (string.endsWith("lower")) {
                Thread thread = (Thread)this.selectedObject;
                thread.setPriority(thread.getPriority() - 1);
                this.updateEntry(this.selectedObject);
                this.prepare();
                return true;
            }
            if (string.endsWith("kill")) {
                this.kill(this.selectedObject);
                this.prepare();
                return true;
            }
        }
        return false;
    }

    public synchronized boolean handleEvent(Event event) {
        switch (event.id) {
            case 701: {
                int n = this.threadList.getSelectedIndex();
                if (n != -1) {
                    this.selectedObject = this.displayedThreads.elementAt(n);
                }
                this.prepare();
                return true;
            }
            case 702: {
                this.selectedObject = null;
                this.prepare();
                return true;
            }
        }
        return super.handleEvent(event);
    }

    int calculateDepth(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = threadGroup.getParent();
        if (threadGroup2 == null) {
            return 0;
        }
        return 1 + this.calculateDepth(threadGroup2);
    }

    int calculateDepth(Thread thread) {
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            return 0;
        }
        return this.calculateDepth(threadGroup);
    }

    void shrinkGroup(ThreadGroup threadGroup, int n) {
        int n2 = n + 1;
        while (n2 < this.displayedThreads.size()) {
            Object object;
            Object e = this.displayedThreads.elementAt(n2);
            if (e instanceof Thread) {
                object = (Thread)e;
                if (!this.isChildOf((Thread)object, threadGroup)) break;
                this.displayedThreads.removeElementAt(n2);
                this.threadList.delItem(n2);
                continue;
            }
            object = (ThreadGroup)e;
            if (!this.isChildOf((ThreadGroup)object, threadGroup)) break;
            this.displayedThreads.removeElementAt(n2);
            this.threadList.delItem(n2);
        }
        this.allExpandedGroups.removeElement(threadGroup);
    }

    void expandGroup(ThreadGroup threadGroup, int n) {
        int n2 = this.calculateDepth(threadGroup);
        this.populateList(this.threadList, threadGroup, this.selectedObject, n + 1, n2);
        this.allExpandedGroups.addElement(threadGroup);
    }

    void kill(Object object) {
        if (object instanceof Thread) {
            Thread thread = (Thread)object;
            thread.stop();
            return;
        }
        if (object instanceof ThreadGroup) {
            ThreadGroup threadGroup = (ThreadGroup)object;
            threadGroup.stop();
        }
    }
}

