/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import sun.awt.ScreenUpdater;
import sun.awt.UpdateClient;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocItem;
import sunw.hotjava.doc.DocItemEnumeration;
import sunw.hotjava.doc.DocLine;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.DocStyle;
import sunw.hotjava.doc.DocView;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentBackground;
import sunw.hotjava.doc.DocumentEvent;
import sunw.hotjava.doc.DocumentFormatterPanel;
import sunw.hotjava.doc.DocumentListener;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.DocumentState;
import sunw.hotjava.doc.DragThread;
import sunw.hotjava.doc.EndTagItem;
import sunw.hotjava.doc.FormatState;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.FormatterVBreakInfo;
import sunw.hotjava.doc.ItemComponent;
import sunw.hotjava.doc.MouseDownInfo;
import sunw.hotjava.doc.PageMargins;
import sunw.hotjava.doc.PageMarker;
import sunw.hotjava.doc.Responsibility;
import sunw.hotjava.doc.SelectionOwner;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.doc.TextItem;
import sunw.hotjava.misc.Globals;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.RequestProcessor;
import sunw.hotjava.script.ScriptContextInterface;
import sunw.hotjava.script.ScriptSecuritySupportInterface;
import sunw.hotjava.script.ScriptingEngineInterface;
import sunw.hotjava.tables.TableElementPanel;
import sunw.hotjava.tables.TablePanel;
import sunw.hotjava.tags.TagAppletPanel;

public class DocumentFormatter
extends Formatter
implements DocView,
UpdateClient,
SelectionOwner,
Serializable {
    public Container parent;
    private DocumentPanel scroller;
    static final long serialVersionUID = 7159451397616758869L;
    private static final Integer FORMAT_SCREEN = new Integer(10000);
    private static final Integer FORMAT_DOCUMENT = new Integer(10001);
    private static final Integer REPAINT = new Integer(10003);
    private Object SYNC_PAINTS = new Object();
    boolean bFormatDone = false;
    int scrollBarWidth;
    boolean repair;
    boolean repaintOnWake = false;
    private int xToScroll;
    private int yToScroll;
    private boolean needScrollOnFinish = false;
    private MouseDownInfo down;
    TagItem active;
    private int marginWidth = 10;
    private int docX;
    private int docY;
    private int newY;
    private boolean printing = false;
    private Vector blinkers = new Vector();
    DragThread dragThread;
    Object dragLock = new Object();
    int dragDelay = 100;
    String label;
    long lastFormatedTime;
    int pendingFormatRequest;
    private FormatState fs;
    private FormatState bs;
    private Formatter.FormatterMouseListener formatterMouseListener;
    private DocListener formatterDocListener;
    private KeyListener keyListener;
    private ScriptContextInterface scriptContext;
    private URL scriptContextCodebase;
    private ScriptSecuritySupportInterface securitySupport;
    private String defaultStatusMessage = "";

    public ScriptContextInterface getScriptContext() {
        return this.scriptContext;
    }

    public void setScriptContext(ScriptContextInterface scriptContextInterface) {
        this.scriptContext = scriptContextInterface;
        this.scriptContextCodebase = scriptContextInterface != null ? this.getDocument().getURL() : null;
    }

    public ScriptSecuritySupportInterface getSecuritySupport() {
        return this.securitySupport;
    }

    public void setSecuritySupport(ScriptSecuritySupportInterface scriptSecuritySupportInterface) {
        this.securitySupport = scriptSecuritySupportInterface;
    }

    public DocumentFormatter(Container container, Document document, DocFont docFont) {
        this(container, document, docFont, true);
    }

    public DocumentFormatter(Container container, Document document, DocFont docFont, boolean bl) {
        this.bFormatDone = false;
        this.parent = container;
        this.scroller = (DocumentPanel)container.getParent();
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document2 = document;
            synchronized (document2) {
                this.stdInit(document, docFont);
                this.itemComponents = new ItemComponent[6];
                document.addView(this);
            }
        }
        this.formatterDocListener = new DocListener();
        object = this.getParent();
        if (object == null) {
            return;
        }
        this.formatterMouseListener = new Formatter.FormatterMouseListener(this);
        ScriptingEngineInterface scriptingEngineInterface = Globals.getScriptingEngine();
        if (scriptingEngineInterface != null && bl) {
            try {
                this.setScriptContext(scriptingEngineInterface.getContext(this));
                return;
            }
            catch (RuntimeException runtimeException) {
                System.out.println("[[[ DocumentFormatter(): could not instantiate script context: <" + runtimeException + "> ]]]");
                runtimeException.printStackTrace();
                return;
            }
        }
    }

    public DocumentFormatter(DocumentFormatter documentFormatter, DocFont docFont) {
        this.parent = null;
        this.scroller = null;
        this.stdInit(documentFormatter.doc, docFont);
        this.copyPanelsForPrinting(documentFormatter, this.ds);
        this.printing = true;
    }

    public DocumentFormatter() {
        this.parent = null;
        this.scroller = null;
    }

    public void removeListeners() {
        this.doc.removeDocumentListener(this.formatterDocListener);
        this.parent.removeMouseListener(this.formatterMouseListener);
        this.parent.removeMouseMotionListener(this.formatterMouseListener);
        this.parent.removeKeyListener(this.keyListener);
    }

    public void unregisterListeners() {
        this.removeListeners();
        super.unregisterListeners();
    }

    public void addListeners() {
        this.doc.addDocumentListener(this.formatterDocListener);
        this.parent.addMouseListener(this.formatterMouseListener);
        this.parent.addMouseMotionListener(this.formatterMouseListener);
        this.parent.addKeyListener(this.keyListener);
    }

    private void stdInit(Document document, DocFont docFont) {
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        this.docHeight = 10;
        this.doc = document;
        this.lines = new DocLine[100];
        this.lines[0] = new DocLine(0, 0, 0, 0, 0, 0, 0, 0, 0, 0);
        this.nlines = 0;
        this.ds.docStyle = new DocStyle(docFont);
        this.ds.docStyle.doc = document;
        this.ds.docStyle.win = this;
        this.ds.started = true;
        this.ds.background = hJBProperties.getColor("hotjava.docbgcolor", Color.white);
        this.ds.topFormatter = this;
        this.resetDocStyle();
        this.ds.selStart = -1;
        this.ds.selEnd = -1;
    }

    public ScrollPane getScrollPane() {
        return this.scroller;
    }

    protected void setVScrollBarWidth(int n) {
        this.scrollBarWidth = n;
    }

    public int getVScrollBarWidth() {
        return this.scrollBarWidth;
    }

    protected int getStartIndex() {
        return 0;
    }

    protected boolean getRepair() {
        return this.repair;
    }

    protected void setRepair(boolean bl) {
        if (this.bFormatDone) {
            this.repair = bl;
        }
    }

    public void stop() {
        this.reset();
        super.stop();
    }

    public boolean isFormatDone() {
        return this.bFormatDone;
    }

    public void reset() {
        this.bFormatDone = false;
    }

    protected int getMaxIndex() {
        return this.doc.nitems;
    }

    public String getDefaultStatusMessage() {
        return this.defaultStatusMessage;
    }

    public void setDefaultStatusMessage(String string) {
        this.defaultStatusMessage = string;
        this.dispatchDocumentEvent(1039, string);
    }

    public void getBackgroundDisplacement(Point point) {
    }

    public boolean hasSelection() {
        return this.hasSelection(this.ds);
    }

    boolean hasSelection(DocumentState documentState) {
        if (documentState.selStart == documentState.selEnd) {
            return false;
        }
        return documentState.selStart != -1 && documentState.selEnd != -1;
    }

    public Vector getAppletPanels() {
        Vector vector = new Vector();
        this.getAppletPanels(vector);
        return vector;
    }

    public Vector getAppletPanelsAcrossFrames() {
        Vector vector = new Vector();
        this.getAppletPanels(vector, true);
        return vector;
    }

    public void gotoLabel(String string) {
        Document document = this.doc;
        synchronized (document) {
            this.label = string;
            if (this.ds.started && this.label != null) {
                this.bFormatDone = true;
                this.touch(false, 0);
            }
            return;
        }
    }

    public boolean setSize(int n, int n2, int n3) {
        return this.setSize(n, n2, n3, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSize(int n, int n2, int n3, boolean bl) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.width != n || this.scrollBarWidth != n3) {
                    int n4 = this.getVScrollBarWidth();
                    if (this.width + n4 != n + n3) {
                        this.setVScrollBarWidth(n3);
                        this.width = n;
                        this.height = n2;
                        this.reformat();
                        return true;
                    }
                    if (!bl) return false;
                    this.width = n;
                    this.height = n2;
                    return false;
                }
                if (this.height == n2) return false;
                this.height = n2;
                this.touch(false, 100);
            }
            return false;
        }
    }

    public void setMargins(int n, int n2) {
        Document document = this.doc;
        synchronized (document) {
            if (this.marginWidth != n || this.marginHeight != n2) {
                this.marginWidth = n;
                this.marginHeight = n2;
                this.resetDocStyle();
                this.reformat();
            }
            return;
        }
    }

    public void setRepaintOnWake(boolean bl) {
        this.repaintOnWake = bl;
    }

    protected void wakeScreenUpdater() {
        if (this.repaintOnWake) {
            ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)REPAINT);
        }
        this.repaintOnWake = false;
    }

    protected void setVisible(Component component, BitSet bitSet, int n) {
        if (bitSet != null && bitSet.get(n)) {
            component.setVisible(true);
        }
    }

    protected void setInvisible(Component component, BitSet bitSet, int n) {
        if (component.isVisible()) {
            bitSet.set(n);
            component.setVisible(false);
        }
    }

    protected void connectBackgroundClient() {
        if (this.ds.bg != null && this.parent != null) {
            this.ds.bg.addClient(this.parent);
        }
    }

    protected void disconnectBackgroundClient() {
        if (this.ds.bg != null && this.parent != null) {
            this.ds.bg.removeClient(this.parent);
        }
    }

    protected void quitViewingDoc() {
        this.doc.removeView(this);
    }

    protected void disconnectFromParent(Component component) {
        if (this.parent != null) {
            this.parent.remove(component);
        }
    }

    protected void setFormatterStarted(boolean bl) {
        this.ds.started = bl;
    }

    public Container getParent() {
        return this.parent;
    }

    public void interruptLoading() {
        super.interruptLoading();
    }

    protected MouseDownInfo getMouseDownInfo() {
        return this.down;
    }

    protected void setMouseDownInfo(MouseDownInfo mouseDownInfo) {
        this.down = mouseDownInfo;
    }

    protected boolean handleMouseDown(MouseEvent mouseEvent) {
        this.parent.requestFocus();
        this.dispatchDocumentEvent(1026, null);
        return super.handleMouseDown(mouseEvent);
    }

    public Graphics getGraphics() {
        if (this.parent != null && this.ds.started) {
            return this.parent.getGraphics();
        }
        return null;
    }

    public void repaint() {
        if (this.ds.started) {
            ScreenUpdater.updater.notify((UpdateClient)this, 100L, (Object)REPAINT);
        }
    }

    public int countPanels() {
        return this.nItemComponents;
    }

    public Component getPanel(int n) {
        if (n < this.nItemComponents) {
            return this.itemComponents[n].getComponent();
        }
        return null;
    }

    public Formatter getCorrectFormatter(int n) {
        return this.findCorrectFormatter(this, n);
    }

    private Formatter findCorrectFormatter(Formatter formatter, int n) {
        Responsibility responsibility = formatter.findResponsibility(n);
        if (responsibility == null) {
            return formatter;
        }
        DocPanel docPanel = responsibility.getTarget();
        if (!(docPanel instanceof TablePanel)) {
            return formatter;
        }
        TablePanel tablePanel = (TablePanel)docPanel;
        Enumeration enumeration = tablePanel.enumeratePanels();
        while (enumeration.hasMoreElements()) {
            TableElementPanel tableElementPanel = (TableElementPanel)enumeration.nextElement();
            if (!tableElementPanel.containsPos(n)) continue;
            Formatter formatter2 = tableElementPanel.getFormatter();
            return this.findCorrectFormatter(formatter2, n);
        }
        return formatter;
    }

    public DocStyle getStyle() {
        return this.ds.docStyle;
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getDocumentX() {
        return this.docX;
    }

    public void setDocumentX(int n) {
        this.docX = n;
    }

    public void setDocumentY(int n) {
        this.docY = n;
    }

    public int getDocumentY() {
        if (this.scroller != null) {
            Point point = this.scroller.getScrollPosition();
            this.docY = point.y;
            return point.y;
        }
        this.docY = 0;
        return 0;
    }

    public TagItem getActive() {
        if (this.down == null) {
            return null;
        }
        return this.down.tag;
    }

    public int getWidth() {
        return this.width;
    }

    public int getAvailableWidth() {
        return this.width - 2 * this.marginWidth;
    }

    public int getAvailableHeight() {
        return this.height - 2 * this.marginHeight;
    }

    public void initializeParent() {
    }

    public Color getDocBackgroundColor() {
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return null;
    }

    public void destroy() {
        ScriptingEngineInterface scriptingEngineInterface = Globals.getScriptingEngine();
        if (scriptingEngineInterface != null) {
            scriptingEngineInterface.unregisterListeners(this);
        }
        super.destroy();
    }

    void resetDocStyle() {
        String string;
        Color color;
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        if (this.doc == null) {
            return;
        }
        if (this.ds.bg != null) {
            this.ds.bg.removeClient(this.parent);
            this.ds.bg = null;
        }
        if ((color = (Color)this.doc.getProperty("text.color")) != null) {
            this.ds.docStyle.color = color;
        }
        this.ds.background = (Color)this.doc.getProperty("background.color");
        if (this.ds.background == null) {
            this.ds.background = hJBProperties.getColor("hotjava.docbgcolor", Color.white);
        }
        if (this.ds.bg != null) {
            if (this.ds.started && this.parent != null) {
                this.ds.bg.removeClient(this.parent);
            }
            this.ds.bg = null;
        }
        if ((string = (String)this.doc.getProperty("background.img")) != null) {
            try {
                this.ds.bg = DocumentBackground.getDocumentBackground(new URL(this.doc.getBaseURL(), string), this.ds.background, this.doc);
                if (this.ds.started && this.parent != null) {
                    this.ds.bg.addClient(this.parent);
                }
            }
            catch (MalformedURLException malformedURLException) {}
        }
        this.ds.docStyle.left = this.ds.docStyle.right = this.marginWidth;
    }

    public void notify(Document document, int n, int n2, int n3) {
        int n4 = this.findAffected(n2);
        switch (n) {
            case 10: {
                int n5 = n2 & 0x7FFFF000;
                int n6 = 4096 - (n2 & 0xFFF);
                int n7 = n5 + 4096;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFFF000) == n5 && this.ds.selStart > n2) {
                        this.ds.selStart += n6;
                    } else if (this.ds.selStart > n7) {
                        this.ds.selStart += 4096;
                    }
                    if ((this.ds.selEnd & 0x7FFFF000) == n5 && this.ds.selEnd >= n2) {
                        this.ds.selEnd += n6;
                    } else if (this.ds.selEnd > n7) {
                        this.ds.selEnd += 4096;
                    }
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFFF000) == n5 && docLine.start > n2) {
                        docLine.start += n6;
                    } else if (docLine.start >= n7) {
                        docLine.start += 4096;
                    }
                    docLine.end = (docLine.end & 0x7FFFF000) == n5 && docLine.end >= n2 ? (docLine.end += n6) : (docLine.end += 4096);
                    docLine.tail = (docLine.tail & 0x7FFFF000) == n5 && docLine.tail >= n2 ? (docLine.tail += n6) : (docLine.tail += 4096);
                    ++n4;
                }
                if (n4 > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 12: {
                int n8 = n2 & 0x7FFFF000;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFFF000) == n8 && this.ds.selStart > n2) {
                        this.ds.selStart += n3;
                    }
                    if ((this.ds.selEnd & 0x7FFFF000) == n8 && this.ds.selEnd >= n2) {
                        this.ds.selEnd += n3;
                    }
                }
                int n9 = n8 + 4096;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start > n9) break;
                    docLine.updated = true;
                    if ((docLine.start & 0x7FFFF000) == n8 && docLine.start > n2) {
                        docLine.start += n3;
                    }
                    if ((docLine.end & 0x7FFFF000) == n8 && docLine.end >= n2) {
                        docLine.end += n3;
                    }
                    if ((docLine.tail & 0x7FFFF000) == n8 && docLine.tail >= n2) {
                        docLine.tail += n3;
                    }
                    ++n4;
                }
                if (n4 > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[--n4].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 13: {
                this.notifyResponsiblesInRange(document, n, n2, n3);
                int n10 = n2 & 0x7FFFF000;
                if (this.hasSelection(this.ds)) {
                    if ((this.ds.selStart & 0x7FFFF000) == n10 && this.ds.selStart > n2) {
                        this.ds.selStart -= n3;
                    }
                    if ((this.ds.selEnd & 0x7FFFF000) == n10 && this.ds.selEnd > n2) {
                        this.ds.selEnd -= n3;
                    }
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start <= n2) {
                        this.invalidateFloatersInRange(docLine.start, docLine.end);
                        docLine.updated = true;
                    }
                    if ((docLine.start & 0x7FFFF000) == n10 && docLine.start > n2) {
                        docLine.start -= n3;
                    }
                    if ((docLine.end & 0x7FFFF000) == n10 && docLine.end > n2) {
                        docLine.end -= n3;
                    }
                    if ((docLine.tail & 0x7FFFF000) == n10 && docLine.tail > n2) {
                        docLine.tail -= n3;
                    }
                    ++n4;
                }
                return;
            }
            case 15: {
                if (this.hasSelection(this.ds)) {
                    this.adjustSelectionBy(n2, n3);
                }
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start != docLine.end) {
                        if (docLine.start > n2) break;
                        if (docLine.end >= n2) {
                            docLine.end += n3;
                        }
                        docLine.tail += n3;
                        docLine.updated = true;
                    }
                    ++n4;
                }
                this.adjustSubsequentLinesBy(n4, n3);
                if (this.nlines > 0) {
                    this.invalidateFloatersInRange(n2, this.lines[this.nlines - 1].end);
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                return;
            }
            case 16: {
                DocLine docLine;
                int n11 = n2 + n3;
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.removeFloatersInRange(n2, n11);
                if (this.hasSelection(this.ds)) {
                    this.adjustSelectionBy(n2, -n3);
                }
                if (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.start < n2) {
                        if (docLine.end > n2) {
                            docLine.end = n2;
                        }
                        docLine.tail = n2;
                        docLine.updated = true;
                        ++n4;
                    }
                }
                while (n4 < this.nlines) {
                    docLine = this.lines[n4];
                    if (docLine.tail > n11) {
                        if (docLine.start >= n11) break;
                        docLine.start = n2;
                        docLine.end = docLine.end <= n11 ? n2 : (docLine.end -= n3);
                        docLine.tail -= n3;
                        docLine.updated = true;
                        ++n4;
                        break;
                    }
                    docLine.end = docLine.tail = n2;
                    docLine.start = docLine.tail;
                    docLine.updated = true;
                    ++n4;
                }
                this.adjustSubsequentLinesBy(n4, -n3);
                return;
            }
            case 18: 
            case 19: {
                Object object = this.SYNC_PAINTS;
                synchronized (object) {
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        try {
                            try {
                                this.paintRangeNoFloaters(graphics, n2, n2 + n3, n == 18);
                            }
                            catch (Exception exception) {
                            }
                            Object var10_34 = null;
                            graphics.dispose();
                        }
                        catch (Throwable throwable) {
                            Object var10_35 = null;
                            graphics.dispose();
                            throw throwable;
                        }
                    }
                    Object var7_19 = null;
                    return;
                }
            }
            case 17: {
                int n12 = n2 + n3;
                int n13 = n4;
                boolean bl = false;
                while (n4 < this.nlines) {
                    DocLine docLine = this.lines[n4];
                    if (docLine.start >= n12) break;
                    docLine.updated = true;
                    bl = true;
                    ++n4;
                }
                while (n4 < this.nlines) {
                    if (this.lines[n4].y == this.lines[n13].y) {
                        this.lines[n4].updated = true;
                        n12 = this.lines[n4].end;
                        bl = true;
                    } else if (this.lines[n4].y > this.lines[n13].y) break;
                    ++n4;
                }
                this.notifyResponsiblesInRange(document, n, n2, n3);
                this.dirtyFloaterLines(new FormatState(), n2, n12);
                this.touch(bl, 200);
                return;
            }
            case 22: {
                this.processActivationQueue();
                return;
            }
            case 20: {
                this.activateItem(n2);
                return;
            }
            case 21: {
                this.notifyResponsiblesInRange(document, n, n2, n3);
                DocItem docItem = document.items[n2 >> 12];
                n4 = 0;
                while (n4 < this.nItemComponents) {
                    Component component = this.itemComponents[n4].getComponent();
                    int n14 = this.itemComponents[n4].getIndex();
                    DocItem docItem2 = document.items[n14];
                    if (docItem2 == docItem) {
                        ((DocPanel)((Object)component)).stop();
                        ((DocPanel)((Object)component)).destroy();
                        if (this.parent != null) {
                            this.parent.remove(component);
                        }
                        System.arraycopy(this.itemComponents, n4 + 1, this.itemComponents, n4, this.nItemComponents - n4 - 1);
                        this.itemComponents[this.nItemComponents - 1] = null;
                        --this.nItemComponents;
                        --n4;
                    }
                    ++n4;
                }
                if (this.itemsNeedingDeactivation == null) break;
                int n15 = 0;
                while (n15 < this.itemsNeedingDeactivation.size()) {
                    DocItem docItem3 = (DocItem)this.itemsNeedingDeactivation.elementAt(n15);
                    docItem3.deactivate(this);
                    ++n15;
                }
                return;
            }
            case 24: {
                ScriptingEngineInterface scriptingEngineInterface = Globals.getScriptingEngine();
                if (scriptingEngineInterface != null) {
                    scriptingEngineInterface.unregisterListeners(this);
                    this.setScriptContext(null);
                }
                int n16 = 0;
                while (n16 < this.itemComponents.length) {
                    if (this.itemComponents[n16] != null && this.itemComponents[n16].getComponent() instanceof TagAppletPanel) {
                        ((TagAppletPanel)this.itemComponents[n16].getComponent()).destroy();
                        System.out.println("Destroying applet " + n16);
                    }
                    ++n16;
                }
                return;
            }
        }
    }

    private void adjustSelectionBy(int n, int n2) {
        if (this.ds.selStart > n) {
            this.ds.selStart += n2;
        }
        if (this.ds.selEnd >= n) {
            this.ds.selEnd += n2;
        }
    }

    private void adjustSubsequentLinesBy(int n, int n2) {
        int n3 = n;
        while (n3 < this.nlines) {
            DocLine docLine = this.lines[n3];
            if (docLine.start != docLine.end) {
                docLine.start += n2;
                docLine.end += n2;
                docLine.tail += n2;
            }
            ++n3;
        }
    }

    public void activateSubItems() {
    }

    synchronized boolean paint(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = false;
        int n5 = n2;
        int n6 = n5 + n4;
        DocStyle docStyle = null;
        Object object = this.SYNC_PAINTS;
        synchronized (object) {
            int n7 = this.findY(n2);
            while (n7 < this.nlines) {
                DocLine docLine = this.lines[n7];
                if (docLine.y >= n6) break;
                n5 = docLine.y;
                if (bl) {
                    this.paintBack(graphics, n, n5, n3, docLine.height);
                }
                if (!docLine.updated) {
                    docStyle = this.paintLine(graphics, docLine, n5, n, n3, docStyle, bl2);
                } else {
                    bl3 = true;
                    docStyle = null;
                }
                n5 += docLine.height;
                ++n7;
            }
            if (bl && n5 < n6) {
                this.paintBack(graphics, n, n5, n3, n6 - n5);
            }
            this.paintFloaters(graphics, n, n2, n3, n4);
        }
        if (this.bFormatDone) {
            return bl3;
        }
        return false;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (this.ds.started) {
            ScreenUpdater.updater.notify((UpdateClient)this, 200L, (Object)REPAINT);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    void copyLines(Graphics var1_1, int var2_2, int var3_3, int var4_4) {
        if (this.lines != null && this.lines.length >= var3_3) ** GOTO lbl24
        return;
        {
            var4_4 += this.lines[var2_2].height;
            ++var2_2;
            do {
                if (var2_2 < var3_3 && this.lines[var2_2].updated) continue block0;
                if (var2_2 >= var3_3) continue;
                var5_5 = this.lines[var2_2];
                var6_6 = var5_5.y;
                var7_7 = var5_5.height;
                var8_8 = var2_2 + 1;
                while (var8_8 < var3_3 && !this.lines[var8_8].updated) {
                    var7_7 += this.lines[var8_8++].height;
                }
                if (var6_6 > var4_4) {
                    var1_1.copyArea(0, var6_6, this.width, var7_7, 0, var4_4 - var6_6);
                } else if (var6_6 < var4_4) {
                    this.copyLines(var1_1, var8_8, var3_3, var4_4 + var7_7);
                    var1_1.copyArea(0, var6_6, this.width, var7_7, 0, var4_4 - var6_6);
                    return;
                }
                var2_2 = var8_8;
                var4_4 += var7_7;
lbl24:
                // 3 sources

            } while (var2_2 < var3_3);
        }
    }

    void notifyDocSize() {
        if (this.ds.started) {
            this.dispatchDocumentEvent(1003, this);
        }
    }

    public void forceFormatScreen() {
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)FORMAT_SCREEN);
    }

    /*
     * Unable to fully structure code
     */
    void formatScreen() {
        var1_1 = null;
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = 0;
        var12_12 = false;
        var13_13 = this.docWidth;
        var14_14 = this.docHeight;
        var15_15 = var4_4;
        if (this.getVScrollBarWidth() == 0) {
            var16_16 = Math.max(this.scroller.getVScrollbarWidth(), 15);
            this.setVScrollBarWidth(var16_16);
            this.width -= var16_16;
        }
        var16_17 = (Vector)(this.floaters != null ? this.floaters.clone() : null);
        do {
            block43: {
                block44: {
                    this.setCompleted(false);
                    this.docHeight = var14_14;
                    this.docWidth = var13_13;
                    var4_4 = var15_15;
                    var1_1 = this.lines;
                    var2_2 = this.nlines;
                    var3_3 = this.doc.nitems << 12;
                    var4_4 = this.getDocumentY();
                    var5_5 = this.height + var4_4;
                    this.floaters = (Vector)(var16_17 != null ? var16_17.clone() : null);
                    var6_6 = 0;
                    var7_7 = 0;
                    var8_8 = 0;
                    if (this.fs == null) {
                        this.fs = new FormatState();
                    }
                    if (this.bs == null) {
                        this.bs = new FormatState();
                    }
                    this.fs.pos = -1;
                    if (var2_2 <= 0) break block43;
                    if (var4_4 > 0) {
                        var17_18 = this.getFloatersStartY(var4_4);
                        var7_7 = this.findY(var17_18);
                        var8_8 = this.doc.startPos(var1_1[var7_7].start);
                        while (var7_7 > 0 && var8_8 < var1_1[var7_7].start) {
                            --var7_7;
                        }
                    }
                    if (var8_8 <= var1_1[var7_7].start) ** GOTO lbl52
                    var1_1[var7_7].updated = true;
                    break block44;
lbl-1000:
                    // 1 sources

                    {
                        ++var7_7;
lbl52:
                        // 2 sources

                        ** while (var7_7 < var2_2 && !var1_1[var7_7].updated)
                    }
                }
                if (var7_7 > 0) {
                    var17_19 = var1_1[var7_7 - 1];
                    var6_6 = var17_19.y + var17_19.height;
                    var8_8 = var17_19.end;
                }
                if (var6_6 >= var5_5 || var8_8 > var3_3) {
                    ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
                    return;
                }
            }
            var10_10 = var6_6;
            var9_9 = var7_7;
            var11_11 = var7_7;
            while (var6_6 < var5_5 && var8_8 < var3_3) {
                var17_20 = this.formatLine(var6_6, var8_8, this.fs, this.bs);
                if (var17_20 == null) break;
                var17_20.updated = true;
                var8_8 = var17_20.end;
                var17_20.y = var6_6;
                var18_23 = var17_20.height;
                var6_6 += var18_23;
                while (var11_11 < var2_2 && var1_1[var11_11].end <= var8_8) {
                    var18_23 -= var1_1[var11_11].height;
                    ++var11_11;
                }
                this.docHeight += var18_23;
                if (var4_4 > this.docHeight) {
                    var4_4 = this.docHeight;
                }
                if ((var19_25 = var17_20.margin >> 16) < 0) {
                    var20_26 = this.getStyleAt(var17_20.start);
                    var19_25 = this.getMargin((DocStyle)var20_26, var17_20.start, var17_20.y) >> 16;
                }
                if (this.docWidth < var19_25 + var17_20.width) {
                    this.docWidth = var19_25 + var17_20.width;
                }
                if (var11_11 == var7_7) {
                    var20_27 = 10;
                    if (var2_2 + var20_27 > var1_1.length) {
                        var21_30 = Math.max(var2_2 + var20_27, 3 * (var1_1.length + 1) / 2);
                        var22_32 = new DocLine[var21_30];
                        System.arraycopy(var1_1, 0, var22_32, 0, var2_2);
                        var1_1 = var22_32;
                    }
                    System.arraycopy(var1_1, var11_11, var1_1, var11_11 + var20_27, var2_2 - var11_11);
                    var11_11 += var20_27;
                    var2_2 += var20_27;
                }
                var1_1[var7_7++] = var17_20;
                if (var11_11 >= var2_2 || var6_6 >= var5_5 || var1_1[var11_11].updated || var1_1[var11_11].start != var8_8 || var1_1[var11_11].margin != this.fs.margin) continue;
                do {
                    var17_20 = var1_1[var11_11++];
                    v0 = var17_20.updated = this.ds.bg != null && var17_20.y != var6_6;
                    if (var17_20.updated) {
                        this.invalidateFloatersInRange(var17_20.start, var17_20.end);
                    }
                    var1_1[var7_7++] = var17_20;
                } while (var11_11 < var2_2 && (var6_6 += var17_20.height) < var5_5 && !var1_1[var11_11].updated);
                var8_8 = var1_1[var11_11 - 1].end;
            }
            var12_12 = true;
            if (this.hasFrameSetPanel()) continue;
            var17_21 = var10_10;
            var18_23 = var9_9;
            var19_25 = -1;
            while (var18_23 < var2_2 && var17_21 < var5_5) {
                if (var1_1[var18_23] != null) {
                    var17_21 += var1_1[var18_23].height;
                    var19_25 = var18_23;
                }
                ++var18_23;
            }
            if (var18_23 >= var2_2 && var19_25 >= 0) {
                var20_26 = var1_1[var19_25];
                var21_30 = this.getCumulativeFloaterHeight(var20_26.y);
                var22_33 = var20_26.y + var21_30;
                if (var22_33 > var17_21) {
                    var17_21 = var22_33;
                }
            }
            if (var17_21 >= var5_5 || this.scroller == null) continue;
            var20_28 = Math.max(this.scroller.getVScrollbarWidth(), 15);
            if (this.getVScrollBarWidth() != var20_28) continue;
            this.width += var20_28;
            this.setVScrollBarWidth(0);
            var12_12 = false;
        } while (!var12_12);
        var17_22 = true;
        if (this.parent != null && this.ds.background != null && !this.ds.background.equals(this.parent.getBackground())) {
            this.parent.setBackground(this.ds.background);
            var17_22 = this.ds.started == false;
        }
        var18_24 = this.SYNC_PAINTS;
        synchronized (var18_24) {
            var20_29 = this.getGraphics();
            if (var20_29 != null) {
                try {
                    if (var9_9 < var7_7) {
                        var6_6 = var10_10;
                        this.copyLines(var20_29, var9_9, var7_7, var6_6);
                        var23_34 = null;
                        try {
                            this.ds.paintingScreen = true;
                            while (var9_9 < var7_7) {
                                var26_35 = var1_1[var9_9++];
                                var26_35.y = var6_6;
                                if (var26_35.updated) {
                                    var26_35.updated = false;
                                    this.paintBack(var20_29, 0, var6_6, this.width, var26_35.height);
                                    var23_34 = this.paintLine(var20_29, var26_35, var6_6, 0, this.width, var23_34, false);
                                } else {
                                    var23_34 = null;
                                }
                                var6_6 += var26_35.height;
                            }
                        }
                        finally {
                            var25_36 = null;
                            this.ds.paintingScreen = false;
                        }
                    }
                    if (var6_6 < var5_5) {
                        this.paintBack(var20_29, 0, var6_6, this.width, this.height - var6_6);
                    }
                    this.paintFloaters(var20_29, 0, var10_10, this.width, this.height - (var10_10 - var4_4));
                }
                finally {
                    var22_32 = null;
                    var20_29.dispose();
                }
            }
        }
        if (var11_11 < var2_2 && var1_1[var11_11].y != var6_6) {
            this.updateFloatersYInRange(var8_8, var3_3, var6_6 - var1_1[var11_11].y);
            do {
                var18_24 = var1_1[var11_11++];
                var18_24.y = var6_6;
                var6_6 += var18_24.height;
                var1_1[var7_7++] = var18_24;
            } while (var11_11 < var2_2);
        } else {
            System.arraycopy(var1_1, var11_11, var1_1, var7_7, var2_2 - var11_11);
        }
        this.lines = var1_1;
        this.nlines = var2_2 += var7_7 - var11_11;
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
    }

    public void scrollWhenDone(Point point) {
        this.scrollWhenDone(point.x, point.y);
    }

    public void scrollWhenDone(int n, int n2) {
        this.xToScroll = n;
        this.yToScroll = n2;
        this.needScrollOnFinish = true;
    }

    /*
     * Unable to fully structure code
     */
    void formatDocument() {
        block28: {
            this.setCompleted(false);
            var1_1 = this.lines;
            var2_2 = this.nlines;
            var3_3 = System.currentTimeMillis() + 200L;
            if (this.newY == 0) {
                this.newY = this.getDocumentY();
            }
            var5_4 = 0;
            while (var5_4 < var2_2 && !var1_1[var5_4].updated) {
                ++var5_4;
            }
            var6_5 = this.doc.nitems << 12;
            var7_6 = var5_4 > 0 ? var1_1[var5_4 - 1].end : 0;
            var8_7 = var5_4 > 0 ? var1_1[var5_4 - 1].y + var1_1[var5_4 - 1].height : 0;
            var9_8 = var5_4;
            var10_9 = false;
            if (this.fs == null) {
                this.fs = new FormatState();
                this.fs.pos = -1;
            }
            if (this.bs == null) {
                this.bs = new FormatState();
            }
            while (var7_6 < var6_5) {
                var11_10 = this.formatLine(var8_7, var7_6, this.fs, this.bs);
                if (var11_10 == null) break;
                if (var8_7 + var11_10.height > this.newY && var8_7 < this.height) {
                    this.touch();
                    break;
                }
                var11_10.y = var8_7;
                var7_6 = var11_10.end;
                var8_7 += var11_10.height;
                var12_15 = var11_10.height;
                while (var9_8 < var2_2 && var1_1[var9_8].end <= var7_6) {
                    var12_15 -= var1_1[var9_8].height;
                    ++var9_8;
                }
                if (var8_7 < this.newY) {
                    this.newY += var12_15;
                }
                this.docHeight += var12_15;
                if (this.newY > this.docHeight) {
                    this.newY = this.docHeight;
                } else if (this.newY < 0) {
                    this.newY = 0;
                }
                var13_19 = var11_10.margin >> 16;
                if (var13_19 < 0) {
                    var14_21 = this.getStyleAt(var11_10.start);
                    var13_19 = this.getMargin(var14_21, var11_10.start, var11_10.y) >> 16;
                }
                if (this.docWidth < var13_19 + var11_10.width) {
                    this.docWidth = var13_19 + var11_10.width;
                }
                if (var9_8 == var5_4) {
                    var14_22 = 10;
                    if (var2_2 + var14_22 > var1_1.length) {
                        var15_24 = new DocLine[var1_1.length * 2];
                        System.arraycopy(var1_1, 0, var15_24, 0, var2_2);
                        var1_1 = var15_24;
                    }
                    System.arraycopy(var1_1, var9_8, var1_1, var9_8 + var14_22, var2_2 - var9_8);
                    var9_8 += var14_22;
                    var2_2 += var14_22;
                }
                var1_1[var5_4++] = var11_10;
                if (var9_8 < var2_2 && !var1_1[var9_8].updated && var1_1[var9_8].start == var7_6 && var1_1[var9_8].margin == this.fs.margin) {
                    do {
                        var11_10 = var1_1[var9_8++];
                        this.updateFloatersYInRange(var11_10.start, var11_10.end, var8_7 - var11_10.y);
                        var11_10.y = var8_7;
                        var8_7 += var11_10.height;
                        var1_1[var5_4++] = var11_10;
                    } while (var9_8 < var2_2 && !var1_1[var9_8].updated);
                    var7_6 = var1_1[var9_8 - 1].end;
                }
                if (System.currentTimeMillis() < var3_3) continue;
                ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)DocumentFormatter.FORMAT_DOCUMENT);
                var10_9 = true;
                break;
            }
            this.docHeight = this.adjustDocHeightForFloaters(this.docHeight);
            if (var9_8 < var2_2 && var1_1[var9_8].y != var8_7) {
                this.updateFloatersYInRange(var7_6, var6_5, var8_7 - var1_1[var9_8].y);
                do {
                    var11_10 = var1_1[var9_8++];
                    var11_10.y = var8_7;
                    var8_7 += var11_10.height;
                    var1_1[var5_4++] = var11_10;
                } while (var9_8 < var2_2);
            } else {
                System.arraycopy(var1_1, var9_8, var1_1, var5_4, var2_2 - var9_8);
            }
            var2_2 += var5_4 - var9_8;
            if (var10_9) break block28;
            var11_11 = 0;
            var8_7 = 0;
            var13_19 = 0;
            while (var13_19 < var2_2 && var11_11 < this.nItemComponents) {
                block29: {
                    var14_23 = this.itemComponents[var11_11].getIndex();
                    var12_17 = var1_1[var13_19];
                    if (var14_23 <= var12_17.end >> 12) ** GOTO lbl99
                    break block29;
lbl-1000:
                    // 1 sources

                    {
                        var15_24 = this.itemComponents[var11_11].getComponent();
                        var16_25 = var15_24.getBounds();
                        if (!(var16_25.y + var16_25.height >= var12_17.y && var12_17.y + var12_17.height > var16_25.y || var8_7 + var12_17.height > this.newY && var8_7 < this.height)) {
                            var15_24.setLocation(var16_25.x, var12_17.y);
                        }
                        if (++var11_11 >= this.nItemComponents) break;
                        var14_23 = this.itemComponents[var11_11].getIndex();
lbl99:
                        // 2 sources

                        ** while (var14_23 >= var12_17.start >> 12 && var14_23 < var12_17.end >> 12)
                    }
                }
                var8_7 += var12_17.height;
                ++var13_19;
            }
        }
        this.nlines = var2_2;
        this.lines = var1_1;
        if (!var10_9) {
            if (this.parent != null && this.ds.background != null && !this.ds.background.equals(this.parent.getBackground())) {
                this.parent.setBackground(this.ds.background);
            }
            this.notifyDocSize();
            this.adjustScrollpaneOrigin();
            if (this.needScrollOnFinish) {
                this.scroller.setScrollPosition(this.xToScroll, this.yToScroll);
                this.docX = this.xToScroll;
                this.docY = this.yToScroll;
                this.needScrollOnFinish = false;
                this.label = null;
            }
            this.setCompleted(true);
        }
        if (this.label != null && (var11_13 = this.doc.findLabel(this.label)) != -1 && var11_13 <= var7_6) {
            var12_18 = this.findYFor(var11_13);
            this.scrollTo(this.docX, var12_18);
            var13_20 = this.scroller.getScrollPosition();
            if (var13_20.y >= var12_18) {
                this.label = null;
            }
        }
        var11_14 = new FinishFormatRequest(this);
        Globals.getInternalEventsQueue().postRequest(var11_14);
        this.bFormatDone = true;
        this.bs = null;
        this.fs = null;
    }

    private void adjustScrollpaneOrigin() {
        int n = this.getDocumentY();
        int n2 = this.docX;
        this.docX = -this.getXOriginDelta();
        if (this.newY != n || this.docX != n2) {
            Graphics graphics;
            if ((n > this.newY && n < this.newY + this.height || n < this.newY && n + this.height > this.newY) && (graphics = this.getGraphics()) != null) {
                int n3 = 0;
                int n4 = 0;
                if (n < this.newY) {
                    n4 = n + this.height - this.newY;
                    n3 = n;
                    graphics.copyArea(this.docX, n3, this.width, n4, 0, this.newY - n);
                } else {
                    n4 = this.newY + this.height - n;
                    n3 = n + this.height - n4;
                    graphics.copyArea(this.docX, n3, this.width, n4, 0, n - n3);
                }
                graphics.dispose();
            }
            this.scrollTo(this.docX, this.newY);
        }
        this.newY = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateClient(Object object) {
        System.currentTimeMillis();
        if (!this.ds.started) return;
        Object object2 = Globals.getAwtLock();
        synchronized (object2) {
            Document document = this.getTopDocument();
            synchronized (document) {
                Document document2 = this.doc;
                synchronized (document2) {
                    if (object != null) {
                        if (object.equals(REPAINT)) {
                            Graphics graphics = this.getGraphics();
                            if (graphics == null) return;
                            int n = this.parent.getSize().width;
                            if (this.paint(graphics, 0, 0, n, this.height, true, false)) {
                                this.touch();
                            }
                            graphics.dispose();
                            return;
                        }
                        if (object.equals(FORMAT_SCREEN)) {
                            this.repair = false;
                            this.formatScreen();
                        } else {
                            if (!object.equals(FORMAT_DOCUMENT)) return;
                            this.formatDocument();
                        }
                    } else if (this.repair) {
                        this.repair = false;
                        this.formatScreen();
                    } else {
                        this.formatDocument();
                    }
                }
            }
            return;
        }
    }

    private Document getTopDocument() {
        if (this.parent == null) {
            return this.doc;
        }
        Container container = this.parent;
        while (!(container instanceof HotJavaBrowserBean)) {
            if ((container = container.getParent()) != null) continue;
            return this.doc;
        }
        HotJavaBrowserBean hotJavaBrowserBean = (HotJavaBrowserBean)container;
        Document document = hotJavaBrowserBean.getDocument();
        if (document != null) {
            return document;
        }
        return this.doc;
    }

    public int updatePriority() {
        if (this.repair) {
            return 5;
        }
        return 4;
    }

    public void touch(boolean bl, int n, DocItem docItem) {
        if (!this.doc.isOkToFormat() || !this.bFormatDone) {
            return;
        }
        int n2 = this.findPos(docItem.getIndex() << 12);
        if (n2 < this.nlines) {
            this.lines[n2].updated = true;
        }
        this.touch(bl, n);
    }

    public void touch(boolean bl, int n) {
        if (this.getParent() == null) {
            return;
        }
        if (!this.doc.isOkToFormat() || !this.bFormatDone) {
            return;
        }
        this.repair = bl | this.repair;
        if (this.ds.started) {
            ScreenUpdater.updater.notify((UpdateClient)this, (long)n);
        }
    }

    protected boolean handleMouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.parent) {
            this.dispatchDocumentEvent(1039, this.defaultStatusMessage);
        }
        return super.handleMouseEntered(mouseEvent);
    }

    protected boolean handleMouseUp(MouseEvent mouseEvent) {
        Object object = this.dragLock;
        synchronized (object) {
            if (this.dragThread != null) {
                this.dragThread.stop();
                this.dragThread = null;
            }
        }
        return super.handleMouseUp(mouseEvent);
    }

    protected boolean handleMouseDrag(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (super.handleMouseDrag(mouseEvent)) {
            int n = point.x;
            int n2 = point.y;
            Point point2 = this.scroller.getScrollPosition();
            Dimension dimension = this.scroller.getViewportSize();
            int n3 = point2.x + dimension.width;
            int n4 = point2.y + dimension.height;
            int n5 = this.scroller.getVAdjustable().getUnitIncrement();
            int n6 = this.scroller.getHAdjustable().getUnitIncrement();
            if (n > n3) {
                this.scrollBy(n6, 0);
                this.notifyDragThread(n6, 0, mouseEvent);
            } else if (n < point2.x) {
                this.scrollBy(-n6, 0);
                this.notifyDragThread(-n6, 0, mouseEvent);
            }
            if (n2 > n4) {
                this.scrollBy(0, n5);
                this.notifyDragThread(0, n5, mouseEvent);
            } else if (n2 < point2.y) {
                this.scrollBy(0, -n5);
                this.notifyDragThread(0, -n5, mouseEvent);
            }
        }
        return true;
    }

    private void notifyDragThread(int n, int n2, MouseEvent mouseEvent) {
        Object object = this.dragLock;
        synchronized (object) {
            if (this.dragThread == null) {
                this.dragThread = new DragThread(n, n2, this.dragDelay, this, mouseEvent);
                this.dragThread.start();
            } else {
                this.dragThread.notifyDragThread(n, n2);
            }
            return;
        }
    }

    public void reformat() {
        if (!this.doc.isOkToFormat() || this.printing) {
            return;
        }
        super.reformat();
        ScreenUpdater.updater.notify((UpdateClient)this, 0L, (Object)FORMAT_SCREEN);
    }

    public void layout() {
        if (!this.doc.isOkToFormat()) {
            return;
        }
        this.docWidth = 0;
        this.reformat();
    }

    public void scrollTo(Point point) {
        this.scrollTo(point.x, point.y);
    }

    public void scrollTo(int n, int n2) {
        int n3 = this.scroller.getViewportSize().height;
        if (this.docHeight > n3 && n2 > this.docHeight - n3) {
            n2 = this.docHeight - n3;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        try {
            this.scroller.getHAdjustable().setValue(n);
            this.scroller.getVAdjustable().setValue(n2);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public void scrollBy(int n, int n2) {
        if (n == 0 && n2 == 0) {
            return;
        }
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                this.notifyDocSize();
                Point point = this.scroller.getScrollPosition();
                this.scrollTo(point.x + n, point.y + n2);
            }
            return;
        }
    }

    public void top() {
        this.scrollTo(0, 0);
    }

    public void paint(Graphics graphics, boolean bl) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                if (this.ds.started) {
                    boolean bl2 = !bl;
                    Rectangle rectangle = graphics.getClipRect();
                    if (rectangle == null) {
                        if (this.paint(graphics, 0, 0, this.width, this.height, true, bl2)) {
                            this.touch();
                        }
                    } else if (this.paint(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true, bl2)) {
                        this.touch();
                    }
                }
            }
            return;
        }
    }

    public void select(int n, int n2) {
        this.ds.selecter = this;
        this.doSelect(n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSelect(int n, int n2) {
        Object object = Globals.getAwtLock();
        synchronized (object) {
            Document document = this.doc;
            synchronized (document) {
                int n3;
                if (n > n2) {
                    n3 = n2;
                    n2 = n;
                    n = n3;
                }
                if (n == this.ds.selStart && n2 == this.ds.selEnd) {
                    return;
                }
                if (n == n2 && n == 0 && !this.hasSelection(this.ds)) {
                    return;
                }
                n3 = this.ds.selStart;
                int n4 = this.ds.selEnd;
                this.ds.selStart = n;
                this.ds.selEnd = n2;
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    if (this.ds.selStart > n4 || this.ds.selEnd < n3) {
                        this.paintRange(graphics, n3, n4, true);
                        this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    } else {
                        int n5;
                        int n6 = Math.min(this.ds.selStart, n3);
                        if (n6 < (n5 = Math.max(this.ds.selStart, n3))) {
                            this.paintRange(graphics, n6, n5, true);
                        }
                        if ((n6 = Math.min(this.ds.selEnd, n4)) < (n5 = Math.max(this.ds.selEnd, n4))) {
                            this.paintRange(graphics, n6, n5, true);
                        }
                    }
                    graphics.dispose();
                }
            }
        }
        this.dispatchDocumentEvent(1007, this.doc);
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.lostOwnership();
    }

    public void lostOwnership() {
        this.select(-1, -1);
    }

    public void selectAll() {
        this.select(0, this.doc.length());
    }

    public synchronized void scrollTo(int n) {
        int n2 = this.findYFor(n);
        this.scrollTo(0, n2);
    }

    public void showCursor(boolean bl) {
        Document document = this.doc;
        synchronized (document) {
            if (this.ds.showcur != bl) {
                Graphics graphics;
                this.ds.showcur = bl;
                if (this.ds.selStart == this.ds.selEnd && (graphics = this.getGraphics()) != null) {
                    this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    graphics.dispose();
                }
            }
            return;
        }
    }

    public void showSelection(boolean bl) {
        Document document = this.doc;
        synchronized (document) {
            if (this.ds.showsel != bl) {
                Graphics graphics;
                this.ds.showsel = bl;
                if (this.ds.selStart < this.ds.selEnd && (graphics = this.getGraphics()) != null) {
                    this.paintRange(graphics, this.ds.selStart, this.ds.selEnd, true);
                    graphics.dispose();
                }
            }
            return;
        }
    }

    public int getSelectEnd() {
        return this.ds.selEnd;
    }

    public void processDocumentEvent(DocumentEvent documentEvent) {
        switch (documentEvent.getID()) {
            case 1043: {
                this.resetDocStyle();
                return;
            }
            case 1004: {
                if (documentEvent.getSource() != this.doc) break;
                String string = (String)documentEvent.getArgument();
                if (string.equals("background.img") || string.equals("text.color") || string.equals("background.color") || string.equals("margin.left") || string.equals("margin.right")) {
                    this.resetDocStyle();
                    return;
                }
                if (!"url".equals(string)) break;
                if (this.getDocument().getURL().equals(this.scriptContextCodebase)) {
                    return;
                }
                ScriptingEngineInterface scriptingEngineInterface = Globals.getScriptingEngine();
                if (scriptingEngineInterface == null || this.getScriptContext() == null) break;
                scriptingEngineInterface.unregisterListeners(this);
                try {
                    this.setScriptContext(scriptingEngineInterface.getContext(this));
                    return;
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                    return;
                }
            }
            case 1005: {
                if (this.doc.getState() != 12) break;
                this.docWidth = 0;
                return;
            }
            case 1009: 
            case 1012: {
                Object object = Globals.getAwtLock();
                synchronized (object) {
                    Document document = this.doc;
                    synchronized (document) {
                        int n = 0;
                        while (n < this.nItemComponents) {
                            Component component = this.itemComponents[n].getComponent();
                            ((DocPanel)((Object)component)).interruptLoading();
                            ++n;
                        }
                        if (this.itemsNeedingDeactivation != null) {
                            int n2 = 0;
                            while (n2 < this.itemsNeedingDeactivation.size()) {
                                DocItem docItem = (DocItem)this.itemsNeedingDeactivation.elementAt(n2);
                                docItem.deactivate(this);
                                ++n2;
                            }
                        }
                    }
                    return;
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 12: {
                int n = 0;
                while (n < this.nlines) {
                    ++n;
                }
                this.doc.print();
                return;
            }
        }
    }

    public String getSelectedText() {
        int n;
        int n2;
        if (!this.hasSelection(this.ds)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        UpdateClient updateClient = this;
        synchronized (updateClient) {
            n2 = this.ds.selStart;
            n = this.ds.selEnd;
        }
        updateClient = this.doc;
        synchronized (updateClient) {
            DocItemEnumeration docItemEnumeration = this.doc.getDocItems(n2, n);
            while (docItemEnumeration.hasMoreElements()) {
                String string;
                DocItem docItem;
                DocItem docItem2 = (DocItem)docItemEnumeration.nextElement();
                if (docItem2.isText()) {
                    docItem = (TextItem)docItem2;
                    stringBuffer.append(((TextItem)docItem).getText(n2, n));
                    continue;
                }
                if (docItem2.isBlock()) {
                    stringBuffer.append("\n");
                    continue;
                }
                if (!docItem2.isEnd() || (string = (docItem = ((EndTagItem)docItem2).getTag(this.doc)).getText()) == null) continue;
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getSelectedSource() {
        int n;
        int n2;
        if (!this.hasSelection(this.ds)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        UpdateClient updateClient = this;
        synchronized (updateClient) {
            n2 = this.ds.selStart;
            n = this.ds.selEnd;
        }
        updateClient = this.doc;
        synchronized (updateClient) {
            DocItemEnumeration docItemEnumeration = this.doc.getDocItems(n2, n);
            while (docItemEnumeration.hasMoreElements()) {
                Object object;
                DocItem docItem = (DocItem)docItemEnumeration.nextElement();
                if (docItem.isText()) {
                    object = (TextItem)docItem;
                    stringBuffer.append(((TextItem)object).getText(n2, n));
                    continue;
                }
                if (!docItem.isStart() && !docItem.isEnd() || (object = docItem.toString()) == null) continue;
                stringBuffer.append((String)object);
            }
        }
        return stringBuffer.toString();
    }

    public void print(PrintJob printJob, HotJavaBrowserBean hotJavaBrowserBean) throws DocBusyException {
        Graphics graphics;
        int n = this.doc.setOwner(14, Thread.currentThread());
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        this.ds.docStyle.left = 0;
        this.ds.docStyle.right = 0;
        this.ds.background = Color.white;
        this.ds.docStyle.nonScreenGraphics = graphics = printJob.getGraphics();
        String string = hJBProperties.getProperty("hotjava.pageMarkerClass");
        if (string == null) {
            string = "sunw.hotjava.doc.StdPageMarker";
        }
        PageMarker pageMarker = null;
        try {
            Object obj = Class.forName(string).newInstance();
            if (obj instanceof PageMarker) {
                pageMarker = (PageMarker)obj;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to instantiate: " + string);
            exception.printStackTrace(System.err);
        }
        try {
            Dimension dimension = printJob.getPageDimension();
            PageMargins pageMargins = new PageMargins();
            int n2 = printJob.getPageResolution();
            pageMargins.setTopMargin(hJBProperties.getInteger("hotjava.print.margin.top", 72) * n2 / 72);
            pageMargins.setBottomMargin(hJBProperties.getInteger("hotjava.print.margin.bottom", 72) * n2 / 72);
            pageMargins.setLeftMargin(hJBProperties.getInteger("hotjava.print.margin.left", 72) * n2 / 72);
            pageMargins.setRightMargin(hJBProperties.getInteger("hotjava.print.margin.right", 72) * n2 / 72);
            if (pageMarker != null) {
                pageMarker.adjustMargins(pageMargins);
            }
            String string2 = hJBProperties.getProperty("printjob.format.msg");
            hotJavaBrowserBean.setStatusMessage(string2);
            Dimension dimension2 = new Dimension(dimension.width - pageMargins.getHorizMargin(), dimension.height - pageMargins.getVertMargin());
            this.setSize(dimension2.width, dimension2.height, 0);
            this.formatPrintDocument(0);
            Vector vector = new Vector(20);
            this.paginate(vector, pageMargins, dimension2);
            hotJavaBrowserBean.setStatusMessage(hJBProperties.getProperty("printjob.start.msg"));
            this.printPages(printJob, graphics, hotJavaBrowserBean, pageMarker, vector, pageMargins, dimension2);
            hotJavaBrowserBean.setStatusMessage(hJBProperties.getProperty("printjob.done.msg"));
        }
        catch (Throwable throwable) {
            Object var9_18 = null;
            this.doc.setOwner(n, null);
            throw throwable;
        }
        Object var9_17 = null;
        this.doc.setOwner(n, null);
    }

    private void paginate(Vector vector, PageMargins pageMargins, Dimension dimension) {
        int n = dimension.height;
        FormatterVBreakInfo formatterVBreakInfo = new FormatterVBreakInfo();
        int n2 = 0;
        boolean bl = false;
        do {
            int n3 = n2 + n;
            n2 = this.findSplitY(n3, n, formatterVBreakInfo);
            FormatterVBreakInfo formatterVBreakInfo2 = new FormatterVBreakInfo();
            bl = this.recordBreakInfo(n2, n3, formatterVBreakInfo, formatterVBreakInfo2);
            formatterVBreakInfo2.setYOffset(n2);
            vector.addElement(formatterVBreakInfo);
            if (!bl) continue;
            formatterVBreakInfo = formatterVBreakInfo2;
        } while (bl);
    }

    private void printPages(PrintJob printJob, Graphics graphics, HotJavaBrowserBean hotJavaBrowserBean, PageMarker pageMarker, Vector vector, PageMargins pageMargins, Dimension dimension) {
        MessageFormat messageFormat;
        int n = vector.size();
        int n2 = printJob.lastPageFirst() ? n - 1 : 0;
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        String string = hJBProperties.getProperty("printjob.page.msg");
        try {
            Class.forName("java.text.MessageFormat");
            messageFormat = new MessageFormat(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            messageFormat = null;
        }
        Object[] objectArray = new Object[]{String.valueOf(n2 + 1)};
        do {
            Object var17_16;
            Graphics graphics2;
            block7: {
                String string2 = messageFormat == null ? this.simpleFormat(string, objectArray) : messageFormat.format(objectArray);
                hotJavaBrowserBean.setStatusMessage(string2);
                graphics2 = graphics;
                graphics = null;
                if (graphics2 == null) {
                    graphics2 = printJob.getGraphics();
                }
                try {
                    if (pageMarker != null) {
                        pageMarker.markBefore(this.doc, graphics2.create(), printJob, n2, n);
                    }
                    FormatterVBreakInfo formatterVBreakInfo = (FormatterVBreakInfo)vector.elementAt(n2);
                    int n3 = dimension.width;
                    Graphics graphics3 = graphics2.create();
                    int n4 = formatterVBreakInfo.getYOffset();
                    graphics2.translate(pageMargins.getLeftMargin(), pageMargins.getTopMargin() - n4);
                    graphics2.clipRect(0, n4, dimension.width, dimension.height);
                    graphics2.setColor(Color.black);
                    graphics2.setFont(this.ds.docStyle.font);
                    this.print(graphics2, formatterVBreakInfo, n3);
                    Dimension dimension2 = printJob.getPageDimension();
                    graphics3.setColor(Color.white);
                    graphics3.fillRect(0, dimension2.height - pageMargins.getBottomMargin() + 1, dimension2.width, pageMargins.getBottomMargin());
                    if (pageMarker == null) break block7;
                    pageMarker.markAfter(this.doc, graphics3, printJob, n2, n);
                }
                catch (Throwable throwable) {
                    var17_16 = null;
                    graphics2.dispose();
                    throw throwable;
                }
            }
            var17_16 = null;
            graphics2.dispose();
        } while (!(printJob.lastPageFirst() ? n2-- <= 0 : ++n2 >= n));
    }

    private String simpleFormat(String string, Object[] objectArray) {
        return string;
    }

    private void setCompleted(boolean bl) {
        bl &= this.doc.doneParsing();
        if (this.getParent() instanceof DocumentFormatterPanel) {
            DocumentFormatterPanel documentFormatterPanel = (DocumentFormatterPanel)this.getParent();
            documentFormatterPanel.setCompleted(bl);
        }
    }

    public void addBlinker(TextItem textItem) {
        if (!this.blinkers.contains(textItem)) {
            this.blinkers.addElement(textItem);
        }
    }

    public Vector getBlinkers() {
        return this.blinkers;
    }

    private final class DocListener
    implements DocumentListener {
        public DocListener() {
            DocumentFormatter.this = DocumentFormatter.this;
        }

        public void documentChanged(DocumentEvent documentEvent) {
            DocumentFormatter.this.processDocumentEvent(documentEvent);
        }
    }

    static class FinishFormatRequest
    extends RequestProcessor.Request {
        private DocumentFormatter formatter;

        public FinishFormatRequest(DocumentFormatter documentFormatter) {
            this.formatter = documentFormatter;
        }

        public void execute() {
            Object object;
            try {
                object = Globals.getScriptingEngine();
                if (object != null && this.formatter.getDocument().hasJavaScriptTags()) {
                    object.registerListeners(this.formatter);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            object = HJBProperties.getHJBProperties("beanPropertiesKey");
            String string = ((HJBProperties)object).getProperty("hotjava.formatting.done", "");
            this.formatter.dispatchDocumentEvent(1000, string);
            this.formatter.dispatchDocumentEvent(1038, null);
        }
    }
}

