/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Container;
import java.net.URL;
import java.util.Vector;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.doc.DocFont;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentFormatterPresentation;
import sunw.hotjava.doc.DocumentFormatterRef;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.misc.HJBProperties;

public class DocumentStack {
    private int purgeContentsThreshold;
    private int purgeURLThreshold;
    private boolean initCalled = false;
    private HotJavaBrowserBean owner;
    Vector nodes = new Vector();
    private int currentPos;

    public DocumentStack(HotJavaBrowserBean hotJavaBrowserBean) {
        this.owner = hotJavaBrowserBean;
    }

    private synchronized void init() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("beanPropertiesKey");
        int n = hJBProperties.getInteger("hotjava.docstack.contents.depth", 10);
        this.setContentsDepth(n);
        n = hJBProperties.getInteger("hotjava.docstack.logical.depth", 100);
        this.setLogicalDepth(n);
    }

    public synchronized void setContentsDepth(int n) {
        this.init();
        n = Math.max(n, 0) + 1;
        int n2 = this.purgeContentsThreshold;
        while (n2 >= n) {
            this.enforceContentsThreshold(this.currentPos - n2);
            this.enforceContentsThreshold(this.currentPos + n2);
            --n2;
        }
        this.purgeContentsThreshold = n;
    }

    public int getContentsDepth() {
        this.init();
        return this.purgeContentsThreshold - 1;
    }

    public synchronized void setLogicalDepth(int n) {
        this.init();
        n = Math.max(n, 0) + 1;
        int n2 = this.purgeURLThreshold;
        while (n2 >= n) {
            this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
            this.enforceURLThreshold(this.currentPos + this.purgeURLThreshold);
            --n2;
        }
        this.purgeURLThreshold = n;
    }

    public synchronized void push(DocumentPanel documentPanel, DocumentFormatterRef documentFormatterRef) {
        Object object;
        this.init();
        DocumentFormatterRef documentFormatterRef2 = documentPanel.current;
        if (documentPanel.isLoadingNext()) {
            documentFormatterRef2 = documentPanel.next;
        }
        if (documentFormatterRef2 == null) {
            return;
        }
        Node node = new Node();
        node.target = documentPanel;
        node.newContents = new DocumentFormatterPresentation(documentFormatterRef);
        node.oldContents = new DocumentFormatterPresentation(documentFormatterRef2);
        node.extViewer = false;
        if (!(documentPanel instanceof HotJavaBrowserBean)) {
            object = new Vector<DocumentFormatterRef>();
            Container container = documentPanel.getParent();
            while (container != null) {
                if (container instanceof DocumentPanel) {
                    ((Vector)object).addElement(((DocumentPanel)container).current);
                    if (container instanceof HotJavaBrowserBean) break;
                }
                container = container.getParent();
            }
            node.parents = new DocumentFormatterRef[((Vector)object).size()];
            int n = 0;
            while (n < ((Vector)object).size()) {
                node.parents[n] = (DocumentFormatterRef)((Vector)object).elementAt(n);
                node.parents[n].addClient();
                ++n;
            }
        }
        node.oldContents.setScrollPosition(documentPanel.getScrollPosition());
        node.oldContents.getFormatterRef().offsetStored = true;
        node.oldContents.getFormatterRef().getFormatter().dispatchDocumentEvent(1040, null);
        this.pruneCurrentToTop();
        this.nodes.addElement(node);
        ++this.currentPos;
        this.enforceContentsThreshold(this.currentPos - this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
        int n = 0;
        while (n < this.nodes.size()) {
            object = (Node)this.nodes.elementAt(n);
            if (((Node)object).extViewer) {
                node.oldContents = ((Node)object).oldContents;
                this.nodes.removeElementAt(n);
                --this.currentPos;
            }
            ++n;
        }
    }

    public synchronized void replace(DocumentPanel documentPanel, DocumentFormatterRef documentFormatterRef) {
        this.init();
        boolean bl = false;
        int n = this.currentPos - 1;
        while (!bl && n >= 0) {
            Node node = (Node)this.nodes.elementAt(n);
            if (node.target == documentPanel) {
                node.newContents.flush();
                node.newContents = new DocumentFormatterPresentation(documentFormatterRef);
                ++n;
                while (!bl && n < this.nodes.size()) {
                    Node node2 = (Node)this.nodes.elementAt(n);
                    if (node2.target == documentPanel) {
                        node2.oldContents.flush();
                        node2.oldContents = new DocumentFormatterPresentation(documentFormatterRef);
                        bl = true;
                    }
                    ++n;
                }
                bl = true;
            }
            --n;
        }
        documentPanel.show(documentFormatterRef);
    }

    public boolean canForward() {
        return this.currentPos < this.nodes.size();
    }

    public boolean canBack() {
        return this.currentPos > 0;
    }

    public synchronized void forward() {
        if (!this.canForward()) {
            return;
        }
        Node node = (Node)this.nodes.elementAt(this.currentPos);
        ++this.currentPos;
        node.oldContents.setScrollPosition(node.target.getScrollPosition());
        node.oldContents.getFormatterRef().offsetStored = true;
        node.oldContents.getFormatterRef().getFormatter().dispatchDocumentEvent(1040, null);
        node.newContents.getFormatterRef().updateDocument();
        node.newContents.showIn(node.target);
        this.enforceContentsThreshold(this.currentPos - this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos - this.purgeURLThreshold);
    }

    public synchronized void back() {
        if (!this.canBack()) {
            return;
        }
        --this.currentPos;
        Node node = (Node)this.nodes.elementAt(this.currentPos);
        node.newContents.setScrollPosition(node.target.getScrollPosition());
        node.newContents.getFormatterRef().offsetStored = true;
        node.newContents.getFormatterRef().getFormatter().getDocument().interruptOwnerWaitCompletion();
        node.newContents.getFormatterRef().getFormatter().dispatchDocumentEvent(1040, null);
        node.oldContents.getFormatterRef().updateDocument();
        node.oldContents.showIn(node.target);
        this.enforceContentsThreshold(this.currentPos + this.purgeContentsThreshold);
        this.enforceURLThreshold(this.currentPos + this.purgeURLThreshold);
        int n = 0;
        while (n < this.nodes.size()) {
            Node node2 = (Node)this.nodes.elementAt(n);
            if (node2.extViewer) {
                this.nodes.removeElementAt(n);
            }
            ++n;
        }
        node.target.dispatchDocumentEvent(1006, node.oldContents.getFormatterRef().getDocument());
    }

    public int getSize() {
        return this.nodes.size();
    }

    public URL getURLAtPosition(int n) {
        URL uRL = null;
        if (this.currentPos == 0) {
            this.owner.getDocumentURL();
        } else if (this.canGo(n)) {
            if (n >= 0) {
                Node node = (Node)this.nodes.elementAt(this.currentPos + n - 1);
                uRL = node.newContents.getURL();
            } else {
                Node node = (Node)this.nodes.elementAt(this.currentPos + n);
                uRL = node.oldContents.getURL();
            }
        }
        return uRL;
    }

    public boolean canGo(int n) {
        int n2 = this.currentPos + n;
        return n2 >= 0 && n2 <= this.nodes.size();
    }

    public void go(int n) {
        if (n == 0) {
            this.owner.forceRelayout();
            return;
        }
        this.goToURL(this.getURLAtPosition(n));
    }

    private void goToURL(URL uRL) {
        if (uRL != null && this.owner != null) {
            this.owner.handleLinkEventWithDefault(this.owner.getName(), uRL, this.owner.getName(), null);
        }
    }

    public void go(String string) {
        if (this.currentPos == 0) {
            return;
        }
        boolean bl = false;
        URL uRL = this.getURLAtPosition(0);
        if (uRL.toExternalForm().indexOf(string) != -1) {
            bl = true;
        }
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 1;
        while (!bl && (bl2 || bl3)) {
            if (bl2 && (bl2 = this.canGo(-n)) && (uRL = this.getURLAtPosition(-n)).toExternalForm().indexOf(string) != -1) {
                bl = true;
                break;
            }
            if (bl3 && (bl3 = this.canGo(n)) && (uRL = this.getURLAtPosition(n)).toExternalForm().indexOf(string) != -1) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            this.goToURL(uRL);
        }
    }

    public synchronized void flushDocumentsContainingCodebases(Vector vector) {
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            Node node = (Node)this.nodes.elementAt(n3);
            this.flushForCodebase(node.oldContents, vector);
            this.flushForCodebase(node.newContents, vector);
            ++n3;
        }
    }

    private void flushForCodebase(DocumentFormatterPresentation documentFormatterPresentation, Vector vector) {
        if (!documentFormatterPresentation.getIsFlushed()) {
            DocumentFormatter documentFormatter = documentFormatterPresentation.getFormatterRef().getFormatter();
            Vector vector2 = new Vector();
            documentFormatter.getAppletPanels(vector2, true);
            int n = 0;
            while (n < vector2.size()) {
                if (vector.contains(vector2.elementAt(n))) {
                    documentFormatterPresentation.flush();
                    return;
                }
                ++n;
            }
        }
    }

    public void addAppletPanels(Vector vector) {
        Vector vector2 = new Vector();
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            DocumentFormatter documentFormatter;
            Node node = (Node)this.nodes.elementAt(n3);
            if (!node.oldContents.getIsFlushed()) {
                documentFormatter = node.oldContents.getFormatterRef().getFormatter();
                documentFormatter.getAppletPanels(vector2, true);
            }
            if (!node.newContents.getIsFlushed()) {
                documentFormatter = node.newContents.getFormatterRef().getFormatter();
                documentFormatter.getAppletPanels(vector2, true);
            }
            if (node.parents != null) {
                int n4 = 0;
                while (n4 < node.parents.length) {
                    DocumentFormatter documentFormatter2 = node.parents[n4].getFormatter();
                    documentFormatter2.getAppletPanels(vector2, true);
                    ++n4;
                }
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < vector2.size()) {
            Object e = vector2.elementAt(n5);
            if (!vector.contains(e)) {
                vector.addElement(e);
            }
            ++n5;
        }
    }

    public synchronized void flush(boolean bl) {
        if (bl) {
            int n = 0;
            while (n < this.nodes.size()) {
                Node node = (Node)this.nodes.elementAt(n);
                this.flushNode(node);
                ++n;
            }
            this.nodes = new Vector();
            this.currentPos = 0;
            return;
        }
        int n = this.getContentsDepth();
        this.setContentsDepth(0);
        this.setContentsDepth(n);
    }

    public void setDocFont(DocFont docFont) {
        int n = Math.max(0, 1 + this.currentPos - this.purgeContentsThreshold);
        int n2 = Math.min(this.nodes.size() - 1, this.currentPos + this.purgeContentsThreshold - 1);
        int n3 = n;
        while (n3 <= n2) {
            DocumentFormatter documentFormatter;
            Node node = (Node)this.nodes.elementAt(n3);
            if (!node.oldContents.getIsFlushed()) {
                documentFormatter = node.oldContents.getFormatterRef().getFormatter();
                documentFormatter.setDocFont(docFont);
            }
            if (!node.newContents.getIsFlushed()) {
                documentFormatter = node.newContents.getFormatterRef().getFormatter();
                documentFormatter.setDocFont(docFont);
            }
            if (node.parents != null) {
                int n4 = 0;
                while (n4 < node.parents.length) {
                    DocumentFormatter documentFormatter2 = node.parents[n4].getFormatter();
                    documentFormatter2.setDocFont(docFont);
                    ++n4;
                }
            }
            ++n3;
        }
    }

    private void pruneCurrentToTop() {
        int n;
        while ((n = this.nodes.size() - 1) >= this.currentPos) {
            this.flushNode((Node)this.nodes.elementAt(n));
            this.nodes.removeElementAt(n);
        }
    }

    private void enforceContentsThreshold(int n) {
        if (n >= 0 && n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            if (node.parents != null) {
                if (n + 1 < this.nodes.size()) {
                    Node node2 = (Node)this.nodes.elementAt(n + 1);
                    if (node2.target == node.target) {
                        DocumentFormatterPresentation documentFormatterPresentation = node2.oldContents;
                        node2.oldContents = node.oldContents;
                        node.oldContents = documentFormatterPresentation;
                    }
                }
                this.flushNode(node);
                this.nodes.removeElementAt(n);
                if (n <= this.currentPos) {
                    --this.currentPos;
                    return;
                }
            } else {
                this.flushNode(node);
            }
        }
    }

    private void enforceURLThreshold(int n) {
        if (n >= 0 && n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            this.flushNode(node);
            this.nodes.removeElementAt(n);
            if (n <= this.currentPos) {
                --this.currentPos;
            }
        }
    }

    private void flushNode(Node node) {
        node.oldContents.flush();
        node.newContents.flush();
        if (node.parents != null) {
            int n = 0;
            while (n < node.parents.length) {
                node.parents[n].removeClient();
                ++n;
            }
        }
        node.parents = null;
    }

    public void setViewer(URL uRL) {
        Node node = null;
        int n = 0;
        while (n < this.nodes.size()) {
            node = (Node)this.nodes.elementAt(n);
            if (node.newContents.getURL().equals(uRL)) {
                node.extViewer = true;
            }
            ++n;
        }
    }

    public void printOutDocStack() {
        System.out.println("=======================================");
        System.out.println("=       Current document stack");
        System.out.println("=       Current position = " + this.currentPos);
        System.out.println("=");
        int n = 0;
        while (n < this.nodes.size()) {
            Node node = (Node)this.nodes.elementAt(n);
            System.out.println("= Node " + n + ":");
            System.out.println("=    target: " + node.target.getName());
            System.out.println("=    old contents: " + node.oldContents.getURL());
            System.out.println("=        scroll position: " + node.oldContents.getScrollPosition());
            System.out.println("=        flushed: " + node.oldContents.getIsFlushed());
            System.out.println("=    new contents: " + node.newContents.getURL());
            System.out.println("=        scroll position: " + node.newContents.getScrollPosition());
            System.out.println("=        flushed: " + node.newContents.getIsFlushed());
            System.out.println("=    parents (length " + (node.parents == null ? 0 : node.parents.length) + "):");
            if (node.parents != null) {
                int n2 = 0;
                while (n2 < node.parents.length) {
                    System.out.print("=       " + node.parents[n2].getURL());
                    DocumentFormatter documentFormatter = node.parents[n2].getFormatterIfNotRemoved();
                    if (documentFormatter != null) {
                        System.out.println(", " + ((DocumentPanel)documentFormatter.getScrollPane()).getName());
                    } else {
                        System.out.println("");
                    }
                    ++n2;
                }
            }
            System.out.println("=    extViewer: " + node.extViewer);
            System.out.println("=");
            ++n;
        }
        System.out.println("=======================================");
    }

    private class Node {
        DocumentPanel target;
        DocumentFormatterPresentation oldContents;
        DocumentFormatterPresentation newContents;
        DocumentFormatterRef[] parents;
        boolean extViewer;

        Node() {
            DocumentStack.this = DocumentStack.this;
        }
    }
}

