/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.ui.ConfirmDialogPanel;
import sunw.hotjava.ui.MultiLineLabel;
import sunw.hotjava.ui.UIHJButton;
import sunw.hotjava.ui.UIHJButtonGroup;
import sunw.hotjava.ui.UserDialog;
import sunw.hotjava.ui.UserImageLabel;

public class ConfirmDialog
extends UserDialog
implements ActionListener {
    protected UIHJButton[] buttons;
    protected String prompt;
    private boolean focused = false;
    MultiLineLabel promptLabel;
    UIHJButtonGroup btnGrouping;
    public static final int NO = 0;
    public static final int YES = 1;
    private ConfirmDialogPanel wrapper;
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private int answer;

    public ConfirmDialog(String string, Frame frame) {
        this(string, frame, 2, true, true);
    }

    public ConfirmDialog(String string, Frame frame, int n) {
        this(string, frame, n, true, true);
    }

    public ConfirmDialog(String string, Frame frame, int n, String[] stringArray) {
        this(string, frame, n, true, false, stringArray);
    }

    public ConfirmDialog(String string, Frame frame, int n, boolean bl) {
        this(string, frame, n, bl, true);
    }

    public ConfirmDialog(String string, Frame frame, int n, boolean bl, boolean bl2) {
        super(string, frame, bl, HJBProperties.getHJBProperties("hjbrowser"));
        this.init(n, bl2, null);
    }

    public ConfirmDialog(String string, Frame frame, int n, boolean bl, boolean bl2, String[] stringArray) {
        super(string, frame, bl, HJBProperties.getHJBProperties("hjbrowser"));
        this.init(n, bl2, stringArray);
    }

    public int getAnswer() {
        return this.answer;
    }

    public void setPrompt(String string) {
        this.prompt = string;
        this.promptLabel.setLabel(this.prompt);
        if (this.wrapper != null) {
            this.wrapper.setSize(this.wrapper.getPreferredSize());
            ((Component)this).setSize(this.getPreferredSize());
        }
    }

    public Dimension getPromptSize() {
        return this.promptLabel.preferredSize();
    }

    public boolean gotFocus(Event event, Object object) {
        if (!this.focused) {
            this.buttons[0].requestFocus();
            this.focused = true;
        }
        return true;
    }

    public void setFocus(int n) {
        this.buttons[1].requestFocus();
    }

    private void init(int n, boolean bl, String[] stringArray) {
        Object object;
        this.answer = 0;
        this.wrapper = new ConfirmDialogPanel();
        this.add("Center", this.wrapper);
        HJBProperties hJBProperties = HJBProperties.getHJBProperties("hjbrowser");
        this.btnGrouping = new UIHJButtonGroup(hJBProperties);
        String string = hJBProperties.getProperty("imagelabel.confirm." + this.getName());
        if (string != null && (object = new UserImageLabel("confirm." + this.getName(), this.properties)) != null) {
            this.wrapper.add("West", (Component)object);
        }
        if (stringArray != null) {
            this.prompt = this.properties.getPropertyReplace("confirm." + this.getName() + ".replaceprompt", stringArray);
        }
        if (this.prompt == null) {
            this.prompt = this.properties.getProperty("confirm." + this.getName() + ".prompt", "Which do you want to do?");
        }
        this.promptLabel = new MultiLineLabel(this.prompt);
        this.wrapper.add("Center", this.promptLabel);
        this.initButtons(n, bl);
        this.addButtons(this.wrapper);
        object = this.properties.getProperty("confirm." + this.getName() + ".title", "Confirm Dialog");
        this.setTitle((String)object);
        this.pack();
        this.centerOnScreen();
    }

    private void initButtons(int n) {
        if (n == 2) {
            this.buttons = new UIHJButton[2];
            this.buttons[0] = new UIHJButton(String.valueOf(this.getName()) + ".no", this.properties);
            this.buttons[1] = new UIHJButton(String.valueOf(this.getName()) + ".yes", this.properties);
            return;
        }
        this.buttons = new UIHJButton[n];
        int n2 = 0;
        while (n2 < n) {
            this.buttons[n2] = new UIHJButton(String.valueOf(this.getName()) + "." + n2, this.properties);
            ++n2;
        }
    }

    private void initButtons(int n, boolean bl) {
        if (bl) {
            this.initButtons(n);
            return;
        }
        this.buttons = new UIHJButton[n];
        int n2 = 0;
        while (n2 < n) {
            this.buttons[n2] = new UIHJButton(String.valueOf(this.getName()) + "." + n2, this.properties);
            ++n2;
        }
    }

    private void addButtons(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(1, 15, 15));
        int n = 0;
        while (n < this.buttons.length) {
            panel2.add(this.buttons[n]);
            this.buttons[n].addActionListener(this);
            this.btnGrouping.addButtonToGroup(this.buttons[n]);
            ++n;
        }
        panel.add("South", panel2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.buttons.length) {
            this.buttons[n].removeActionListener(this);
            if ((UIHJButton)actionEvent.getSource() == this.buttons[n]) {
                this.answer = n;
                ((Component)this).hide();
                return;
            }
            ++n;
        }
        ((Component)this).hide();
        super.processEvent(actionEvent);
    }
}

