/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.URLCanonicalizer;
import sunw.hotjava.ui.Bookmark;
import sunw.hotjava.ui.BookmarkDialog;
import sunw.hotjava.ui.BrowserListCanvas;
import sunw.hotjava.ui.DragAndDropEvent;
import sunw.hotjava.ui.DragAndDropListener;
import sunw.hotjava.ui.DragStartInfo;
import sunw.hotjava.ui.DraggableContainer;
import sunw.hotjava.ui.EntrySeparator;
import sunw.hotjava.ui.Folder;
import sunw.hotjava.ui.FolderDialog;
import sunw.hotjava.ui.FolderPanel;
import sunw.hotjava.ui.HotCanvas;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListBuffer;
import sunw.hotjava.ui.HotListEntry;
import sunw.hotjava.ui.ListContainer;
import sunw.hotjava.ui.ListItem;
import sunw.hotjava.ui.ListItemComponent;
import sunw.hotjava.ui.ListPanel;
import sunw.hotjava.ui.PageFolder;
import sunw.hotjava.ui.PlacesMessageLine;
import sunw.hotjava.ui.Separator;
import sunw.hotjava.ui.UserFrame;
import sunw.hotjava.ui.UserMenuBar;
import sunw.hotjava.ui.Webmark;

public class HotListFrame
extends UserFrame {
    private static HotListFrame frm = null;
    static final String propName = "hotlistframe";
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    Panel topPanel;
    HJFrame owner;
    ListPanel listPanel;
    FolderPanel folderPanel;
    HotCanvas selectedCanvas;
    PlacesMessageLine messageLine;
    UserMenuBar hotlistframemenubar;
    ActionListener actionEventsListener;
    String title;
    Image book_img;
    Image open_img;
    Image closed_img;
    Image list_img;
    ListItem storeSelection;
    private DraggableContainer draggable;
    boolean readOnlyList;
    HotListBuffer buffer;
    boolean iconified = false;

    public static HotListFrame getHotListFrame(HJFrame hJFrame) {
        if (frm == null) {
            frm = new HotListFrame(hJFrame);
            HotList hotList = HotList.getHotList();
            if (!hotList.isFinishedImporting()) {
                hotList.raiseImportPriority();
            }
        }
        if (HotListFrame.frm.iconified) {
            frm.dispose();
            frm = new HotListFrame(hJFrame);
        }
        return frm;
    }

    public static HotListFrame getHotListFrame() {
        return frm;
    }

    public ActionListener getActionEventListener() {
        return this.actionEventsListener;
    }

    private HotListFrame(HJFrame hJFrame) {
        super(propName);
        this.owner = hJFrame;
        Insets insets = this.insets();
        ((Component)this).setSize(insets.left + insets.right + 150, insets.top + insets.bottom + 150);
        this.actionEventsListener = new ActionEventsListener();
        String string = this.properties.getProperty("hotlistframe.bookmarkImage");
        String string2 = this.properties.getProperty("hotlistframe.diropenImage");
        String string3 = this.properties.getProperty("hotlistframe.dirclosedImage");
        String string4 = this.properties.getProperty("hotlistframe.listImage");
        this.properties.getProperty("hotlistframe.listname");
        this.book_img = this.initImage(string);
        this.open_img = this.initImage(string2);
        this.closed_img = this.initImage(string3);
        this.list_img = this.initImage(string4);
        this.buffer = new HotListBuffer();
        this.initFrame();
        1 var7_7 = new 1();
        this.addWindowListener(var7_7);
        2 var8_8 = new 2();
        this.addMouseListener(var8_8);
        3 var9_9 = new 3();
        this.addMouseMotionListener(var9_9);
    }

    public void initFrame() {
        this.setLayout(new BorderLayout());
        this.invalidate();
        this.title = this.properties.getProperty("hotlistframe.title");
        this.listPanel = new ListPanel(this);
        this.folderPanel = new FolderPanel(this);
        this.add("North", this.listPanel);
        this.add("Center", this.folderPanel);
        this.messageLine = new PlacesMessageLine();
        this.add("South", this.messageLine);
        this.setFrameMenuBar();
        ((Component)this).setBackground(this.properties.getColor("hotjava.background", null));
        this.validate();
        this.pack();
    }

    public void setListName(String string) {
        this.listPanel.setLabelName(string);
    }

    public void setMessage(String string) {
        this.messageLine.setMessage(string);
    }

    public void setAdjustables(Graphics graphics, ScrollPane scrollPane) {
        Adjustable adjustable;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        Adjustable adjustable2 = scrollPane.getHAdjustable();
        if (adjustable2 != null) {
            adjustable2.setUnitIncrement(n);
        }
        if ((adjustable = scrollPane.getVAdjustable()) != null) {
            adjustable.setUnitIncrement(n);
        }
    }

    public void initializePanels() {
        if (this.listPanel.getCanvas() == null || this.folderPanel.getCanvas() == null) {
            this.folderPanel.initialize();
            this.listPanel.initialize();
            DnDListener dnDListener = new DnDListener();
            HotCanvas hotCanvas = this.listPanel.getCanvas();
            hotCanvas.addDragAndDropListener(dnDListener);
            hotCanvas = this.folderPanel.getCanvas();
            hotCanvas.addDragAndDropListener(dnDListener);
        }
    }

    public void show() {
        super.show();
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                ScrollPane scrollPane = this.listPanel.getListPane();
                this.setAdjustables(graphics, scrollPane);
                scrollPane = this.folderPanel.getFolderPane();
                this.setAdjustables(graphics, scrollPane);
                return;
            }
            finally {
                Object var3_3 = null;
                graphics.dispose();
            }
        }
    }

    public void openList(String string) {
        this.initializePanels();
        this.show();
        BrowserListCanvas browserListCanvas = (BrowserListCanvas)this.listPanel.getCanvas();
        Folder folder = browserListCanvas.getFolder(string);
        Folder folder2 = (Folder)browserListCanvas.getSelectedItem();
        if (folder == null) {
            return;
        }
        browserListCanvas.setSelectedItem(folder);
        try {
            if (folder2 != null) {
                folder2.toggleSelected();
                boolean bl = true;
                folder2.setContainerState(bl);
            }
            folder.toggleSelected();
            this.selectCanvas(browserListCanvas);
            this.displayList(folder);
            this.storeSelection = folder;
            return;
        }
        catch (Exception exception) {
            System.out.println("Failed to postEvent: " + this.listPanel);
            exception.printStackTrace();
            return;
        }
    }

    public FolderPanel getFolderPanel() {
        return this.folderPanel;
    }

    public ListPanel getListPanel() {
        return this.listPanel;
    }

    public Panel getContainingPanelForCanvas(HotCanvas hotCanvas) {
        if (hotCanvas instanceof BrowserListCanvas) {
            return this.getContainingListPanel(hotCanvas);
        }
        return this.getContainingFolderPanel(hotCanvas);
    }

    public ListPanel getContainingListPanel(HotCanvas hotCanvas) {
        Container container = hotCanvas.getParent();
        while (container != null) {
            if (container instanceof ListPanel) {
                return (ListPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public FolderPanel getContainingFolderPanel(HotCanvas hotCanvas) {
        Container container = hotCanvas.getParent();
        while (container != null) {
            if (container instanceof FolderPanel) {
                return (FolderPanel)container;
            }
            container = container.getParent();
        }
        return null;
    }

    private Image initImage(String string) {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.properties.getImage(string);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (Exception exception) {
            image = null;
        }
        return image;
    }

    public Image getBookImage() {
        return this.book_img;
    }

    public Image getOpenImage() {
        return this.open_img;
    }

    public Image getClosedImage() {
        return this.closed_img;
    }

    public Image getListImage() {
        return this.list_img;
    }

    public HotList getHotList() {
        return HotList.getHotList();
    }

    public HJFrame getOwner() {
        return this.owner;
    }

    public HotListBuffer getBuffer() {
        return this.buffer;
    }

    public String getListName() {
        return this.properties.getProperty("hotlistframe.listname");
    }

    protected void setFrameMenuBar() {
        this.hotlistframemenubar = new UserMenuBar("hotlistframemenubar", this.actionEventsListener);
        this.setMenuBar(this.hotlistframemenubar);
        this.enableCutCopyRename(false);
        this.updatePaste();
        this.updateUndo();
        this.enableSorting(false);
    }

    public void processDragAndDropEvent(DragAndDropEvent dragAndDropEvent) {
        switch (dragAndDropEvent.getID()) {
            case 91960: {
                if (this.draggable != null) break;
                DragStartInfo dragStartInfo = (DragStartInfo)dragAndDropEvent.getArgument();
                this.draggable = new DraggableContainer(this, this, dragStartInfo);
                HotCanvas hotCanvas = this.getListPanel().getCanvas();
                DragAndDropListener dragAndDropListener = hotCanvas.getDragAndDropListener();
                this.draggable.addDragAndDropListener(dragAndDropListener);
                hotCanvas = this.getFolderPanel().getCanvas();
                dragAndDropListener = hotCanvas.getDragAndDropListener();
                this.draggable.addDragAndDropListener(dragAndDropListener);
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 502: {
                ListItem listItem;
                if (this.draggable == null) break;
                this.draggable.processDragAndDropEvent(this, mouseEvent);
                ListItemComponent listItemComponent = (ListItemComponent)this.draggable.getDraggee();
                ListItem listItem2 = listItemComponent.getBaseItem();
                ((Component)this.draggable).setVisible(false);
                this.draggable.dispose();
                this.draggable = null;
                if (this.selectedCanvas != null && !this.selectedCanvas.itemMoved()) {
                    return;
                }
                ListContainer listContainer = listItem2.getParentListContainer();
                Folder folder = (Folder)listContainer.getParentListContainer();
                Folder folder2 = (Folder)listContainer;
                boolean bl = folder2.closed();
                if (folder.isTopList() && !bl) {
                    folder2.setContainerState(!bl);
                    this.displayList(folder2);
                }
                if ((listItem = this.selectedCanvas.getSelectedItem()) != null) {
                    listItem.toggleSelected();
                }
                this.selectedCanvas.setSelectedItem(null);
                this.selectedCanvas.setCurrentItem(null);
                this.getHotList().exportHTMLFile();
                this.enableCutCopyRename(false);
                this.updatePaste();
                this.updateUndo();
                return;
            }
            case 506: {
                if (this.draggable == null) break;
                this.draggable.processDragAndDropEvent(this, mouseEvent);
                return;
            }
        }
    }

    public void notify(int n, Object object) {
    }

    public boolean action(ActionEvent actionEvent, String string, boolean bl) {
        actionEvent.getActionCommand();
        if (string.equals("newlist")) {
            HotCanvas hotCanvas = this.listPanel.getCanvas();
            Folder folder = (Folder)hotCanvas.getMainContainer();
            String string2 = new String(".newlist");
            String string3 = new String(".listdialog.label");
            FolderDialog folderDialog = new FolderDialog(propName, string2, string3, this);
            String string4 = this.properties.getProperty("hotlistframe.default.newlist", "New List");
            string4 = this.getHotList().getUniqueName(string4, (PageFolder)folder.getHotListEntry());
            folderDialog.setDefaultText(string4);
            String string5 = folderDialog.getFolderName();
            if (string5 == null) {
                return true;
            }
            if (string5.equals("")) {
                string5 = string4;
            }
            this.getHotList().addFolder((PageFolder)folder.getHotListEntry(), string5, true, -5);
            this.getHotList().exportHTMLFile();
            this.repaint();
            return true;
        }
        if (string.equals("newfolder")) {
            HotListEntry hotListEntry;
            HotCanvas hotCanvas = this.selectedCanvas;
            if (hotCanvas == null || hotCanvas.getSelectedItemFolder() == null) {
                hotCanvas = this.listPanel.getCanvas();
            }
            if (hotCanvas == null) {
                return true;
            }
            Folder folder = (Folder)hotCanvas.getSelectedItemFolder();
            String string6 = new String(".newfolder");
            String string7 = new String(".folderdialog.label");
            FolderDialog folderDialog = new FolderDialog(propName, string6, string7, this);
            String string8 = folderDialog.getFolderName();
            if (string8 == null) {
                return true;
            }
            if (string8.equals("")) {
                string8 = this.properties.getProperty("hotlistframe.newfolder.title");
            }
            ListItem listItem = hotCanvas.getSelectedItem();
            PageFolder pageFolder = (PageFolder)folder.getHotListEntry();
            int n = -5;
            if (listItem != null && (n = pageFolder.getItemPos(hotListEntry = listItem instanceof Bookmark ? ((Bookmark)listItem).getWebmark() : (listItem instanceof Folder ? ((Folder)listItem).getPageFolder() : ((EntrySeparator)listItem).getHotListEntry())) + 1) == 0) {
                n = -5;
            }
            hotListEntry = (PageFolder)folder.getHotListEntry();
            this.getHotList().addFolder((PageFolder)hotListEntry, string8, true, n);
            this.getHotList().sort((PageFolder)hotListEntry);
            this.getHotList().exportHTMLFile();
            HotCanvas hotCanvas2 = this.getFolderPanel().getCanvas();
            this.updateCanvas(hotCanvas2, folder);
            return true;
        }
        if (string.equals("newplace")) {
            Object object;
            HotCanvas hotCanvas = this.selectedCanvas;
            if (hotCanvas == null || hotCanvas.getSelectedItemFolder() == null) {
                hotCanvas = this.listPanel.getCanvas();
            }
            if (hotCanvas == null) {
                return true;
            }
            Folder folder = (Folder)hotCanvas.getSelectedItemFolder();
            if (folder == null) {
                return false;
            }
            String string9 = new String(".newplace");
            String string10 = new String(".placedialog.URLlabel");
            String string11 = new String(".placedialog.titlelabel");
            BookmarkDialog bookmarkDialog = new BookmarkDialog(propName, string9, string10, string11, this);
            String string12 = bookmarkDialog.getPlaceName();
            this.setMessage(" ");
            if (string12 == null || string12.equals("")) {
                return true;
            }
            if (string12.startsWith("|")) {
                String string13 = this.properties.getProperty("hotlistframe.newplaceerr.msg");
                this.setMessage(string13);
                return true;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string12, "|", false);
            String string14 = null;
            String string15 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (string14 == null) {
                    string14 = stringTokenizer.nextToken();
                    continue;
                }
                string15 = stringTokenizer.nextToken();
            }
            ListItem listItem = hotCanvas.getSelectedItem();
            PageFolder pageFolder = (PageFolder)folder.getHotListEntry();
            int n = -5;
            if (listItem != null && (n = pageFolder.getItemPos((HotListEntry)(object = listItem instanceof Bookmark ? ((Bookmark)listItem).getWebmark() : (listItem instanceof Folder ? ((Folder)listItem).getPageFolder() : ((EntrySeparator)listItem).getHotListEntry()))) + 1) == 0) {
                n = -5;
            }
            try {
                object = new URLCanonicalizer();
                string14 = ((URLCanonicalizer)object).canonicalize(string14);
                URL uRL = new URL(null, string14);
                this.getHotList().addItemToFolder(uRL.toString(), string15, pageFolder, n);
                this.getHotList().sort(pageFolder);
                this.getHotList().exportHTMLFile();
                HotCanvas hotCanvas3 = this.getFolderPanel().getCanvas();
                this.updateCanvas(hotCanvas3, folder);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            return true;
        }
        if (string.equals("cut") || string.equals("delete")) {
            ListItem listItem;
            ListItem listItem2 = this.selectedCanvas.getSelectedItem();
            HotListEntry hotListEntry = null;
            this.buffer.saveInBuffer(listItem2, string);
            if (listItem2 instanceof Folder) {
                listItem = (Folder)listItem2;
                hotListEntry = ((Folder)listItem).getHotListEntry();
            }
            if (listItem2 instanceof Bookmark) {
                listItem = (Bookmark)listItem2;
                hotListEntry = ((Bookmark)listItem).getHotListEntry();
            }
            if (listItem2 instanceof EntrySeparator) {
                listItem = (EntrySeparator)listItem2;
                hotListEntry = ((EntrySeparator)listItem).getHotListEntry();
            }
            if (listItem2 != null) {
                this.getHotList().deleteGotoItem(hotListEntry);
                this.getHotList().exportHTMLFile();
            }
            if ((listItem2 = this.selectedCanvas.getSelectedItem()) == null) {
                this.enableCutCopyRename(false);
            }
            this.updatePaste();
            this.updateUndo();
            this.enableReverseSort(false);
            return true;
        }
        if (string.equals("copy")) {
            ListItem listItem = this.selectedCanvas.getSelectedItem();
            this.buffer.saveInBuffer(listItem, "copy");
            this.updatePaste();
            this.updateUndo();
            this.getHotList().exportHTMLFile();
            return true;
        }
        if (string.equals("paste")) {
            boolean bl2;
            ListItem listItem = this.selectedCanvas.getSelectedItem();
            String string16 = this.properties.getProperty("hotlistframe.pasteerr.msg");
            if (listItem == null) {
                this.setMessage(string16);
                return true;
            }
            if (!(listItem instanceof Folder)) {
                this.setMessage(string16);
                return true;
            }
            Folder folder = (Folder)listItem;
            PageFolder pageFolder = (PageFolder)folder.getHotListEntry();
            HotListEntry hotListEntry = this.buffer.getEntryFromBuffer();
            ListItem listItem3 = this.buffer.getListItemFromBuffer();
            Folder folder2 = null;
            boolean bl3 = true;
            if (listItem3 instanceof Folder) {
                folder2 = (Folder)listItem3;
                bl3 = folder2.closed();
            }
            HotCanvas hotCanvas = this.getFolderPanel().getCanvas();
            if (hotListEntry instanceof PageFolder) {
                bl2 = this.getHotList().pasteFolder(pageFolder, (PageFolder)hotListEntry, bl3, 0);
                if (!bl2) {
                    return true;
                }
                this.updateCanvas(hotCanvas, folder);
            }
            if (hotListEntry instanceof Webmark && !(bl2 = this.getHotList().pasteWebmark(pageFolder, (Webmark)hotListEntry, 0))) {
                return true;
            }
            if (hotListEntry instanceof Separator) {
                this.getHotList().addSeparatorItem(pageFolder, 0);
            }
            this.buffer.saveInBuffer(listItem3, "paste");
            this.updateUndo();
            this.getHotList().exportHTMLFile();
            this.enableReverseSort(false);
            return true;
        }
        if (string.equals("undo")) {
            HotListEntry hotListEntry;
            Cloneable cloneable;
            ListItem listItem;
            Cloneable cloneable2;
            this.buffer.disableUndo();
            this.updateUndo();
            String string17 = this.buffer.getOperationFromBuffer();
            if (string17.equals("copy")) {
                this.buffer.clearBuffer();
                this.updatePaste();
                this.getHotList().exportHTMLFile();
            }
            if (string17.equals("paste")) {
                cloneable2 = this.selectedCanvas.getSelectedItem();
                if (cloneable2 == null) {
                    String string18 = this.properties.getProperty("hotlistframe.pasteundoerr");
                    this.setMessage(string18);
                    return true;
                }
                if (!(cloneable2 instanceof Folder)) {
                    String string19 = this.properties.getProperty("hotlistframe.pasteundoerr");
                    this.setMessage(string19);
                    return true;
                }
                listItem = (Folder)cloneable2;
                cloneable = (PageFolder)((Folder)listItem).getHotListEntry();
                HotListEntry hotListEntry2 = this.buffer.getEntryFromBuffer();
                hotListEntry = this.getHotList().getEntry((PageFolder)cloneable, hotListEntry2);
                this.getHotList().deleteGotoItem(hotListEntry);
                this.getHotList().exportHTMLFile();
                this.enableReverseSort(false);
            }
            if (string17.equals("cut") || string17.equals("delete")) {
                cloneable2 = this.buffer.getEntryFromBuffer();
                listItem = this.buffer.getListItemFromBuffer();
                this.buffer.clearBuffer();
                this.updatePaste();
                if (listItem == null) {
                    return true;
                }
                cloneable = null;
                boolean bl4 = true;
                if (listItem instanceof Folder) {
                    cloneable = (Folder)listItem;
                    bl4 = ((ListContainer)cloneable).closed();
                }
                this.getFolderPanel().getCanvas();
                hotListEntry = ((HotListEntry)cloneable2).getParent();
                if (cloneable2 instanceof PageFolder) {
                    this.getHotList().pasteFolder((PageFolder)hotListEntry, (PageFolder)cloneable2, bl4, 0);
                    this.getHotList().sort((PageFolder)hotListEntry);
                    this.reInitialize((PageFolder)hotListEntry, listItem);
                }
                if (cloneable2 instanceof Webmark) {
                    this.getHotList().pasteWebmark((PageFolder)hotListEntry, (Webmark)cloneable2, 0);
                    this.getHotList().sort(((PageFolder)hotListEntry).getSortType(), (PageFolder)hotListEntry);
                    this.reInitialize((PageFolder)hotListEntry, listItem);
                }
                if (cloneable2 instanceof Separator) {
                    this.getHotList().addSeparatorItem((PageFolder)hotListEntry, 0);
                    this.reInitialize((PageFolder)hotListEntry, listItem);
                }
                this.getHotList().exportHTMLFile();
                this.enableReverseSort(false);
            }
            frm.setMessage(" ");
            return true;
        }
        if (string.equals("rename")) {
            ListItem listItem = this.selectedCanvas.getSelectedItem();
            if (listItem == null) {
                String string20 = this.properties.getProperty("hotlistframe.noitemselected.msg");
                this.setMessage(string20);
                return true;
            }
            if (listItem instanceof Bookmark) {
                this.renameBookmark((Bookmark)listItem, this);
            } else {
                this.renameContainer((Folder)listItem, this);
            }
            this.enableReverseSort(false);
            return true;
        }
        if (string.equals("newseparator")) {
            HotListEntry hotListEntry;
            HotCanvas hotCanvas = this.selectedCanvas;
            if (hotCanvas == null || hotCanvas.getSelectedItem() == null) {
                String string21 = this.properties.getProperty("hotlistframe.noselection.msg");
                this.setMessage(string21);
                return true;
            }
            Folder folder = (Folder)hotCanvas.getSelectedItemFolder();
            ListItem listItem = hotCanvas.getSelectedItem();
            PageFolder pageFolder = (PageFolder)folder.getHotListEntry();
            int n = pageFolder.getItemPos(hotListEntry = listItem instanceof Bookmark ? ((Bookmark)listItem).getWebmark() : (listItem instanceof Folder ? ((Folder)listItem).getPageFolder() : ((EntrySeparator)listItem).getHotListEntry())) + 1;
            if (n == 0) {
                n = -5;
            }
            this.getHotList().addSeparatorItem(pageFolder, n);
            this.getHotList().exportHTMLFile();
            this.enableReverseSort(false);
            return true;
        }
        if (string.equals("import")) {
            HotList hotList = this.getHotList();
            hotList.importList(this);
            if (!hotList.isFinishedImporting()) {
                hotList.raiseImportPriority();
            }
            return true;
        }
        if (string.equals("export")) {
            HotList hotList = HotList.getHotList();
            if (this.selectedCanvas != null) {
                ListItem listItem;
                ListItem listItem4 = this.selectedCanvas.getSelectedItem();
                HotListEntry hotListEntry = null;
                String string22 = this.properties.getProperty("hotlistframe.exportList");
                PageFolder pageFolder = new PageFolder(null, string22, true);
                if (listItem4 instanceof Folder) {
                    listItem = (Folder)listItem4;
                    hotListEntry = ((Folder)listItem).getHotListEntry();
                    pageFolder.addElement(hotListEntry);
                }
                if (listItem4 instanceof Bookmark) {
                    listItem = (Bookmark)listItem4;
                    hotListEntry = ((Bookmark)listItem).getHotListEntry();
                    String string23 = this.properties.getProperty("hotlistframe.exportItem");
                    PageFolder pageFolder2 = new PageFolder(pageFolder, string23, true);
                    pageFolder2.addElement(hotListEntry);
                    pageFolder.addElement(pageFolder2);
                }
                hotList.exportList(this, pageFolder);
            } else {
                hotList.exportList(this, null);
            }
        }
        if (string.equals("atoz")) {
            this.sort(70);
            return true;
        }
        if (string.equals("date")) {
            this.sort(71);
            return true;
        }
        if (string.equals("frequent")) {
            this.sort(72);
            return true;
        }
        if (string.equals("reverse")) {
            this.sort(73);
            return true;
        }
        if (string.equals("closewin")) {
            this.closeFrame();
            return true;
        }
        if (string.equals("quit")) {
            if (!this.owner.confirmExit(true)) {
                return true;
            }
            this.closeFrame();
            this.owner.saveStateToProperties();
            this.properties.save();
            HJWindowManager.getHJWindowManager().quit();
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public void updateCanvas(Component var1_1, Folder var2_2) {
        block3: {
            var3_3 = (PageFolder)var2_2.getHotListEntry();
            var4_4 = (HotCanvas)var1_1;
            if (var3_3.getGrandParent() != null) ** GOTO lbl12
            var4_4.createInitialFolder(var2_2);
            var5_5 = var2_2.closed();
            if (!var5_5) {
                var4_4.initialize(var3_3);
            } else {
                var4_4.setMainContainer(null);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var3_3 = var3_3.getParent();
lbl12:
                // 2 sources

                ** while (var3_3.getGrandParent() != null)
            }
lbl13:
            // 1 sources

            var5_6 = this.getListPanel().getCanvas();
            var4_4.createInitialFolder((Folder)var5_6.getMainContainer());
            var4_4.initialize(var3_3);
        }
        var4_4.repaint();
    }

    public void selectCanvas(HotCanvas hotCanvas) {
        ListItem listItem = hotCanvas.getSelectedItem();
        if (this.selectedCanvas == null) {
            this.selectedCanvas = hotCanvas;
        }
        ListItem listItem2 = this.selectedCanvas.getSelectedItem();
        if (this.selectedCanvas != hotCanvas) {
            if (listItem2 != null) {
                listItem2.toggleSelected();
                if (this.selectedCanvas instanceof BrowserListCanvas) {
                    this.storeSelection = ((BrowserListCanvas)this.selectedCanvas).getSelectedItem();
                }
                this.selectedCanvas.setSelectedItem(null);
                this.selectedCanvas.setCurrentItem(null);
                this.selectedCanvas.repaint();
            }
            this.selectedCanvas = hotCanvas;
        }
        if (hotCanvas instanceof BrowserListCanvas) {
            boolean bl;
            Folder folder;
            String string = this.properties.getProperty("hotlist.netscape");
            if (listItem != null) {
                this.readOnlyList = listItem.text.equals(string);
            }
            ListItem listItem3 = ((BrowserListCanvas)this.selectedCanvas).previousSelection();
            listItem2 = this.selectedCanvas.getSelectedItem();
            if (listItem3 == null) {
                listItem3 = this.storeSelection;
            }
            if (listItem2 != listItem3 && listItem3 instanceof Folder && (folder = (Folder)listItem3) != null && !(bl = folder.closed())) {
                folder.setContainerState(!bl);
            }
        }
        this.setMenuItemStates(listItem);
    }

    public void setMenuItemStates(ListItem listItem) {
        block8: {
            block5: {
                block7: {
                    block6: {
                        if (listItem == null) break block5;
                        this.updateEditing();
                        this.enableSorting(true);
                        this.enableRename(true);
                        if (!(listItem instanceof Folder)) break block6;
                        PageFolder pageFolder = ((Folder)listItem).getPageFolder();
                        if (pageFolder.getSortType() == 0) {
                            this.enableReverseSort(false);
                            return;
                        }
                        break block7;
                    }
                    if (listItem instanceof Bookmark) {
                        this.enableSorting(false);
                        return;
                    }
                    if (!(listItem instanceof EntrySeparator)) break block8;
                    this.enableSorting(false);
                    this.enableRename(false);
                }
                return;
            }
            this.enableSorting(false);
        }
    }

    public void sort(int n) {
        if (this.selectedCanvas == null) {
            return;
        }
        ListItem listItem = this.selectedCanvas.getSelectedItem();
        if (listItem == null) {
            String string = this.properties.getProperty("hotlistframe.sorterr.msg");
            this.setMessage(string);
            return;
        }
        if (!(listItem instanceof Folder)) {
            String string = this.properties.getProperty("hotlistframe.sorterr.msg");
            this.setMessage(string);
            return;
        }
        Folder folder = (Folder)listItem;
        PageFolder pageFolder = folder.getPageFolder();
        HotList.getHotList().sort(n, pageFolder);
        HotCanvas hotCanvas = this.getFolderPanel().getCanvas();
        this.updateCanvas(hotCanvas, folder);
        this.enableReverseSort(true);
        this.getHotList().exportHTMLFile();
    }

    public boolean displayList(Folder folder) {
        HotCanvas hotCanvas = frm.getFolderPanel().getCanvas();
        BrowserListCanvas browserListCanvas = (BrowserListCanvas)frm.getListPanel().getCanvas();
        boolean bl = folder.closed();
        if (!bl) {
            browserListCanvas.repaint();
            return true;
        }
        folder.setContainerState(!bl);
        ScrollPane scrollPane = frm.getFolderPanel().getFolderPane();
        scrollPane.setScrollPosition(0, 0);
        browserListCanvas.repaint();
        PageFolder pageFolder = folder.getPageFolder();
        hotCanvas.createInitialFolder(folder);
        bl = folder.closed();
        if (!bl) {
            hotCanvas.initialize(pageFolder);
        } else {
            hotCanvas.setMainContainer(null);
        }
        hotCanvas.repaint();
        scrollPane.doLayout();
        this.setListName(folder.getTitle());
        return true;
    }

    public void renameContainer(Folder folder, Frame frame) {
        Object object;
        String string = null;
        if (folder != null) {
            if (this.selectedCanvas instanceof BrowserListCanvas) {
                object = new String(".renamelist");
                String string2 = new String(".renamelistdialog.label");
                FolderDialog folderDialog = new FolderDialog(propName, (String)object, string2, this);
                folderDialog.setDefaultText(folder.getTitle());
                string = folderDialog.getFolderName();
            } else {
                object = new String(".renamefolder");
                String string3 = new String(".renamefolderdialog.label");
                FolderDialog folderDialog = new FolderDialog(propName, (String)object, string3, this);
                folderDialog.setDefaultText(folder.getTitle());
                string = folderDialog.getFolderName();
            }
        }
        if (string == null || string.equals("")) {
            return;
        }
        folder.setTitle(string);
        this.selectedCanvas.repaint();
        object = (PageFolder)folder.getHotListEntry();
        if (this.selectedCanvas instanceof BrowserListCanvas) {
            this.setListName(string);
        }
        this.getHotList().renameInMenus((HotListEntry)object, string, null);
        ((HotListEntry)object).setTitle(string);
        this.getHotList().exportHTMLFile();
    }

    public void renameBookmark(Bookmark bookmark, Frame frame) {
        String string = null;
        if (bookmark != null) {
            Webmark webmark = (Webmark)bookmark.getHotListEntry();
            String string2 = new String(".renameplace");
            String string3 = new String(".renameplacedialog.URLlabel");
            String string4 = new String(".renameplacedialog.titlelabel");
            BookmarkDialog bookmarkDialog = new BookmarkDialog(propName, string2, string3, string4, this);
            bookmarkDialog.setDefaultURL(webmark.getURL());
            bookmarkDialog.setDefaultTitle(bookmark.getTitle());
            string = bookmarkDialog.getPlaceName();
            if (string == null || string.equals("")) {
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|", false);
            String string5 = null;
            String string6 = null;
            while (stringTokenizer.hasMoreTokens()) {
                if (string5 == null) {
                    string5 = stringTokenizer.nextToken();
                    continue;
                }
                string6 = stringTokenizer.nextToken();
            }
            try {
                URLCanonicalizer uRLCanonicalizer = new URLCanonicalizer();
                string5 = uRLCanonicalizer.canonicalize(string5);
                URL uRL = new URL(null, string5);
                bookmark.setTitle(string6);
                this.selectedCanvas.repaint();
                String string7 = uRL.toExternalForm();
                frm.setMessage(string7);
                this.getHotList().renameInMenus(webmark, string6, string7);
                webmark.setURL(string7);
                webmark.setTitle(string6);
                this.getHotList().exportHTMLFile();
                return;
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                return;
            }
        }
    }

    public static boolean frameVisible() {
        return frm != null;
    }

    public static boolean isIconified() {
        return HotListFrame.frm.iconified;
    }

    /*
     * Unable to fully structure code
     */
    public void reInitialize(PageFolder var1_1, ListItem var2_2) {
        block3: {
            var3_3 = this.getFolderPanel().getCanvas();
            if (var1_1.getGrandParent() != null) ** GOTO lbl12
            var4_4 = (Folder)var2_2.getParentListContainer();
            var3_3.createInitialFolder(var4_4);
            var5_6 = var4_4.closed();
            if (!var5_6) {
                var3_3.initialize(var1_1);
            } else {
                var3_3.setMainContainer(null);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                var1_1 = var1_1.getParent();
lbl12:
                // 2 sources

                ** while (var1_1.getGrandParent() != null)
            }
lbl13:
            // 1 sources

            var4_5 = this.getListPanel().getCanvas();
            var3_3.createInitialFolder((Folder)var4_5.getMainContainer());
            var3_3.initialize(var1_1);
        }
        var3_3.repaint();
    }

    public void saveStateToProperties() {
        if (this.isShowing()) {
            Point point = this.getLocation();
            Dimension dimension = this.getToolkit().getScreenSize();
            if (point.x > dimension.width || point.y > dimension.height) {
                return;
            }
            if (point.x < 0 || point.y < 0) {
                return;
            }
            Dimension dimension2 = this.getSize();
            if (this.properties != null) {
                this.properties.put("hotlistframe.width", String.valueOf(dimension2.width));
                this.properties.put("hotlistframe.height", String.valueOf(dimension2.height));
                this.properties.put("hotlistframe.x", String.valueOf(point.x));
                this.properties.put("hotlistframe.y", String.valueOf(point.y));
                this.properties.save();
            }
        }
    }

    public void closeFrame() {
        HotList.getHotList().exportHTMLFile();
        this.saveStateToProperties();
        this.dispose();
        frm = null;
    }

    public void setBoundsForFrame() {
        Dimension dimension = this.getSize();
        dimension.width = Integer.parseInt(this.properties.getProperty("hotlistframe.width"));
        dimension.height = Integer.parseInt(this.properties.getProperty("hotlistframe.height"));
        int n = Integer.parseInt(this.properties.getProperty("hotlistframe.x"));
        int n2 = Integer.parseInt(this.properties.getProperty("hotlistframe.y"));
        ((Component)this).setBounds(n, n2, dimension.width, dimension.height);
    }

    private void enableItem(String string, boolean bl) {
        MenuItem menuItem = this.hotlistframemenubar.getMenuItem(string);
        if (menuItem != null) {
            menuItem.setEnabled(bl);
        }
    }

    public void enableCutCopyRename(boolean bl) {
        this.enableItem("delete", !this.readOnlyList && bl);
        this.enableItem("cut", !this.readOnlyList && bl);
        this.enableItem("rename", !this.readOnlyList && bl);
        this.enableItem("copy", bl);
    }

    public void updatePaste() {
        this.enableItem("paste", !this.readOnlyList && this.buffer.canPaste());
    }

    public void updateUndo() {
        this.enableItem("undo", !this.readOnlyList && this.buffer.canUndo());
    }

    public void enableReverseSort(boolean bl) {
        this.enableItem("reverse", bl);
    }

    public void enableRename(boolean bl) {
        this.enableItem("rename", !this.readOnlyList && bl);
    }

    public void updateEditing() {
        this.updatePaste();
        this.updateUndo();
        this.enableCutCopyRename(true);
        this.enableItem("newfolder", !this.readOnlyList);
        this.enableItem("newplace", !this.readOnlyList);
        this.enableItem("newseparator", !this.readOnlyList);
    }

    public void enableSorting(boolean bl) {
        this.enableItem("atoz", bl);
        this.enableItem("date", bl);
        this.enableItem("frequent", bl);
        this.enableItem("reverse", bl);
    }

    protected class DnDListener
    implements DragAndDropListener {
        public void dragAndDropPerformed(DragAndDropEvent dragAndDropEvent) {
            HotListFrame.this.processDragAndDropEvent(dragAndDropEvent);
        }

        protected DnDListener() {
            HotListFrame.this = HotListFrame.this;
        }
    }

    private final class ActionEventsListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = (actionEvent.getModifiers() & 1) != 0;
            HotListFrame.this.action(actionEvent, actionEvent.getActionCommand(), bl);
        }

        ActionEventsListener() {
            HotListFrame.this = HotListFrame.this;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowIconified(WindowEvent windowEvent) {
            HotListFrame.this.setTitle(HotListFrame.this.title);
            HotListFrame.this.iconified = true;
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            HotListFrame.this.setTitle(HotListFrame.this.title);
            HotListFrame.this.iconified = false;
        }

        public void windowClosing(WindowEvent windowEvent) {
            HotListFrame.this.closeFrame();
        }

        public void windowOpened(WindowEvent windowEvent) {
            HotListFrame.this.setBoundsForFrame();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends MouseAdapter {
        public void mouseReleased(MouseEvent mouseEvent) {
            HotListFrame.this.processMouseEvent(mouseEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            HotListFrame.this.processMouseEvent(mouseEvent);
        }

        /* synthetic */ 3() {
        }
    }
}

