/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import sunw.hotjava.ui.ActivityMonitor;
import sunw.hotjava.ui.ClockPanel;
import sunw.hotjava.ui.InstrumentPanelControls;
import sunw.hotjava.ui.InstrumentPanelLayout;
import sunw.hotjava.ui.InstrumentPanelLocator;
import sunw.hotjava.ui.InstrumentPanelMessageLine;
import sunw.hotjava.ui.Locator;
import sunw.hotjava.ui.MessageLine;
import sunw.hotjava.ui.RaisedPanel;
import sunw.hotjava.ui.Toolbar;

public class InstrumentPanel
extends RaisedPanel {
    InstrumentPanelControls controls;
    InstrumentPanelLocator locatorBox;
    InstrumentPanelMessageLine messageBox;
    boolean hasClock = false;

    public InstrumentPanel() {
        this.setLayout(new InstrumentPanelLayout());
    }

    protected InstrumentPanelControls getControls() {
        if (this.controls == null) {
            this.controls = new InstrumentPanelControls("left");
            this.add(this.controls);
        }
        return this.controls;
    }

    protected InstrumentPanelLocator getLocatorBox() {
        if (this.locatorBox == null) {
            this.locatorBox = new InstrumentPanelLocator();
            this.add(this.locatorBox);
        }
        return this.locatorBox;
    }

    protected InstrumentPanelMessageLine getMessageBox() {
        if (this.messageBox == null) {
            this.messageBox = new InstrumentPanelMessageLine();
            this.add(this.messageBox);
        }
        return this.messageBox;
    }

    public boolean isEmpty() {
        return !(this.controls != null && this.haveControls() || this.locatorBox != null && this.hasLocator() || this.messageBox != null && this.hasMessageLine()) && !this.hasClock;
    }

    public boolean hasLocator() {
        return this.locatorBox != null && this.locatorBox.hasLocator();
    }

    public boolean hasMessageLine() {
        return this.messageBox != null && this.messageBox.hasMessageLine();
    }

    public boolean haveControls() {
        return this.controls != null && (this.controls.haveToolbars() || this.controls.hasActivityMonitor());
    }

    public boolean haveToolbars() {
        return this.controls != null && this.controls.haveToolbars();
    }

    public boolean hasClock() {
        return this.messageBox != null && this.messageBox.hasClock();
    }

    public boolean hasActivityMonitor() {
        return this.controls != null && this.controls.hasActivityMonitor() || this.locatorBox != null && this.locatorBox.hasActivityMonitor() || this.messageBox != null && this.messageBox.hasActivityMonitor();
    }

    public void add(InstrumentPanelControls instrumentPanelControls) {
        this.invalidate();
        this.add("Controls", instrumentPanelControls);
        this.validate();
    }

    public void add(InstrumentPanelLocator instrumentPanelLocator) {
        this.invalidate();
        this.add("LocatorBox", instrumentPanelLocator);
        this.validate();
    }

    public void add(InstrumentPanelMessageLine instrumentPanelMessageLine) {
        this.invalidate();
        this.add("MessageBox", instrumentPanelMessageLine);
        this.validate();
    }

    public void add(Toolbar toolbar) {
        this.invalidate();
        if (!this.haveControls() && this.hasLocator() && this.locatorBox.hasActivityMonitor()) {
            this.moveActivityMonitorLocatorToControls();
        }
        this.getControls().add(toolbar);
        this.validate();
    }

    public void add(ClockPanel clockPanel) {
        this.invalidate();
        this.getMessageBox().add(clockPanel);
        this.validate();
    }

    public void add(ActivityMonitor activityMonitor) {
        this.invalidate();
        if (this.haveControls()) {
            this.controls.add(activityMonitor);
        } else if (this.hasLocator()) {
            this.locatorBox.add(activityMonitor);
        } else {
            this.getControls().getPreferredSize();
            this.getControls().add(activityMonitor);
        }
        this.validate();
    }

    public void add(Locator locator) {
        this.invalidate();
        InstrumentPanelLocator instrumentPanelLocator = this.getLocatorBox();
        instrumentPanelLocator.add(locator);
        this.validate();
    }

    public void add(MessageLine messageLine) {
        this.invalidate();
        InstrumentPanelMessageLine instrumentPanelMessageLine = this.getMessageBox();
        instrumentPanelMessageLine.add(messageLine);
        this.validate();
    }

    public Toolbar removeToolbar(Toolbar toolbar) {
        Toolbar toolbar2 = toolbar;
        this.invalidate();
        if (this.haveControls()) {
            this.controls.remove(toolbar);
            if (!this.haveToolbars() && this.controls.hasActivityMonitor() && this.hasLocator()) {
                this.moveActivityMonitorControlsToLocator();
            }
        }
        this.validate();
        return toolbar2;
    }

    public Locator removeLocator() {
        Locator locator = null;
        this.invalidate();
        if (this.locatorBox != null && this.locatorBox.hasLocator()) {
            locator = this.locatorBox.removeLocator();
        }
        this.validate();
        return locator;
    }

    public MessageLine removeMessageLine() {
        MessageLine messageLine = null;
        this.invalidate();
        if (this.messageBox != null && this.messageBox.hasMessageLine()) {
            messageLine = this.messageBox.removeMessageLine();
        }
        this.validate();
        return messageLine;
    }

    public ActivityMonitor removeActivityMonitor() {
        ActivityMonitor activityMonitor = null;
        this.invalidate();
        if (this.controls != null && this.controls.hasActivityMonitor()) {
            activityMonitor = this.controls.removeActivityMonitor();
        } else if (this.locatorBox != null && this.locatorBox.hasActivityMonitor()) {
            activityMonitor = this.locatorBox.removeActivityMonitor();
        } else if (this.messageBox != null && this.messageBox.hasActivityMonitor()) {
            activityMonitor = this.messageBox.removeActivityMonitor();
        }
        this.validate();
        return activityMonitor;
    }

    public ClockPanel removeClock() {
        Container container;
        Component component = null;
        this.invalidate();
        if (this.messageBox != null && this.messageBox.hasClock()) {
            component = this.messageBox.removeClock();
        }
        if (component != null && (container = component.getParent()) != null) {
            container.remove(component);
        }
        this.validate();
        return component;
    }

    public void checkClock(String string) {
        if (string != null && "on".equalsIgnoreCase(string)) {
            if (!this.hasClock()) {
                this.startClock();
                this.setVisible(true);
                return;
            }
        } else {
            this.stopClock();
        }
    }

    protected void startClock() {
        ClockPanel clockPanel = new ClockPanel(this.getParent().getFont());
        this.add(clockPanel);
        clockPanel.start();
        this.hasClock = true;
    }

    protected void stopClock() {
        ClockPanel clockPanel = this.removeClock();
        if (clockPanel != null) {
            clockPanel.stop();
        }
        this.hasClock = false;
    }

    protected void moveActivityMonitorLocatorToControls() {
        ActivityMonitor activityMonitor = this.locatorBox.removeActivityMonitor();
        if (activityMonitor != null) {
            this.getControls().add(activityMonitor);
        }
    }

    protected void moveActivityMonitorControlsToLocator() {
        ActivityMonitor activityMonitor = this.controls.removeActivityMonitor();
        if (activityMonitor != null) {
            this.getLocatorBox().add(activityMonitor);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }
}

