/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import sunw.hotjava.misc.HJBProperties;

class MessageBox
extends Window {
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");
    private String message;
    private Point location;
    private Font font = this.properties.getFont("hotjava.timedMessage.font", new Font("SansSerif", 0, 10));
    private FontMetrics fm = this.getFontMetrics(this.font);
    private static final int hMargin = 4;
    private static final int vMargin = 4;
    private Image offScreenImage;

    MessageBox(Frame frame, String string, Point point) {
        super(frame);
        this.message = string;
        this.location = point;
        if ("".equals(this.message)) {
            this.dispose();
            return;
        }
        Dimension dimension = this.measureMessage(string);
        dimension.width += 8;
        dimension.height += 8;
        this.setEnabled(false);
        ((Component)this).setSize(dimension);
        ((Component)this).setLocation(point.x, point.y);
        this.offScreenImage = frame.createImage(dimension.width, dimension.height);
        this.prepareMessage();
        ((Component)this).setBackground(this.properties.getColor("hotjava.timedMessage.color", Color.yellow));
        ((Component)this).setVisible(true);
    }

    private Dimension measureMessage(String string) {
        Dimension dimension = new Dimension();
        dimension.width = this.fm.stringWidth(string);
        dimension.height = this.fm.getHeight();
        return dimension;
    }

    private void prepareMessage() {
        Graphics graphics = this.offScreenImage.getGraphics();
        Dimension dimension = this.getSize();
        try {
            graphics.setColor(this.properties.getColor("hotjava.timedMessage.color", Color.yellow));
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(Color.black);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setFont(this.font);
            graphics.drawString(this.message, 4, 4 + this.fm.getAscent());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var4_3 = null;
        graphics.dispose();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.offScreenImage, 0, 0, null);
    }
}

