/*
 * Decompiled with CFR 0.152.
 */
package sunw.html;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import sunw.html.AttributeList;
import sunw.html.Attributes;
import sunw.html.ContentModel;
import sunw.html.ContentModelState;
import sunw.html.DTD;
import sunw.html.DTDConstants;
import sunw.html.Element;
import sunw.html.Entity;
import sunw.html.IncorrectReaderException;
import sunw.html.Tag;
import sunw.html.TagStack;
import sunw.html.UnknownTag;

public class Parser
implements DTDConstants {
    private static final int BUFSIZE = 1024;
    private static final byte[] notext = new byte[0];
    private char[] text = new char[1024];
    private int textpos;
    private Tag last;
    private boolean space;
    private boolean verbose;
    private boolean modeXMP = false;
    private static final boolean debugTime = false;
    private static final boolean debugTimeTags = false;
    private char[] str = new char[128];
    private int strpos;
    protected Properties props;
    protected DTD dtd;
    private int ch;
    private int ln;
    private Reader in;
    private Element recent;
    protected TagStack stack;
    private boolean skipTag = false;
    private boolean parsingScript = false;
    private boolean ignoringInterrupts = false;
    private boolean seenHtml;
    private boolean seenHead;
    private boolean seenBody;
    protected boolean isFramed = false;
    protected boolean isNonFramed = false;
    private boolean ignoreFormEnd = false;
    private boolean formNeedsPlacing = false;
    private boolean needAngleBracket = false;
    private Stack overlapTags = new Stack();
    private boolean haveOverlaps = false;
    private final char[] map = new char[]{',', '\u0192', '\u201d', '\u2026', '\u2020', '\u2021', '^', '\u2030', '_', '<', '\u0152', '\u008d', '\u008e', '\u008f', '\u0090', '`', '\'', '\u201c', '\u201d', '\u2022', '\u2014', '\u2013', '~', '\u2122', '_', '>', '\u0153', '\u009d', '\u009e', '\u0178'};
    private char[] buf = new char[1024];
    private int pos;
    private int len;
    private StringBuffer interruptBuffer;
    private int interruptPosition;

    protected int getCurrentLine() {
        return this.ln;
    }

    protected char[] getText() {
        return this.text;
    }

    protected String getTextAsString() {
        return new String(this.text, 0, this.textpos);
    }

    protected boolean isInContext(String string) {
        TagStack tagStack = this.stack;
        while (tagStack != null && !tagStack.elem.getName().equals(string)) {
            tagStack = tagStack.next;
        }
        return tagStack != null;
    }

    protected Tag makeTag(Element element, Attributes attributes) {
        return new UnknownTag(element, attributes);
    }

    private void handleText(char[] cArray) {
        this.handleText(cArray, null);
    }

    protected void handleText(char[] cArray, Tag tag) {
        Thread.dumpStack();
        System.out.println("##Parser.handleText: ");
    }

    protected void handleTitle(char[] cArray, Tag tag) {
        this.handleText(cArray, tag);
    }

    protected void handleCommentOrScript(char[] cArray) {
    }

    protected void handleEOFInComment() {
        int n = this.strIndexOf('\n');
        if (n >= 0) {
            this.handleCommentOrScript(this.getChars(0, n));
            try {
                this.in.close();
                this.in = new CharArrayReader(this.getChars(n + 1));
                this.ch = 62;
            }
            catch (IOException iOException) {
                this.error("ioexception");
            }
            this.resetStrBuffer();
            return;
        }
        this.error("eof.comment");
    }

    protected void handleEmptyTag(Tag tag) throws IncorrectReaderException {
    }

    protected void handleStartTag(Tag tag) {
        System.out.println("##handleStartTag: " + tag);
    }

    protected void handleBodyTagAttributes(Attributes attributes) {
    }

    protected void handleFormTagInTable(Tag tag) {
    }

    protected void handleEndTag(Tag tag) {
    }

    protected void handleError(int n, String string) {
        System.out.println("**** " + this.stack);
        System.out.println("line " + n + ": error: " + string);
        System.out.println();
    }

    private void handleText(Tag tag) {
        char[] cArray;
        if (tag.isBlock()) {
            this.space = false;
        }
        if (!(this.textpos != 0 || this.space && this.stack != null && !this.last.isBlock() && this.stack.advance(this.dtd.pcdata))) {
            this.last = tag;
            this.space = false;
            return;
        }
        if (this.space) {
            if (this.textpos + 1 > this.text.length) {
                cArray = new char[this.text.length + 200];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = 32;
            this.space = false;
        }
        cArray = new char[this.textpos];
        System.arraycopy(this.text, 0, cArray, 0, this.textpos);
        if (tag.getElement().getName().equals("title")) {
            this.handleTitle(cArray, tag);
        } else {
            this.handleText(cArray, tag);
        }
        this.textpos = 0;
        this.last = tag;
        this.space = false;
    }

    protected void error(String string, String string2, String string3, String string4) {
        this.handleError(this.ln, String.valueOf(string) + string2 + string3 + string4);
    }

    protected void error(String string, String string2, String string3) {
        this.error(string, string2, string3, "?");
    }

    protected void error(String string, String string2) {
        this.error(string, string2, "?", "?");
    }

    protected void error(String string) {
        this.error(string, "?", "?", "?");
    }

    protected Tag getEnclosingForm() {
        TagStack tagStack = this.stack;
        while (tagStack != null && !tagStack.elem.getName().equals("form")) {
            tagStack = tagStack.next;
        }
        if (tagStack != null) {
            return tagStack.tag;
        }
        return null;
    }

    protected void startTag(Tag tag) throws IncorrectReaderException {
        Element element = tag.getElement();
        Attributes attributes = tag.getAttributes();
        if (!(this.isNonFramed || this.isFramed || this.stack == null || this.stack.elem != this.dtd.body || element.getName().equals("frameset") || element.getName().equals("noscript") || element.getName().equals("script"))) {
            this.isNonFramed = true;
        }
        this.handleText(tag);
        AttributeList attributeList = element.atts;
        while (attributeList != null) {
            if (attributeList.modifier == 2 && (attributes == null || attributes.get(attributeList.name) == null)) {
                this.error("req.att", attributeList.getName(), element.getName());
            }
            attributeList = attributeList.next;
        }
        if (element.isEmpty()) {
            this.handleEmptyTag(tag);
        } else {
            this.recent = element;
            this.stack = new TagStack(tag, this.stack);
            this.handleStartTag(tag);
        }
        if (this.haveOverlaps) {
            this.haveOverlaps = false;
            while (!this.overlapTags.empty()) {
                Tag tag2 = (Tag)this.overlapTags.pop();
                if (!this.needToReopenTag(tag, tag2) || !this.stack.advance(tag2.getElement())) continue;
                this.startTag(this.makeTag(tag2.getElement(), tag2.getAttributes()));
            }
        }
    }

    protected boolean needToReopenTag(Tag tag, Tag tag2) {
        return false;
    }

    protected void endTag(boolean bl) {
        this.handleText(this.stack.tag);
        if (bl && !this.stack.elem.omitEnd()) {
            this.error("end.missing", this.stack.elem.getName());
        } else if (!this.stack.terminate()) {
            this.error("end.unexpected", this.stack.elem.getName());
        }
        this.handleEndTag(this.stack.tag);
        this.stack = this.stack.next;
        this.recent = this.stack != null ? this.stack.elem : null;
    }

    private boolean ignoreElement(Element element) {
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (string2.equals("html") && this.seenHtml || string2.equals("head") && this.seenHead || string2.equals("body") && this.seenBody) {
            return true;
        }
        if (string2.equals("dt") || string2.equals("dd")) {
            TagStack tagStack = this.stack;
            while (tagStack != null && !tagStack.elem.getName().equals("dl")) {
                tagStack = tagStack.next;
            }
            if (tagStack == null) {
                return true;
            }
        }
        return string2.equals("font") && (string.equals("ul") || string.equals("ol")) || string2.equals("meta") && this.stack != null && !string.equals("html") || string2.equals("style") || string.equals("frameset");
    }

    protected void setTableSurroundedByForm(Tag tag) {
    }

    protected void incrementNumberFormsToEnd(Tag tag) {
    }

    protected void checkForSurroundedTable(Element element, Tag tag) {
    }

    protected void doNecessarySurroundedTableCleanup() {
    }

    protected void markFirstTime(Element element) {
        String string = element.getName();
        if (string.equals("html")) {
            this.seenHtml = true;
            return;
        }
        if (string.equals("head")) {
            this.seenHead = true;
            return;
        }
        if (string.equals("body")) {
            this.seenBody = true;
            return;
        }
        if (string.equals("frameset") && !this.isNonFramed) {
            this.isFramed = true;
        }
    }

    private boolean legalElementContext(Element element) throws IncorrectReaderException {
        DTDConstants dTDConstants;
        Object object;
        if (this.stack == null) {
            if (element != this.dtd.html) {
                this.startTag(this.makeTag(this.dtd.html, null));
                this.seenHtml = true;
                return this.legalElementContext(element);
            }
            return true;
        }
        if (this.isFramed && (object = new ContentModelState(this.dtd.frameset.getContent()).advance(element)) == null) {
            this.skipTag = true;
            return true;
        }
        if ((this.isNonFramed || this.textpos != 0 || this.isFramed && !this.stack.elem.getName().equals("frameset")) && element.getName().equals("frameset")) {
            this.isNonFramed = true;
            this.skipTag = true;
            return true;
        }
        if (element.getName().equals("form")) {
            object = this.stack;
            while (object != null && !((TagStack)object).elem.getName().equals("table")) {
                object = ((TagStack)object).next;
            }
            if (object != null) {
                this.setTableSurroundedByForm(((TagStack)object).tag);
                this.ignoreFormEnd = true;
                this.formNeedsPlacing = true;
                return true;
            }
        }
        if (this.stack.elem == this.dtd.head && element == this.dtd.head) {
            this.skipTag = true;
            return true;
        }
        if (this.stack.advance(element)) {
            this.markFirstTime(element);
            return true;
        }
        if (element.getName().equals("frame")) {
            this.skipTag = true;
            return false;
        }
        boolean bl = false;
        String string = this.stack.elem.getName();
        String string2 = element.getName();
        if (string2.equals("script")) {
            return true;
        }
        if (string.equals("table") && string2.equals("td") || string.equals("table") && string2.equals("th") || string.equals("tr") && !string2.equals("tr")) {
            bl = true;
        }
        if (!bl && (this.stack.elem.getName() != element.getName() || element.getName().equals("body") || element.getName().equals("table")) && (this.skipTag = this.ignoreElement(element))) {
            this.error("tag.ignore", element.getName());
            return this.skipTag;
        }
        if (!(!string.equals("table") || string2.equals("tr") || string2.equals("td") || string2.equals("th") || string2.equals("caption"))) {
            Element element2 = this.dtd.getElement("td");
            Tag tag = this.makeTag(element2, null);
            this.legalTagContext(tag);
            this.startTag(tag);
            this.error("start.missing", element.getName());
            return this.legalElementContext(element);
        }
        if (string.equals("option") && !string2.equals("option")) {
            this.skipTag = true;
            return this.skipTag;
        }
        boolean bl2 = false;
        if (!bl && this.stack.terminate()) {
            dTDConstants = this.stack.next;
            while (dTDConstants != null) {
                if (((TagStack)dTDConstants).advance(element)) {
                    while (this.stack != dTDConstants) {
                        this.overlapTags.push(this.stack.tag);
                        this.haveOverlaps = true;
                        this.endTag(true);
                    }
                    return true;
                }
                if (!((TagStack)dTDConstants).terminate() || ((TagStack)dTDConstants).next == null) {
                    bl2 = true;
                    break;
                }
                dTDConstants = ((TagStack)dTDConstants).next;
            }
        }
        if (this.stack != null && this.stack.elem.getName().equalsIgnoreCase("select") && element.getName().equalsIgnoreCase("#pcdata")) {
            return false;
        }
        dTDConstants = this.stack.first();
        if (!(dTDConstants == null || dTDConstants == this.dtd.head && element == this.dtd.pcdata || dTDConstants == this.dtd.head && element == this.dtd.script)) {
            Tag tag = this.makeTag((Element)dTDConstants, null);
            this.legalTagContext(tag);
            this.startTag(tag);
            if (!((Element)dTDConstants).omitStart()) {
                this.error("start.missing", element.getName());
            }
            return this.legalElementContext(element);
        }
        ContentModel contentModel = this.stack.contentModel();
        Vector vector = new Vector();
        if (contentModel != null) {
            contentModel.getElements(vector);
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                ContentModel contentModel2;
                Element element3 = (Element)enumeration.nextElement();
                if (this.stack.excluded(element3.getIndex())) continue;
                boolean bl3 = false;
                AttributeList attributeList = element3.getAttributes();
                while (attributeList != null) {
                    if (attributeList.modifier == 2) {
                        bl3 = true;
                        break;
                    }
                    attributeList = attributeList.next;
                }
                if (bl3 || (contentModel2 = element3.getContent()) == null || !contentModel2.first(element)) continue;
                Tag tag = this.makeTag(element3, null);
                this.legalTagContext(tag);
                this.startTag(tag);
                this.error("start.missing", element3.getName());
                return this.legalElementContext(element);
            }
        }
        if (bl2 && this.seenBody) {
            this.skipTag = true;
            return true;
        }
        if (this.stack.terminate() && this.stack.elem != this.dtd.body) {
            if (!this.stack.elem.omitEnd()) {
                this.error("end.missing", element.getName());
            }
            this.endTag(true);
            return this.legalElementContext(element);
        }
        return false;
    }

    private void legalTagContext(Tag tag) throws IncorrectReaderException {
        this.skipTag = false;
        if (this.legalElementContext(tag.getElement())) {
            this.markFirstTime(tag.getElement());
            return;
        }
        if (tag.isBlock() && this.stack != null && !this.stack.tag.isBlock()) {
            this.endTag(true);
            this.legalTagContext(tag);
            return;
        }
        TagStack tagStack = this.stack;
        while (tagStack != null) {
            if (tagStack.tag.getElement() == this.dtd.head) {
                while (this.stack != tagStack) {
                    this.endTag(true);
                }
                this.endTag(true);
                this.legalTagContext(tag);
                return;
            }
            tagStack = tagStack.next;
        }
        this.error("tag.unexpected", tag.getElement().getName());
    }

    private void errorContext() throws IncorrectReaderException {
        while (this.stack != null && this.stack.tag.getElement() != this.dtd.body) {
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        if (this.stack == null) {
            this.legalElementContext(this.dtd.body);
            this.startTag(this.makeTag(this.dtd.body, null));
        }
    }

    private void addString(int n) {
        if (this.strpos == this.str.length) {
            char[] cArray = new char[this.str.length + 128];
            System.arraycopy(this.str, 0, cArray, 0, this.str.length);
            this.str = cArray;
        }
        this.str[this.strpos++] = (char)n;
    }

    private String getString(int n) {
        int n2 = this.strpos - n;
        this.strpos = n;
        return new String(this.str, n, n2);
    }

    private char[] getChars(int n) {
        char[] cArray = new char[this.strpos - n];
        System.arraycopy(this.str, n, cArray, 0, this.strpos - n);
        this.strpos = n;
        return cArray;
    }

    private char[] getChars(int n, int n2) {
        char[] cArray = new char[n2 - n];
        System.arraycopy(this.str, n, cArray, 0, n2 - n);
        return cArray;
    }

    private void resetStrBuffer() {
        this.strpos = 0;
    }

    private int strIndexOf(char c) {
        int n = 0;
        while (n < this.strpos) {
            if (this.str[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void skipSpace() throws IOException {
        block5: while (true) {
            switch (this.ch) {
                case 10: {
                    ++this.ln;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block5;
                }
                case 13: {
                    ++this.ln;
                    int n = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch != 10) continue block5;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block5;
                }
                case 9: 
                case 32: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block5;
                }
            }
            break;
        }
    }

    private void skipTillAttributeEnd() throws IOException {
        while (!Character.isLetter((char)this.ch)) {
            switch (this.ch) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 60: 
                case 62: {
                    return;
                }
            }
            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseIdentifier(boolean var1_1) throws IOException {
        var2_2 = this.str.length;
        if (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90) ** GOTO lbl12
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1 && this.ch >= 65 && this.ch <= 90) {
                this.ch = 97 + (this.ch - 65);
            }
            if (this.strpos < var2_2) {
                this.str[this.strpos++] = (char)this.ch;
            } else {
                this.addString(this.ch);
                var2_2 = this.str.length;
            }
            v0 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
lbl12:
            // 2 sources

            ** while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch >= 48 && this.ch <= 57 || this.ch == 46 || this.ch == 45 || this.ch == 95)
        }
lbl13:
        // 1 sources

        return true;
    }

    protected char[] handleScript(char[] cArray, String string) {
        return null;
    }

    private char[] parseEntityReference() throws IOException {
        int n = this.strpos;
        int n2 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        if (this.ch == 35) {
            int n3 = 0;
            int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
            if (this.ch >= 48 && this.ch <= 57) {
                while (this.ch >= 48 && this.ch <= 57) {
                    n3 = n3 * 10 + this.ch - 48;
                    int n5 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
                switch (this.ch) {
                    case 10: {
                        ++this.ln;
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        break;
                    }
                    case 13: {
                        ++this.ln;
                        int n6 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        if (this.ch != 10) break;
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        break;
                    }
                    case 59: {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        break;
                    }
                }
                if (n3 > 129 && n3 < 160) {
                    n3 = this.map[n3 - 130];
                }
                char[] cArray = new char[]{(char)n3};
                return cArray;
            }
            this.addString(35);
            if (!this.parseIdentifier(false)) {
                this.error("ident.expected");
                this.strpos = n;
                char[] cArray = new char[]{'&', '#'};
                return cArray;
            }
        } else {
            if (this.ch == 123) {
                StringBuffer stringBuffer = new StringBuffer();
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                while (this.ch != 125) {
                    stringBuffer.append((char)this.ch);
                    int n7 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
                int n8 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                if (this.ch == 59) {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
                return this.handleScript(stringBuffer.toString().toCharArray(), null);
            }
            if (!this.parseIdentifier(false)) {
                char[] cArray = new char[]{'&'};
                return cArray;
            }
        }
        switch (this.ch) {
            case 10: {
                ++this.ln;
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                break;
            }
            case 13: {
                ++this.ln;
                int n9 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                if (this.ch != 10) break;
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                break;
            }
            case 59: {
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                break;
            }
        }
        String string = this.getString(n);
        Entity entity = this.dtd.getEntity(string);
        if (entity == null) {
            entity = this.dtd.getEntity(string.toLowerCase());
        }
        if (entity == null || !entity.isGeneral()) {
            Object object;
            String string2 = null;
            if (this.props == null || !this.matchesInterestedType() || (string2 = this.props.getProperty(string)) == null) {
                if (string.length() == 0) {
                    this.error("invalid.entref", string);
                    return new char[0];
                }
                object = null;
                if (this.props != null) {
                    object = (String)((Hashtable)this.props).get("url");
                }
                if (this.matchesInterestedType() || object != null && ((String)object).startsWith("doc")) {
                    if (this.props != null) {
                        string2 = this.props.getProperty(string);
                    }
                    if (string2 == null) {
                        string2 = System.getProperty(string);
                    }
                }
                if (string2 == null) {
                    string2 = "&" + string;
                }
            }
            object = new char[string2.length()];
            string2.getChars(0, ((Object)object).length, (char[])object, 0);
            return object;
        }
        return entity.getData();
    }

    private void parseComment() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (this.ch == 45) {
            ++n3;
            int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        }
        if (n3 > 1) {
            switch (this.ch) {
                case 62: {
                    return;
                }
                case 33: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch != 62) break;
                    return;
                }
            }
        }
        boolean bl2 = false;
        block13: while (true) {
            int n5 = this.ch;
            switch (n5) {
                case 45: {
                    if (bl) {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        break;
                    }
                    if (this.strpos != 0 && this.str[this.strpos - 1] == '-' || bl2) {
                        bl2 = false;
                        int n6 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        if (this.ch == 33) {
                            int n7 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            if (this.ch == 62) {
                                return;
                            }
                            if (n == 0) continue block13;
                            this.addString(45);
                            this.addString(33);
                            continue block13;
                        }
                        if (this.ch != 45 || n != 0) break;
                        bl2 = true;
                        break;
                    }
                    int n8 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch != 45) break;
                    int n9 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 62) {
                        return;
                    }
                    if (this.ch == 33) {
                        int n10 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        if (this.ch == 62) {
                            return;
                        }
                        if (n == 0) continue block13;
                        this.addString(45);
                        this.addString(33);
                        continue block13;
                    }
                    if (n != 0) {
                        this.addString(45);
                        break;
                    }
                    bl2 = true;
                    break;
                }
                case -1: {
                    this.handleEOFInComment();
                    return;
                }
                case 10: {
                    ++this.ln;
                    ++n;
                    bl = false;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    break;
                }
                case 62: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    break;
                }
                case 13: {
                    ++this.ln;
                    ++n;
                    bl = false;
                    int n11 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    }
                    n5 = 10;
                    break;
                }
                case 34: 
                case 39: {
                    if (n != 0) {
                        if (this.parsingScript) {
                            if (bl) {
                                if (n2 == n5) {
                                    bl = false;
                                }
                            } else {
                                n2 = n5;
                                bl = true;
                            }
                        }
                        this.addString(n5);
                    }
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block13;
                }
                default: {
                    int n12 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
            if (n == 0) continue;
            this.addString(n5);
        }
    }

    private char[] parseScript() throws IOException {
        this.parsingScript = true;
        while (true) {
            int n;
            if ((n = this.ch) == 60) {
                this.ch = this.readCh();
                if (this.ch == 33 && (this.ch = this.readCh()) == 45) {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    this.parseComment();
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue;
                }
                if (this.ch == 47) {
                    this.addString(n);
                    n = this.ch;
                    int n2 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 115 || this.ch == 83) {
                        this.addString(n);
                        n = this.ch;
                        int n3 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        if (this.ch == 99 || this.ch == 67) {
                            this.addString(n);
                            n = this.ch;
                            int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            if (this.ch == 114 || this.ch == 82) {
                                this.addString(n);
                                n = this.ch;
                                int n5 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                if (this.ch == 105 || this.ch == 73) {
                                    this.addString(n);
                                    n = this.ch;
                                    int n6 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                    if (this.ch == 112 || this.ch == 80) {
                                        this.addString(n);
                                        n = this.ch;
                                        int n7 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                        if (this.ch == 116 || this.ch == 84) {
                                            this.addString(n);
                                            n = this.ch;
                                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                            int n8 = 0;
                                            while (this.ch == 32 || this.ch == 10 || this.ch == 13) {
                                                this.addString(n);
                                                n = this.ch;
                                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                                ++n8;
                                            }
                                            if (this.ch == 62) {
                                                this.ch = 32;
                                                this.parsingScript = false;
                                                return this.getChars(0, this.strpos - "</scrip".length() - n8);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                int n9 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
            }
            if (n == -1) {
                this.parsingScript = false;
                return this.getChars(0);
            }
            this.addString(n);
        }
    }

    void parseLiteral(boolean bl) throws IOException {
        block7: while (true) {
            int n = this.ch;
            switch (n) {
                case -1: {
                    this.error("eof.literal", this.stack.elem.getName());
                    this.endTag(true);
                    return;
                }
                case 62: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    int n2 = this.textpos - (this.stack.elem.name.length() + 2);
                    int n3 = 0;
                    if (n2 < 0 || this.text[n2++] != '<' || this.text[n2] != '/') break;
                    while (++n2 < this.textpos && Character.toLowerCase(this.text[n2]) == this.stack.elem.name.charAt(n3++)) {
                    }
                    if (n2 != this.textpos) break;
                    this.textpos -= this.stack.elem.name.length() + 2;
                    if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                        --this.textpos;
                    }
                    if (this.stack.elem.name.equalsIgnoreCase("xmp")) {
                        this.modeXMP = false;
                    }
                    this.endTag(false);
                    return;
                }
                case 38: {
                    if (this.modeXMP) {
                        this.ch = this.readCh();
                        break;
                    }
                    char[] cArray = this.parseEntityReference();
                    if (this.textpos + cArray.length > this.text.length) {
                        char[] cArray2 = new char[Math.max(this.textpos + cArray.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray2, 0, this.text.length);
                        this.text = cArray2;
                    }
                    System.arraycopy(cArray, 0, this.text, this.textpos, cArray.length);
                    this.textpos += cArray.length;
                    continue block7;
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    break;
                }
                case 13: {
                    ++this.ln;
                    int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 10) {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    }
                    n = 10;
                    break;
                }
                default: {
                    int n5 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
            if (this.textpos == this.text.length) {
                char[] cArray = new char[this.text.length + 128];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            this.text[this.textpos++] = (char)n;
        }
    }

    private String parseAttributeValue(boolean bl) throws IOException {
        int n = -1;
        switch (this.ch) {
            case 34: 
            case 39: {
                n = this.ch;
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                break;
            }
        }
        block14: while (true) {
            int n2 = this.ch;
            switch (n2) {
                case 10: {
                    ++this.ln;
                    int n3 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 13: {
                    ++this.ln;
                    int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 10) {
                        int n5 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    }
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 9: {
                    if (n < 0) {
                        n2 = 32;
                    }
                }
                case 32: {
                    int n6 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (n >= 0) break;
                    return this.getString(0);
                }
                case 60: 
                case 62: {
                    if (n < 0) {
                        return this.getString(0);
                    }
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    break;
                }
                case 34: 
                case 39: {
                    int n7 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (n2 == n) {
                        this.skipTillAttributeEnd();
                        return this.getString(0).trim();
                    }
                    if (n != -1) break;
                    this.error("attvalerr");
                    break;
                }
                case 61: {
                    if (n < 0) {
                        this.error("attvalerr");
                    }
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    break;
                }
                case 38: {
                    char[] cArray = this.parseEntityReference();
                    int n8 = 0;
                    while (true) {
                        if (n8 >= cArray.length) continue block14;
                        n2 = cArray[n8];
                        this.addString(bl && n2 >= 65 && n2 <= 90 ? 97 + n2 - 65 : n2);
                        ++n8;
                    }
                }
                case -1: {
                    return this.getString(0);
                }
                default: {
                    if (bl && n2 >= 65 && n2 <= 90) {
                        n2 = 97 + n2 - 65;
                    }
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
            this.addString(n2);
        }
    }

    private Attributes parseAttributeSpecificationList(Element element) throws IOException {
        Attributes attributes = null;
        while (true) {
            String string;
            String string2;
            AttributeList attributeList;
            block19: {
                char[] cArray;
                block20: {
                    block21: {
                        block22: {
                            block17: {
                                block18: {
                                    this.skipSpace();
                                    switch (this.ch) {
                                        case -1: 
                                        case 60: 
                                        case 62: {
                                            return attributes;
                                        }
                                    }
                                    attributeList = null;
                                    string2 = null;
                                    string = null;
                                    if (!this.parseIdentifier(true)) break block17;
                                    string2 = this.getString(0);
                                    this.skipSpace();
                                    if (this.ch != 61) break block18;
                                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                    this.skipSpace();
                                    attributeList = element.getAttribute(string2);
                                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11 && attributeList.type != 7);
                                    break block19;
                                }
                                string = string2;
                                attributeList = element.getAttributeByValue(string);
                                if (attributeList != null || (attributeList = element.getAttribute(string2)) == null) break block19;
                                string = attributeList.getValue();
                                break block19;
                            }
                            if (this.ch == 44) {
                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                continue;
                            }
                            if (this.ch != 34) break block20;
                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            this.skipSpace();
                            if (!this.parseIdentifier(true)) break block21;
                            string2 = this.getString(0);
                            if (this.ch == 34) {
                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            }
                            this.skipSpace();
                            if (this.ch != 61) break block22;
                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            this.skipSpace();
                            attributeList = element.getAttribute(string2);
                            string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                            break block19;
                        }
                        string = string2;
                        attributeList = element.getAttributeByValue(string);
                        if (attributeList != null || (attributeList = element.getAttribute(string2)) == null) break block19;
                        string = attributeList.getValue();
                        break block19;
                    }
                    cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    if (this.ch == 62) continue;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue;
                }
                if (attributes == null && this.ch == 61) {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    this.skipSpace();
                    string2 = element.getName();
                    attributeList = element.getAttribute(string2);
                    string = this.parseAttributeValue(attributeList != null && attributeList.type != 1 && attributeList.type != 11);
                } else {
                    if (this.ch == 61) {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        this.skipSpace();
                        string = this.parseAttributeValue(true);
                        this.error("attvalerr");
                        return attributes;
                    }
                    cArray = new char[]{(char)this.ch};
                    this.error("invalid.tagchar", new String(cArray), element.getName());
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue;
                }
            }
            if (attributeList != null) {
                string2 = attributeList.getName();
            } else {
                this.error("invalid.tagatt", string2, element.getName());
            }
            if (attributes == null) {
                attributes = new Attributes();
            } else if (attributes.get(string2) != null) {
                this.error("multi.tagatt", string2, element.getName());
            }
            if (string == null) {
                string = attributeList != null && attributeList.value != null ? attributeList.value : "";
            } else if (attributeList != null && attributeList.values != null && !attributeList.values.contains(string)) {
                this.error("invalid.tagattval", string2, element.getName());
            }
            attributes.append(string2, string);
        }
    }

    public String parseDTDMarkup() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        block7: while (true) {
            switch (this.ch) {
                case 62: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    return stringBuffer.toString();
                }
                case -1: {
                    this.error("invalid.markup");
                    return stringBuffer.toString();
                }
                case 10: {
                    ++this.ln;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block7;
                }
                case 34: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block7;
                }
                case 13: {
                    ++this.ln;
                    int n = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch != 10) continue block7;
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    continue block7;
                }
            }
            stringBuffer.append((char)(this.ch & 0xFF));
            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        }
    }

    protected boolean parseMarkupDeclarations(StringBuffer stringBuffer) throws IOException {
        if (stringBuffer.length() == "DOCTYPE".length() && stringBuffer.toString().toUpperCase().equals("DOCTYPE")) {
            this.parseDTDMarkup();
            return true;
        }
        return false;
    }

    private void parseInvalidTag() throws IOException {
        while (true) {
            this.skipSpace();
            switch (this.ch) {
                case -1: 
                case 62: {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    return;
                }
                case 60: {
                    return;
                }
            }
            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseTag() throws IOException {
        var1_1 = null;
        var2_2 = false;
        var3_3 = false;
        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
        switch (this.ch) {
            case 33: {
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                switch (this.ch) {
                    case 45: {
                        block36: while (true) {
                            if (this.ch == 45) {
                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                this.parseComment();
                                this.handleCommentOrScript(this.getChars(0));
                                continue;
                            }
                            this.skipSpace();
                            switch (this.ch) {
                                case 45: {
                                    continue block36;
                                }
                                case 62: {
                                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                }
                                case -1: {
                                    return;
                                }
                            }
                            v0 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            if (var3_3) continue;
                            var3_3 = true;
                            this.error("invalid.commentchar", String.valueOf((char)this.ch));
                        }
                    }
                }
                var4_4 = new StringBuffer();
                block37: while (true) {
                    var4_4.append((char)this.ch);
                    if (this.parseMarkupDeclarations(var4_4)) {
                        return;
                    }
                    switch (this.ch) {
                        case 62: {
                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                        }
                        case -1: {
                            this.error("invalid.markup");
                            return;
                        }
                        case 10: {
                            ++this.ln;
                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            continue block37;
                        }
                        case 13: {
                            ++this.ln;
                            v1 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            if (this.ch != 10) continue block37;
                            this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            continue block37;
                        }
                    }
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
            case 47: {
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                switch (this.ch) {
                    case 62: {
                        this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    }
                    case 60: {
                        if (this.recent == null) {
                            this.error("invalid.shortend");
                            return;
                        }
                        var1_1 = this.recent;
                        break;
                    }
                    default: {
                        if (!this.parseIdentifier(true)) {
                            this.error("expected.endtagname");
                            return;
                        }
                        this.skipSpace();
                        switch (this.ch) {
                            case 62: {
                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                break;
                            }
                            default: {
                                this.error("expected", "'>'");
                                while (this.ch != -1 && this.ch != 10 && this.ch != 62) {
                                    v2 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                                }
                                if (this.ch != 62) break;
                                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                            }
                            case 60: 
                        }
                        var4_5 = this.getString(0);
                        if (!this.dtd.elementExists(var4_5)) {
                            this.error("end.unrecognized", var4_5);
                            if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                                --this.textpos;
                            }
                            return;
                        }
                        var1_1 = this.dtd.getElement(var4_5);
                    }
                }
                if (this.stack == null) {
                    this.error("end.extra.tag", var1_1.getName());
                    return;
                }
                if (this.textpos > 0 && this.text[this.textpos - 1] == '\n') {
                    if (this.stack.pre) {
                        if (this.textpos > 1 && this.text[this.textpos - 2] != '\n') {
                            --this.textpos;
                        }
                    } else {
                        --this.textpos;
                    }
                }
                var4_5 = this.stack.elem.getName();
                if (!var1_1.getName().equals("form")) ** GOTO lbl118
                var5_7 = this.stack;
                if (!this.ignoreFormEnd) ** GOTO lbl109
                this.ignoreFormEnd = false;
                while (var5_7 != null && !var5_7.elem.getName().equals("table")) {
                    var5_7 = var5_7.next;
                }
                if (var5_7 == null) ** GOTO lbl117
                this.incrementNumberFormsToEnd(var5_7.tag);
                return;
lbl-1000:
                // 1 sources

                {
                    var5_7 = var5_7.next;
lbl109:
                    // 2 sources

                    ** while (var5_7 != null && var1_1 != var5_7.elem)
                }
lbl110:
                // 1 sources

                if (var5_7 != null) ** GOTO lbl114
                return;
                while (!((var4_5 = this.stack.elem.getName()).equals("tr") || var4_5.equals("th") || var4_5.equals("td"))) {
                    this.endTag(true);
lbl114:
                    // 2 sources

                    if (this.stack != var5_7 && this.stack.elem.omitEnd()) continue;
                }
                if (this.stack.elem == var1_1) {
                    this.endTag(false);
                }
lbl117:
                // 4 sources

                return;
lbl118:
                // 1 sources

                if (var4_5.equals("table") && !var1_1.getName().equals(var4_5)) {
                    this.error("tag.ignore", var1_1.getName());
                    return;
                }
                if ((var4_5.equals("tr") || var4_5.equals("th") || var4_5.equals("td")) && !var1_1.getName().equals("table") && !var1_1.getName().equals(var4_5)) {
                    this.error("tag.ignore", var1_1.getName());
                    return;
                }
                var5_8 = this.stack;
                while (var5_8 != null && var1_1 != var5_8.elem) {
                    var5_8 = var5_8.next;
                }
                if (var5_8 == null) {
                    this.error("unmatched.endtag", var1_1.getName());
                    return;
                }
                var6_10 = var1_1.getName();
                if (this.stack == var5_8 || !var6_10.equals("font") && !var6_10.equals("center")) ** GOTO lbl147
                if (var6_10.equals("center")) {
                    var7_13 = this.stack;
                    while (var7_13 != var5_8) {
                        if ("table".equals(var7_13.elem.getName())) {
                            return;
                        }
                        var7_13 = var7_13.next;
                    }
                }
                while (this.stack.elem.omitEnd() && this.stack != var5_8) {
                    this.endTag(true);
                }
                if (this.stack.elem == var1_1) {
                    this.endTag(false);
                }
                return;
lbl-1000:
                // 1 sources

                {
                    this.endTag(true);
lbl147:
                    // 2 sources

                    ** while (this.stack != var5_8)
                }
lbl148:
                // 1 sources

                this.checkForSurroundedTable(var1_1, this.stack.tag);
                this.endTag(false);
                if (var1_1.getName().equals("table") && this.stack.elem.getName().equals("form")) {
                    this.doNecessarySurroundedTableCleanup();
                    this.ignoreFormEnd = false;
                }
                return;
            }
            case -1: {
                this.error("eof");
                return;
            }
        }
        if (!this.parseIdentifier(true)) {
            this.needAngleBracket = true;
            var1_1 = this.recent;
            if (this.ch != 62 || var1_1 == null) {
                this.error("expected.tagname");
                return;
            }
        } else {
            var4_6 = this.getString(0);
            if (var4_6.equals("image")) {
                var4_6 = new String("img");
            }
            if (!this.dtd.elementExists((String)var4_6)) {
                this.parseInvalidTag();
                this.error("tag.unrecognized", (String)var4_6);
                return;
            }
            var1_1 = this.dtd.getElement((String)var4_6);
        }
        var4_6 = this.parseAttributeSpecificationList(var1_1);
        switch (this.ch) {
            case 47: {
                var2_2 = true;
            }
            case 62: {
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                break;
            }
            default: {
                this.error("expected", "'>'");
            }
            case 60: 
        }
        if (!var1_1.isEmpty()) {
            if (this.ch == 10) {
                ++this.ln;
                this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
            } else if (this.ch == 13) {
                ++this.ln;
                v3 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                if (this.ch == 10) {
                    this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
        }
        var5_9 = this.makeTag(var1_1, (Attributes)var4_6);
        this.legalTagContext(var5_9);
        if (this.skipTag) {
            this.skipTag = false;
            if (var1_1 == this.dtd.body) {
                this.handleBodyTagAttributes((Attributes)var4_6);
            }
            return;
        }
        if (var1_1 == this.dtd.body) {
            this.isNonFramed = true;
        }
        if (this.formNeedsPlacing) {
            this.formNeedsPlacing = false;
            this.handleFormTagInTable(var5_9);
            var6_11 = this.stack;
            while (!var6_11.elem.getName().equals("table")) {
                var6_11 = var6_11.next;
            }
            var7_14 = var6_11.next;
            var6_11.next = var8_15 = new TagStack(var5_9, var7_14);
            return;
        }
        if (var1_1.getName().equalsIgnoreCase("xmp")) {
            this.modeXMP = true;
        }
        this.startTag(var5_9);
        if (!var1_1.isEmpty()) {
            switch (var1_1.getType()) {
                case 1: {
                    this.parseLiteral(false);
                    break;
                }
                case 16: {
                    this.parseLiteral(true);
                    break;
                }
                default: {
                    this.stack.net = var2_2;
                }
            }
            if (var1_1 == this.dtd.script) {
                var6_12 = this.parseScript();
                this.handleCommentOrScript(var6_12);
                this.endTag(true);
                this.resetStrBuffer();
            }
        }
    }

    private void parseContent() throws IOException {
        Thread thread = Thread.currentThread();
        block9: while (true) {
            char[] cArray;
            if (!this.ignoringInterrupts && thread.isInterrupted()) {
                thread.interrupt();
                return;
            }
            int n = this.ch;
            switch (n) {
                case 60: {
                    this.parseTag();
                    if (this.needAngleBracket && this.legalElementContext(this.dtd.pcdata)) break;
                    this.needAngleBracket = false;
                    continue block9;
                }
                case 47: {
                    int n2 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.stack == null || !this.stack.net) break;
                    this.endTag(false);
                    continue block9;
                }
                case -1: {
                    if (this.interruptBuffer != null) {
                        this.ch = this.readCh();
                        continue block9;
                    }
                    return;
                }
                case 38: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    if (this.textpos + (cArray = this.parseEntityReference()).length + 1 > this.text.length) {
                        char[] cArray2 = new char[Math.max(this.textpos + cArray.length + 128, this.text.length * 2)];
                        System.arraycopy(this.text, 0, cArray2, 0, this.text.length);
                        this.text = cArray2;
                    }
                    if (this.space) {
                        this.space = false;
                        this.text[this.textpos++] = 32;
                    }
                    System.arraycopy(cArray, 0, this.text, this.textpos, cArray.length);
                    this.textpos += cArray.length;
                    continue block9;
                }
                case 10: {
                    ++this.ln;
                    int n3 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 13: {
                    ++this.ln;
                    n = 10;
                    int n4 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.ch == 10) {
                        int n5 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    }
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                case 9: 
                case 32: {
                    int n6 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                    if (this.stack != null && this.stack.pre) break;
                    this.space = true;
                    continue block9;
                }
                default: {
                    if (this.textpos == 0) {
                        if (!this.legalElementContext(this.dtd.pcdata)) {
                            this.error("unexpected.pcdata");
                        }
                        if (this.last.isBlock()) {
                            this.space = false;
                        }
                    }
                    int n7 = this.ch = this.pos < this.len && this.interruptBuffer == null ? this.buf[this.pos++] : this.readCh();
                }
            }
            if (this.textpos + 2 > this.text.length) {
                cArray = new char[2 * this.text.length];
                System.arraycopy(this.text, 0, cArray, 0, this.text.length);
                this.text = cArray;
            }
            if (this.space) {
                this.text[this.textpos++] = 32;
                this.space = false;
            }
            if (this.needAngleBracket) {
                this.text[this.textpos++] = 60;
                this.needAngleBracket = false;
                continue;
            }
            this.text[this.textpos++] = (char)n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void parse(Reader reader, DTD dTD) throws IOException {
        this.in = reader;
        this.dtd = dTD;
        this.ln = 1;
        boolean bl = true;
        this.initDocumentState();
        try {
            block16: {
                try {
                    try {
                        try {
                            this.ch = this.readCh();
                            this.text = new char[1024];
                            this.str = new char[128];
                            this.parseContent();
                            while (this.stack != null) {
                                this.endTag(true);
                            }
                        }
                        catch (IncorrectReaderException incorrectReaderException) {
                            bl = false;
                            throw incorrectReaderException;
                        }
                        Object var7_5 = null;
                        if (!bl) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        if (!bl) throw throwable;
                        reader.close();
                        throw throwable;
                    }
                    reader.close();
                }
                catch (IncorrectReaderException incorrectReaderException) {
                    throw incorrectReaderException;
                }
                catch (IOException iOException) {
                    this.errorContext();
                    this.error("ioexception");
                    throw iOException;
                }
                catch (Exception exception) {
                    this.errorContext();
                    this.error("exception", exception.getClass().getName(), exception.getMessage());
                    exception.printStackTrace();
                }
                catch (ThreadDeath threadDeath) {
                    this.errorContext();
                    this.error("terminated");
                    throw threadDeath;
                }
            }
            Object var5_12 = null;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
        }
        while (true) {
            if (this.stack == null) {
                this.text = null;
                this.str = null;
                return;
            }
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
        while (true) {
            if (this.stack == null) {
                this.text = null;
                this.str = null;
                throw throwable;
            }
            this.handleEndTag(this.stack.tag);
            this.stack = this.stack.next;
        }
    }

    protected void interruptsIgnored(boolean bl) {
        this.ignoringInterrupts = bl;
    }

    private final int readCh() throws IOException {
        if (this.interruptBuffer != null) {
            if (this.interruptPosition >= this.interruptBuffer.length()) {
                this.interruptPosition = 0;
                this.interruptBuffer = null;
                return this.readCh();
            }
            char c = this.interruptBuffer.charAt(this.interruptPosition++);
            return c;
        }
        if (this.pos >= this.len) {
            while (true) {
                try {
                    this.len = this.in.read(this.buf);
                }
                catch (InterruptedIOException interruptedIOException) {
                    if (this.ignoringInterrupts) continue;
                    throw interruptedIOException;
                }
                break;
            }
            if (this.len <= 0) {
                return -1;
            }
            this.pos = 0;
        }
        return this.buf[this.pos++];
    }

    public void insertStringInDocument(String string) {
        if (this.interruptBuffer == null) {
            this.interruptBuffer = new StringBuffer(string.length() * 2);
        }
        this.interruptBuffer.append(string);
    }

    protected void resetParser() {
        this.pos = 0;
        this.len = 0;
        this.stack = null;
        this.strpos = 0;
        this.textpos = 0;
    }

    protected void initDocumentState() {
        this.seenHtml = false;
        this.seenHead = false;
        this.seenBody = false;
    }

    public void printImmediateDocContext() {
        this.printImmediateDocContext(5);
    }

    public void printImmediateDocContext(int n) {
    }

    public void printTagStack() {
        TagStack tagStack = this.stack;
        System.out.println("----------------------------");
        System.out.println("- Tag stack is");
        while (tagStack != null) {
            System.out.println("- <" + tagStack.elem.getName() + ">");
            tagStack = tagStack.next;
        }
        System.out.println("----------------------------");
    }

    public boolean matchesInterestedType() {
        return false;
    }

    protected void timeStamp(String string) {
    }
}

