/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.sgml.Element;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.TagValidator;
import com.totalvalidator.validations.problem.CoreProblem;
import com.totalvalidator.validations.problem.LinkProblem;
import com.totalvalidator.validations.problem.ValidationError;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Piece {
    private static final String END_MARKER = "</VALIDA>";
    private static final String MARKER = "<VALIDA>";
    private static final int MARKER_LENGTHS = "<VALIDA>".length() + "</VALIDA>".length();
    private static final String CDATA = "cdata";
    static final char AMP_CHAR = '&';
    static final Pattern AMP_PATTERN = Pattern.compile("&amp;");
    private int warningCount;
    private int errorCount;
    private ArrayList<ValidationProblem> messages = new ArrayList();
    private List<ValidationProblem> linkMessages = new ArrayList<ValidationProblem>();
    private boolean showWarnings;
    private boolean virtual;
    private int malformed = 0;
    private List<String> ignoreMessages;
    private String text;
    private int lineNumber = -1;
    private Piece parent;
    private TreeMap<Integer, Point> locations = new TreeMap();
    private String thePieceString;

    public Piece(Piece piece) {
        this.malformed = piece.malformed;
        this.ignoreMessages = new ArrayList<String>();
        this.text = piece.text;
        this.lineNumber = piece.lineNumber;
    }

    public Piece(String thePieceString, int lineNumber, List<String> ignoreMessages, boolean showWarnings) {
        this.ignoreMessages = ignoreMessages;
        this.showWarnings = showWarnings;
        this.thePieceString = thePieceString;
        this.lineNumber = this.realLineNumber(lineNumber, thePieceString);
        this.setText(Piece.trimWhitespace(thePieceString));
    }

    public static String trimWhitespace(String text) {
        if (text.trim().length() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(text);
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken()).append(' ');
        }
        String result = sb.toString();
        if (result.length() != 2 || !Character.isLetter(text.charAt(0)) || !Character.isWhitespace(text.charAt(text.length() - 1))) {
            result = result.trim();
        }
        return result;
    }

    private int realLineNumber(int lineNumber, String text) {
        int i;
        char[] chars = text.toCharArray();
        for (i = 0; i < chars.length && chars[i] == '\n'; ++i) {
        }
        while (i < chars.length) {
            if (chars[i] == '\n') {
                --lineNumber;
            }
            ++i;
        }
        return lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public String getThePieceString() {
        return this.thePieceString;
    }

    public String getMarkedText() {
        String markedText = this.getText();
        int count = 0;
        for (Point p : this.locations.values()) {
            int extra = count * MARKER_LENGTHS;
            int startChar = p.x + extra;
            int endChar = p.y + extra;
            if (endChar + 1 > markedText.length()) continue;
            StringBuilder sb = new StringBuilder(markedText.substring(0, startChar));
            sb.append(MARKER).append(markedText.substring(startChar, endChar));
            sb.append(END_MARKER).append(markedText.substring(endChar));
            markedText = sb.toString();
            ++count;
        }
        return markedText;
    }

    static int notEntity(String value, int index) {
        int index2;
        int position = -1;
        do {
            if ((index2 = value.indexOf(59, index)) == -1) {
                position = index;
                break;
            }
            int index3 = value.indexOf(32, index);
            if (index3 != -1 && index3 < index2) {
                position = index;
                break;
            }
            index = -1;
        } while (index2 < value.length() - 1 && (index = value.indexOf(38, index2)) != -1);
        return position;
    }

    public boolean isMalformed() {
        return this.malformed != 0;
    }

    public void setMalformed(int type) {
        this.malformed = type;
    }

    public int getMalformed() {
        return this.malformed;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public ValidationProblem[] getMessages() {
        ValidationProblem[] mess = new ValidationProblem[this.messages.size()];
        return this.messages.toArray(mess);
    }

    public List<ValidationProblem> getLinkMessages(List<ValidationProblem> messageCopy) {
        messageCopy.addAll(this.linkMessages);
        return messageCopy;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public void unsetProblem(ValidationProblem problem) {
        if (this.messages.remove(problem)) {
            CoreProblem coreProblem = problem.getCoreProblem();
            if (coreProblem instanceof LinkProblem) {
                this.linkMessages.remove(problem);
            }
            if (coreProblem instanceof ValidationError) {
                --this.errorCount;
            } else {
                --this.warningCount;
            }
        }
    }

    private void setInternalProblem(ValidationProblem problem) {
        CoreProblem coreProblem = problem.getCoreProblem();
        for (ValidationProblem message : this.messages) {
            if (message.getCoreProblem() != coreProblem) continue;
            return;
        }
        if (coreProblem instanceof LinkProblem) {
            this.linkMessages.add(problem);
        }
        this.messages.add(problem);
        if (coreProblem instanceof ValidationError) {
            ++this.errorCount;
        } else {
            ++this.warningCount;
        }
    }

    public void setProblem(ValidationProblem problem) {
        CoreProblem coreProblem = problem.getCoreProblem();
        if (!this.isMalformed() && (coreProblem instanceof ValidationError || this.showWarnings)) {
            for (String ignore : this.ignoreMessages) {
                if (!coreProblem.getProblemNumber().equals(ignore)) continue;
                return;
            }
            this.setInternalProblem(problem);
        }
    }

    public void setProblem(ValidationProblem problem, int startChar, int endChar) {
        CoreProblem coreProblem = problem.getCoreProblem();
        if (!this.isMalformed() && (coreProblem instanceof ValidationError || this.showWarnings)) {
            for (String ignore : this.ignoreMessages) {
                if (!coreProblem.getProblemNumber().equals(ignore)) continue;
                return;
            }
            if (startChar >= 0 && endChar > startChar) {
                boolean add = true;
                Iterator<Point> iter = this.locations.values().iterator();
                while (iter.hasNext()) {
                    Point p = iter.next();
                    if (p.x <= startChar) {
                        if (p.y == startChar || p.y >= endChar) {
                            add = false;
                            break;
                        }
                        if (p.y >= endChar || p.y <= startChar) continue;
                        startChar = p.x;
                        iter.remove();
                        continue;
                    }
                    if (p.x == endChar) {
                        add = false;
                        break;
                    }
                    if (p.x >= endChar) continue;
                    if (p.y <= endChar) {
                        iter.remove();
                        continue;
                    }
                    endChar = p.y;
                    iter.remove();
                }
                if (add) {
                    this.locations.put(startChar, new Point(startChar, endChar));
                }
            }
            this.setInternalProblem(problem);
        }
    }

    public void forceWarning(ValidationProblem problem) {
        CoreProblem coreProblem = problem.getCoreProblem();
        for (ValidationProblem message : this.messages) {
            if (!coreProblem.getProblemNumber().equals(message)) continue;
            return;
        }
        if (coreProblem instanceof LinkProblem) {
            this.linkMessages.add(problem);
        }
        this.messages.add(problem);
        ++this.warningCount;
    }

    public void unsetErrors() {
        this.messages = new ArrayList();
        this.linkMessages = new ArrayList<ValidationProblem>();
        this.warningCount = 0;
        this.errorCount = 0;
    }

    public void setEndTag(boolean endTag) {
    }

    public boolean isEndTag() {
        return false;
    }

    public void setMatchingTag(Piece tag) {
    }

    public boolean hasMatchingTag() {
        return false;
    }

    public String getOrigElement(boolean isXml) {
        return "#pcdata";
    }

    public String getElement(boolean isXml) {
        return "#pcdata";
    }

    String stripNameSpace(String candidate) {
        return candidate;
    }

    public String getStrippedElement() {
        return "#pcdata";
    }

    public void setElement(String string) {
    }

    public void setProblemElement(ValidationProblem problem) {
        this.setProblem(problem);
    }

    public void setProblemAttribute(ValidationProblem problem, String attributeName) {
    }

    public void setProblemValue(ValidationProblem problem, String attributeName) {
    }

    public void setParent(Piece parent) {
        this.parent = parent;
    }

    public Piece getParent() {
        return this.parent;
    }

    public Piece getMatchingTag() {
        return null;
    }

    public Map<String, RealAttribute> getAttributes() {
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public boolean isValuesInQuotes() {
        return true;
    }

    public void addMessages(List<ValidationProblem> problems) {
        for (ValidationProblem problem : problems) {
            this.setProblem(problem);
        }
    }

    public String getOrigAttrName(String attrName, boolean isXml) {
        return null;
    }

    public String getAttr(String attrName) {
        return null;
    }

    public static boolean allowedWithin(Element e2, String testElement) {
        if (testElement == null) {
            return false;
        }
        String rule = e2.getRule(testElement);
        if (rule == null && testElement.equals("#pcdata")) {
            rule = e2.getRule(CDATA);
        }
        return rule != null;
    }

    public boolean isMarkedUpAlready() {
        return this.locations.size() > 0;
    }

    public void makeValidator(Element e) {
    }

    public TagValidator getValidator() {
        return null;
    }

    public void removeValidator() {
    }

    public String toString() {
        String result = "Empty tag";
        if (this.getElement(false) != null) {
            StringBuilder res = new StringBuilder(this.getOrigElement(false)).append('\n');
            Map<String, RealAttribute> attributes = this.getAttributes();
            if (attributes != null) {
                for (String name : attributes.keySet()) {
                    String value = attributes.get(name).getValue();
                    if (value == null) {
                        value = "null";
                    }
                    res.append('\t').append(name).append(":").append(value).append('\n');
                }
            }
            res.append("\tType: ").append(this.getClass()).append('\n');
            res.append("\tIs end tag: ").append(this.isEndTag()).append('\n');
            res.append("\tIs singleton: ").append(this.isSingleton()).append('\n');
            res.append("\tHas matching tag: ").append(this.hasMatchingTag()).append('\n');
            result = res.toString();
        }
        return result;
    }
}

