/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.spelling;

import com.totalvalidator.spelling.SpellCheck;

public class WordIterator {
    private SpellCheck spellCheck;
    private char[] textChars;
    private int currIndex = 0;
    private int startOfWord = 0;
    private int endOfWord = 0;

    public WordIterator(String text, SpellCheck spellCheck) {
        this.textChars = text.toCharArray();
        this.spellCheck = spellCheck;
    }

    public boolean hasNext() {
        for (int i = this.currIndex; i < this.textChars.length; ++i) {
            if (Character.isWhitespace(this.textChars[i]) || this.textChars[i] == '\u00a0' || this.textChars[i] == '\u2007' || this.textChars[i] == '\u202f') continue;
            return true;
        }
        return false;
    }

    public String next() {
        char c;
        this.startOfWord = this.currIndex;
        while (this.startOfWord < this.textChars.length && !Character.isLetterOrDigit(this.textChars[this.startOfWord])) {
            ++this.startOfWord;
        }
        if (this.startOfWord == this.textChars.length) {
            this.currIndex = this.startOfWord;
            return "";
        }
        this.endOfWord = this.startOfWord;
        while (this.endOfWord < this.textChars.length && !Character.isWhitespace(c = this.textChars[this.endOfWord]) && c != '\u00a0' && c != '\u2007' && c != '\u202f') {
            ++this.endOfWord;
        }
        this.currIndex = this.endOfWord;
        do {
            --this.endOfWord;
        } while (!Character.isLetterOrDigit(this.textChars[this.endOfWord]) && this.endOfWord > this.startOfWord);
        if (this.endOfWord == this.startOfWord) {
            return "";
        }
        ++this.endOfWord;
        String nextWord = new String(this.textChars, this.startOfWord, this.endOfWord - this.startOfWord);
        if (nextWord.length() == 1 || this.isPunctuatedWord(nextWord) || this.spellCheck.ignoreMixed && this.isMixedCaseWord(nextWord) || this.spellCheck.ignoreUpper && nextWord.toUpperCase().equals(nextWord) || this.spellCheck.ignoreNumbers && this.isNumberWord(nextWord)) {
            return "";
        }
        return nextWord;
    }

    private boolean isPunctuatedWord(String word) {
        char[] chars = word.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (Character.isLetterOrDigit(chars[i]) || chars[i] == '\'' || chars[i] == '-') continue;
            return true;
        }
        return false;
    }

    private boolean isNumberWord(String word) {
        char[] chars = word.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isDigit(chars[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isMixedCaseWord(String word) {
        String text;
        if (word.length() == 1) {
            return false;
        }
        boolean startsWithUpper = Character.isUpperCase(word.charAt(0));
        if (startsWithUpper && (text = word.substring(1)).toLowerCase().equals(text)) {
            return false;
        }
        if (startsWithUpper) {
            return !word.toUpperCase().equals(word);
        }
        return !word.toLowerCase().equals(word);
    }

    public int getStartOfWord() {
        return this.startOfWord;
    }

    public int getEndOfWord() {
        return this.endOfWord;
    }
}

