/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.Cookie;
import com.totalvalidator.utils.GeneralUtils;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieCache
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Cookie> cookieJar = new ArrayList<Cookie>();
    private Map<Object, List<Cookie>> domainIndex = new HashMap<Object, List<Cookie>>();
    private Map<Object, List<Cookie>> uriIndex = new HashMap<Object, List<Cookie>>();
    private ReentrantLock lock = new ReentrantLock(false);

    public void add(URI uri, Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        this.cookieJar.remove(cookie);
        if (cookie.getMaxAge() != 0L) {
            GeneralUtils.LOGGER.fine("Really storing cookie: " + cookie);
            this.cookieJar.add(cookie);
            String domain = cookie.getDomain();
            if (domain == null) {
                this.addIndex(this.uriIndex, this.getEffectiveURI(uri), cookie);
            } else {
                this.addIndex(this.domainIndex, domain, cookie);
            }
        }
        this.lock.unlock();
    }

    public void add(String domain, Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie is null");
        }
        this.lock.lock();
        this.cookieJar.remove(cookie);
        if (cookie.getMaxAge() != 0L) {
            GeneralUtils.LOGGER.fine("Really storing cookie: " + cookie);
            this.cookieJar.add(cookie);
            this.addIndex(this.domainIndex, domain, cookie);
        }
        this.lock.unlock();
    }

    public List<Cookie> get(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
        this.lock.lock();
        this.getInternal(arraylist, this.uriIndex, this.getEffectiveURI(uri));
        this.lock.unlock();
        return arraylist;
    }

    public List<Cookie> get2(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
        this.lock.lock();
        this.getInternal(arraylist, this.domainIndex, new DomainComparator(uri.getHost()));
        this.getInternal(arraylist, this.uriIndex, this.getEffectiveURI(uri));
        this.lock.unlock();
        return arraylist;
    }

    public List<Cookie> get(String domain) {
        if (domain == null) {
            throw new NullPointerException("domain is null");
        }
        ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
        this.lock.lock();
        this.getInternal(arraylist, this.domainIndex, (Comparable)((Object)domain));
        this.lock.unlock();
        return arraylist;
    }

    public List<Cookie> getCookies() {
        this.lock.lock();
        Iterator<Cookie> iterator = this.cookieJar.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().hasExpired()) continue;
            iterator.remove();
        }
        List<Cookie> list = Collections.unmodifiableList(this.cookieJar);
        this.lock.unlock();
        return list;
    }

    public List<Object> getURIs() {
        ArrayList<Object> arraylist = new ArrayList<Object>();
        this.lock.lock();
        Iterator<Object> iterator = this.uriIndex.keySet().iterator();
        while (iterator.hasNext()) {
            URI uri = (URI)iterator.next();
            List<Cookie> list = this.uriIndex.get(uri);
            if (list != null && list.size() != 0) continue;
            iterator.remove();
        }
        arraylist.addAll(this.uriIndex.keySet());
        this.lock.unlock();
        return arraylist;
    }

    public List<Object> getDomains() {
        ArrayList<Object> arraylist = new ArrayList<Object>();
        this.lock.lock();
        Iterator<Object> iterator = this.domainIndex.keySet().iterator();
        while (iterator.hasNext()) {
            String domain = (String)iterator.next();
            List<Cookie> list = this.domainIndex.get(domain);
            if (list != null && list.size() != 0) continue;
            iterator.remove();
        }
        arraylist.addAll(this.domainIndex.keySet());
        this.lock.unlock();
        return arraylist;
    }

    public boolean remove(Cookie cookie) {
        List<Cookie> cookies;
        Object element;
        if (cookie == null) {
            throw new NullPointerException("cookie is null");
        }
        boolean flag1 = false;
        this.lock.lock();
        flag1 = this.cookieJar.remove(cookie);
        Iterator<Object> iter = this.uriIndex.keySet().iterator();
        while (iter.hasNext()) {
            element = (URI)iter.next();
            cookies = this.uriIndex.get(element);
            cookies.remove(cookie);
            if (cookies.size() != 0) continue;
            iter.remove();
        }
        iter = this.domainIndex.keySet().iterator();
        while (iter.hasNext()) {
            element = (String)iter.next();
            cookies = this.domainIndex.get(element);
            cookies.remove(cookie);
            if (cookies.size() != 0) continue;
            iter.remove();
        }
        this.lock.unlock();
        return flag1;
    }

    public boolean removeAll() {
        this.lock.lock();
        this.cookieJar.clear();
        this.domainIndex.clear();
        this.uriIndex.clear();
        this.lock.unlock();
        return true;
    }

    private void getInternal(List<Cookie> list, Map<Object, List<Cookie>> map, Comparable comparable) {
        for (Object obj : map.keySet()) {
            List<Cookie> list1;
            if (comparable.compareTo(obj) != 0 || (list1 = map.get(obj)) == null) continue;
            Iterator<Cookie> iterator1 = list1.iterator();
            while (iterator1.hasNext()) {
                Cookie Cookie2 = iterator1.next();
                if (this.cookieJar.indexOf(Cookie2) != -1) {
                    if (!Cookie2.hasExpired()) {
                        if (list.contains(Cookie2)) continue;
                        list.add(Cookie2);
                        continue;
                    }
                    iterator1.remove();
                    this.cookieJar.remove(Cookie2);
                    continue;
                }
                iterator1.remove();
            }
        }
    }

    private void addIndex(Map<Object, List<Cookie>> map, Object obj, Cookie cookie) {
        if (obj != null) {
            List<Cookie> list = map.get(obj);
            if (list != null) {
                list.remove(cookie);
                list.add(cookie);
            } else {
                ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
                arraylist.add(cookie);
                map.put(obj, arraylist);
            }
        }
    }

    private URI getEffectiveURI(URI uri) {
        URI uri1 = null;
        try {
            uri1 = new URI(uri.getScheme(), uri.getAuthority(), null, null, null);
        }
        catch (URISyntaxException urisyntaxexception) {
            uri1 = uri;
        }
        return uri1;
    }

    public void remove(URI uri) {
        ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
        this.getInternal(arraylist, this.uriIndex, this.getEffectiveURI(uri));
        for (Cookie cookie : arraylist) {
            this.remove(cookie);
        }
    }

    public void remove(String domain) {
        ArrayList<Cookie> arraylist = new ArrayList<Cookie>();
        this.getInternal(arraylist, this.domainIndex, (Comparable)((Object)domain));
        for (Cookie cookie : arraylist) {
            this.remove(cookie);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DomainComparator
    implements Comparable<Object> {
        String host = null;

        @Override
        public int compareTo(String s) {
            return !Cookie.domainMatches(s, this.host) ? -1 : 0;
        }

        @Override
        public int compareTo(Object obj) {
            return this.compareTo((String)obj);
        }

        public DomainComparator(String s) {
            this.host = s;
        }
    }
}

