/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.Validator;
import com.totalvalidator.online.MailHelper;
import com.totalvalidator.snapshot.WindowsShell;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.MyAuthenticator;
import com.totalvalidator.utils.MyHostnameVerifier;
import com.totalvalidator.utils.MyProxySelector;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralUtils {
    public static final Logger LOGGER = Logger.getLogger("validator");
    private static List<Validator> validators = new ArrayList<Validator>();
    private static boolean shuttingDown = false;
    private static MyAuthenticator myAuthenticator = new MyAuthenticator();
    private static String appServerHome = "http://www.totalvalidator.com";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String HTTP = "http://";
    public static final String NO_MESSAGE = "Error - No Message";
    public static final String VALIDATION_ERROR = "Validation Error";
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss z", Locale.UK);
    private static final String NT_BROWSER = "rundll32 url.dll,FileProtocolHandler ";
    private static final String MAC_DEF_BROWSER = "open ";
    private static final String MAC_BROWSER = "open -a ";
    private static final String UNIX_BROWSER = "./default_browser.sh ";
    private static final String EMAIL_FAILURE = "Email Send Failure";
    private static String displayBrowser = "";

    private GeneralUtils() {
    }

    public static boolean basicSettings(String[] args) {
        GeneralUtils.checkJavaVersion();
        boolean extension = FileUtils.checkInstallationFolder(args);
        GeneralUtils.setupLogging();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-debug") || LOGGER.isLoggable(Level.FINEST)) continue;
            System.setProperty("SingleThread", TRUE);
            LOGGER.setLevel(Level.ALL);
            GeneralUtils.logSystemProperties();
            break;
        }
        GeneralUtils.ignoreServerCerts();
        GeneralUtils.setupAuthentication();
        GeneralUtils.setupProxySupport();
        String testAppServer = System.getProperty("appserverhome");
        if (testAppServer != null) {
            appServerHome = testAppServer;
        }
        System.setProperty("apple.laf.useScreenMenuBar", TRUE);
        if (System.getProperty("SingleThread") == null) {
            System.setProperty("SingleThread", FALSE);
        } else {
            System.setProperty("SingleThread", TRUE);
            LOGGER.fine("Single Threaded Mode");
        }
        return extension;
    }

    public static void checkJavaVersion() {
        String jvm = System.getProperty("java.version");
        if (Integer.parseInt(jvm.substring(2, 3)) < 5) {
            System.err.println("Java version detected: " + jvm);
            System.err.println("ERROR: This tool only operates with Java 1.5 and above");
            System.exit(1);
        }
    }

    public static void setupLogging() {
        File oldLogFile;
        File logFile = new File(FileUtils.getDataFolder() + "logging.props");
        if (!logFile.exists() && (oldLogFile = new File(FileUtils.getInstallationFolder() + "logging.props")).exists()) {
            try {
                FileUtils.renameTo(oldLogFile, logFile);
            }
            catch (IOException e) {
                logFile = new File(FileUtils.getInstallationFolder() + "logging.props");
            }
        }
        System.setProperty("java.util.logging.config.file", logFile.getAbsolutePath());
        try {
            LogManager.getLogManager().readConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        GeneralUtils.logSystemProperties();
    }

    public static void logSystemProperties() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            Properties p = System.getProperties();
            for (String string : p.keySet()) {
                LOGGER.fine(string + "=" + p.getProperty(string, ""));
            }
            LOGGER.fine("Docs Folder=" + FileUtils.getDocumentsFolder());
            LOGGER.fine("Data Folder=" + FileUtils.getDataFolder());
        }
    }

    public static void ignoreServerCerts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to install the SSL manager", e);
        }
    }

    private static void setupProxySupport() {
        MyProxySelector ps = new MyProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault(ps);
    }

    public static void logProxies(URL url) {
        if (LOGGER.isLoggable(Level.FINE) && (url.getProtocol().equals("http") || url.getProtocol().equals("https"))) {
            LOGGER.fine("Use System Proxies: " + System.getProperty("java.net.useSystemProxies"));
            try {
                List<Proxy> l = ProxySelector.getDefault().select(new URI(url.toString()));
                for (Proxy p : l) {
                    LOGGER.fine("Proxy: " + p.toString());
                }
                if (ProxySelector.getDefault() instanceof MyProxySelector) {
                    MyProxySelector ps = (MyProxySelector)ProxySelector.getDefault();
                    l = ps.getDefaultSelector().select(new URI(url.toString()));
                    for (Proxy p : l) {
                        LOGGER.fine("Proxy: " + p.toString());
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public static synchronized void addValidator(Validator v) {
        validators.add(v);
    }

    public static synchronized void removeValidator(Validator v) {
        validators.remove(v);
    }

    public static synchronized List<Validator> getValidators() {
        return validators;
    }

    public static boolean isShuttingDown() {
        return shuttingDown;
    }

    public static void setShuttingDown(boolean shuttingDown) {
        GeneralUtils.shuttingDown = shuttingDown;
    }

    public static boolean isMacOSX() {
        return System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
    }

    public static boolean isWinNT() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public static void launchBrowser(String url) throws Exception {
        String cmd = "";
        if (displayBrowser.length() > 0) {
            cmd = GeneralUtils.getBrowserCommand(displayBrowser) + url;
            LOGGER.fine("Browser: " + cmd);
            try {
                WindowsShell.runCommand(cmd, false, true, false);
            }
            catch (Exception e) {
                cmd = GeneralUtils.getDefaultBrowserCommand() + url;
                WindowsShell.runCommand(cmd, false, true, false);
            }
        } else {
            cmd = GeneralUtils.getDefaultBrowserCommand() + url;
            LOGGER.fine("Browser: " + cmd);
            WindowsShell.runCommand(cmd, false, true, false);
        }
    }

    private static String getBrowserCommand(String browser) {
        String command = "";
        command = GeneralUtils.isMacOSX() ? MAC_BROWSER + browser : (GeneralUtils.isWinNT() ? browser : browser);
        return command + " ";
    }

    private static String getDefaultBrowserCommand() {
        String command = "";
        if (GeneralUtils.isMacOSX()) {
            command = MAC_DEF_BROWSER;
        } else if (GeneralUtils.isWinNT()) {
            command = NT_BROWSER;
        } else {
            command = FileUtils.getInstallationFolder();
            if (command.length() == 0) {
                command = "./";
            }
            command = command + UNIX_BROWSER;
        }
        return command;
    }

    public static boolean isLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static void setupAuthentication() {
        Authenticator.setDefault(myAuthenticator);
    }

    public static MyAuthenticator getAuthenticator() {
        return myAuthenticator;
    }

    public static String getAppServerHome() {
        return appServerHome;
    }

    public static void setDisplayBrowser(String browser) {
        displayBrowser = browser;
    }

    public static String getDisplayBrowser() {
        return displayBrowser;
    }

    public static void report(Exception e, String issue, String subject) {
        if (e != null) {
            e.printStackTrace();
        }
        LOGGER.severe(issue);
        GeneralUtils.sendEmail(MailHelper.defaultFromAddress, MailHelper.defaultFromAddress, issue, subject);
    }

    public static boolean sendEmail(String to, String from, String message, String subject) {
        boolean result = MailHelper.sendEmail((boolean)true, (String)to, (String)from, (String)message, (String)subject, null);
        if (!result && !EMAIL_FAILURE.equals(subject)) {
            GeneralUtils.report(null, message, EMAIL_FAILURE);
        }
        return result;
    }

    public static synchronized String format(Date date) {
        return SDF.format(date);
    }

    public static synchronized Date parse(String timestamp) throws ParseException {
        return SDF.parse(timestamp);
    }
}

