/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import com.totalvalidator.utils.ProxyDetails;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyProxySelector
extends ProxySelector {
    private ProxySelector defaultSelector;
    private List<Proxy> userDefined;

    public MyProxySelector(ProxySelector defaultSelector) {
        this.defaultSelector = defaultSelector;
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        return this.userDefined != null ? this.userDefined : this.defaultSelector.select(uri);
    }

    @Override
    public void connectFailed(URI uri, SocketAddress socketAddress, IOException ioe) {
        this.defaultSelector.connectFailed(uri, socketAddress, ioe);
    }

    public void setProxyDetails(ProxyDetails proxyDetails) {
        if (proxyDetails == null || proxyDetails.getHost().length() == 0) {
            this.userDefined = null;
        } else {
            String portStr = proxyDetails.getPort();
            if (portStr.length() == 0) {
                portStr = "0";
            }
            int port = 0;
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (port == 0) {
                port = proxyDetails.isSocksProxy() ? 1080 : 8080;
            }
            InetSocketAddress sa = new InetSocketAddress(proxyDetails.getHost(), port);
            Proxy proxy = new Proxy(proxyDetails.isSocksProxy() ? Proxy.Type.SOCKS : Proxy.Type.HTTP, sa);
            this.userDefined = new ArrayList<Proxy>();
            this.userDefined.add(proxy);
        }
    }

    public ProxySelector getDefaultSelector() {
        return this.defaultSelector;
    }
}

