/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.sgml.CSSPiece;
import com.totalvalidator.sgml.Data;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.spelling.SpellCheck;
import com.totalvalidator.spelling.SpellingDictionary;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpellingValidation
implements Validation {
    public static final String GB = "GB";
    public static final String US = "US";
    public static final String IT = "IT";
    public static final String FR = "FR";
    public static final String DE = "DE";
    public static final String ES = "ES";
    public static final String GB_TEXT = "British";
    public static final String US_TEXT = "American";
    public static final String IT_TEXT = "Italian";
    public static final String FR_TEXT = "French";
    public static final String DE_TEXT = "German";
    public static final String ES_TEXT = "Spanish";
    public static final String ALTDIC_TEXT = "Own dictionary";
    public static final String GB_DICTIONARY = "dicts/ukenglish.dic";
    public static final String US_DICTIONARY = "dicts/usenglish.dic";
    public static final String IT_DICTIONARY = "dicts/italian.dic";
    public static final String FR_DICTIONARY = "dicts/french.dic";
    public static final String ES_DICTIONARY = "dicts/spanish.dic";
    public static final String DE_DICTIONARY = "dicts/german.dic";
    private static final String OWN_DICTIONARY = "dicts/own_dictionary.dic";
    private static final Pattern VALIDA_START = Pattern.compile("&lt;VALIDA&gt;");
    private static final Pattern VALIDA_END = Pattern.compile("&lt;/VALIDA&gt;");
    private static final Pattern VALIDB_START = Pattern.compile("&lt;VALIDB&gt;");
    private static final Pattern VALIDB_END = Pattern.compile("&lt;/VALIDB&gt;");
    private static List<String> stylingElements = new ArrayList<String>();
    public static List<String> languageOptions = new ArrayList<String>();
    private static Map<String, String> languages = new HashMap<String, String>();
    private static Map<String, String> displayNames = new HashMap<String, String>();
    private EntityEncoder ee;
    private SpellCheck spellCheck;
    private boolean spellCheckAttrs;
    private String language;
    private boolean checkLang;
    private boolean saveBadWords;

    public SpellingValidation(SpellingDictionary dictionary, EntityEncoder ee, Map<String, Boolean> spellOptions, String language, boolean checkLang, boolean saveBadWords) throws ValidationException {
        this.ee = ee;
        this.spellCheckAttrs = spellOptions.containsKey("checkattrs") && spellOptions.get("checkattrs") != false;
        this.spellCheck = new SpellCheck(dictionary, spellOptions);
        this.language = language;
        this.checkLang = checkLang;
        this.saveBadWords = saveBadWords;
    }

    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        if (this.checkLang) {
            Piece htmlTag = null;
            if (this.language != null && (htmlTag = this.abortSpellCheck(pieces)) != null) {
                htmlTag.setProblem(ValidationProblem.SPELL_LANG);
                this.spellCheck = null;
                return;
            }
        }
        ArrayList<Piece> textPiece = new ArrayList<Piece>();
        for (Piece piece : pieces) {
            if (piece.isMalformed() || piece.isVirtual() || piece instanceof CSSPiece || piece.getParent() != null && piece.getParent().getStrippedElement().equals("script")) continue;
            if (piece instanceof Data && !piece.isMarkedUpAlready()) {
                textPiece.add(piece);
                continue;
            }
            if (!(piece instanceof Tag) || stylingElements.contains(piece.getStrippedElement())) continue;
            textPiece.add(piece);
        }
        Iterator iter = textPiece.iterator();
        while (iter.hasNext()) {
            Piece piece;
            cancellor.isCancelled();
            piece = (Piece)iter.next();
            if (piece instanceof Data) {
                String text = piece.getText();
                String[] result = this.ee.decode(text, true, false);
                if ((text = result[0]).length() == 1 && Character.isLetter(text.charAt(0)) && iter.hasNext()) {
                    Piece nextTag = (Piece)iter.next();
                    if (nextTag instanceof Data) {
                        String nextText = nextTag.getText();
                        result = this.ee.decode(nextText, true, false);
                        nextText = result[0];
                        if (nextTag.getLineNumber() == piece.getLineNumber()) {
                            if (Character.isLetter(nextText.charAt(0))) {
                                this.checkText(nextTag, text + nextText);
                                continue;
                            }
                            this.checkText(piece, text);
                            this.checkText(nextTag, nextText);
                            continue;
                        }
                        this.checkText(piece, text);
                        this.checkText(nextTag, nextText);
                        continue;
                    }
                    if (!this.spellCheckAttrs) continue;
                    List<String> names = this.getAttrs(nextTag.getAttributes());
                    for (String attrName : names) {
                        String nextText = nextTag.getAttr(attrName);
                        if (nextText == null || this.spellCheck.checkSpelling(nextText, this.saveBadWords)) continue;
                        StringBuilder sb = new StringBuilder(attrName).append("=\"");
                        sb.append(SpellingValidation.format(this.ee.encode(this.spellCheck.getText()))).append("\"");
                        nextTag.forceWarning(ValidationProblem.newSpellWarning(sb.toString()));
                    }
                    continue;
                }
                this.checkText(piece, text);
                continue;
            }
            if (!this.spellCheckAttrs) continue;
            List<String> names = this.getAttrs(piece.getAttributes());
            for (String attrName : names) {
                String text = piece.getAttr(attrName);
                if (text == null || this.spellCheck.checkSpelling(text, this.saveBadWords)) continue;
                StringBuilder sb = new StringBuilder(attrName).append("=\"");
                sb.append(SpellingValidation.format(this.ee.encode(this.spellCheck.getText()))).append("\"");
                piece.forceWarning(ValidationProblem.newSpellWarning(sb.toString()));
            }
        }
        if (this.saveBadWords) {
            this.saveBadWords(this.spellCheck.getBadWords(), this.language);
        }
        this.spellCheck = null;
    }

    private void checkText(Piece piece, String text) {
        if (!this.spellCheck.checkSpelling(text, this.saveBadWords)) {
            piece.forceWarning(ValidationProblem.SPELLING);
            piece.setText(this.spellCheck.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveBadWords(Set<String> badWords, String language) {
        block19: {
            if (badWords.isEmpty()) {
                return;
            }
            if (language == null) {
                language = "dicts/own_dictionary.dic";
            }
            if (!((languageFile = new File(FileUtils.getResultsFolder() + '/' + language + ".new")).getParentFile().exists() || languageFile.getParentFile().mkdirs() || (languageFile = new File('/' + language + ".new")).getParentFile().exists() || languageFile.getParentFile().mkdirs())) {
                GeneralUtils.LOGGER.severe("Can't create " + languageFile.getParent());
                return;
            }
            uniqueSortedWords = new TreeSet<String>();
            if (languageFile.exists()) {
                br = null;
                try {
                    try {
                        line = null;
                        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(languageFile), "UTF-8"));
                        while ((line = br.readLine()) != null) {
                            if (line.trim().length() == 0) continue;
                            uniqueSortedWords.add(line);
                        }
                        var8_9 = null;
                        if (br == null) break block19;
                    }
                    catch (IOException e) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "Failed reading dictionary", e);
                        var8_10 = null;
                        if (br == null) return;
                        try {
                            br.close();
                            return;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        return;
                    }
                }
                catch (Throwable var7_15) {
                    var8_11 = null;
                    if (br == null) throw var7_15;
                    ** try [egrp 2[TRYBLOCK] [4 : 282->290)] { 
lbl39:
                    // 1 sources

                    br.close();
                    throw var7_15;
lbl41:
                    // 1 sources

                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var7_15;
                }
                try {}
                catch (IOException e) {}
                br.close();
            }
        }
        uniqueSortedWords.addAll(badWords);
        pw = null;
        try {
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(languageFile), "UTF-8"));
                i$ = uniqueSortedWords.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        var11_17 = null;
                        if (pw == null) return;
                        pw.close();
                        return;
                    }
                    word = (String)i$.next();
                    pw.println(word);
                }
            }
            catch (IOException e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed writing dictionary", e);
                var11_18 = null;
                if (pw == null) return;
                pw.close();
                return;
            }
        }
        catch (Throwable var10_20) {
            var11_19 = null;
            if (pw == null) throw var10_20;
            pw.close();
            throw var10_20;
        }
    }

    private Piece abortSpellCheck(List<Piece> pieces) {
        for (Piece tag : pieces) {
            StringTokenizer st;
            String element = tag.getStrippedElement();
            if (element == null || !element.equals("html")) continue;
            String lang = tag.getAttr("xml:lang");
            if (lang == null) {
                lang = tag.getAttr("lang");
            }
            if (lang == null || !(st = new StringTokenizer(lang, "-*")).hasMoreTokens()) break;
            lang = st.nextToken().toLowerCase(Locale.ENGLISH);
            if (("en".equals(lang) || "eng".equals(lang)) && (this.language.equals(GB_DICTIONARY) || this.language.equals(US_DICTIONARY))) {
                return null;
            }
            if (languages.containsKey(lang) && languages.get(lang).equals(this.language)) {
                return null;
            }
            return tag;
        }
        return null;
    }

    private List<String> getAttrs(Map<String, RealAttribute> attrs) {
        ArrayList<String> attrNames = new ArrayList<String>();
        if (attrs != null) {
            if (attrs.containsKey("alt")) {
                attrNames.add("alt");
            } else if (attrs.containsKey("title")) {
                attrNames.add("title");
            } else if (attrs.containsKey("label")) {
                attrNames.add("label");
            } else if (attrs.containsKey("prompt")) {
                attrNames.add("prompt");
            } else if (attrs.containsKey("standby")) {
                attrNames.add("standby");
            } else if (attrs.containsKey("summary")) {
                attrNames.add("summary");
            }
        }
        return attrNames;
    }

    public static String format(String text) {
        text = VALIDA_START.matcher(text).replaceAll("<span>");
        text = VALIDA_END.matcher(text).replaceAll("</span>");
        text = VALIDB_START.matcher(text).replaceAll("<span class=\"em\">");
        text = VALIDB_END.matcher(text).replaceAll("</span>");
        return text;
    }

    public static String getLanguage(String text) {
        if (text.equals(US_TEXT)) {
            return US;
        }
        if (text.equals(GB_TEXT)) {
            return GB;
        }
        if (text.equals(IT_TEXT)) {
            return IT;
        }
        if (text.equals(FR_TEXT)) {
            return FR;
        }
        if (text.equals(ES_TEXT)) {
            return ES;
        }
        if (text.equals(DE_TEXT)) {
            return DE;
        }
        if (text.equals(ALTDIC_TEXT)) {
            return ALTDIC_TEXT;
        }
        return null;
    }

    public static String getDisplayName(String language) {
        return displayNames.get(language);
    }

    static {
        displayNames.put(GB_DICTIONARY, GB_TEXT);
        displayNames.put(US_DICTIONARY, US_TEXT);
        displayNames.put(IT_DICTIONARY, IT_TEXT);
        displayNames.put(FR_DICTIONARY, FR_TEXT);
        displayNames.put(ES_DICTIONARY, ES_TEXT);
        displayNames.put(DE_DICTIONARY, DE_TEXT);
        languageOptions.add(GB);
        languageOptions.add(US);
        languageOptions.add(IT);
        languages.put("it", IT_DICTIONARY);
        languages.put("ita", IT_DICTIONARY);
        languageOptions.add(FR);
        languages.put("fr", FR_DICTIONARY);
        languages.put("fra", FR_DICTIONARY);
        languages.put("fre", FR_DICTIONARY);
        languageOptions.add(ES);
        languages.put("es", ES_DICTIONARY);
        languages.put("esl", ES_DICTIONARY);
        languages.put("spa", ES_DICTIONARY);
        languageOptions.add(DE);
        languages.put("de", DE_DICTIONARY);
        languages.put("deu", DE_DICTIONARY);
        languages.put("ger", DE_DICTIONARY);
        stylingElements.add("b");
        stylingElements.add("i");
        stylingElements.add("s");
        stylingElements.add("u");
        stylingElements.add("em");
        stylingElements.add("strong");
        stylingElements.add("span");
        stylingElements.add("big");
        stylingElements.add("small");
        stylingElements.add("strike");
        stylingElements.add("font");
    }
}

