/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations.http;

import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.LinkValidation;
import com.totalvalidator.validations.http.TestLink;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestHttpLink
extends Thread
implements TestLink {
    private LinkValidation lv;
    private String link;
    private String contentType;
    private Piece tag;
    private String schemelessOrigin;
    private String followLink;
    private boolean dontFollow;
    private Map<String, List<ValidationProblem>> linksTested;
    private boolean reportBroken;
    private CommandLineParser cl;
    private String attribute;
    private int timeOut;
    private int dialogCount = 0;
    private String referer;
    private boolean started;
    private boolean validateErrors;

    public TestHttpLink(LinkValidation lv, String link, String referer, Piece piece, String attribute, String urlOrigin, boolean dontFollow, Map<String, List<ValidationProblem>> linksTested, CommandLineParser cl) {
        this.lv = lv;
        this.link = link;
        this.referer = referer;
        this.tag = piece;
        this.attribute = attribute;
        int index = urlOrigin.indexOf("://");
        this.schemelessOrigin = index != -1 ? urlOrigin.substring(index) + "/" : urlOrigin;
        this.dontFollow = dontFollow;
        this.linksTested = linksTested;
        this.cl = cl;
        this.reportBroken = cl.isBrokenLinks();
        this.timeOut = (int)cl.getTimeOut();
        this.validateErrors = cl.isValidateErrors();
    }

    public String getURL() {
        return this.link;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        int retestCount = 1;
        boolean loop = true;
        String method = "HEAD";
        HttpURLConnection httpConnection = null;
        while (loop && retestCount < 7) {
            Object var11_11;
            loop = false;
            try {
                block32: {
                    try {
                        URL url = new URL(this.link);
                        GeneralUtils.LOGGER.info("Testing: " + this.link);
                        URLConnection connection = url.openConnection();
                        if (connection instanceof HttpURLConnection) {
                            httpConnection = (HttpURLConnection)connection;
                            httpConnection.setInstanceFollowRedirects(false);
                            httpConnection.setRequestMethod(method);
                            httpConnection.setConnectTimeout(this.timeOut);
                            httpConnection.setReadTimeout(this.timeOut);
                            httpConnection.setRequestProperty("User-Agent", this.cl.getUserAgent());
                            httpConnection.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
                            httpConnection.setRequestProperty("Referer", this.referer == null ? "http://www.totalvalidator.com/index.html" : this.referer);
                            httpConnection.connect();
                            int response = httpConnection.getResponseCode();
                            GeneralUtils.LOGGER.fine("Response code=" + response + " for " + this.link);
                            if (response == 200) {
                                this.followThisLinkIfRequired(httpConnection);
                                break block32;
                            }
                            if (response == 301 || response == 302 || response == 303 || response == 307) {
                                String location = httpConnection.getHeaderField("Location");
                                if (this.reportBroken && this.cl.isReportRedirects()) {
                                    String type = "";
                                    switch (response) {
                                        case 301: {
                                            type = "Page moved permanently to ";
                                            break;
                                        }
                                        case 302: {
                                            type = "Page moved temporarily to ";
                                            break;
                                        }
                                        case 303: {
                                            type = "See other page at ";
                                            break;
                                        }
                                    }
                                    if (type.length() > 0) {
                                        this.tag.forceWarning(ValidationProblem.newLinkWarning(response, type + (location != null ? location : "unknown")));
                                    }
                                }
                                if (location == null) break block32;
                                GeneralUtils.LOGGER.info("Redirecting: " + this.link + " to " + location);
                                this.link = this.lv.testLink(location, this.tag, null, this.attribute, true, this.link, false);
                                if (this.link == null) break block32;
                                loop = true;
                                ++retestCount;
                                break block32;
                            }
                            if (response == 407 && this.cl.isInteractiveAuth()) {
                                GeneralUtils.LOGGER.info("Proxy Authentication Request");
                                this.dialogCount = AuthenticationDialog.getAuthDetails(null, httpConnection, true, this.link, this.dialogCount);
                                if (this.dialogCount != -1) {
                                    loop = true;
                                    break block32;
                                } else {
                                    if (this.validateErrors) {
                                        this.followThisLinkIfRequired(httpConnection);
                                    }
                                    this.reportBroken(httpConnection, response);
                                }
                                break block32;
                            }
                            if (response == 401 && this.cl.isInteractiveAuth()) {
                                GeneralUtils.LOGGER.info("HTTP Authentication Request");
                                this.dialogCount = AuthenticationDialog.getAuthDetails(null, httpConnection, false, this.link, this.dialogCount);
                                if (this.dialogCount != -1) {
                                    loop = true;
                                    break block32;
                                } else {
                                    if (this.validateErrors) {
                                        this.followThisLinkIfRequired(httpConnection);
                                    }
                                    this.reportBroken(httpConnection, response);
                                }
                                break block32;
                            }
                            if ("HEAD".equals(method)) {
                                method = "GET";
                                GeneralUtils.LOGGER.info("Trying GET for " + this.link);
                                loop = true;
                                break block32;
                            } else {
                                if (this.validateErrors) {
                                    this.followThisLinkIfRequired(httpConnection);
                                }
                                this.reportBroken(httpConnection, response);
                            }
                            break block32;
                        }
                        if (!this.reportBroken) break block32;
                        this.tag.setProblemValue(ValidationProblem.NOT_HTML, this.attribute);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        if (message == null) {
                            message = "";
                        }
                        GeneralUtils.LOGGER.fine("Link failed: " + this.link + " : " + e + ":" + message);
                        if ("HEAD".equals(method)) {
                            method = "GET";
                            GeneralUtils.LOGGER.info("Trying GET for " + this.link);
                            loop = true;
                        } else {
                            this.setConnectionError(message);
                        }
                        var11_11 = null;
                        if (!"GET".equals(method)) continue;
                        FileUtils.readStream(httpConnection);
                        continue;
                    }
                }
                var11_11 = null;
                if (!"GET".equals(method)) continue;
            }
            catch (Throwable throwable) {
                var11_11 = null;
                if ("GET".equals(method)) {
                    FileUtils.readStream(httpConnection);
                }
                throw throwable;
            }
            FileUtils.readStream(httpConnection);
        }
        if (loop) {
            this.tag.setProblemValue(ValidationProblem.TOO_MANY_REDIRECTS, this.attribute);
        }
        if (this.link != null) {
            GeneralUtils.LOGGER.fine("Tested: " + this.link);
            this.linksTested.put(this.link, this.tag.getLinkMessages(new ArrayList<ValidationProblem>()));
        }
    }

    private void followThisLinkIfRequired(URLConnection httpConnection) {
        int index = this.link.indexOf("://");
        String schemelessLink = this.link;
        if (index != -1) {
            schemelessLink = schemelessLink.substring(index);
        }
        if (!this.dontFollow && (this.cl.isFollowLinks() || schemelessLink.startsWith(this.schemelessOrigin))) {
            this.followLink = this.link;
        }
        this.contentType = httpConnection.getContentType();
    }

    private void reportBroken(HttpURLConnection httpConnection, int response) throws IOException {
        if (this.reportBroken) {
            String message = httpConnection.getResponseMessage();
            if (message == null) {
                message = "";
            }
            if (response >= 400) {
                this.tag.setProblemValue(ValidationProblem.newLinkError(response, "Problem with link: " + message), this.attribute);
            } else {
                this.tag.setProblemValue(ValidationProblem.newLinkWarning(response, "Problem with link: " + message), this.attribute);
            }
        }
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getLink() {
        return this.followLink;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setConnectionError(String message) {
        if (this.reportBroken) {
            this.tag.setProblemValue(new ValidationProblem("Connection failure: Timed out", ValidationProblem.CONNECTION_FAILURE), this.attribute);
        }
    }
}

