/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.utils.FileUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class EntityEncoder
implements Serializable {
    private Map<String, String> characterEntityRefs = new HashMap<String, String>();
    private Map<String, String> characterEntityRefsReverse = new HashMap<String, String>();
    static final long serialVersionUID = -1L;
    private static final Pattern AMP_PATTERN = Pattern.compile("&");
    private static final String LATIN = "dtds/1.0/xhtml-lat1.ent";
    private static final String SYMBOL = "dtds/1.0/xhtml-symbol.ent";
    private static final String SPECIAL = "dtds/1.0/xhtml-special.ent";
    private static final String AMP = "&";
    private static final String SEMICOLON = ";";
    private static final String AMP_ENTITY = "&amp;";
    private static final char BIG_X = 'X';
    private static final char X = 'x';
    private static final String HASH = "&#";
    private static final char QUOTE = '\'';
    private static final char FANCY_START = '\u2018';
    private static final char FANCY_END = '\u2019';

    public void addBasics(FileUtils fileUtils) throws ValidationException {
        this.loadEntityFile(fileUtils, LATIN);
        this.loadEntityFile(fileUtils, SYMBOL);
        this.loadEntityFile(fileUtils, SPECIAL);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadEntityFile(FileUtils fileUtils, String fileName) throws ValidationException {
        BufferedReader br = null;
        String line = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(fileUtils.getInputStream(FileUtils.getInstallationFolder() + fileName), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("<!ENTITY")) continue;
                    StringTokenizer st = new StringTokenizer(line, " \"");
                    st.nextToken();
                    String name = st.nextToken().trim();
                    String value = st.nextToken().trim();
                    if ("CDATA".equals(value)) {
                        value = st.nextToken().trim();
                    }
                    this.addCharEntityRef(name, value);
                }
                Object var9_9 = null;
            }
            catch (IOException e) {
                throw new ValidationException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        br.close();
        return;
    }

    public void addCharEntityRef(String name, String value) {
        name = AMP + name + SEMICOLON;
        String val = value.substring(2, value.length() - 1);
        if ((val = this.convertToChar(val)) != null) {
            this.characterEntityRefs.put(name, val);
            this.characterEntityRefsReverse.put(val, name);
        }
    }

    public String encode(String text) {
        text = AMP_PATTERN.matcher(text).replaceAll(AMP_ENTITY);
        for (String val : this.characterEntityRefsReverse.keySet()) {
            if (AMP.equals(val)) continue;
            text = text.replaceAll(val, this.characterEntityRefsReverse.get(val));
        }
        return text;
    }

    public String[] decode(String text, boolean quotes, boolean noAmpersands) {
        int index2;
        String[] result = new String[2];
        result[1] = "";
        int index = 0;
        while ((index = text.indexOf(HASH, index)) != -1 && (index2 = text.indexOf(SEMICOLON, index)) != -1) {
            if (index2 == index + 2) {
                index = index2;
                continue;
            }
            String val = text.substring(index + 2, index2);
            if (val.charAt(0) == 'X') {
                result[1] = "true";
            }
            if ((val = this.convertToChar(val)) == null) {
                index = index2;
                continue;
            }
            if (noAmpersands && AMP.equals(val)) {
                val = AMP_ENTITY;
            }
            text = text.substring(0, index) + val + text.substring(index2 + 1);
        }
        for (String ref : this.characterEntityRefs.keySet()) {
            if (noAmpersands && AMP_ENTITY.equals(ref)) continue;
            text = text.replaceAll(ref, this.characterEntityRefs.get(ref));
        }
        if (quotes) {
            text = text.replace('\u2018', '\'');
            text = text.replace('\u2019', '\'');
        }
        result[0] = text;
        return result;
    }

    private String convertToChar(String val) {
        int i = -1;
        if ((val = val.toLowerCase(Locale.ENGLISH)).charAt(0) == 'x') {
            val = val.substring(1);
            try {
                i = Integer.parseInt(val, 16);
            }
            catch (NumberFormatException e) {
                i = -1;
            }
        } else {
            try {
                i = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                i = -1;
            }
        }
        return i < 0 || i > 65533 ? null : (char)i + "";
    }
}

