/*
 * Decompiled with CFR 0.152.
 */
import emsl.awt.GUIAlertBox;
import emsl.io.FileManager;
import emsl.io.FileReader;
import java.awt.Frame;
import java.util.Hashtable;

public class DemoFileAccess {
    private ClassLoader classLoader;
    private FileManager fileManager;
    private Frame parent;

    public DemoFileAccess(Frame frame, ClassLoader classLoader) {
        this.setParent(frame);
        this.setClassLoader(classLoader);
        this.setFileManager(new FileManager(frame));
    }

    public void setParent(Frame frame) {
        this.parent = frame;
    }

    public Frame getParent() {
        return this.parent;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public Document openDocument() {
        this.getFileManager().showLocalBrowser(0, "Load Document");
        if (this.getFileManager().getFile() == null) {
            return null;
        }
        FileReader fileReader = new FileReader(this.getParent(), this.getFileManager());
        Hashtable hashtable = fileReader.loadData(this.getClassLoader());
        if (hashtable == null) {
            this.getFileManager().setFile(null);
            return null;
        }
        Document document = new Document();
        document.setAsHashtable(hashtable);
        document.setName(this.getFileManager().getFile());
        return document;
    }

    public Document openText() {
        this.getFileManager().showLocalBrowser(0, "Load Text");
        if (this.getFileManager().getFile() == null) {
            return null;
        }
        FileReader fileReader = new FileReader(this.getParent(), this.getFileManager());
        String string = fileReader.loadText();
        this.getFileManager().setFile(null);
        if (string == null) {
            return null;
        }
        Document document = new Document();
        document.setAsText(string);
        return document;
    }

    public boolean saveDocument(Document document) {
        this.displayDemoMessage();
        return false;
    }

    public boolean saveDocumentAs(Document document) {
        this.displayDemoMessage();
        return false;
    }

    public boolean saveTextAs(Document document) {
        this.displayDemoMessage();
        return false;
    }

    public void displayDemoMessage() {
        GUIAlertBox gUIAlertBox = new GUIAlertBox(this.getParent(), "Demonstration Copy");
        gUIAlertBox.addExitButtons("OK");
        gUIAlertBox.addText("The Save feature of this application has been Disabled");
        gUIAlertBox.addText("");
        gUIAlertBox.addText("To obtain a fully featured version of this application");
        gUIAlertBox.addText("contact the authors using the Feedback tool");
        gUIAlertBox.display();
        gUIAlertBox.dispose();
    }
}

