/*
 * Decompiled with CFR 0.152.
 */
package emsl.awt;

import emsl.awt.GUIIcon;
import emsl.awt.GUIPopUpManager;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class GUIButton
extends GUIIcon
implements Runnable {
    public static final int DESELECTED = 0;
    public static final int SELECTED = 1;
    public static final int DISABLED = 2;
    public static final int PUSH_BUTTON = 0;
    public static final int TOGGLE_BUTTON = 1;
    public static final int RADIO_BUTTON = 2;
    protected static final int NONE = 0;
    protected static final int PRESSED = 1;
    private String name;
    protected int publicState = 0;
    protected int privateState = 0;
    private int buttonType = 0;
    private boolean mouseDown = false;
    private ActionListener actionListener;
    private String tipText;
    private Thread motor;
    private GUIPopUpManager popUpManager;
    private Color background;

    public GUIButton(Dimension dimension) {
        super(dimension);
        this.setBorder(1);
        this.setName("NoName");
        this.tipText = null;
        this.enableEvents(48L);
    }

    public GUIButton(Dimension dimension, String string) {
        this(dimension);
        this.setText(string);
        this.setName(string);
    }

    public GUIButton(String string) {
        this((Dimension)null);
        this.setText(string);
        this.setName(string);
    }

    public GUIButton(Dimension dimension, Color color) {
        this(dimension);
        this.setBackground(color);
    }

    public GUIButton(Dimension dimension, Class clazz, String string, String string2) {
        this(dimension);
        this.setImage(clazz, string, string2);
    }

    public GUIButton(Class clazz, String string, String string2) {
        this((Dimension)null);
        this.setImage(clazz, string, string2);
    }

    public void setBackground(Color color) {
        this.background = new Color(color.getRGB());
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return super.getBackground();
    }

    public String getName() {
        if (this.name == null) {
            return "NoName";
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void select(boolean bl) {
        if (this.getState() == 1) {
            return;
        }
        this.setState(1);
        if (bl) {
            this.repaint();
        }
    }

    public void deSelect(boolean bl) {
        if (this.getState() == 0) {
            return;
        }
        this.setState(0);
        if (bl) {
            this.repaint();
        }
    }

    public void select(boolean bl, boolean bl2) {
        if (bl) {
            this.select(bl2);
            return;
        }
        this.deSelect(bl2);
    }

    public boolean isSelected() {
        return this.getState() == 1;
    }

    public void setState(int n) {
        if (n == 1 || n == 0 || n == 2) {
            this.publicState = n;
        }
        this.privateState = 0;
    }

    public int getState() {
        return this.publicState;
    }

    public int getPrivateState() {
        return this.privateState;
    }

    public void setBehaviour(int n) {
        this.buttonType = n;
    }

    public int getBehaviour() {
        return this.buttonType;
    }

    public void setTipText(String string) {
        this.tipText = string;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        int n = this.privateState;
        if (mouseEvent.getID() == 506 && this.mouseDown && !this.contains(mouseEvent.getPoint())) {
            this.mouseDown = false;
            n = 0;
        }
        this.buttonChanged(n, this.publicState);
        super.processMouseMotionEvent(mouseEvent);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        int n = this.privateState;
        int n2 = this.publicState;
        boolean bl = false;
        switch (mouseEvent.getID()) {
            case 501: {
                this.tipTextStop();
                this.mouseDown = true;
                n = 1;
                break;
            }
            case 502: {
                this.mouseDown = false;
                if (this.privateState == 1) {
                    if (this.publicState == 0) {
                        n2 = 1;
                    } else if (this.buttonType == 1) {
                        n2 = 0;
                    }
                    if (this.buttonType == 0) {
                        n2 = 0;
                    }
                    bl = true;
                }
                n = 0;
                break;
            }
            case 505: {
                this.mouseDown = false;
                n = 0;
                this.tipTextStop();
                break;
            }
            case 504: {
                this.tipTextStart();
                break;
            }
        }
        this.buttonChanged(n, n2);
        if (bl && this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, n2, this.name));
        }
        super.processMouseEvent(mouseEvent);
    }

    private void buttonChanged(int n, int n2) {
        if (this.publicState == 2) {
            return;
        }
        if (this.privateState != n || this.publicState != n2) {
            this.privateState = n;
            this.publicState = n2;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        Color color = this.getBackground();
        if (this.publicState == 0) {
            this.setBorder(1);
        }
        if (this.publicState == 1) {
            this.setBorder(2);
            if (this.getBorderThickness() == 2 && color != null) {
                this.setBackground(color.brighter());
            }
        }
        if (this.privateState == 1) {
            this.setBorder(2);
            this.setBackground(color);
        }
        if (this.publicState == 2) {
            this.setBorder(0);
        }
        super.paint(graphics);
        this.setBackground(color);
    }

    public void tipTextStart() {
        if (this.motor != null) {
            this.tipTextStop();
        }
        if (this.tipText == null) {
            return;
        }
        this.motor = new Thread(this);
        this.motor.start();
    }

    public void tipTextStop() {
        if (this.motor != null) {
            this.motor.stop();
        }
        this.motor = null;
        if (this.tipText == null) {
            return;
        }
        if (this.popUpManager != null) {
            this.popUpManager.hideTipText();
        }
    }

    public void tipTextDisplay() {
        if (this.tipText == null) {
            return;
        }
        this.getPopUpManager();
        if (this.popUpManager != null) {
            this.popUpManager.showTipText(this, this.tipText);
        }
    }

    public void run() {
        try {
            int n = 800;
            Thread.sleep(n);
            this.tipTextDisplay();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void getPopUpManager() {
        if (this.popUpManager != null) {
            return;
        }
        Container container = this;
        Container container2 = null;
        do {
            int n;
            if ((container2 = container.getParent()) == null || (n = (container = container2).getComponentCount()) <= 0) continue;
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                if (component instanceof GUIPopUpManager) {
                    this.popUpManager = (GUIPopUpManager)component;
                    return;
                }
                ++n2;
            }
        } while (container2 != null);
        if (this.popUpManager == null) {
            System.out.println("Error using the TipText facility of this program:");
            System.out.println("   A popUp manager could not be found");
            System.out.println("   Base level object = " + container);
        }
    }
}

