/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIChoice;
import emsl.awt.GUIDialogueBox;
import emsl.awt.GUILabelPanel;
import emsl.awt.GUIPanel;
import emsl.awt.GUITextField;
import emsl.objects.DocumentSize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class DocumentSizeEditor
extends GUIDialogueBox
implements ActionListener {
    private transient GUIChoice sizeChoice;
    private transient GUITextField widthField;
    private transient GUITextField heightField;
    private transient Hashtable pageSizeList;
    private transient GUITextField topMargin;
    private transient GUITextField bottomMargin;
    private transient GUITextField leftMargin;
    private transient GUITextField rightMargin;
    private transient GUIChoice units;
    private transient double conversionFromInches;
    private transient DocumentSize documentSize;

    public DocumentSizeEditor(Frame frame) {
        super(frame, "Document Size Editor...", true);
        this.createPageSizeList();
        GUIPanel gUIPanel = this.getDisplayPanel();
        gUIPanel.setLayout(new BorderLayout(10, 15));
        gUIPanel.add("North", new GUIPanel(new Dimension(5, 5)));
        gUIPanel.add("East", new GUIPanel(new Dimension(5, 5)));
        gUIPanel.add("West", new GUIPanel(new Dimension(5, 5)));
        GUIPanel gUIPanel2 = new GUIPanel(new Dimension(650, 250));
        gUIPanel2.setLayout(new GridLayout(0, 2, 10, 10));
        gUIPanel.add("Center", gUIPanel2);
        gUIPanel2.add(this.createSizeGUI());
        gUIPanel2.add(this.createMarginGUI());
        gUIPanel.add("South", this.createUnitGUI());
        this.addExitButton("OK", false);
        this.setWindowCloseButton(this.addExitButton("Cancel", false));
        this.setUnits("Inches");
        this.setDocumentSize(new DocumentSize());
    }

    private GUIPanel createSizeGUI() {
        GUIPanel gUIPanel = new GUIPanel(new Dimension(300, 200), 3);
        gUIPanel.setText("Page Size");
        Dimension dimension = new Dimension(100, 30);
        this.sizeChoice = new GUIChoice(new Dimension(280, 30));
        this.sizeChoice.addActionListener(this);
        this.sizeChoice.setAlignment(1);
        gUIPanel.add(this.sizeChoice);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.pageSizeList.keys();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(String.valueOf((String)enumeration.nextElement()) + ",");
        }
        this.sizeChoice.setChoices(stringBuffer.toString());
        this.sizeChoice.addActionListener(this);
        this.widthField = new GUITextField(3, 15);
        this.widthField.addActionListener(this);
        this.heightField = new GUITextField(3, 15);
        this.heightField.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.widthField, "Page Width", dimension.width));
        gUIPanel.add(new GUILabelPanel((Component)this.heightField, "Page Height", dimension.width));
        return gUIPanel;
    }

    private GUIPanel createMarginGUI() {
        GUIPanel gUIPanel = new GUIPanel(new Dimension(300, 200), 3);
        gUIPanel.setText("Margins");
        Dimension dimension = new Dimension(100, 30);
        this.topMargin = new GUITextField(3, 15);
        this.topMargin.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.topMargin, "Top Margin", dimension.width));
        this.leftMargin = new GUITextField(3, 15);
        this.leftMargin.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.leftMargin, "Left Margin", dimension.width));
        this.rightMargin = new GUITextField(3, 15);
        this.rightMargin.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.rightMargin, "Right Margin", dimension.width));
        this.bottomMargin = new GUITextField(3, 15);
        this.bottomMargin.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.bottomMargin, "Bottom Margin", dimension.width));
        return gUIPanel;
    }

    private GUIPanel createUnitGUI() {
        GUIPanel gUIPanel = new GUIPanel();
        this.units = new GUIChoice(new Dimension(100, 30), "CM, Inches");
        this.units.addActionListener(this);
        gUIPanel.add(new GUILabelPanel((Component)this.units, "Measurement Units", 120));
        return gUIPanel;
    }

    private void createPageSizeList() {
        this.pageSizeList = new Hashtable();
        this.pageSizeList.put("US Letter", new Dimension(8500, 11000));
        this.pageSizeList.put("US Legal", new Dimension(8500, 14000));
        this.pageSizeList.put("A5", new Dimension(5800, 8300));
        this.pageSizeList.put("A4", new Dimension(8300, 11700));
        this.pageSizeList.put("A3", new Dimension(11700, 16500));
        this.pageSizeList.put("35mm Slide", new Dimension(11000, 7330));
        this.pageSizeList.put("Custom", new Dimension(5000, 5000));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        Dimension dimension;
        Object object = actionEvent.getSource();
        if (object == this.units) {
            this.setUnits(this.units.getText());
        }
        if (object == this.topMargin) {
            this.documentSize.setTopMargin(this.fromDisplay(this.topMargin.getDouble()));
        }
        if (object == this.leftMargin) {
            this.documentSize.setLeftMargin(this.fromDisplay(this.leftMargin.getDouble()));
        }
        if (object == this.rightMargin) {
            this.documentSize.setRightMargin(this.fromDisplay(this.rightMargin.getDouble()));
        }
        if (object == this.bottomMargin) {
            this.documentSize.setBottomMargin(this.fromDisplay(this.bottomMargin.getDouble()));
        }
        if (object == this.widthField || object == this.heightField) {
            int n = this.fromDisplay(this.widthField.getDouble());
            int n2 = this.fromDisplay(this.heightField.getDouble());
            this.documentSize.setPageSize(n, n2);
        }
        if (object == this.sizeChoice && (dimension = (Dimension)this.pageSizeList.get(string = this.sizeChoice.getText())) != null) {
            this.documentSize.setPageSize(dimension);
        }
        super.actionPerformed(actionEvent);
        this.setDocumentSize(this.documentSize);
    }

    private void setPageSize() {
        Dimension dimension = this.documentSize.getPageSize();
        this.widthField.setText(this.toDisplay(dimension.width));
        this.heightField.setText(this.toDisplay(dimension.height));
        String string = null;
        Enumeration enumeration = this.pageSizeList.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Dimension dimension2 = (Dimension)this.pageSizeList.get(string2);
            if (!dimension.equals(dimension2)) continue;
            string = string2;
        }
        if (string != null) {
            this.sizeChoice.select(string, true);
            return;
        }
        this.sizeChoice.select("Custom", true);
        this.pageSizeList.put("Custom", new Dimension(dimension.width, dimension.height));
    }

    private void setMargins() {
        this.topMargin.setText(this.toDisplay(this.documentSize.getTopMargin()));
        this.bottomMargin.setText(this.toDisplay(this.documentSize.getBottomMargin()));
        this.leftMargin.setText(this.toDisplay(this.documentSize.getLeftMargin()));
        this.rightMargin.setText(this.toDisplay(this.documentSize.getRightMargin()));
    }

    private double toDisplay(int n) {
        double d = n;
        d = d * this.conversionFromInches / 1000.0;
        return d;
    }

    private int fromDisplay(double d) {
        d = d * 1000.0 / this.conversionFromInches;
        return (int)d;
    }

    private void setUnits(String string) {
        if (string.equals("CM")) {
            this.units.select("CM", true);
            this.conversionFromInches = 2.54;
            return;
        }
        this.units.select("Inches", true);
        this.conversionFromInches = 1.0;
    }

    public void setDocumentSize(DocumentSize documentSize) {
        this.documentSize = (DocumentSize)documentSize.clone();
        this.setPageSize();
        this.setMargins();
    }

    public DocumentSize getDocumentSize() {
        return (DocumentSize)this.documentSize.clone();
    }
}

