/*
 * Decompiled with CFR 0.152.
 */
package emsl.editors;

import emsl.awt.GUIButton;
import emsl.awt.GUIIconBox;
import emsl.awt.GUIPanel;
import emsl.awt.GUIPopUpButton;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;

public class PropertyTags
extends GUIPanel
implements ActionListener {
    private transient GUIPopUpButton trigger;
    private transient GUIButton toggle;
    private transient PropertyEditor editor;

    public PropertyTags(PropertyEditor propertyEditor) {
        this.setBorder(0);
        this.setLayout(new BorderLayout());
        this.editor = propertyEditor;
        String[] stringArray = propertyEditor.getTags();
        if (stringArray == null) {
            return;
        }
        Dimension dimension = new Dimension(250, 30);
        if (stringArray.length == 2) {
            this.toggle = new GUIButton(dimension, "");
            this.toggle.setAlignment(0);
            this.add("Center", this.toggle);
            this.toggle.addActionListener(this);
            return;
        }
        GUIIconBox gUIIconBox = new GUIIconBox(1, 0);
        int n = 0;
        while (n < stringArray.length) {
            GUIButton gUIButton = new GUIButton(dimension, stringArray[n]);
            gUIButton.setAlignment(0);
            gUIIconBox.add(gUIButton);
            ++n;
        }
        this.trigger = new GUIPopUpButton(dimension, gUIIconBox);
        this.trigger.setAlignment(0);
        this.add("Center", this.trigger);
        this.trigger.addActionListener(this);
    }

    public void repaint() {
        String string = this.editor.getAsText();
        if (this.toggle != null) {
            this.toggle.setText(string);
            this.toggle.repaint();
        }
        if (this.trigger != null) {
            this.trigger.select(string, true);
        }
        super.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = null;
        try {
            if (object == this.trigger) {
                string = this.trigger.getText();
            }
            if (object == this.toggle) {
                String[] stringArray = this.editor.getTags();
                String string2 = this.toggle.getText();
                if (string2.equals(string = stringArray[0])) {
                    string = stringArray[1];
                }
            }
            this.editor.setAsText(string);
        }
        catch (Exception exception) {}
        this.repaint();
    }
}

