/*
 * Decompiled with CFR 0.152.
 */
package emsl.system;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;

public class ClipboardManager
implements ClipboardOwner {
    private Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
    private Clipboard userClipboard;

    public ClipboardManager(String string) {
        this.userClipboard = new Clipboard(string);
    }

    public void setClipboardData(Transferable transferable) {
        try {
            this.userClipboard.setContents(transferable, this);
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            StringSelection stringSelection = new StringSelection(string);
            this.systemClipboard.setContents(stringSelection, this);
            return;
        }
        catch (Exception exception) {
            System.out.println("Error copying to clipboard");
            System.out.println(exception.toString());
            return;
        }
    }

    public Transferable getClipboardData() {
        String string = null;
        String string2 = null;
        Transferable transferable = null;
        Transferable transferable2 = null;
        try {
            transferable2 = this.systemClipboard.getContents(this);
            string = (String)transferable2.getTransferData(DataFlavor.plainTextFlavor);
        }
        catch (Exception exception) {
            string = null;
        }
        try {
            transferable = this.userClipboard.getContents(this);
            string2 = (String)transferable.getTransferData(DataFlavor.plainTextFlavor);
            if (string2.equals(string)) {
                string = null;
            }
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string != null) {
            return transferable2;
        }
        return transferable;
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }
}

