/*
 * Decompiled with CFR 0.152.
 */
package emsl.text;

import emsl.inch.ComponentPanel;
import emsl.objects.TextStyle;
import emsl.text.Attribute;
import emsl.text.AttributeList;
import emsl.text.CharacterList;
import emsl.text.TextOwner;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;

public class TextData
implements Serializable {
    private CharacterList characterList;
    private AttributeList styleList;
    private AttributeList ownerList;
    private transient TextStyle nextTextStyle;
    private transient int nextPosition;

    public TextData() {
        this(false);
    }

    public TextData(boolean bl) {
        this.resetNextTextStyle();
        this.newData();
        this.insert(" ", 1);
        if (bl) {
            this.createTestData();
        }
    }

    public void newData() {
        this.characterList = new CharacterList();
        this.styleList = new AttributeList("Text Styles", new TextStyle());
        this.ownerList = new AttributeList("Text Owners", new TextOwner());
    }

    public int getSize() {
        return this.characterList.getSize();
    }

    public AttributeList getStyleList() {
        return this.styleList;
    }

    public void setStyleList(AttributeList attributeList) {
        this.styleList = attributeList;
    }

    public AttributeList getOwnerList() {
        return this.ownerList;
    }

    public void setOwnerList(AttributeList attributeList) {
        this.ownerList = attributeList;
    }

    public CharacterList getCharacterList() {
        return this.characterList;
    }

    public void setCharacterList(CharacterList characterList) {
        this.characterList = characterList;
    }

    public void setNextTextStyle(TextStyle textStyle, int n) {
        this.nextTextStyle = textStyle;
        this.nextPosition = n;
    }

    private boolean isNextTextStyle(int n) {
        if (this.nextTextStyle == null) {
            return false;
        }
        return n == this.nextPosition;
    }

    public void resetNextTextStyle() {
        this.setNextTextStyle(null, -2);
    }

    public int insert(char c, int n) {
        this.insert(String.valueOf(c), n);
        return 1;
    }

    public int insert(String string, int n) {
        block6: {
            boolean bl;
            block5: {
                int n2;
                block4: {
                    n = this.validateIndex(n);
                    this.characterList.insert(string, n);
                    this.styleList.insertData(n, string.length());
                    this.ownerList.insertData(n, string.length());
                    n2 = n - 1;
                    if (this.nextTextStyle != null) break block4;
                    bl = false;
                    break block5;
                }
                if (n2 != this.nextPosition) break block6;
                bl = true;
            }
            if (bl) {
                this.setTextStyle(this.nextTextStyle, n, n + string.length() - 1);
                this.resetNextTextStyle();
            }
        }
        return string.length();
    }

    public int insert(ComponentPanel componentPanel, int n) {
        block6: {
            boolean bl;
            block5: {
                int n2;
                block4: {
                    n = this.validateIndex(n);
                    this.characterList.insert(componentPanel, n);
                    this.styleList.insertData(n, 1);
                    this.ownerList.insertData(n, 1);
                    n2 = n - 1;
                    if (this.nextTextStyle != null) break block4;
                    bl = false;
                    break block5;
                }
                if (n2 != this.nextPosition) break block6;
                bl = true;
            }
            if (bl) {
                this.setTextStyle(this.nextTextStyle, n, n);
                this.resetNextTextStyle();
            }
        }
        return 1;
    }

    public int insert(TextData textData, int n, boolean bl) {
        n = this.validateIndex(n);
        this.characterList.insert(textData.getCharacterList(), n, bl);
        int n2 = textData.getSize();
        this.styleList.insertData(textData.getStyleList(), n, n2);
        this.ownerList.insertData(textData.getOwnerList(), n, n2);
        return textData.getSize() - 1;
    }

    public int delete(int n) {
        return this.delete(n, n);
    }

    public int delete(int n, int n2) {
        int n3;
        if (n2 < n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n < 1) {
            n = 1;
        }
        if (n2 < 1) {
            return 0;
        }
        n3 = this.characterList.getSize();
        if (n3 <= 1) {
            return 0;
        }
        if (n >= n3 - 1 || n2 >= n3 - 1) {
            return 0;
        }
        this.characterList.delete(n, n2);
        this.styleList.deleteData(n, n2);
        this.ownerList.deleteData(n, n2);
        return n2 - n + 1;
    }

    public void removeComponents(int n, int n2) {
        this.characterList.removeComponents(n, n2);
    }

    public char getCharacter(int n) {
        return this.characterList.getCharacter(this.validateIndex(n));
    }

    public ComponentPanel getComponent(int n) {
        return this.characterList.getComponent(this.validateIndex(n));
    }

    public int getCharacterIndex(Component component) {
        return this.characterList.getCharacterIndex(component);
    }

    public TextStyle getTextStyle(int n) {
        Object object;
        block6: {
            boolean bl;
            block5: {
                block4: {
                    object = this.styleList.getAttributeObject(this.validateIndex(n));
                    if (this.nextTextStyle != null) break block4;
                    bl = false;
                    break block5;
                }
                if (n != this.nextPosition) break block6;
                bl = true;
            }
            if (bl) {
                return this.nextTextStyle;
            }
        }
        return (TextStyle)object;
    }

    public TextOwner getTextOwner(int n) {
        Object object = this.ownerList.getAttributeObject(this.validateIndex(n));
        return (TextOwner)object;
    }

    public TextData getTextData(int n, int n2, boolean bl) {
        n = this.validateIndex(n);
        n2 = this.validateIndex(n2);
        TextData textData = new TextData(false);
        textData.setCharacterList(this.characterList.getCharacterList(n, n2, bl));
        textData.setStyleList(this.styleList.getAttributeList(n, n2));
        textData.setOwnerList(this.ownerList.getAttributeList(n, n2));
        return textData;
    }

    public void setTextStyle(TextStyle textStyle, int n, int n2) {
        Attribute attribute = new Attribute(textStyle);
        this.styleList.setAttribute(attribute, this.validateIndex(n), this.validateIndex(n2 + 1));
    }

    public void setTextStyle(TextStyle textStyle, int n) {
        Attribute attribute = new Attribute(textStyle);
        this.styleList.setAttribute(attribute, this.validateIndex(n));
    }

    public void setTextOwner(TextOwner textOwner, int n, int n2) {
        Attribute attribute = new Attribute(textOwner);
        this.ownerList.setAttribute(attribute, this.validateIndex(n), this.validateIndex(n2 + 1));
    }

    public void setTextOwner(TextOwner textOwner, int n) {
        Attribute attribute = new Attribute(textOwner);
        this.ownerList.setAttribute(attribute, this.validateIndex(n));
    }

    public String getWord(int n) {
        String string = this.characterList.getWord(n);
        int n2 = this.styleList.getNextAttributeIndex(n);
        if (n2 >= n && n2 <= n + string.length()) {
            string = string.substring(0, n2 - n);
        }
        return string;
    }

    public boolean isComponent(int n) {
        return this.characterList.isComponent(this.validateIndex(n));
    }

    public boolean isSymbol(int n) {
        return this.characterList.isSymbol(this.validateIndex(n));
    }

    public boolean isBreak(int n) {
        return this.characterList.isBreak(this.validateIndex(n));
    }

    public boolean isNewPage(int n) {
        return this.characterList.isNewPage(this.validateIndex(n));
    }

    public boolean isNewLine(int n) {
        return this.characterList.isNewLine(this.validateIndex(n));
    }

    public boolean isTab(int n) {
        return this.characterList.isTab(this.validateIndex(n));
    }

    public int validateIndex(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = this.characterList.getSize() - 1;
        if (n > n2 && n2 > 0) {
            return n2;
        }
        return n;
    }

    public String getString(int n, int n2) {
        try {
            String string = this.characterList.getString(n, n2);
            string = string.replace('\u0001', '*');
            string = string.replace('\u0002', '\n');
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String getString() {
        String string = this.characterList.getString();
        string = string.replace('\u0001', '*');
        string = string.replace('\u0002', '\n');
        return string;
    }

    public void print() {
        System.out.println("\nTextData:\n");
        System.out.println(this.characterList.toString());
        System.out.println(this.styleList.toString());
        System.out.println(this.ownerList.toString());
    }

    public void printWords() {
        String string;
        System.out.println("\nTextData split into word groups:\n");
        int n = 0;
        int n2 = 0;
        do {
            if ((string = this.getWord(n)) == null) continue;
            System.out.print("'" + string + "'(" + n + ")   ");
            n += string.length();
            if (++n2 <= 3) continue;
            System.out.println("");
            n2 = 0;
        } while (string.length() > 0);
    }

    public void print(int n) {
        n = this.validateIndex(n);
        System.out.println("\nTextData for character : " + n);
        System.out.println("  Character = " + this.getCharacter(n));
        System.out.println("  Component = " + this.getComponent(n));
        System.out.println("  Style = " + this.getTextStyle(n));
        System.out.println("  Owner = " + this.getTextOwner(n));
    }

    private void createTestData() {
        this.insert(" Anyway, hope you all have a lovely day, see you..!\n", 1);
        this.insert(" really hope that they work.", 1);
        this.insert(" A tab goes here and ends here. These classes are the product of a lot of headaches, so I", 1);
        this.insert("Welcome to Chris's text panel and associated data classes.", 1);
        TextStyle textStyle = new TextStyle();
        textStyle.setFontSize(12);
        textStyle.setForeground(Color.blue);
        textStyle.setFontStyle(8);
        this.setTextStyle(textStyle, 20);
        textStyle = new TextStyle();
        textStyle.setForeground(Color.red);
        textStyle.setFontSize(10);
        this.setTextStyle(textStyle, 30);
        textStyle = new TextStyle();
        textStyle.setForeground(Color.green);
        textStyle.setFontSize(10);
        this.setTextStyle(textStyle, 26, 26);
    }
}

