/*
 * Decompiled with CFR 0.152.
 */
package it.flavianopetrocchi.colors;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ColorsButton
extends JButton {
    private Color color = Color.black;
    private int iconSize = 22;

    public ColorsButton(int iconSize) {
        this.iconSize = iconSize;
        this.setIcon(this.createColorIcon(iconSize));
    }

    public ColorsButton(Icon icon) {
        super(icon);
    }

    private ImageIcon createColorIcon(int iconSize) {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int lenght = metrics.getHeight() - metrics.getDescent();
        BufferedImage image = new BufferedImage(iconSize, iconSize, 1);
        Graphics g = image.getGraphics();
        g.setColor(this.color);
        g.fillRect(0, 0, lenght, lenght);
        g.setColor(this.getForeground());
        g.drawRect(0, 0, lenght - 1, lenght - 1);
        g.dispose();
        return new ImageIcon(image);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }
}

