/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.io.File;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.Commands;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;

public class MultiViewListener
implements InternalFrameListener {
    Object pageScaling = null;
    Object pageRotation = null;
    private PdfDecoder decode_pdf;
    private SwingGUI currentGUI;
    private Values commonValues;
    private Commands currentCommands;

    public MultiViewListener(PdfDecoder pdfDecoder, SwingGUI swingGUI, Values values, Commands commands) {
        this.decode_pdf = pdfDecoder;
        this.currentGUI = swingGUI;
        this.commonValues = values;
        this.currentCommands = commands;
    }

    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        this.currentGUI.setBackNavigationButtonsEnabled(false);
        this.currentGUI.setForwardNavigationButtonsEnabled(false);
        this.currentGUI.resetPageNav();
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        this.decode_pdf.flushObjectValues(true);
        this.decode_pdf.closePdfFile();
    }

    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        this.currentGUI.setPdfDecoder(this.decode_pdf);
        this.currentCommands.setPdfDecoder(this.decode_pdf);
        int n = this.decode_pdf.getlastPageDecoded();
        this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        this.commonValues.setCurrentPage(n);
        String string = this.decode_pdf.getFileName();
        if (string != null) {
            this.commonValues.setSelectedFile(string);
            File file = new File(string);
            this.commonValues.setInputDir(file.getParent());
            this.commonValues.setFileSize(file.length() >> 10);
        }
        this.commonValues.setPDF(this.decode_pdf.isPDF());
        this.commonValues.setMultiTiff(this.decode_pdf.isMultiPageTiff());
        if (this.pageScaling != null) {
            this.currentGUI.setSelectedComboItem(252, this.pageScaling.toString());
        }
        if (this.pageRotation != null) {
            this.currentGUI.setSelectedComboItem(251, this.pageRotation.toString());
        }
        this.currentGUI.setPageNumber();
        this.decode_pdf.updateUI();
        this.currentGUI.removeSearchWindow(false);
        this.currentGUI.hideRedundentNavButtons();
    }

    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
        if (this.pageScaling != null) {
            this.pageScaling = this.currentGUI.getSelectedComboItem(252);
        }
        if (this.pageRotation != null) {
            this.pageRotation = this.currentGUI.getSelectedComboItem(251);
        }
    }

    public void setPageProperties(Object object, Object object2) {
        this.pageRotation = object;
        this.pageScaling = object2;
    }
}

