/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.SimpleViewer;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIButton;
import org.jpedal.examples.simpleviewer.gui.generic.GUICombo;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.swing.SwingOutline;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.render.ImageObject;
import org.jpedal.utils.Messages;

public class GUI {
    public GUIButton first;
    public GUIButton fback;
    public GUIButton back;
    public GUIButton forward;
    public GUIButton fforward;
    public GUIButton end;
    public GUIButton singleButton;
    public GUIButton continuousButton;
    public GUIButton continuousFacingButton;
    public GUIButton facingButton;
    public GUIButton pageFlowButton;
    private String[] annotTypes = new String[]{"Other", "Text", "FileAttachment"};
    protected boolean hiResPrinting = false;
    protected Map objs;
    protected boolean bookmarksGenerated = false;
    protected PdfDecoder decode_pdf;
    protected static final int thumbLocation = 200;
    protected static final int minimumScreenWidth = 700;
    protected HashMap pagesDecoded = new HashMap();
    public GUIButton snapshotButton;
    private Rectangle currentRectangle = null;
    public int cropX;
    public int cropW;
    public int cropH;
    protected int mediaX;
    protected int mediaY;
    public int mediaW;
    public int cropY;
    public int mediaH;
    protected boolean useDownloadWindow = true;
    protected boolean hasOutlinesDrawn = false;
    protected GUIOutline tree = new SwingOutline();
    protected boolean allowScrolling = true;
    protected boolean confirmClose = false;
    protected int divLocation = 170;
    protected boolean showOutlines = true;
    protected float[] scalingFloatValues = new float[]{1.0f, 1.0f, 1.0f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 2.5f, 5.0f, 7.5f, 10.0f};
    protected float scaling = 1.0f;
    protected static int inset = 25;
    protected int rotation = 0;
    protected String[] rotationValues = new String[]{"0", "90", "180", "270"};
    protected GUICombo rotationBox;
    protected GUICombo qualityBox;
    protected GUICombo scalingBox;
    protected static int defaultSelection = 0;
    protected String titleMessage = null;
    protected Values commonValues;
    protected GUIThumbnailPanel thumbnails;
    protected PropertiesFile properties;

    public boolean useHiResPrinting() {
        return this.hiResPrinting;
    }

    public void setHiResPrinting(boolean bl) {
        this.hiResPrinting = bl;
    }

    public String getPropertiesFileLocation() {
        return this.properties.getConfigFile();
    }

    public void setPropertiesFileLocation(String string) {
        this.properties.loadProperties(string);
    }

    public void setProperties(String string, boolean bl) {
        this.properties.setValue(string, String.valueOf(bl));
    }

    public void setPreferences(int n, int n2, int n3, boolean bl, int n4, boolean bl2, int n5, boolean bl3, boolean bl4) {
        PdfDecoder.CURRENT_BORDER_STYLE = n3;
        this.properties.setValue("borderType", String.valueOf(n3));
        this.allowScrolling = bl;
        this.properties.setValue("autoScroll", String.valueOf(bl));
        this.decode_pdf.getDPIFactory().setDpi(n);
        this.properties.setValue("DPI", String.valueOf(n));
        if (n4 < 1 || n4 > 4) {
            n4 = 1;
        }
        this.decode_pdf.setPageMode(n4);
        this.properties.setValue("pageMode", String.valueOf(n4));
        this.decode_pdf.repaint();
        String string = this.properties.getValue("searchWindowType");
        if (string.length() > 0 && !string.equals(String.valueOf(n2)) && SimpleViewer.showMessages) {
            JOptionPane.showMessageDialog(null, Messages.getMessage("PageLayoutViewMenu.ResetSearch"));
        }
        this.properties.setValue("searchWindowType", String.valueOf(n2));
        this.properties.setValue("automaticupdate", String.valueOf(bl2));
        this.commonValues.setMaxMiltiViewers(n5);
        this.properties.setValue("maxmultiviewers", String.valueOf(n5));
        this.useDownloadWindow = bl3;
        this.properties.setValue("showDownloadWindow", String.valueOf(bl3));
        this.hiResPrinting = bl4;
        this.properties.setValue("useHiResPrinting", String.valueOf(bl3));
    }

    public boolean allowScrolling() {
        return this.allowScrolling;
    }

    public boolean confirmClose() {
        return this.confirmClose;
    }

    public String[] getAnnotTypes() {
        return this.annotTypes;
    }

    public void setRectangle(Rectangle rectangle) {
        this.currentRectangle = rectangle;
    }

    public Rectangle getRectangle() {
        return this.currentRectangle;
    }

    public void setAutoScrolling(boolean bl) {
        this.allowScrolling = bl;
    }

    public void toogleAutoScrolling() {
        this.allowScrolling = !this.allowScrolling;
    }

    public int getRotation() {
        return this.rotation;
    }

    public float getScaling() {
        return this.scaling;
    }

    public void setScaling(float f) {
        this.scaling = f;
        this.scalingBox.setSelectedIndex((int)this.scaling);
    }

    public static int getPDFDisplayInset() {
        return inset;
    }

    public void createUniqueAnnotationIcons() {
        int n = this.commonValues.getCurrentPage();
        PdfArrayIterator pdfArrayIterator = this.decode_pdf.getFormRenderer().getAnnotsOnPage(n);
        if (this.objs == null) {
            this.objs = new HashMap();
        } else {
            this.objs.clear();
        }
        if (pdfArrayIterator != null && pdfArrayIterator.getTokenCount() > 0) {
            int n2 = 0;
            int n3 = pdfArrayIterator.getTokenCount();
            while (pdfArrayIterator.hasMoreTokens()) {
                int n4 = this.decode_pdf.getPdfPageData().getMediaBoxX(n);
                int n5 = this.decode_pdf.getPdfPageData().getMediaBoxY(n);
                int[] nArray = new int[n3];
                Color[] colorArray = new Color[n3];
                Object[] objectArray = new Object[n3];
                String string = pdfArrayIterator.getNextValueAsString(true);
                Object object = this.decode_pdf.getFormRenderer().getCompData().getRawForm(string);
                if (object == null) {
                    System.out.println("no match on " + string);
                    continue;
                }
                FormObject formObject = (FormObject)object;
                int n6 = formObject.getParameterConstant(1147962727);
                if (n6 != -1113876231) continue;
                this.objs.put(formObject, "x");
                Color color = Color.BLUE;
                Rectangle rectangle = formObject.getBoundingRectangle();
                nArray[n2] = 3;
                ImageObject imageObject = new ImageObject();
                imageObject.x = rectangle.x + n4;
                imageObject.y = rectangle.y + n5;
                imageObject.image = GUI.createUniqueImage(12, String.valueOf(n2 + 1), color);
                objectArray[n2] = imageObject;
                ++n2;
            }
        }
    }

    private static BufferedImage createUniqueImage(int n, String string, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(new Rectangle(0, 0, n, n));
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(new Rectangle(0, 0, n - 1, n - 1));
        graphics2D.setColor(Color.white);
        graphics2D.drawString(string, 2, 12);
        return bufferedImage;
    }

    public void setDpi(int n) {
        this.decode_pdf.getDPIFactory().setDpi(n);
    }

    public boolean isUseDownloadWindow() {
        return this.useDownloadWindow;
    }

    public void setUseDownloadWindow(boolean bl) {
        this.useDownloadWindow = bl;
    }

    public PropertiesFile getProperties() {
        return this.properties;
    }

    public void dispose() {
        this.first = null;
        this.fback = null;
        this.back = null;
        this.forward = null;
        this.fforward = null;
        this.end = null;
        this.singleButton = null;
        this.continuousButton = null;
        this.continuousFacingButton = null;
        this.facingButton = null;
        this.pageFlowButton = null;
        this.annotTypes = null;
        this.pagesDecoded = null;
        this.snapshotButton = null;
        this.currentRectangle = null;
        this.tree = null;
        this.pagesDecoded = null;
        this.snapshotButton = null;
        this.scalingFloatValues = null;
        this.rotationValues = null;
        this.rotationBox = null;
        this.qualityBox = null;
        this.scalingBox = null;
        this.titleMessage = null;
    }
}

