/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.examples.simpleviewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwingOutline
extends JScrollPane
implements GUIOutline {
    private boolean ignoreAlteredBookmark = false;
    private Map pageLookupTableViaTitle = new HashMap();
    private Map nodeToRef = new HashMap();
    private Map closedNodes = new HashMap();
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;
    private boolean hasDuplicateTitles;

    public SwingOutline() {
        this.getViewport().add(new JLabel("No outline"));
    }

    public void reset(Node node) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        this.pageLookupTableViaTitle.clear();
        this.nodeToRef.clear();
        this.closedNodes.clear();
        this.hasDuplicateTitles = false;
        if (node != null) {
            this.hasDuplicateTitles = false;
            this.readChildNodes(node, this.top, 0);
        }
        this.tree = new JTree(this.top);
        this.tree.setName("Tree");
        if (node != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void expandAll() {
        for (int i = 1; i < 4; ++i) {
            if (!this.closedNodes.containsKey(new Integer(i))) {
                this.tree.expandRow(i);
                continue;
            }
            this.tree.collapseRow(i);
        }
    }

    public int readChildNodes(Node node, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        if (defaultMutableTreeNode == null) {
            defaultMutableTreeNode = this.top;
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = nodeList.getLength();
        for (int i = 0; i < n2; ++i) {
            Node node2 = nodeList.item(i);
            Element element = (Element)node2;
            String string = element.getAttribute("title");
            String string2 = element.getAttribute("page");
            String string3 = element.getAttribute("isClosed");
            String string4 = element.getAttribute("objectRef");
            if (this.pageLookupTableViaTitle.containsKey(string)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(string, string2);
            }
            if (string3.equals("true")) {
                this.closedNodes.put(new Integer(n), "x");
            }
            this.nodeToRef.put(new Integer(n), string4);
            ++n;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            if (!node2.hasChildNodes()) continue;
            n = this.readChildNodes(node2, defaultMutableTreeNode2, n);
        }
        return n;
    }

    public boolean isIgnoreAlteredBookmark() {
        return this.ignoreAlteredBookmark;
    }

    public String getPage(String string) {
        if (this.hasDuplicateTitles) {
            return null;
        }
        return (String)this.pageLookupTableViaTitle.get(string);
    }

    public String convertNodeIDToRef(int n) {
        return (String)this.nodeToRef.get(new Integer(n));
    }

    public void selectBookmark() {
    }

    public Object getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

