/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer.gui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jpedal.PdfDecoder;
import org.jpedal.ThumbnailDecoder;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.objects.PdfPageData;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.SwingWorker;
import org.jpedal.utils.repositories.Vector_Object;

public class SwingThumbnailPanel
extends JScrollPane
implements GUIThumbnailPanel {
    static final boolean debugThumbnails = false;
    SwingWorker worker = null;
    JPanel panel = new JPanel();
    private ThumbPainter painter = new ThumbPainter();
    private boolean showThumbnailsdefault;
    private boolean showThumbnails = this.showThumbnailsdefault = true;
    public boolean interrupt = false;
    public boolean drawing;
    public boolean generateOtherVisibleThumbnails = false;
    public ThumbnailDecoder thumbDecoder;
    private JButton[] pageButton;
    private boolean[] buttonDrawn;
    private boolean[] isLandscape;
    private int[] pageHeight;
    private static final int thumbH = 100;
    private static final int thumbW = 70;
    Values commonValues;
    final PdfDecoder decode_pdf;
    boolean isExtractor = false;
    private int lastPage = -1;

    public SwingThumbnailPanel(Values values, final PdfDecoder pdfDecoder) {
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        this.commonValues = values;
        this.decode_pdf = pdfDecoder;
        this.thumbDecoder = new ThumbnailDecoder(pdfDecoder);
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                if (!SwingThumbnailPanel.this.isExtractor) {
                    if (SwingThumbnailPanel.this.drawing) {
                        SwingThumbnailPanel.this.terminateDrawing();
                    }
                    if (pdfDecoder.isOpen()) {
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
            }

            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    public void generateOtherThumbnails(String[] stringArray, Vector_Object vector_Object) {
        this.drawing = true;
        this.getViewport().removeAll();
        this.panel.removeAll();
        int n = stringArray.length;
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(n, 1, 0, 10));
        for (int i = 0; i < n; ++i) {
            BufferedImage bufferedImage = null;
            try {
                if (stringArray[i] == null) continue;
                Object object = vector_Object.elementAt(i);
                this.decode_pdf.waitForDecodingToFinish();
                if (object == null) {
                    bufferedImage = ImageIO.read(new File(stringArray[i]));
                    vector_Object.addElement(bufferedImage);
                } else {
                    bufferedImage = (BufferedImage)object;
                }
                if (bufferedImage == null) continue;
                int n2 = bufferedImage.getWidth();
                int n3 = bufferedImage.getHeight();
                Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                graphics2D.setColor(Color.black);
                graphics2D.draw(new Rectangle(0, 0, n2 - 1, n3 - 1));
                ImageIcon imageIcon = n3 > n2 ? new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 2)) : new ImageIcon(bufferedImage.getScaledInstance(100, -1, 2));
                this.pageButton[i].setIcon(imageIcon);
                this.pageButton[i].setVisible(true);
                this.buttonDrawn[i] = true;
                this.panel.add(this.pageButton[i]);
                continue;
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " loading " + stringArray[i]);
            }
        }
        this.drawing = false;
        this.panel.setVisible(true);
    }

    public synchronized void generateOtherVisibleThumbnails(final int n) {
        try {
            Rectangle rectangle;
            this.generateOtherVisibleThumbnails = true;
            if (n == -1 || n == this.lastPage || this.pageButton == null) {
                return;
            }
            this.lastPage = n;
            int n2 = this.decode_pdf.getPageCount();
            for (int i = 0; i < n2; ++i) {
                if (!this.generateOtherVisibleThumbnails) {
                    return;
                }
                if (i == n - 1) continue;
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            if (n2 > 1 && n > 0) {
                this.pageButton[n - 1].setBorder(BorderFactory.createLineBorder(Color.red));
            }
            if (!(rectangle = this.panel.getVisibleRect()).contains(this.pageButton[n - 1].getLocation())) {
                if (SwingUtilities.isEventDispatchThread()) {
                    Rectangle rectangle2 = new Rectangle(this.pageButton[n - 1].getLocation().x, this.pageButton[n - 1].getLocation().y, this.pageButton[n - 1].getBounds().width, this.pageButton[n - 1].getBounds().height);
                    this.panel.scrollRectToVisible(rectangle2);
                } else {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            if (!SwingThumbnailPanel.this.generateOtherVisibleThumbnails) {
                                return;
                            }
                            Rectangle rectangle = new Rectangle(((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[n - 1].getLocation().x, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[n - 1].getLocation().y, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[n - 1].getBounds().width, ((SwingThumbnailPanel)SwingThumbnailPanel.this).pageButton[n - 1].getBounds().height);
                            if (!SwingThumbnailPanel.this.generateOtherVisibleThumbnails) {
                                return;
                            }
                            SwingThumbnailPanel.this.panel.scrollRectToVisible(rectangle);
                        }
                    });
                }
            }
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            if (this.drawing) {
                this.terminateDrawing();
            }
            if (!this.generateOtherVisibleThumbnails) {
                return;
            }
            this.drawThumbnails();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    public void drawThumbnails() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.decode_pdf.isLoadingLinearizedPDF()) {
            return;
        }
        if (this.drawing) {
            this.terminateDrawing();
        }
        this.worker = new SwingWorker(){

            public Object construct() {
                SwingThumbnailPanel.this.drawing = true;
                try {
                    Rectangle rectangle = SwingThumbnailPanel.this.panel.getVisibleRect();
                    int n = SwingThumbnailPanel.this.decode_pdf.getPageCount();
                    for (int i = 0; i < n; ++i) {
                        SwingThumbnailPanel.this.decode_pdf.waitForDecodingToFinish();
                        if (SwingThumbnailPanel.this.interrupt) {
                            i = n;
                            continue;
                        }
                        if (SwingThumbnailPanel.this.buttonDrawn == null || rectangle == null || SwingThumbnailPanel.this.buttonDrawn[i] || SwingThumbnailPanel.this.pageButton[i] == null || !rectangle.intersects(SwingThumbnailPanel.this.pageButton[i].getBounds())) continue;
                        SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(true);
                        int n2 = 100;
                        if (SwingThumbnailPanel.this.isLandscape[i]) {
                            n2 = 70;
                        }
                        BufferedImage bufferedImage = SwingThumbnailPanel.this.thumbDecoder.getPageAsThumbnail(i + 1, n2);
                        if (!SwingThumbnailPanel.this.interrupt) {
                            SwingThumbnailPanel.this.createThumbnail(bufferedImage, i + 1, false);
                        }
                        SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SwingThumbnailPanel.this.decode_pdf.setThumbnailsDrawing(false);
                SwingThumbnailPanel.this.interrupt = false;
                SwingThumbnailPanel.this.drawing = false;
                return null;
            }
        };
        this.worker.start();
    }

    public void addDisplayedPageAsThumbnail(int n, DynamicVectorRenderer dynamicVectorRenderer) {
        Rectangle rectangle = this.panel.getVisibleRect();
        if (this.buttonDrawn != null && !this.buttonDrawn[n - 1] && rectangle.intersects(this.pageButton[n - 1].getBounds())) {
            int n2 = 100;
            if (this.isLandscape[n - 1]) {
                n2 = 70;
            }
            BufferedImage bufferedImage = this.decode_pdf.getPageAsThumbnail(n2, dynamicVectorRenderer);
            this.createThumbnail(bufferedImage, n, true);
        }
    }

    private BufferedImage createBlankThumbnail(int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n + 1, n2 + 1, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fill(new Rectangle(0, 0, n, n2));
        graphics2D.setColor(Color.black);
        graphics2D.draw(new Rectangle(0, 0, n, n2));
        graphics2D.drawLine(0, 0, n, n2);
        graphics2D.drawLine(0, n2, n, 0);
        return bufferedImage;
    }

    public BufferedImage getThumbnail(int n) {
        if (this.pageButton == null || this.pageButton[n] == null) {
            return null;
        }
        return (BufferedImage)((ImageIcon)this.pageButton[n].getIcon()).getImage();
    }

    private void createThumbnail(BufferedImage bufferedImage, int n, boolean bl) {
        --n;
        if (bufferedImage != null) {
            Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
            graphics2D.setColor(Color.black);
            graphics2D.draw(new Rectangle(0, 0, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 1));
            ImageIcon imageIcon = new ImageIcon(bufferedImage);
            this.pageButton[n].setIcon(imageIcon);
            this.buttonDrawn[n] = true;
        }
    }

    public void setupThumbnails(int n, int[] nArray, int n2) {
        this.isExtractor = true;
        this.lastPage = -1;
        Font font = new Font("Serif", 0, 12);
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage bufferedImage = this.createBlankThumbnail(70, 100);
        ImageIcon imageIcon = new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[n];
        this.pageHeight = new int[n];
        this.pageButton = new JButton[n];
        this.buttonDrawn = new boolean[n];
        for (int i = 0; i < n; ++i) {
            int n3 = i + 1;
            this.pageButton[i] = n2 < 2 ? new JButton(String.valueOf(n3), imageIcon) : new JButton(String.valueOf(n3) + " ( Page " + nArray[i] + " )", imageIcon);
            this.isLandscape[i] = false;
            this.pageHeight[i] = 100;
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && n > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(font);
        }
    }

    public void resetHighlightedThumbnail(int n) {
        if (this.pageButton != null) {
            int n2 = this.pageButton.length;
            for (int i = 0; i < n2; ++i) {
                if (i == n) {
                    this.pageButton[i].setBorder(BorderFactory.createLineBorder(Color.red));
                    continue;
                }
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
        }
    }

    public void setupThumbnails(int n, Font font, String string, PdfPageData pdfPageData) {
        this.lastPage = -1;
        this.getViewport().removeAll();
        this.panel.removeAll();
        this.getViewport().add(this.panel);
        this.panel.setLayout(new GridLayout(n, 1, 0, 10));
        this.panel.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.getVerticalScrollBar().setUnitIncrement(80);
        BufferedImage bufferedImage = this.createBlankThumbnail(70, 100);
        BufferedImage bufferedImage2 = this.createBlankThumbnail(100, 70);
        ImageIcon imageIcon = new ImageIcon(bufferedImage2.getScaledInstance(-1, 70, 4));
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage.getScaledInstance(-1, 100, 4));
        this.isLandscape = new boolean[n];
        this.pageHeight = new int[n];
        this.pageButton = new JButton[n];
        this.buttonDrawn = new boolean[n];
        for (int i = 0; i < n; ++i) {
            ImageIcon imageIcon3;
            ImageIcon imageIcon4;
            int n2;
            int n3 = i + 1;
            int n4 = pdfPageData.getCropBoxWidth(n3);
            int n5 = pdfPageData.getCropBoxHeight(n3);
            int n6 = pdfPageData.getRotation(n3);
            if (n6 == 0 | n6 == 180) {
                n2 = pdfPageData.getMediaBoxHeight(n3);
                imageIcon4 = imageIcon;
                imageIcon3 = imageIcon2;
            } else {
                n2 = pdfPageData.getMediaBoxWidth(n3);
                imageIcon4 = imageIcon2;
                imageIcon3 = imageIcon;
            }
            if (n4 > n5) {
                this.pageButton[i] = new JButton(string + ' ' + n3, imageIcon4);
                this.isLandscape[i] = true;
                this.pageHeight[i] = n2;
            } else {
                this.pageButton[i] = new JButton(string + ' ' + n3, imageIcon3);
                this.isLandscape[i] = false;
                this.pageHeight[i] = n2;
            }
            this.pageButton[i].setVerticalTextPosition(3);
            this.pageButton[i].setHorizontalTextPosition(0);
            if (i == 0 && n > 1) {
                this.pageButton[0].setBorder(BorderFactory.createLineBorder(Color.red));
            } else {
                this.pageButton[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            }
            this.pageButton[i].setFont(font);
            this.panel.add((Component)this.pageButton[i], "Center");
        }
    }

    public Object[] getButtons() {
        return this.pageButton;
    }

    public void setThumbnailsEnabled(boolean bl) {
        this.showThumbnailsdefault = bl;
        this.showThumbnails = bl;
    }

    public boolean isShownOnscreen() {
        return this.showThumbnails;
    }

    public void resetToDefault() {
        this.showThumbnails = this.showThumbnailsdefault;
    }

    public void setIsDisplayedOnscreen(boolean bl) {
        this.showThumbnails = bl;
    }

    public void addComponentListener() {
        this.panel.addComponentListener(this.painter);
    }

    public void removeAllListeners() {
        this.panel.removeComponentListener(this.painter);
        Object[] objectArray = this.getButtons();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                ActionListener[] actionListenerArray = ((JButton)objectArray[i]).getActionListeners();
                for (int j = 0; j < actionListenerArray.length; ++j) {
                    ((JButton)objectArray[i]).removeActionListener(actionListenerArray[j]);
                }
            }
        }
    }

    public void terminateDrawing() {
        this.generateOtherVisibleThumbnails = false;
        if (this.drawing) {
            this.interrupt = true;
            while (this.drawing) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.interrupt = false;
        }
    }

    public void refreshDisplay() {
        this.validate();
    }

    public void dispose() {
        this.removeAll();
        this.worker = null;
        if (this.panel != null) {
            this.panel.removeAll();
        }
        this.panel = null;
        this.painter = null;
        this.thumbDecoder = null;
        this.pageButton = null;
        this.buttonDrawn = null;
        this.isLandscape = null;
        this.pageHeight = null;
    }

    private class ThumbPainter
    extends ComponentAdapter {
        boolean requestMade = false;
        Timer trapMultipleMoves = new Timer(250, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ThumbPainter.this.requestMade) {
                    ThumbPainter.this.requestMade = true;
                    SwingThumbnailPanel swingThumbnailPanel = SwingThumbnailPanel.this;
                    if (!swingThumbnailPanel.commonValues.isProcessing()) {
                        if (((ThumbPainter)ThumbPainter.this).SwingThumbnailPanel.this.drawing) {
                            SwingThumbnailPanel.this.terminateDrawing();
                        }
                        ThumbPainter.this.requestMade = false;
                        SwingThumbnailPanel.this.drawThumbnails();
                    }
                }
            }
        });

        private ThumbPainter() {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.trapMultipleMoves.isRunning()) {
                this.trapMultipleMoves.stop();
            }
            this.trapMultipleMoves.setRepeats(false);
            this.trapMultipleMoves.start();
        }
    }
}

